/*
 * Decompiled with CFR 0.152.
 */
package com.skysql.java;

import com.skysql.java.Configuration;
import com.skysql.java.GsonConfig;
import com.skysql.java.GsonManager;
import com.skysql.java.Logging;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.lang.reflect.Method;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MonAPI {
    String m_apiHost;
    String m_apiKey;
    String m_apiKeyID;
    private boolean m_bufferingExecution;
    private int m_cycles;
    private String m_timeZone = null;

    public MonAPI() {
        this(true, 1);
    }

    public MonAPI(int APIKeyID) {
        this(true, APIKeyID);
    }

    public MonAPI(boolean buffer, int APIKeyId) {
        this.getApiCredentials(APIKeyId);
        this.m_bufferingExecution = buffer;
        this.m_cycles = 0;
    }

    private void getApiCredentials(int APIKeyId) {
        Properties props = System.getProperties();
        this.m_apiHost = props.getProperty("SKYSQL_API_HOST");
        this.m_apiKey = props.getProperty("SKYSQL_API_KEY");
        this.m_apiKeyID = props.getProperty("SKYSQL_API_KEYID");
        if (this.m_apiKeyID != null && !this.m_apiKeyID.isEmpty()) {
            try {
                APIKeyId = Integer.parseInt(this.m_apiKeyID);
            }
            catch (Exception e) {
                Logging.error("The provided API Key ID is invalid. Looking for another value in the configuration files.");
                this.m_apiKeyID = null;
            }
        }
        if (this.isPropertyNullOrEmpty()) {
            this.getConfig();
        }
        if (this.isPropertyNullOrEmpty()) {
            this.getConfigJson(APIKeyId);
        }
        if (this.isPropertyNullOrEmpty()) {
            this.getConfigIni(APIKeyId);
        }
        if (this.isPropertyNullOrEmpty()) {
            this.getConfigDefault(APIKeyId);
        }
    }

    private boolean isPropertyNullOrEmpty() {
        boolean result = this.m_apiHost == null || this.m_apiHost.isEmpty() || this.m_apiKey == null || this.m_apiKey.isEmpty() || this.m_apiKeyID == null || this.m_apiKeyID.isEmpty();
        return result;
    }

    private void getConfig() {
        Configuration config = new Configuration();
        this.m_apiKeyID = config.getConfig(Configuration.getApplication()).get("apikeyid");
        this.m_apiKey = config.getConfig(Configuration.DEFAULT_SECTION.APIKEYS).get(this.m_apiKeyID);
        this.m_apiHost = config.getConfig(Configuration.DEFAULT_SECTION.APIHOST).get("uri");
    }

    private void getConfigJson(int APIKeyId) {
        String configJson = "";
        try {
            String tmp;
            BufferedReader reader = new BufferedReader(new FileReader("/usr/local/skysql/config/manager.json"));
            while ((tmp = reader.readLine()) != null) {
                configJson = configJson + tmp;
            }
            reader.close();
            GsonConfig gsonConfig = GsonManager.fromJson(configJson, GsonConfig.class);
            if (this.m_apiHost == null || this.m_apiHost.isEmpty()) {
                this.m_apiHost = gsonConfig.getUri();
            }
            if (this.m_apiKey == null || this.m_apiKey.isEmpty()) {
                this.m_apiKey = gsonConfig.getKey(APIKeyId);
            }
            if (this.m_apiKeyID == null || this.m_apiKeyID.isEmpty()) {
                this.m_apiKeyID = Integer.toString(APIKeyId);
            }
        }
        catch (Exception e) {
            Logging.info("Configuration Json file not found.");
        }
    }

    private void getConfigIni(int APIKeyId) {
        try {
            String keyString;
            BufferedReader config = new BufferedReader(new FileReader("/usr/local/skysql/config/components.ini"));
            while ((keyString = config.readLine()) != null) {
                Pattern p = Pattern.compile("^" + APIKeyId + "\\s*=\\s*\"(\\w+)\"");
                Matcher m = p.matcher(keyString);
                if (!m.find()) continue;
                keyString = m.group(1);
                break;
            }
            config.close();
            if (this.m_apiKey == null || this.m_apiKey.isEmpty()) {
                this.m_apiKey = keyString;
            }
            if (this.m_apiKeyID == null || this.m_apiKeyID.isEmpty()) {
                this.m_apiKeyID = "" + APIKeyId;
            }
        }
        catch (Exception e) {
            Logging.info("Configuration ini file not found.");
        }
    }

    private void getConfigDefault(int APIKeyId) {
        if (this.m_apiHost == null || this.m_apiHost.isEmpty()) {
            this.m_apiHost = "http://localhost/restfulapi";
        }
        if (this.m_apiKey == null || this.m_apiKey.isEmpty()) {
            this.m_apiKey = "1f8d9e040e65d7b105538b1ed0231770";
        }
        if (this.m_apiKeyID == null || this.m_apiKeyID.isEmpty()) {
            this.m_apiKeyID = "" + APIKeyId;
        }
    }

    public boolean MonitorValue(int systemID, String monitorKey, String value) {
        String apiRequest = "system/" + systemID + "/monitor/" + monitorKey + "/data";
        return this.restPost(apiRequest, new String[]{"value"}, new String[]{value});
    }

    public boolean bulkMonitorValue(String apiRequest, String[] fields, String[] values) {
        return this.restPost(apiRequest, fields, values);
    }

    public boolean updateValue(String restRequest, String pName, String pValue) {
        String[] newpName = new String[]{pName};
        String[] newpValue = new String[]{pValue};
        String result = this.updateValue(restRequest, newpName, newpValue);
        return result != null;
    }

    public String updateValue(String restRequest, String[] pName, String[] pValue) {
        String outJson = this.restPut(restRequest, pName, pValue);
        return outJson;
    }

    public String getReturnedJson(String restRequest, String[] pName, String[] pValue) {
        String outJson = this.getReturnedJson(restRequest, pName, pValue, null);
        return outJson;
    }

    public String getReturnedJson(String restRequest, String[] pName, String[] pValue, String lastUpdate) {
        String outJson = this.restGet(restRequest, pName, pValue, lastUpdate);
        if (outJson == null) {
            Logging.error("Failed: Output Json: " + outJson);
            Logging.debug("        URI request: " + restRequest);
            return null;
        }
        return outJson;
    }

    private String restGet(String restRequest, String[] pName, String[] pValue, String lastUpdate) {
        String result = "";
        String value = "";
        if (pName != null && pValue != null && !pName[0].isEmpty()) {
            for (int i = 0; i < pName.length; ++i) {
                value = value + "&" + pName[i] + "=" + pValue[i];
            }
            value = value.substring(1);
        }
        try {
            String tmp;
            String reqString = "" + this.m_apiHost + "/" + restRequest;
            if (value != "") {
                reqString = reqString + "?" + value;
            }
            String rfcdate = this.setDate();
            String sb = this.setAuth(restRequest, rfcdate);
            URL postURL = new URL(reqString);
            HttpURLConnection apiConn = (HttpURLConnection)postURL.openConnection();
            if (lastUpdate != null && lastUpdate != "") {
                apiConn.setRequestProperty("If-Modified-Since", lastUpdate);
            }
            this.setUpConn(apiConn, sb, rfcdate, value, "GET");
            BufferedReader in = new BufferedReader(new InputStreamReader(apiConn.getInputStream()));
            while ((tmp = in.readLine()) != null) {
                result = result + tmp + "\n";
            }
            in.close();
            if (apiConn.getResponseCode() == 304) {
                result = "";
            }
        }
        catch (ConnectException e) {
            Logging.error("Cannot connect to the web server.");
            return "";
        }
        catch (Exception e) {
            Logging.error(e.getMessage());
            return "";
        }
        return result;
    }

    private String restPut(String restRequest, String[] pName, String[] pValue) {
        String result = "";
        String value = "";
        if (pName != null && pValue != null && !pName[0].isEmpty()) {
            for (int i = 0; i < pName.length; ++i) {
                value = value + "&" + pName[i] + "=" + pValue[i];
            }
            value = value.substring(1);
        }
        try {
            String tmp;
            String reqString = "" + this.m_apiHost + "/" + restRequest;
            String rfcdate = this.setDate();
            String sb = this.setAuth(restRequest, rfcdate);
            URL postURL = new URL(reqString);
            HttpURLConnection apiConn = (HttpURLConnection)postURL.openConnection();
            this.setUpConn(apiConn, sb, rfcdate, value, "PUT");
            BufferedReader in = new BufferedReader(new InputStreamReader(apiConn.getInputStream()));
            while ((tmp = in.readLine()) != null) {
                result = result + tmp + "\n";
            }
            in.close();
            this.runBuffer();
            if (apiConn.getResponseCode() != 200) {
                throw new RuntimeException("Failed : HTTP error : " + apiConn.getResponseMessage() + ": returned data: " + result);
            }
        }
        catch (Exception e) {
            this.pushFailedApi("restPut", restRequest, pName, pValue);
            return null;
        }
        return result;
    }

    private boolean restPost(String restRequest, String[] pName, String[] pValue) {
        String result = "";
        String value = "";
        if (pName != null && pValue != null && !pName[0].isEmpty()) {
            for (int i = 0; i < pName.length; ++i) {
                value = value + "&" + pName[i] + "=" + pValue[i];
            }
            value = value.substring(1);
        }
        try {
            String tmp;
            String reqString = "" + this.m_apiHost + "/" + restRequest;
            String rfcdate = this.setDate();
            String sb = this.setAuth(restRequest, rfcdate);
            URL postURL = new URL(reqString);
            HttpURLConnection apiConn = (HttpURLConnection)postURL.openConnection();
            this.setUpConn(apiConn, sb, rfcdate, value, "POST");
            BufferedReader in = new BufferedReader(new InputStreamReader(apiConn.getInputStream()));
            while ((tmp = in.readLine()) != null) {
                result = result + tmp + "\n";
            }
            in.close();
            this.runBuffer();
            if (apiConn.getResponseCode() != 200) {
                throw new RuntimeException("Failed : HTTP error : " + apiConn.getResponseMessage() + ": returned data: " + result);
            }
        }
        catch (Exception e) {
            this.pushFailedApi("restPost", restRequest, pName, pValue);
            return false;
        }
        return true;
    }

    private String setDate() throws IOException {
        SimpleDateFormat sdf = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z");
        if (this.m_timeZone == null) {
            try {
                String tz;
                BufferedReader timeZone = new BufferedReader(new FileReader("/etc/php.ini"));
                while ((tz = timeZone.readLine()) != null) {
                    Pattern p = Pattern.compile("date\\.timezone\\s*=\\s*(\\w+/\\w+)");
                    Matcher m = p.matcher(tz);
                    if (!m.find()) continue;
                    tz = m.group(1);
                    break;
                }
                timeZone.close();
                this.m_timeZone = tz == null ? "Atlantic/Reykjavik" : tz;
            }
            catch (Exception e) {
                this.m_timeZone = "Europe/London";
            }
        }
        sdf.setTimeZone(TimeZone.getTimeZone(this.m_timeZone));
        return sdf.format(new Date());
    }

    private String setAuth(String restRequest, String rfcdate) throws NoSuchAlgorithmException {
        String fullkey = restRequest.substring(0, 1).matches("/") ? restRequest.substring(1) : restRequest;
        fullkey = fullkey + this.m_apiKey + rfcdate;
        MessageDigest md = MessageDigest.getInstance("MD5");
        md.update(fullkey.getBytes());
        byte[] byteData = md.digest();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < byteData.length; ++i) {
            sb.append(Integer.toString((byteData[i] & 0xFF) + 256, 16).substring(1));
        }
        return sb.toString();
    }

    private void setUpConn(HttpURLConnection apiConn, String sb, String rfcdate, String value, String method) throws IOException {
        apiConn.setRequestMethod(method);
        apiConn.setRequestProperty("Accept", "application/json");
        apiConn.setRequestProperty("Authorization", "api-auth-" + this.m_apiKeyID + "-" + sb);
        if (method.equalsIgnoreCase("PUT") || method.equalsIgnoreCase("POST")) {
            apiConn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        }
        apiConn.setRequestProperty("charset", "utf-8");
        apiConn.setRequestProperty("Date", rfcdate);
        apiConn.setRequestProperty("Content-Length", "" + Integer.toString(value.getBytes().length));
        apiConn.setRequestProperty("X-SkySQL-API-Version", "1.1");
        apiConn.setDoOutput(true);
        apiConn.setUseCaches(false);
        if (!method.equalsIgnoreCase("GET") && value.length() > 1) {
            OutputStreamWriter out = new OutputStreamWriter(apiConn.getOutputStream());
            out.write(value);
            out.flush();
            out.close();
        }
    }

    private void runBuffer() {
        if (this.m_bufferingExecution && this.m_cycles >= 10) {
            APIBatchExecution.sendAll();
            this.m_cycles = 0;
        }
        ++this.m_cycles;
    }

    private void pushFailedApi(String typeValue, String restRequest, String[] pName, String[] pValue) {
        ArrayList<Object> toBatch = new ArrayList<Object>();
        toBatch.add(typeValue);
        toBatch.add(restRequest);
        toBatch.add(pName);
        toBatch.add(pValue);
        try {
            toBatch.add(this.setDate());
        }
        catch (IOException e) {
            // empty catch block
        }
        APIBatchExecution.push(toBatch);
    }

    private static class APIBatchExecution {
        private List<List<Object>> stack = new ArrayList<List<Object>>();
        private List<List<Object>> stack_bkp = new ArrayList<List<Object>>();
        private MonAPI mapi = new MonAPI(false, 3);
        private static volatile APIBatchExecution INSTANCE = null;

        private APIBatchExecution() {
        }

        private static synchronized void APIBatchExecutionHolder() {
            if (INSTANCE == null) {
                INSTANCE = new APIBatchExecution();
            }
        }

        private static APIBatchExecution getInstance() {
            if (INSTANCE == null) {
                APIBatchExecution.APIBatchExecutionHolder();
            }
            return INSTANCE;
        }

        private void backupBatchQueue() {
            APIBatchExecution.getInstance().stack_bkp.addAll(APIBatchExecution.getInstance().stack);
            APIBatchExecution.getInstance().stack.clear();
        }

        public static synchronized boolean push(List<Object> toBuffer) {
            try {
                APIBatchExecution.getInstance().stack.add(toBuffer);
            }
            catch (Exception e) {
                return false;
            }
            return true;
        }

        public static synchronized void sendAll() {
            APIBatchExecution.getInstance().backupBatchQueue();
            Logging.info("START BUFFERED REQUESTS: " + APIBatchExecution.getInstance().stack_bkp.size() + " queued requests.");
            for (List<Object> batchCmd : APIBatchExecution.getInstance().stack_bkp) {
                try {
                    Class<?> classRequest = batchCmd.get(1).getClass();
                    Class<Object> classOne = batchCmd.get(2).getClass();
                    classOne = String[].class;
                    Class<Object> classTwo = batchCmd.get(3).getClass();
                    classTwo = String[].class;
                    Method method = APIBatchExecution.getInstance().mapi.getClass().getDeclaredMethod((String)batchCmd.get(0), classRequest, classOne, classTwo);
                    method.invoke((Object)APIBatchExecution.getInstance().mapi, batchCmd.get(1), batchCmd.get(2), batchCmd.get(3));
                }
                catch (ClassCastException e) {
                    Logging.debug("Method " + (String)batchCmd.get(0) + ": the parameters must be strings or extensions, got instead " + batchCmd.get(1).getClass().getSimpleName() + ", " + batchCmd.get(2).getClass().getSimpleName() + ", " + batchCmd.get(3).getClass().getSimpleName());
                }
                catch (NoSuchMethodException e) {
                    Logging.debug("No method " + (String)batchCmd.get(0) + " with parameters of type " + batchCmd.get(1).getClass().getSimpleName() + ", " + batchCmd.get(2).getClass().getSimpleName() + ", " + batchCmd.get(3).getClass().getSimpleName());
                }
                catch (Exception e) {}
            }
            APIBatchExecution.getInstance().stack_bkp.clear();
            Logging.info("STOP BUFFERED REQUESTS");
        }
    }
}

