/*
 * Decompiled with CFR 0.152.
 */
package com.skysql.java;

import com.skysql.java.Credential;
import com.skysql.java.GsonLatestObservations;
import com.skysql.java.GsonManager;
import com.skysql.java.GsonMonitorClasses;
import com.skysql.java.GsonNode;
import com.skysql.java.GsonNodeStates;
import com.skysql.java.GsonProvisionedNode;
import com.skysql.java.GsonSystem;
import com.skysql.java.GsonUpdatedAPI;
import com.skysql.java.Logging;
import com.skysql.java.MonAPI;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MonData {
    private int m_systemID;
    private MonAPI m_api;
    private String m_systemType;
    private GsonLatestObservations m_dataChanged;

    public MonData(int systemID) {
        this.m_systemID = systemID;
        this.m_api = new MonAPI();
        this.m_systemType = "galera";
        this.m_dataChanged = new GsonLatestObservations();
    }

    public MonData() {
        this(0);
    }

    private <T> T getObjectFromAPI(String apiRequest, Class<T> objectClass) {
        String getJson = this.m_api.getReturnedJson(apiRequest, null, null);
        T object = GsonManager.fromJson(getJson, objectClass);
        return object;
    }

    private <T> T getObjectFromAPI(String apiRequest, Class<T> objectClass, String lastUpdate) {
        String getJson = this.m_api.getReturnedJson(apiRequest, null, null, lastUpdate);
        T object = GsonManager.fromJson(getJson, objectClass);
        return object;
    }

    private <T> T getObjectFromAPI(String apiRequest, String[] pName, String[] pValue, Class<T> objectClass) {
        String getJson = this.m_api.getReturnedJson(apiRequest, pName, pValue);
        T object = GsonManager.fromJson(getJson, objectClass);
        return object;
    }

    private GsonNode getNodeCached(int nodeID) {
        return this.m_dataChanged.getNode(this.m_systemID, nodeID);
    }

    private <T> T updateValue(String apiRequest, Class<T> objectClass, String[] pName, String[] pValue) {
        String getJson = this.m_api.updateValue(apiRequest, pName, pValue);
        T object = GsonManager.fromJson(getJson, objectClass);
        return object;
    }

    public void registerAPI(String component, String version, String release, String date) {
        String apiRequest = "system/0/node/0/component/" + component.toLowerCase() + "/property/";
        String property = "";
        if (component != null) {
            property = "name";
            this.m_api.updateValue(apiRequest + property, new String[]{"value"}, new String[]{component});
        }
        if (version != null) {
            property = "version";
            this.m_api.updateValue(apiRequest + property, new String[]{"value"}, new String[]{version});
        }
        if (release != null) {
            property = "release";
            this.m_api.updateValue(apiRequest + property, new String[]{"value"}, new String[]{release});
        }
        if (date != null) {
            property = "date";
            this.m_api.updateValue(apiRequest + property, new String[]{"value"}, new String[]{date});
        }
    }

    public List<Integer> getSystemList() {
        String apiRequest = "system";
        String[] fields = new String[]{"fields"};
        String[] values = new String[]{"systemid"};
        GsonSystem gsonSystem = this.getObjectFromAPI(apiRequest, fields, values, GsonSystem.class);
        return gsonSystem == null ? null : gsonSystem.getSystemIdList();
    }

    public Integer getSystemMonitorInterval() {
        String apiRequest = "system/" + this.m_systemID + "/property/MonitorInterval";
        GsonSystem gsonSystem = this.getObjectFromAPI(apiRequest, GsonSystem.class);
        if (gsonSystem == null) {
            return 30;
        }
        return gsonSystem.getSystems().get(0).getProperties().getMonitorInterval();
    }

    public boolean IPMonitor() {
        String apiRequest = "system/" + this.m_systemID + "/property/IPMonitor";
        GsonSystem gsonSystem = this.getObjectFromAPI(apiRequest, GsonSystem.class);
        if (gsonSystem == null) {
            return false;
        }
        String IP = gsonSystem.getSystems().get(0).getProperties().getIPMonitor();
        if (IP == null) {
            return false;
        }
        Pattern pattern = Pattern.compile("\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}");
        Matcher matcher = pattern.matcher(IP);
        return matcher.matches();
    }

    public boolean getProvisionedNodes() {
        Iterator<Integer> nodeIt = this.getNodeList().iterator();
        boolean isChanged = true;
        while (nodeIt.hasNext()) {
            Integer nodeID = nodeIt.next();
            String now = this.m_dataChanged.getNodeUpdateDate(this.m_systemID, nodeID);
            GsonProvisionedNode gsonProvisionedNode = this.getObjectFromAPI("provisionednode", GsonProvisionedNode.class, now);
            boolean bl = isChanged = gsonProvisionedNode != null && gsonProvisionedNode.getProvisionedNodes() != null && !gsonProvisionedNode.getProvisionedNodes().isEmpty();
            if (gsonProvisionedNode != null && gsonProvisionedNode.getProvisionedNodes() != null && gsonProvisionedNode.getProvisionedNodes().isEmpty()) {
                this.m_dataChanged.clearAllNodes(this.m_systemID);
            }
            if (!isChanged) continue;
            this.m_dataChanged.clearAllNodes(this.m_systemID);
            for (GsonProvisionedNode.ProvisionedNodes provisionedNode : gsonProvisionedNode.getProvisionedNodes()) {
                String ser = "{ \"node\": " + GsonManager.toJson(provisionedNode) + "}";
                GsonNode gsonNode = GsonManager.fromJson(ser, GsonNode.class);
                this.m_dataChanged.setLastNode(gsonNode);
            }
        }
        return isChanged;
    }

    public List<Integer> getNodeList() {
        String apiRequest = "system/" + this.m_systemID + "/node";
        String[] fields = new String[]{"fields"};
        String[] values = new String[]{"nodeid"};
        GsonNode gsonNode = this.getObjectFromAPI(apiRequest, fields, values, GsonNode.class);
        return gsonNode == null ? null : gsonNode.getNodeIdList();
    }

    public List<Integer> getNodeListCached() {
        GsonNode gsonNode = this.m_dataChanged.getAllNodes(this.m_systemID);
        return gsonNode == null ? null : gsonNode.getNodeIdList();
    }

    public String getNodePrivateIP(int NodeNo) {
        GsonNode gsonNode = this.getNodeCached(NodeNo);
        return gsonNode == null ? null : gsonNode.getNode(0).getPrivateIP();
    }

    public Credential getNodeMonitorCredentials(int NodeNo) {
        try {
            GsonNode gsonNode = this.getNodeCached(NodeNo);
            Credential cred = gsonNode != null && !gsonNode.getNode(0).getDbUserName().equalsIgnoreCase("") && gsonNode.getNode(0).getDbUserName() != null ? new Credential(gsonNode.getNode(0).getDbUserName(), gsonNode.getNode(0).getDbPassword()) : new Credential("repluser", "replpassword");
            return cred;
        }
        catch (Exception ex) {
            Logging.error("Failed to retrieve node credentials for Node ID " + NodeNo);
            return null;
        }
    }

    public List<Integer> getInstances() {
        String apiRequest = "system/" + this.m_systemID + "/node";
        GsonNode gsonNode = this.getObjectFromAPI(apiRequest, GsonNode.class);
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (int i = 0; i < gsonNode.getNodes().size(); ++i) {
            result.add(gsonNode.getNodes().get(i).getInstanceID());
        }
        return result;
    }

    public List<String> getNodeStates() {
        String apiRequest = "system/" + this.m_systemID + "/node";
        String[] fields = new String[]{"fields"};
        String[] values = new String[]{"state"};
        GsonNode gsonNode = this.getObjectFromAPI(apiRequest, fields, values, GsonNode.class);
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < gsonNode.getNodes().size(); ++i) {
            result.add(gsonNode.getNodes().get(i).getState());
        }
        return result;
    }

    public String getNodeState(int nodeID) {
        String apiRequest = "system/" + this.m_systemID + "/node/" + nodeID;
        String[] fields = new String[]{"fields"};
        String[] values = new String[]{"state"};
        GsonNode gsonNode = this.getObjectFromAPI(apiRequest, fields, values, GsonNode.class);
        String result = gsonNode == null ? "down" : gsonNode.getNode(0).getState();
        return result;
    }

    public String getNodeName(int NodeNo) {
        GsonNode gsonNode = this.getNodeCached(NodeNo);
        if (gsonNode != null) {
            if (gsonNode.getNode(0).getName() != null) {
                return gsonNode.getNode(0).getName();
            }
            return Integer.toString(gsonNode.getNode(0).getNodeId());
        }
        return null;
    }

    public String getNodeHostName(int NodeNo) {
        GsonNode gsonNode = this.getNodeCached(NodeNo);
        String result = null;
        if (!(gsonNode == null || (result = gsonNode.getNode(0).getHostname()) != null && !result.isEmpty() || (result = gsonNode.getNode(0).getPrivateIP()) != null && !result.isEmpty() || (result = gsonNode.getNode(0).getPublicIP()) != null && !result.isEmpty())) {
            result = null;
        }
        return result;
    }

    public List<String> getNodeValidStates() {
        String apiRequest = "nodestate/" + this.m_systemType;
        GsonNodeStates gsonNodeStates = this.getObjectFromAPI(apiRequest, GsonNodeStates.class);
        if (gsonNodeStates == null) {
            return null;
        }
        return gsonNodeStates.getDescriptionList();
    }

    public int getNodeStateId(String Name) {
        String apiRequest = "nodestate/" + this.m_systemType;
        GsonNodeStates gsonNodeStates = this.getObjectFromAPI(apiRequest, GsonNodeStates.class);
        return gsonNodeStates == null ? null : gsonNodeStates.getIdFromState(Name);
    }

    public String getNodeStateFromId(int stateId) {
        String apiRequest = "nodestate/" + this.m_systemType;
        GsonNodeStates gsonNodeStates = this.getObjectFromAPI(apiRequest, GsonNodeStates.class);
        return gsonNodeStates.getStateFromId(stateId);
    }

    public boolean saveMonitorChanges() {
        boolean isChanged;
        String now;
        String apiRequest = "monitorclass/" + this.m_systemType;
        GsonMonitorClasses gsonMonitorClasses = this.getObjectFromAPI(apiRequest, GsonMonitorClasses.class, now = this.m_dataChanged.getMonitorUpdateDate());
        boolean bl = isChanged = gsonMonitorClasses != null && gsonMonitorClasses.getMonitorClass(0) != null;
        if (isChanged) {
            this.m_dataChanged.setLastMonitor(gsonMonitorClasses);
        }
        return isChanged;
    }

    private GsonMonitorClasses getMonitorClassesCached() {
        return this.m_dataChanged.getAllMonitorClasses();
    }

    private GsonMonitorClasses getMonitorClassesCached(Integer monitorID) {
        return this.m_dataChanged.getMonitorClasses(monitorID);
    }

    private int getMonitorId(String key) {
        int result = -1;
        GsonMonitorClasses gsonMonitorClasses = this.getMonitorClassesCached();
        for (GsonMonitorClasses.MonitorClasses monitorClass : gsonMonitorClasses.getMonitorClasses()) {
            if (!monitorClass.getMonitor().equalsIgnoreCase(key)) continue;
            result = monitorClass.getMonitorId();
            break;
        }
        return result;
    }

    public List<Integer> getMonitorIdList() {
        GsonMonitorClasses gsonMonitorClasses = this.getMonitorClassesCached();
        return gsonMonitorClasses == null ? null : gsonMonitorClasses.getMonitorIdList();
    }

    public String getMonitorSQL(int monitor_id) {
        GsonMonitorClasses gsonMonitorClasses = this.getMonitorClassesCached(monitor_id);
        if (gsonMonitorClasses == null || gsonMonitorClasses.getMonitorClass(0) == null) {
            return null;
        }
        return gsonMonitorClasses.getMonitorClass(0).getSql();
    }

    public int getMonitorClassInterval(String monitorKey) {
        int monitor_id = this.getMonitorId(monitorKey);
        GsonMonitorClasses gsonMonitorClasses = this.getMonitorClassesCached(monitor_id);
        return gsonMonitorClasses == null ? null : Integer.valueOf(gsonMonitorClasses.getMonitorClass(0).getInterval());
    }

    public int getNamedMonitor(String monitorKey) {
        String apiRequest = "monitorclass/" + this.m_systemType + "/key/" + monitorKey;
        GsonMonitorClasses gsonMonitorClasses = this.getObjectFromAPI(apiRequest, GsonMonitorClasses.class);
        return gsonMonitorClasses == null ? null : Integer.valueOf(gsonMonitorClasses.getMonitorClass(0).getMonitorId());
    }

    public String getMonitorType(int monitor_id) {
        GsonMonitorClasses gsonMonitorClasses = this.getMonitorClassesCached(monitor_id);
        if (gsonMonitorClasses == null || gsonMonitorClasses.getMonitorClass(0) == null) {
            return null;
        }
        return gsonMonitorClasses == null ? null : gsonMonitorClasses.getMonitorClass(0).getMonitorType();
    }

    public boolean isMonitorSystemAverage(int monitor_id) {
        GsonMonitorClasses gsonMonitorClasses = this.getMonitorClassesCached(monitor_id);
        Integer result = gsonMonitorClasses == null ? 0 : gsonMonitorClasses.getMonitorClass(0).getSystemAverage();
        return result == 1;
    }

    public Boolean isMonitorDelta(int monitor_id) {
        GsonMonitorClasses gsonMonitorClasses = this.getMonitorClassesCached(monitor_id);
        Integer result = gsonMonitorClasses == null ? 0 : gsonMonitorClasses.getMonitorClass(0).getDelta();
        if (result == 0) {
            return false;
        }
        return true;
    }

    public String getMonitorKey(int monitor_id) {
        GsonMonitorClasses gsonMonitorClasses = this.getMonitorClassesCached(monitor_id);
        if (gsonMonitorClasses == null || gsonMonitorClasses.getMonitorClass(0) == null) {
            return null;
        }
        return gsonMonitorClasses.getMonitorClass(0).getMonitor();
    }

    public void setSystemStatus() {
        String apiRequest = "system/" + this.m_systemID + "/node";
        try {
            GsonNode gsonNode = this.getObjectFromAPI(apiRequest, GsonNode.class);
            Iterator<String> states = gsonNode.getNodeStateList().iterator();
            String systemState = "stopped";
            while (states.hasNext()) {
                String rval = states.next();
                if (rval == "master") {
                    systemState = "running";
                    break;
                }
                if (rval != "slave") continue;
                systemState = "running";
            }
            apiRequest = "system/" + this.m_systemID;
            this.m_api.updateValue(apiRequest, "state", systemState);
        }
        catch (Exception e) {
            Logging.error("Update System State Failed: " + e.getMessage());
        }
    }

    public void setSystemState(String state) {
        String apiRequest = "system/" + this.m_systemID;
        String[] pName = new String[]{"systemtype", "state"};
        String[] pValue = new String[]{this.m_systemType, state};
        try {
            GsonUpdatedAPI gsonUpdatedAPI = this.updateValue(apiRequest, GsonUpdatedAPI.class, pName, pValue);
            if (gsonUpdatedAPI != null && gsonUpdatedAPI.getUpdateCount() == 0) {
                Logging.error("Failed to update system " + this.m_systemID + " to state " + state);
            }
            if (gsonUpdatedAPI.getErrors() != null) {
                throw new RuntimeException(gsonUpdatedAPI.getErrors().get(0));
            }
            if (gsonUpdatedAPI.getWarnings() != null) {
                throw new RuntimeException(gsonUpdatedAPI.getWarnings().get(0));
            }
        }
        catch (Exception e) {
            Logging.error("API Failed: " + apiRequest + ": cannot update system state to " + state);
        }
    }

    public void setNodeState(int nodeid, int stateid) {
        String apiRequest = "system/" + this.m_systemID + "/node/" + nodeid;
        String[] pName = new String[]{"stateid"};
        String[] pValue = new String[]{Integer.toString(stateid)};
        try {
            GsonUpdatedAPI gsonUpdatedAPI = this.updateValue(apiRequest, GsonUpdatedAPI.class, pName, pValue);
            if (gsonUpdatedAPI != null && gsonUpdatedAPI.getUpdateCount() == 0) {
                Logging.error("Failed to update Node " + nodeid + " of system " + this.m_systemID + " to state " + stateid);
            }
            if (gsonUpdatedAPI.getErrors() != null) {
                throw new RuntimeException(gsonUpdatedAPI.getErrors().get(0));
            }
            if (gsonUpdatedAPI.getWarnings() != null) {
                throw new RuntimeException(gsonUpdatedAPI.getWarnings().get(0));
            }
        }
        catch (Exception e) {
            Logging.error("API Failed: " + apiRequest + ": cannot set Node state to " + stateid);
        }
    }

    public void setNodeDatabaseProperties(int nodeid, String dbType, String dbVersion) {
        String apiRequest = "system/" + this.m_systemID + "/node/" + nodeid;
        String[] pName = new String[]{"dbtype", "dbversion"};
        String[] pValue = new String[]{dbType, dbVersion};
        try {
            GsonUpdatedAPI gsonUpdatedAPI = this.updateValue(apiRequest, GsonUpdatedAPI.class, pName, pValue);
            if (gsonUpdatedAPI != null && gsonUpdatedAPI.getUpdateCount() == 0) {
                Logging.error("Failed to update Node database properties on Node " + nodeid + " of system " + this.m_systemID);
            }
            if (gsonUpdatedAPI.getErrors() != null) {
                throw new RuntimeException(gsonUpdatedAPI.getErrors().get(0));
            }
            if (gsonUpdatedAPI.getWarnings() != null) {
                throw new RuntimeException(gsonUpdatedAPI.getWarnings().get(0));
            }
        }
        catch (Exception e) {
            Logging.error("API Failed: " + apiRequest + ": cannot update Node database properties");
        }
    }

    public boolean setNodePublicIP(int nodeID, String publicIP) {
        GsonNode gsonNode = this.getNodeCached(nodeID);
        if (gsonNode != null && gsonNode.getNode(0).getPublicIP() != null && gsonNode.getNode(0).getPublicIP().equalsIgnoreCase(publicIP)) {
            return false;
        }
        String apiRequest = "system/" + this.m_systemID + "/node/" + nodeID;
        return this.m_api.updateValue(apiRequest, "publicip", publicIP);
    }

    public boolean setNodePrivateIP(int nodeID, String privateIP) {
        try {
            if (this.getNodeCached(nodeID).getNode(0).getPrivateIP().equalsIgnoreCase(privateIP)) {
                return false;
            }
            String apiRequest = "system/" + this.m_systemID + "/node/" + nodeID;
            return this.m_api.updateValue(apiRequest, "privateip", privateIP);
        }
        catch (Exception e) {
            return false;
        }
    }

    public String mapCRMStatus(String state) {
        return "";
    }

    public boolean monitorData(int systemID, int monitorID, String observation) {
        return this.m_api.MonitorValue(systemID, this.getMonitorKey(monitorID), observation);
    }

    public boolean bulkMonitorData(List<Integer> monitorIDs, Integer systemID, Integer nodeID, List<String> values) {
        String apiRequest = "monitordata";
        if (monitorIDs.size() != values.size()) {
            Logging.error("Bulk data failed: arrays must be of the same size: got " + monitorIDs.size() + " Monitor IDs, " + values.size() + " values.");
            return false;
        }
        ArrayList<String> fi = new ArrayList<String>();
        ArrayList<String> va = new ArrayList<String>();
        fi.add("systemid");
        va.add(Integer.toString(systemID));
        fi.add("nodeid");
        va.add(Integer.toString(nodeID));
        fi.add("timestamp");
        va.add(Long.toString(new Date().getTime() / 1000L));
        for (int i = 0; i < monitorIDs.size(); ++i) {
            fi.add("m[" + Integer.toString(i) + "]");
            va.add(Integer.toString(monitorIDs.get(i)));
            fi.add("v[" + Integer.toString(i) + "]");
            va.add(values.get(i));
        }
        String[] fields = fi.toArray(new String[0]);
        String[] parameters = va.toArray(new String[0]);
        return this.m_api.bulkMonitorValue(apiRequest, fields, parameters);
    }

    public boolean bulkMonitorData(List<Integer> monitorIDs, List<Integer> systemIDs, List<Integer> nodeIDs, List<String> values) {
        String apiRequest = "monitordata";
        if (monitorIDs.size() != systemIDs.size() || monitorIDs.size() != nodeIDs.size() || monitorIDs.size() != values.size()) {
            Logging.error("Bulk data failed: arrays must be of the same size: got " + monitorIDs.size() + " Monitor IDs, " + systemIDs.size() + " systems, " + nodeIDs.size() + " nodes and " + values.size() + " values.");
            return false;
        }
        ArrayList<String> fi = new ArrayList<String>();
        ArrayList<String> va = new ArrayList<String>();
        for (int i = 0; i < monitorIDs.size(); ++i) {
            fi.add("m[" + Integer.toString(i) + "]");
            va.add(Integer.toString(monitorIDs.get(i)));
            fi.add("s[" + Integer.toString(i) + "]");
            va.add(Integer.toString(systemIDs.get(i)));
            fi.add("n[" + Integer.toString(i) + "]");
            va.add(Integer.toString(nodeIDs.get(i)));
            fi.add("v[" + Integer.toString(i) + "]");
            va.add(values.get(i));
        }
        String[] fields = fi.toArray(new String[0]);
        String[] parameters = va.toArray(new String[0]);
        return this.m_api.bulkMonitorValue(apiRequest, fields, parameters);
    }
}

