/*
 * Decompiled with CFR 0.152.
 */
package org.productivity.java.syslog4j.impl.log4j;

import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.LoggingEvent;
import org.productivity.java.syslog4j.Syslog;
import org.productivity.java.syslog4j.SyslogConstants;
import org.productivity.java.syslog4j.SyslogIF;
import org.productivity.java.syslog4j.SyslogRuntimeException;
import org.productivity.java.syslog4j.impl.AbstractSyslogConfigIF;
import org.productivity.java.syslog4j.util.SyslogUtility;

public abstract class Syslog4jAppenderSkeleton
extends AppenderSkeleton
implements SyslogConstants {
    private static final long serialVersionUID = 5520555788232095628L;
    protected SyslogIF syslog = null;
    protected String ident = null;
    protected String protocol = null;
    protected String facility = null;
    protected String host = null;
    protected String port = null;
    protected String charSet = null;
    protected String threaded = null;
    protected String threadLoopInterval = null;
    protected String splitMessageBeginText = null;
    protected String splitMessageEndText = null;
    protected String maxMessageLength = null;
    protected String maxShutdownWait = null;
    protected String writeRetries = null;
    protected String truncateMessage = null;
    protected boolean initialized = false;

    public abstract String initialize() throws SyslogRuntimeException;

    protected static boolean isTrueOrOn(String string) {
        boolean bl = false;
        if (string != null) {
            if ("true".equalsIgnoreCase(string.trim()) || "on".equalsIgnoreCase(string.trim())) {
                bl = true;
            } else if ("false".equalsIgnoreCase(string.trim()) || "off".equalsIgnoreCase(string.trim())) {
                bl = false;
            } else {
                LogLog.error((String)("Value \"" + string + "\" not true, on, false, or off -- assuming false"));
            }
        }
        return bl;
    }

    public void _initialize() {
        String string = this.initialize();
        if (string != null && this.protocol == null) {
            this.protocol = string;
        }
        if (this.protocol != null) {
            try {
                int n;
                this.syslog = Syslog.getInstance(this.protocol);
                if (this.host != null) {
                    this.syslog.getConfig().setHost(this.host);
                }
                if (this.facility != null) {
                    this.syslog.getConfig().setFacility(SyslogUtility.getFacility(this.facility));
                }
                if (this.port != null) {
                    try {
                        n = Integer.parseInt(this.port);
                        this.syslog.getConfig().setPort(n);
                    }
                    catch (NumberFormatException numberFormatException) {
                        LogLog.error((String)numberFormatException.toString());
                    }
                }
                if (this.charSet != null) {
                    this.syslog.getConfig().setCharSet(this.charSet);
                }
                if (this.ident != null) {
                    this.syslog.getConfig().setIdent(this.ident);
                }
                if (this.truncateMessage != null && !"".equals(this.truncateMessage.trim())) {
                    this.syslog.getConfig().setTruncateMessage(Syslog4jAppenderSkeleton.isTrueOrOn(this.truncateMessage));
                }
                if (this.maxMessageLength != null && this.maxMessageLength.length() > 0) {
                    try {
                        n = Integer.parseInt(this.maxMessageLength.trim());
                        this.syslog.getConfig().setMaxMessageLength(n);
                    }
                    catch (NumberFormatException numberFormatException) {
                        LogLog.error((String)numberFormatException.toString());
                    }
                }
                if (this.syslog.getConfig() instanceof AbstractSyslogConfigIF) {
                    AbstractSyslogConfigIF abstractSyslogConfigIF = (AbstractSyslogConfigIF)this.syslog.getConfig();
                    if (this.threaded != null && !"".equals(this.threaded.trim())) {
                        abstractSyslogConfigIF.setThreaded(Syslog4jAppenderSkeleton.isTrueOrOn(this.threaded));
                    }
                    if (this.threadLoopInterval != null && this.threadLoopInterval.length() > 0) {
                        try {
                            long l = Long.parseLong(this.threadLoopInterval.trim());
                            abstractSyslogConfigIF.setThreadLoopInterval(l);
                        }
                        catch (NumberFormatException numberFormatException) {
                            LogLog.error((String)numberFormatException.toString());
                        }
                    }
                    if (this.splitMessageBeginText != null) {
                        abstractSyslogConfigIF.setSplitMessageBeginText(SyslogUtility.getBytes(abstractSyslogConfigIF, this.splitMessageBeginText));
                    }
                    if (this.splitMessageEndText != null) {
                        abstractSyslogConfigIF.setSplitMessageEndText(SyslogUtility.getBytes(abstractSyslogConfigIF, this.splitMessageEndText));
                    }
                    if (this.maxShutdownWait != null && this.maxShutdownWait.length() > 0) {
                        try {
                            int n2 = Integer.parseInt(this.maxShutdownWait.trim());
                            abstractSyslogConfigIF.setMaxShutdownWait(n2);
                        }
                        catch (NumberFormatException numberFormatException) {
                            LogLog.error((String)numberFormatException.toString());
                        }
                    }
                    if (this.writeRetries != null && this.writeRetries.length() > 0) {
                        try {
                            int n3 = Integer.parseInt(this.writeRetries.trim());
                            abstractSyslogConfigIF.setWriteRetries(n3);
                        }
                        catch (NumberFormatException numberFormatException) {
                            LogLog.error((String)numberFormatException.toString());
                        }
                    }
                }
                this.initialized = true;
            }
            catch (SyslogRuntimeException syslogRuntimeException) {
                LogLog.error((String)syslogRuntimeException.toString());
            }
        }
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String string) {
        this.protocol = string;
    }

    protected void append(LoggingEvent loggingEvent) {
        if (!this.initialized) {
            this._initialize();
        }
        if (this.initialized) {
            int n = loggingEvent.getLevel().getSyslogEquivalent();
            if (this.layout != null) {
                String string = this.layout.format(loggingEvent);
                this.syslog.log(n, string);
            } else {
                String string = loggingEvent.getRenderedMessage();
                this.syslog.log(n, string);
            }
        }
    }

    public void close() {
        if (this.syslog != null) {
            this.syslog.flush();
        }
    }

    public String getFacility() {
        return this.facility;
    }

    public void setFacility(String string) {
        this.facility = string;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String string) {
        this.host = string;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String string) {
        this.port = string;
    }

    public String getCharSet() {
        return this.charSet;
    }

    public void setCharSet(String string) {
        this.charSet = string;
    }

    public String getIdent() {
        return this.ident;
    }

    public void setIdent(String string) {
        this.ident = string;
    }

    public String getThreaded() {
        return this.threaded;
    }

    public void setThreaded(String string) {
        this.threaded = string;
    }

    public boolean requiresLayout() {
        return false;
    }

    public String getThreadLoopInterval() {
        return this.threadLoopInterval;
    }

    public void setThreadLoopInterval(String string) {
        this.threadLoopInterval = string;
    }

    public String getSplitMessageBeginText() {
        return this.splitMessageBeginText;
    }

    public void setSplitMessageBeginText(String string) {
        this.splitMessageBeginText = string;
    }

    public String getSplitMessageEndText() {
        return this.splitMessageEndText;
    }

    public void setSplitMessageEndText(String string) {
        this.splitMessageEndText = string;
    }

    public String getMaxMessageLength() {
        return this.maxMessageLength;
    }

    public void setMaxMessageLength(String string) {
        this.maxMessageLength = string;
    }

    public String getMaxShutdownWait() {
        return this.maxShutdownWait;
    }

    public void setMaxShutdownWait(String string) {
        this.maxShutdownWait = string;
    }

    public String getWriteRetries() {
        return this.writeRetries;
    }

    public void setWriteRetries(String string) {
        this.writeRetries = string;
    }

    public String getTruncateMessage() {
        return this.truncateMessage;
    }

    public void setTruncateMessage(String string) {
        this.truncateMessage = string;
    }
}

