/*
 * Decompiled with CFR 0.152.
 */
package org.productivity.java.syslog4j.impl.message;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.productivity.java.syslog4j.SyslogMessageIF;

public abstract class AbstractSyslogMessage
implements SyslogMessageIF {
    private static final long serialVersionUID = 414124277626756491L;
    public static final String UNDEFINED = "undefined";
    public static final String DEFAULT_DATE_FORMAT = "yyyy/MM/dd";
    public static final String DEFAULT_TIME_FORMAT = "HH:mm:ss";
    public static final char DEFAULT_DELIMITER = ' ';
    public static final String DEFAULT_REPLACE_DELIMITER = "_";

    protected char getDelimiter() {
        return ' ';
    }

    protected String getReplaceDelimiter() {
        return DEFAULT_REPLACE_DELIMITER;
    }

    protected String getDateFormat() {
        return DEFAULT_DATE_FORMAT;
    }

    protected String getTimeFormat() {
        return DEFAULT_TIME_FORMAT;
    }

    protected String generateDate() {
        String string = new SimpleDateFormat(this.getDateFormat()).format(new Date());
        return string;
    }

    protected String generateTime() {
        String string = new SimpleDateFormat(this.getTimeFormat()).format(new Date());
        return string;
    }

    protected String[] generateDateAndTime(Date date) {
        String[] stringArray = new String[]{new SimpleDateFormat(this.getDateFormat()).format(date), new SimpleDateFormat(this.getTimeFormat()).format(date)};
        return stringArray;
    }

    protected String generateLocalHostName() {
        String string = UNDEFINED;
        try {
            string = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return string;
    }

    protected boolean nullOrEmpty(String string) {
        return string == null || "".equals(string.trim());
    }

    protected String replaceDelimiter(String string, String string2, char c, String string3) {
        if (string3 == null || string3.length() < 1 || string2 == null || string2.length() < 1) {
            return string2;
        }
        String string4 = string2.replaceAll("\\" + c, string3);
        return string4;
    }

    public abstract String createMessage();
}

