/*
 * Decompiled with CFR 0.152.
 */
package org.productivity.java.syslog4j.impl.message.structured;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.productivity.java.syslog4j.impl.message.AbstractSyslogMessage;
import org.productivity.java.syslog4j.impl.message.structured.StructuredSyslogMessageIF;

public class StructuredSyslogMessage
extends AbstractSyslogMessage
implements StructuredSyslogMessageIF {
    private static final long serialVersionUID = 3669887659567965965L;
    private String messageId;
    private Map structuredData;
    private String message;

    private StructuredSyslogMessage() {
        this.messageId = null;
        this.message = null;
        this.structuredData = null;
    }

    public StructuredSyslogMessage(String string, Map map, String string2) {
        this.messageId = string;
        this.structuredData = map;
        this.message = string2;
        this.ensureCorrectMapType();
    }

    private void ensureCorrectMapType() {
        if (this.getStructuredData() != null) {
            Set set = this.getStructuredData().entrySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                if (!(entry.getKey() instanceof String)) {
                    throw new IllegalArgumentException("Structured data map must be a map of String -> (Map of String,String)");
                }
                if (!(entry.getValue() instanceof Map)) {
                    throw new IllegalArgumentException("Structured data map must be a map of String -> (Map of String,String)");
                }
                Set set2 = ((Map)entry.getValue()).entrySet();
                Iterator iterator2 = set2.iterator();
                while (iterator2.hasNext()) {
                    Map.Entry entry2 = iterator2.next();
                    if (!(entry2.getKey() instanceof String)) {
                        throw new IllegalArgumentException("Structured data map must be a map of String -> (Map of String,String)");
                    }
                    if (entry2.getValue() instanceof String) continue;
                    throw new IllegalArgumentException("Structured data map must be a map of String -> (Map of String,String)");
                }
            }
        }
    }

    public static StructuredSyslogMessage fromString(String string) {
        StructuredSyslogMessage structuredSyslogMessage = new StructuredSyslogMessage();
        structuredSyslogMessage.deserialize(string);
        return structuredSyslogMessage;
    }

    private void deserialize(String string) {
        if (string.indexOf(91) <= 0) {
            throw new IllegalArgumentException("Invalid Syslog string format: " + string);
        }
        String string2 = string.substring(0, string.indexOf(91));
        String string3 = string.substring(string.indexOf(91), string.lastIndexOf(93) + 1);
        this.message = string.lastIndexOf(93) + 2 <= string.length() ? string.substring(string.lastIndexOf(93) + 2) : "";
        String[] stringArray = string2.split(" ");
        if (stringArray.length != 1) {
            throw new IllegalArgumentException("Invalid Syslog string format: " + string);
        }
        this.messageId = "-".equals(stringArray[0]) ? null : stringArray[0];
        this.structuredData = new HashMap();
        if (!"[0@0]".equals(string3)) {
            while (!"".equals(string3)) {
                if (!string3.startsWith("[") || string3.indexOf(93) == -1) {
                    throw new IllegalArgumentException("Invalid structured data format in Syslog message: " + string);
                }
                String string4 = string3.substring(1, string3.indexOf(93));
                HashMap<String, String> hashMap = new HashMap<String, String>();
                String[] stringArray2 = string4.split(" ");
                for (int i = 1; i < stringArray2.length; ++i) {
                    String[] stringArray3 = stringArray2[i].split("=");
                    if (stringArray3.length != 2) {
                        throw new IllegalArgumentException("Invalid structured data format in Syslog message: " + string);
                    }
                    if (!stringArray3[1].startsWith("\"") || !stringArray3[1].endsWith("\"")) {
                        throw new IllegalArgumentException("Invalid structured data format in Syslog message: " + string);
                    }
                    hashMap.put(stringArray3[0], stringArray3[1].substring(1, stringArray3[1].length() - 1));
                }
                this.structuredData.put(stringArray2[0], hashMap);
                if (string3.indexOf(93) != string3.lastIndexOf(93)) {
                    string3 = string3.substring(string3.indexOf(93) + 1);
                    continue;
                }
                string3 = "";
            }
        }
    }

    public String getMessageId() {
        return this.messageId;
    }

    public Map getStructuredData() {
        return this.structuredData;
    }

    public String getMessage() {
        return this.message;
    }

    public String createMessage() {
        return this.serialize();
    }

    private String serialize() {
        if (!StructuredSyslogMessage.checkIsPrintable(this.getMessageId())) {
            throw new IllegalArgumentException("Invalid message id: " + this.getMessageId());
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(StructuredSyslogMessage.nilProtect(this.getMessageId()));
        stringBuffer.append(' ');
        if (this.getStructuredData() == null || this.getStructuredData().size() == 0) {
            stringBuffer.append("[0@0]");
        } else {
            Set set = this.getStructuredData().entrySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                String string = (String)entry.getKey();
                if (string == null || string.length() == 0 || !StructuredSyslogMessage.checkIsPrintable(string)) {
                    throw new IllegalArgumentException("Illegal structured data id: " + string);
                }
                stringBuffer.append('[').append(string);
                Map map = (Map)entry.getValue();
                if (map != null) {
                    Set set2 = map.entrySet();
                    Iterator iterator2 = set2.iterator();
                    while (iterator2.hasNext()) {
                        Map.Entry entry2 = iterator2.next();
                        String string2 = (String)entry2.getKey();
                        String string3 = (String)entry2.getValue();
                        if (string2 == null || string2.length() == 0 || !StructuredSyslogMessage.checkIsPrintable(string2)) {
                            throw new IllegalArgumentException("Illegal structured data parameter name: " + string2);
                        }
                        if (string3 == null || string3.length() == 0) {
                            throw new IllegalArgumentException("Illegal structured data parameter value: " + string3);
                        }
                        stringBuffer.append(' ');
                        stringBuffer.append(string2);
                        stringBuffer.append('=').append('\"');
                        StructuredSyslogMessage.sdEscape(stringBuffer, string3);
                        stringBuffer.append('\"');
                    }
                }
                stringBuffer.append(']');
            }
        }
        if (this.getMessage() != null && this.getMessage().length() != 0) {
            stringBuffer.append(' ');
            stringBuffer.append(StructuredSyslogMessage.nilProtect(this.getMessage()));
        }
        return stringBuffer.toString();
    }

    public static void sdEscape(StringBuffer stringBuffer, String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\"' || c == '\\' || c == ']') {
                stringBuffer.append('\\');
            }
            stringBuffer.append(c);
        }
    }

    public static boolean checkIsPrintable(String string) {
        if (string == null) {
            return true;
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c >= '!' && c <= '~') continue;
            return false;
        }
        return true;
    }

    public static String nilProtect(String string) {
        if (string == null || string.trim().length() == 0) {
            return "-";
        }
        return string;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.message == null ? 0 : this.message.hashCode());
        n = 31 * n + (this.messageId == null ? 0 : this.messageId.hashCode());
        n = 31 * n + (this.structuredData == null ? 0 : ((Object)this.structuredData).hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        StructuredSyslogMessage structuredSyslogMessage = (StructuredSyslogMessage)object;
        if (this.message == null ? structuredSyslogMessage.message != null : !this.message.equals(structuredSyslogMessage.message)) {
            return false;
        }
        if (this.messageId == null ? structuredSyslogMessage.messageId != null : !this.messageId.equals(structuredSyslogMessage.messageId)) {
            return false;
        }
        return !(this.structuredData == null ? structuredSyslogMessage.structuredData != null : !((Object)this.structuredData).equals(structuredSyslogMessage.structuredData));
    }

    public String toString() {
        return this.serialize();
    }
}

