/*
 * Decompiled with CFR 0.152.
 */
package org.productivity.java.syslog4j.server.impl.net.tcp;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.net.ServerSocketFactory;
import org.productivity.java.syslog4j.SyslogRuntimeException;
import org.productivity.java.syslog4j.server.SyslogServerEventHandlerIF;
import org.productivity.java.syslog4j.server.SyslogServerEventIF;
import org.productivity.java.syslog4j.server.SyslogServerIF;
import org.productivity.java.syslog4j.server.impl.AbstractSyslogServer;
import org.productivity.java.syslog4j.server.impl.net.tcp.TCPNetSyslogServerConfigIF;
import org.productivity.java.syslog4j.util.SyslogUtility;

public class TCPNetSyslogServer
extends AbstractSyslogServer {
    protected ServerSocket serverSocket = null;
    protected Set sockets = new HashSet();
    protected TCPNetSyslogServerConfigIF tcpNetSyslogServerConfig = null;

    public void initialize() throws SyslogRuntimeException {
        this.tcpNetSyslogServerConfig = null;
        try {
            this.tcpNetSyslogServerConfig = (TCPNetSyslogServerConfigIF)((Object)this.syslogServerConfig);
        }
        catch (ClassCastException classCastException) {
            throw new SyslogRuntimeException("config must be of type TCPNetSyslogServerConfig");
        }
        if (this.syslogServerConfig == null) {
            throw new SyslogRuntimeException("config cannot be null");
        }
        if (this.tcpNetSyslogServerConfig.getBacklog() < 1) {
            this.tcpNetSyslogServerConfig.setBacklog(50);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void shutdown() {
        super.shutdown();
        try {
            if (this.serverSocket != null) {
                if (this.syslogServerConfig.getShutdownWait() > 0) {
                    try {
                        Thread.sleep(this.syslogServerConfig.getShutdownWait());
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                this.serverSocket.close();
            }
            Set set = this.sockets;
            synchronized (set) {
                if (this.sockets != null && this.sockets.size() > 0) {
                    Iterator iterator = this.sockets.iterator();
                    while (iterator.hasNext()) {
                        Socket socket = (Socket)iterator.next();
                        socket.close();
                    }
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.thread != null) {
            this.thread.interrupt();
            this.thread = null;
        }
    }

    protected ServerSocketFactory getServerSocketFactory() throws IOException {
        ServerSocketFactory serverSocketFactory = ServerSocketFactory.getDefault();
        return serverSocketFactory;
    }

    protected ServerSocket createServerSocket() throws IOException {
        ServerSocket serverSocket = null;
        ServerSocketFactory serverSocketFactory = this.getServerSocketFactory();
        if (this.syslogServerConfig.getHost() != null) {
            InetAddress inetAddress = InetAddress.getByName(this.syslogServerConfig.getHost());
            serverSocket = serverSocketFactory.createServerSocket(this.syslogServerConfig.getPort(), this.tcpNetSyslogServerConfig.getBacklog(), inetAddress);
        } else {
            serverSocket = this.tcpNetSyslogServerConfig.getBacklog() < 1 ? serverSocketFactory.createServerSocket(this.syslogServerConfig.getPort()) : serverSocketFactory.createServerSocket(this.syslogServerConfig.getPort(), this.tcpNetSyslogServerConfig.getBacklog());
        }
        return serverSocket;
    }

    public void run() {
        try {
            this.serverSocket = this.createServerSocket();
            this.shutdown = false;
        }
        catch (SocketException socketException) {
            throw new SyslogRuntimeException(socketException);
        }
        catch (IOException iOException) {
            throw new SyslogRuntimeException(iOException);
        }
        while (!this.shutdown) {
            try {
                Socket socket = this.serverSocket.accept();
                TCPNetSyslogSocketHandler tCPNetSyslogSocketHandler = new TCPNetSyslogSocketHandler(this.sockets, this, socket);
                Thread thread = new Thread(tCPNetSyslogSocketHandler);
                thread.start();
            }
            catch (SocketException socketException) {
                if (!"Socket closed".equals(socketException.getMessage())) continue;
                this.shutdown = true;
            }
            catch (IOException iOException) {
                System.err.println(iOException);
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public static class TCPNetSyslogSocketHandler
    implements Runnable {
        protected SyslogServerIF server = null;
        protected Socket socket = null;
        protected Set sockets = null;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TCPNetSyslogSocketHandler(Set set, SyslogServerIF syslogServerIF, Socket socket) {
            this.sockets = set;
            this.server = syslogServerIF;
            this.socket = socket;
            Set set2 = this.sockets;
            synchronized (set2) {
                this.sockets.add(this.socket);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            Object object;
            try {
                object = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
                String string = ((BufferedReader)object).readLine();
                while (string != null && string.length() != 0) {
                    byte[] byArray = SyslogUtility.getBytes(this.server.getConfig(), string);
                    SyslogServerEventIF syslogServerEventIF = TCPNetSyslogServer.createEvent(this.server.getConfig(), byArray, byArray.length, this.socket.getInetAddress());
                    List list = this.server.getConfig().getEventHandlers();
                    for (int i = 0; i < list.size(); ++i) {
                        SyslogServerEventHandlerIF syslogServerEventHandlerIF = (SyslogServerEventHandlerIF)list.get(i);
                        syslogServerEventHandlerIF.event(this.server, syslogServerEventIF);
                    }
                    string = ((BufferedReader)object).readLine();
                }
            }
            catch (SocketException socketException) {
                if (!"Socket closed".equals(socketException.getMessage())) {
                    // empty if block
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.socket.close();
                object = this.sockets;
                synchronized (object) {
                    this.sockets.remove(this.socket);
                    return;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

