/*
 * Decompiled with CFR 0.152.
 */
package com.sobercoding.loopauth.servlet.filter;

import com.sobercoding.loopauth.function.LoopAuthErrorFilter;
import com.sobercoding.loopauth.function.LoopAuthFilterFun;
import com.sobercoding.loopauth.model.LoopAuthHttpMode;
import com.sobercoding.loopauth.session.carryout.LoopAuthSession;
import com.sobercoding.loopauth.util.LoopAuthUtil;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

public class LoopAuthServletFilter
implements Filter {
    private ConcurrentHashMap<String, HashSet<LoopAuthHttpMode>> includeList = new ConcurrentHashMap();
    private ConcurrentHashMap<String, HashSet<LoopAuthHttpMode>> excludeList = new ConcurrentHashMap();
    public LoopAuthFilterFun loopAuthFilterFun = (isIntercept, route) -> {
        if (isIntercept) {
            LoopAuthSession.isLogin();
        }
    };
    public LoopAuthErrorFilter loopAuthErrorFilter = e -> {
        e.printStackTrace();
        return e.getMessage();
    };

    public LoopAuthServletFilter addInclude(String path, LoopAuthHttpMode ... mode) {
        if (mode.length <= 0) {
            this.includeList.put(path, new HashSet<LoopAuthHttpMode>(Collections.singleton(LoopAuthHttpMode.ALL)));
        } else {
            this.includeList.put(path, new HashSet<LoopAuthHttpMode>(Arrays.asList(mode)));
        }
        return this;
    }

    public LoopAuthServletFilter addExclude(String path, LoopAuthHttpMode ... mode) {
        if (mode.length <= 0) {
            this.excludeList.put(path, new HashSet<LoopAuthHttpMode>(Collections.singleton(LoopAuthHttpMode.ALL)));
        } else {
            this.excludeList.put(path, new HashSet<LoopAuthHttpMode>(Arrays.asList(mode)));
        }
        return this;
    }

    public ConcurrentHashMap<String, HashSet<LoopAuthHttpMode>> getIncludeList() {
        return this.includeList;
    }

    public ConcurrentHashMap<String, HashSet<LoopAuthHttpMode>> getExcludeList() {
        return this.excludeList;
    }

    public LoopAuthServletFilter setLoopAuthFilter(LoopAuthFilterFun loopAuthFilterFun) {
        this.loopAuthFilterFun = loopAuthFilterFun;
        return this;
    }

    public LoopAuthServletFilter setLoopAuthErrorFilter(LoopAuthErrorFilter loopAuthErrorFilter) {
        this.loopAuthErrorFilter = loopAuthErrorFilter;
        return this;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            HttpServletRequest httpServletRequest = (HttpServletRequest)request;
            String route = httpServletRequest.getRequestURI();
            LoopAuthHttpMode loopAuthHttpMode = LoopAuthHttpMode.toEnum((String)httpServletRequest.getMethod());
            this.loopAuthFilterFun.run(LoopAuthUtil.matchPaths(this.excludeList, this.includeList, (String)route, (LoopAuthHttpMode)loopAuthHttpMode), route);
        }
        catch (Throwable e) {
            String result = String.valueOf(this.loopAuthErrorFilter.run(e));
            if (response.getContentType() == null) {
                response.setContentType("text/plain; charset=utf-8");
            }
            response.getWriter().print(result);
            return;
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }
}

