/*
 * Decompiled with CFR 0.152.
 */
package com.sourcecoding.multitenancy;

import com.sourcecoding.multitenancy.AbstractMultiTenancyUser;
import com.sourcecoding.multitenancy.AbstractMultiTenancyUserRole;
import com.sourcecoding.multitenancy.MultiTenancyEntity;
import com.sourcecoding.multitenancy.MultiTenancyPrincipal;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.ejb.SessionContext;
import javax.ejb.Startup;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.metamodel.EntityType;

@Stateless
@Startup
public class MultiTenancyService {
    private List<String> multiTenancyObjects = new ArrayList<String>();
    private String userTableEntityName;
    private String userRoleTableEntityName;
    @PersistenceContext
    EntityManager em;
    @Resource
    private SessionContext sctx;

    @PostConstruct
    public void init() {
        System.out.println("Initalize Multitenancy entities");
        long time = System.currentTimeMillis();
        ArrayList<String> list = new ArrayList<String>();
        for (EntityType et : this.em.getMetamodel().getEntities()) {
            Class c = et.getJavaType();
            if (c.getAnnotation(Entity.class) == null) continue;
            try {
                Object o = c.newInstance();
                if (o instanceof MultiTenancyEntity) {
                    String tablename = c.getSimpleName();
                    System.out.println("Multitenancy class: " + c.getName());
                    list.add(tablename);
                }
                if (o instanceof AbstractMultiTenancyUser) {
                    if (this.userTableEntityName != null) {
                        throw new RuntimeException("The MultiTenancyUser can only have one instance.");
                    }
                    this.userTableEntityName = c.getSimpleName();
                }
                if (!(o instanceof AbstractMultiTenancyUserRole)) continue;
                if (this.userRoleTableEntityName != null) {
                    throw new RuntimeException("The MultiTenancyUserRole can only have one instance.");
                }
                this.userRoleTableEntityName = c.getSimpleName();
            }
            catch (IllegalAccessException | InstantiationException e) {}
        }
        if (this.userTableEntityName == null || this.userRoleTableEntityName == null) {
            throw new RuntimeException("There has to be an instance of (Abstract)MultiTenancyUserRole and (Abstract)MultTenancyiUserRole");
        }
        this.multiTenancyObjects = Collections.unmodifiableList(list);
        System.out.println("dauer: " + (System.currentTimeMillis() - time) + "ms");
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    public AbstractMultiTenancyUser getMultiTenancyUser(String tenant, String name) {
        AbstractMultiTenancyUser mtu = (AbstractMultiTenancyUser)this.em.createQuery("select m from " + this.userTableEntityName + " m where m.tenant = ? and m.username = ?").setParameter(1, (Object)tenant).setParameter(2, (Object)name).getSingleResult();
        if (mtu == null) {
            return null;
        }
        mtu.getRoles().size();
        return mtu;
    }

    public MultiTenancyPrincipal getPrincipal() {
        Principal p = this.sctx.getCallerPrincipal();
        if (p instanceof MultiTenancyPrincipal) {
            return (MultiTenancyPrincipal)p;
        }
        return null;
    }

    public List<String> getAllMultiTenancyTableNames() {
        return this.multiTenancyObjects;
    }

    public List<AbstractMultiTenancyUser> getMultiTenancyUserList(String tenant) {
        List mtuList = this.em.createQuery("select m from " + this.userTableEntityName + " m where m.tenant = ?").setParameter(1, (Object)tenant).getResultList();
        for (AbstractMultiTenancyUser mtu : mtuList) {
            mtu.getRoles().size();
        }
        return mtuList;
    }
}

