/*
 * Decompiled with CFR 0.152.
 */
package com.sourcecoding.multitenancy;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class SecurityTools {
    private static final int ITERATION_NUMBER = 1000;

    public static boolean checkPassword(String clearText, String hash) {
        if (clearText == null || hash == null || hash.length() < 30) {
            return false;
        }
        try {
            String salt = hash.substring(27) + "=";
            String digest = hash.substring(0, 27) + "=";
            BASE64Decoder base64 = new BASE64Decoder();
            byte[] bDigest = base64.decodeBuffer(digest);
            byte[] bSalt = base64.decodeBuffer(salt);
            byte[] proposedDigest = SecurityTools.getHash(1000, clearText, bSalt);
            return Arrays.equals(proposedDigest, bDigest);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String ... args) {
        String hash = SecurityTools.createHash(args[0]);
        System.out.println("hash:");
        System.out.println(SecurityTools.createHash(args[0]));
        System.out.println("validate: " + SecurityTools.checkPassword(args[0], hash));
    }

    public static String createHash(String password) {
        if (password == null) {
            throw new RuntimeException("Build a hash from null is not possible!");
        }
        try {
            SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
            byte[] bSalt = new byte[8];
            random.nextBytes(bSalt);
            byte[] bDigest = SecurityTools.getHash(1000, password, bSalt);
            BASE64Encoder base64 = new BASE64Encoder();
            String sDigest = base64.encode(bDigest);
            String sSalt = base64.encode(bSalt);
            sDigest = sDigest.substring(0, sDigest.length() - 1);
            sSalt = sSalt.substring(0, sSalt.length() - 1);
            return sDigest + sSalt;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] getHash(int iterationNb, String password, byte[] salt) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        MessageDigest digest = MessageDigest.getInstance("SHA-1");
        digest.reset();
        digest.update(salt);
        byte[] input = digest.digest(password.getBytes("UTF-8"));
        for (int i = 0; i < iterationNb; ++i) {
            digest.reset();
            input = digest.digest(input);
        }
        return input;
    }
}

