/*
 * Copyright (C) 2012 sourcecoding.com / Matthias Reining
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.sourcecoding.multitenancy;

import java.security.Principal;
import java.util.List;

import org.jboss.security.SimplePrincipal;

/**
 * @author matthias reining
 */
public class MultiTenancyPrincipal extends SimplePrincipal implements Principal {

	private static final long serialVersionUID = 1L;

	protected MultiTenancyUser mtu;

	public <T extends MultiTenancyUser> MultiTenancyPrincipal(T mtu) {
		super(mtu.getUsername());
		this.mtu = mtu;
	}

	@Override
	public String getName() {
		return mtu.getUsername();
	}

	public String getTenant() {
		return mtu.getTenant();
	}

	public List<? extends MultiTenancyUserRole> getUserRoles() {
		return mtu.getRoles();
	}

}
