/*
 * Decompiled with CFR 0.152.
 */
package com.sourcecoding.multitenancy;

import java.lang.annotation.Annotation;
import java.util.Set;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.util.AnnotationLiteral;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public final class ManagedObject {
    private ManagedObject() {
    }

    public static <T> T ejbLookup(Class<T> ejbClass) {
        String jndiName = "java:module/" + ejbClass.getSimpleName();
        try {
            return (T)new InitialContext().lookup(jndiName);
        }
        catch (NamingException e) {
            throw new IllegalArgumentException(String.format("Cannot find EJB class %s in JNDI %s", ejbClass, jndiName), e);
        }
    }

    public static <T> T cdiLookup(Class<T> clazz) {
        BeanManager bm = ManagedObject.getBeanManager();
        String beanName = clazz.getSimpleName();
        System.out.println("cdiLookup for " + beanName);
        Set beans = bm.getBeans(clazz, new Annotation[]{new AnnotationLiteral<Any>(){
            private static final long serialVersionUID = 1L;
        }});
        if (beans == null || beans.isEmpty()) {
            return null;
        }
        Bean bean = null;
        bean = (Bean)beans.iterator().next();
        if (beans.iterator().hasNext()) {
            System.out.println("WARNING, Qualifiers are at the moment not considered!");
        }
        CreationalContext ctx = bm.createCreationalContext((Contextual)bean);
        Object o = bm.getReference(bean, bean.getClass(), ctx);
        return (T)o;
    }

    private static BeanManager getBeanManager() {
        try {
            InitialContext initialContext = new InitialContext();
            return (BeanManager)initialContext.lookup("java:comp/BeanManager");
        }
        catch (NamingException e) {
            throw new RuntimeException("Couldn't find BeanManager in JNDI");
        }
    }
}

