/*
 * Decompiled with CFR 0.152.
 */
package com.sourcecoding.multitenancy;

import com.sourcecoding.multitenancy.ManagedObject;
import com.sourcecoding.multitenancy.MultiTenancyPrincipal;
import com.sourcecoding.multitenancy.MultiTenancyService;
import com.sourcecoding.multitenancy.MultiTenancyUser;
import com.sourcecoding.multitenancy.MultiTenancyUserRole;
import com.sourcecoding.multitenancy.SecurityTools;
import java.security.Principal;
import java.security.acl.Group;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import org.jboss.security.SimpleGroup;
import org.jboss.security.SimplePrincipal;
import org.jboss.security.auth.spi.DatabaseServerLoginModule;

public class MultiTenancyDatabaseServerLoginModule
extends DatabaseServerLoginModule {
    public static final String CLIENT_DELIMITER = "#";

    protected String getUsersPassword() throws LoginException {
        Principal p = this.getIdentity();
        if (!(p instanceof MultiTenancyPrincipal)) {
            return super.getUsersPassword();
        }
        return ((MultiTenancyPrincipal)p).mtu.getPassword();
    }

    protected boolean validatePassword(String inputPassword, String expectedPassword) {
        Principal p = this.getIdentity();
        if (!(p instanceof MultiTenancyPrincipal)) {
            return super.validatePassword(inputPassword, expectedPassword);
        }
        boolean ok = SecurityTools.checkPassword(inputPassword, expectedPassword);
        MultiTenancyService mtService = ManagedObject.ejbLookup(MultiTenancyService.class);
        mtService.handleAuthentication((MultiTenancyPrincipal)this.getIdentity(), ok);
        return ok;
    }

    protected Principal createIdentity(String username) throws Exception {
        int i = username.indexOf(CLIENT_DELIMITER);
        if (i == -1) {
            throw new LoginException("PB00026: Wrong Format:A multi-tenancy 'username' must have a delimiter ('#')!");
        }
        String tenant = username.substring(0, i);
        username = username.substring(i + 1);
        MultiTenancyService mtService = ManagedObject.ejbLookup(MultiTenancyService.class);
        try {
            MultiTenancyUser mtu = mtService.getMultiTenancyUser(tenant, username);
            MultiTenancyPrincipal ip = new MultiTenancyPrincipal(mtu);
            return ip;
        }
        catch (Exception e) {
            if (this.trace) {
                this.log.trace((Object)"Query returned no matches from db");
            }
            throw new FailedLoginException("PB00019: Processing Failed:No matching username found in Principals");
        }
    }

    protected Group[] getRoleSets() throws LoginException {
        Principal identity = this.getIdentity();
        SimpleGroup group = new SimpleGroup("Roles");
        if (!(identity instanceof MultiTenancyPrincipal)) {
            return super.getRoleSets();
        }
        for (MultiTenancyUserRole multiTenancyUserRole : ((MultiTenancyPrincipal)identity).getUserRoles()) {
            group.addMember((Principal)new SimplePrincipal(multiTenancyUserRole.getRole()));
        }
        return new Group[]{group};
    }
}

