/*
 * Decompiled with CFR 0.152.
 */
package com.sourcecoding.multitenancy;

import com.sourcecoding.multitenancy.ManagedObject;
import com.sourcecoding.multitenancy.MultiTenancyEntity;
import com.sourcecoding.multitenancy.MultiTenancyPrincipal;
import com.sourcecoding.multitenancy.MultiTenancyService;
import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hibernate.EmptyInterceptor;
import org.hibernate.type.Type;

public class MultiTenancyHibernateInterceptor
extends EmptyInterceptor {
    private static final long serialVersionUID = 1L;
    private static final String TENANT_ID_COLUMN = "tenantid";

    public String onPrepareStatement(String sql) {
        MultiTenancyService mtService = ManagedObject.ejbLookup(MultiTenancyService.class);
        MultiTenancyPrincipal mtp = mtService.getPrincipal();
        if (mtp == null) {
            return sql;
        }
        if (sql.contains("insert into")) {
            return sql;
        }
        for (String mto : mtService.getAllMultiTenancyTableNames()) {
            if (!sql.contains(mto)) continue;
            String client = mtp.getTenant();
            Matcher matcher = Pattern.compile(mto + " (\\w+)").matcher(sql);
            matcher.find();
            String tableAlias = matcher.group(1);
            StringBuffer sb = new StringBuffer(" where ");
            sb.append(tableAlias).append(".").append(TENANT_ID_COLUMN).append("=");
            sb.append("'").append(client).append("' ");
            if (sql.contains("where")) {
                String test = sql.substring(sql.indexOf(" where "));
                if (test.contains(TENANT_ID_COLUMN)) continue;
                sql = sql.replaceFirst(" where ", sb.toString() + " and ");
                continue;
            }
            sql = sql + sb.toString();
        }
        System.out.println("in meinem Interceptor: " + sql);
        return sql;
    }

    public boolean onFlushDirty(Object entity, Serializable id, Object[] currentState, Object[] previousState, String[] propertyNames, Type[] types) {
        if (entity instanceof MultiTenancyEntity) {
            String client = ManagedObject.ejbLookup(MultiTenancyService.class).getPrincipal().getTenant();
            for (int i = 0; i < propertyNames.length; ++i) {
                if (!TENANT_ID_COLUMN.equals(propertyNames[i])) continue;
                if (client.equals(currentState[i])) {
                    return false;
                }
                currentState[i] = client;
                return true;
            }
        }
        return false;
    }

    public boolean onSave(Object entity, Serializable id, Object[] state, String[] propertyNames, Type[] types) {
        if (entity instanceof MultiTenancyEntity) {
            String client = ManagedObject.ejbLookup(MultiTenancyService.class).getPrincipal().getTenant();
            for (int i = 0; i < propertyNames.length; ++i) {
                if (!TENANT_ID_COLUMN.equals(propertyNames[i])) continue;
                if (client.equals(state[i])) {
                    return false;
                }
                state[i] = client;
                return true;
            }
        }
        return false;
    }
}

