/*
 * Decompiled with CFR 0.152.
 */
package com.sourcecoding.multitenancy;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import org.jboss.security.Base64Utils;

public abstract class SecurityTools {
    private static final int ITERATION_NUMBER = 1000;

    public static boolean checkPassword(String clearText, String hash) {
        if (clearText == null || hash == null || hash.length() < 30) {
            return false;
        }
        try {
            String salt = hash.substring(27);
            String digest = hash.substring(0, 27);
            byte[] bDigest = Base64Utils.fromb64((String)digest);
            byte[] bSalt = Base64Utils.fromb64((String)salt);
            byte[] proposedDigest = SecurityTools.getHash(1000, clearText, bSalt);
            return Arrays.equals(proposedDigest, bDigest);
        }
        catch (IOException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String ... args) {
        String hash = SecurityTools.createHash(args[0]);
        System.out.println("pw: " + args[0]);
        System.out.println("hash: " + SecurityTools.createHash(args[0]));
        System.out.println("validate: " + SecurityTools.checkPassword(args[0], hash));
    }

    public static String createHash(String password) {
        if (password == null) {
            throw new RuntimeException("Build a hash from null is not possible!");
        }
        try {
            SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
            String hash = "";
            while (hash.length() != 38) {
                byte[] bSalt = random.generateSeed(8);
                byte[] bDigest = SecurityTools.getHash(1000, password, bSalt);
                String sDigest = Base64Utils.tob64((byte[])bDigest);
                String sSalt = Base64Utils.tob64((byte[])bSalt);
                hash = sDigest + sSalt;
            }
            return hash;
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] getHash(int iterationNb, String password, byte[] salt) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        MessageDigest digest = MessageDigest.getInstance("SHA-1");
        digest.reset();
        digest.update(salt);
        byte[] input = digest.digest(password.getBytes("UTF-8"));
        for (int i = 0; i < iterationNb; ++i) {
            digest.reset();
            input = digest.digest(input);
        }
        return input;
    }
}

