/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.clienttlstools.https;

import com.google.common.base.Preconditions;
import com.spotify.clienttlstools.https.CertHttpsHandler;
import com.spotify.clienttlstools.tls.CertKey;
import com.spotify.clienttlstools.tls.CertKeyPaths;
import java.io.IOException;
import java.nio.file.Path;
import java.security.GeneralSecurityException;

public class CertFileHttpsHandler
extends CertHttpsHandler {
    private final CertKeyPaths certKeyPaths;

    private CertFileHttpsHandler(String user, boolean failOnCertError, CertKeyPaths certKeyPaths) {
        super(user, failOnCertError);
        this.certKeyPaths = (CertKeyPaths)Preconditions.checkNotNull((Object)certKeyPaths);
    }

    static CertFileHttpsHandler create(String user, boolean failOnError, CertKeyPaths certKeyPaths) {
        return new CertFileHttpsHandler(user, failOnError, certKeyPaths);
    }

    @Override
    protected CertKey createCertKey() throws IOException, GeneralSecurityException {
        return CertKey.fromPaths((Path)this.certKeyPaths.certPath(), (Path)this.certKeyPaths.keyPath());
    }

    @Override
    protected String getCertSource() {
        return this.certKeyPaths.toString();
    }
}

