/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.clienttlstools.https;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.spotify.clienttlstools.https.HttpsHandler;
import com.spotify.clienttlstools.tls.CertKey;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import org.apache.http.ssl.SSLContexts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class CertHttpsHandler
implements HttpsHandler {
    private static final Logger LOG = LoggerFactory.getLogger(CertHttpsHandler.class);
    private static final char[] KEY_STORE_PASSWORD = "FPLSlZQuM3ZCM3SjINSKuWyPK2HeS4".toCharArray();
    private final String user;
    private final boolean failOnCertError;

    CertHttpsHandler(String user, boolean failOnCertError) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)user) ? 1 : 0) != 0);
        this.user = user;
        this.failOnCertError = failOnCertError;
    }

    String getUser() {
        return this.user;
    }

    protected abstract CertKey createCertKey() throws IOException, GeneralSecurityException;

    protected abstract String getCertSource();

    @Override
    public void handle(HttpsURLConnection conn) {
        CertKey certKey;
        try {
            certKey = this.createCertKey();
        }
        catch (IOException | GeneralSecurityException e) {
            if (this.failOnCertError) {
                throw new RuntimeException(e);
            }
            LOG.warn("Error when setting up client certificates fromPaths {}. Error was '{}'. No cert will be sent with request.", (Object)this.getCertSource(), (Object)e.toString());
            LOG.debug("full exception fromPaths setting up ClientCertificate follows", (Throwable)e);
            return;
        }
        Certificate cert = certKey.cert();
        PrivateKey key = certKey.key();
        try {
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(null, null);
            keyStore.setCertificateEntry("client", cert);
            keyStore.setKeyEntry("key", key, KEY_STORE_PASSWORD, new Certificate[]{cert});
            SSLContext sslContext = SSLContexts.custom().useProtocol("TLS").loadKeyMaterial(keyStore, KEY_STORE_PASSWORD).build();
            conn.setSSLSocketFactory(sslContext.getSocketFactory());
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
            throw new RuntimeException(e);
        }
    }
}

