/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.clienttlstools.https;

import com.google.common.base.Preconditions;
import com.spotify.clienttlstools.https.CertHttpsHandler;
import com.spotify.clienttlstools.tls.CertKey;
import com.spotify.clienttlstools.tls.SshAgentContentSigner;
import com.spotify.clienttlstools.tls.X509CachingCertKeyCreator;
import com.spotify.clienttlstools.tls.X509CertKeyCreator;
import com.spotify.sshagentproxy.AgentProxy;
import com.spotify.sshagentproxy.Identity;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.bouncycastle.operator.ContentSigner;

public class SshAgentHttpsHandler
extends CertHttpsHandler {
    private static final Path CERT_CACHE_DIR = Paths.get(System.getProperty("user.home"), ".client-tls-tools", "cert_cache");
    private final Identity identity;
    private final X509CachingCertKeyCreator x509CachingCertKeyCreator;

    private SshAgentHttpsHandler(String user, boolean failOnCertError, AgentProxy agentProxy, Identity identity) {
        super(user, failOnCertError);
        Preconditions.checkNotNull((Object)agentProxy, (Object)"agentProxy");
        this.identity = (Identity)Preconditions.checkNotNull((Object)identity, (Object)"identity");
        SshAgentContentSigner contentSigner = SshAgentContentSigner.create((AgentProxy)agentProxy, (Identity)identity);
        X509CertKeyCreator delegate = X509CertKeyCreator.create((String)this.getUser(), (ContentSigner)contentSigner);
        this.x509CachingCertKeyCreator = X509CachingCertKeyCreator.create((X509CertKeyCreator)delegate, (Path)CERT_CACHE_DIR, (Identity)identity, (String)this.getUser());
    }

    static SshAgentHttpsHandler create(String user, boolean failOnCertError, AgentProxy agentProxy, Identity identity) {
        return new SshAgentHttpsHandler(user, failOnCertError, agentProxy, identity);
    }

    @Override
    protected CertKey createCertKey() {
        return this.x509CachingCertKeyCreator.createCertKey();
    }

    @Override
    protected String getCertSource() {
        return "ssh-agent key: " + this.identity.getComment();
    }
}

