/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.dataenum.processor.generator.match;

import com.spotify.dataenum.processor.parser.ParserException;
import com.spotify.dataenum.processor.util.Iterables;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeVariableName;
import java.util.ArrayList;

class TypeVariableUtils {
    TypeVariableUtils() {
    }

    static TypeName withoutMissingTypeVariables(TypeName typeName, Iterable<TypeVariableName> availableTypeVariables) throws ParserException {
        if (!(typeName instanceof ParameterizedTypeName) || availableTypeVariables == null) {
            return typeName;
        }
        ParameterizedTypeName parameterizedTypeName = (ParameterizedTypeName)typeName;
        ArrayList<Object> adjustedArguments = new ArrayList<Object>();
        for (TypeName argument : parameterizedTypeName.typeArguments) {
            if (argument instanceof ParameterizedTypeName) {
                adjustedArguments.add(TypeVariableUtils.withoutMissingTypeVariables(argument, availableTypeVariables));
                continue;
            }
            if (argument instanceof TypeVariableName) {
                TypeVariableName variable = (TypeVariableName)argument;
                if (Iterables.contains(availableTypeVariables, variable)) {
                    adjustedArguments.add(variable);
                    continue;
                }
                if (variable.bounds.size() == 0) {
                    adjustedArguments.add(TypeName.OBJECT);
                    continue;
                }
                if (variable.bounds.size() == 1) {
                    adjustedArguments.add(variable.bounds.get(0));
                    continue;
                }
                throw new ParserException("More than one generic type bound is not supported");
            }
            adjustedArguments.add(argument);
        }
        TypeName[] adjustedArgumentsArr = adjustedArguments.toArray(new TypeName[0]);
        return ParameterizedTypeName.get((ClassName)parameterizedTypeName.rawType, (TypeName[])adjustedArgumentsArr);
    }
}

