/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.dataenum.processor;

import com.spotify.dataenum.DataEnum;
import com.spotify.dataenum.DataenumUtils;
import com.spotify.dataenum.processor.data.OutputSpec;
import com.spotify.dataenum.processor.data.Parameter;
import com.spotify.dataenum.processor.data.Spec;
import com.spotify.dataenum.processor.data.Value;
import com.spotify.dataenum.processor.generator.data.OutputSpecFactory;
import com.spotify.dataenum.processor.generator.spec.SpecTypeFactory;
import com.spotify.dataenum.processor.parser.ParserException;
import com.spotify.dataenum.processor.parser.SpecParser;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;

public class DataEnumProcessor
extends AbstractProcessor {
    @Override
    public boolean process(Set<? extends TypeElement> set, RoundEnvironment roundEnvironment) {
        Filer filer = this.processingEnv.getFiler();
        Messager messager = this.processingEnv.getMessager();
        for (Element element : roundEnvironment.getElementsAnnotatedWith(DataEnum.class)) {
            try {
                Spec spec = SpecParser.parse(element, this.processingEnv);
                if (spec == null) continue;
                OutputSpec outputSpec = OutputSpecFactory.create(spec);
                TypeSpec outputTypeSpec = SpecTypeFactory.create(outputSpec);
                JavaFile.Builder javaFileBuilder = JavaFile.builder((String)outputSpec.outputClass().packageName(), (TypeSpec)outputTypeSpec);
                if (DataEnumProcessor.needsCheckNotNull(spec)) {
                    javaFileBuilder.addStaticImport(DataenumUtils.class, new String[]{"checkNotNull"});
                }
                if (DataEnumProcessor.needsNullSafeEquals(spec)) {
                    javaFileBuilder.addStaticImport(DataenumUtils.class, new String[]{"equal"});
                }
                JavaFile javaFile = javaFileBuilder.build();
                javaFile.writeTo(filer);
            }
            catch (ParserException | IOException e) {
                messager.printMessage(Diagnostic.Kind.ERROR, e.getMessage());
            }
        }
        return false;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return Collections.singleton(DataEnum.class.getCanonicalName());
    }

    private static boolean needsCheckNotNull(Spec enumDef) {
        for (Value value : enumDef.values()) {
            for (Parameter parameter : value.parameters()) {
                if (parameter.type().isPrimitive() || parameter.canBeNull()) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean needsNullSafeEquals(Spec enumDef) {
        for (Value value : enumDef.values()) {
            for (Parameter parameter : value.parameters()) {
                if (parameter.type().isPrimitive() || !parameter.canBeNull()) continue;
                return true;
            }
        }
        return false;
    }
}

