/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.dataenum.processor.generator.data;

import com.spotify.dataenum.processor.data.OutputSpec;
import com.spotify.dataenum.processor.data.OutputValue;
import com.spotify.dataenum.processor.data.Spec;
import com.spotify.dataenum.processor.data.Value;
import com.spotify.dataenum.processor.generator.data.OutputValueFactory;
import com.spotify.dataenum.processor.parser.ParserException;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;
import java.util.ArrayList;

public final class OutputSpecFactory {
    static final String SUFFIX = "_dataenum";

    private OutputSpecFactory() {
    }

    public static OutputSpec create(Spec spec) throws ParserException {
        ClassName specClass = spec.specClass();
        ClassName outputClass = OutputSpecFactory.toOutputClass((TypeName)specClass);
        ArrayList<OutputValue> values = new ArrayList<OutputValue>();
        for (Value value : spec.values()) {
            values.add(OutputValueFactory.create(value, outputClass, spec));
        }
        return new OutputSpec(spec, outputClass, values);
    }

    public static ClassName toOutputClass(TypeName dataEnumType) throws ParserException {
        ClassName dataEnumClass = (ClassName)dataEnumType;
        String packageName = dataEnumClass.packageName();
        String name = dataEnumClass.simpleName();
        if (!name.endsWith(SUFFIX)) {
            throw new ParserException(String.format("Bad name for DataEnum interface! Name must end with '%s', found: %s", SUFFIX, name));
        }
        String nameWithoutSuffix = name.substring(0, name.length() - SUFFIX.length());
        return ClassName.get((String)packageName, (String)nameWithoutSuffix, (String[])new String[0]);
    }
}

