/*
 * -\-\-
 * DataEnum
 * --
 * Copyright (c) 2017 Spotify AB
 * --
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * -/-/-
 */
package com.spotify.dataenum.processor.data;

import com.squareup.javapoet.TypeName;

public class Parameter {
  private final String name;
  private final TypeName type;
  private final boolean nullable;
  private final boolean redacted;
  private final boolean isEnum;

  public Parameter(String name, TypeName type, boolean nullable, boolean redacted, boolean isEnum) {
    this.name = name;
    this.type = type;
    this.nullable = nullable;
    this.redacted = redacted;
    this.isEnum = isEnum;
  }

  public String name() {
    return name;
  }

  public TypeName type() {
    return type;
  }

  public boolean canBeNull() {
    return nullable;
  }

  public boolean redacted() {
    return redacted;
  }

  public boolean isEnum() {
    return isEnum;
  }
}
