/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.dataenum.processor.generator.data;

import com.spotify.dataenum.processor.data.OutputValue;
import com.spotify.dataenum.processor.data.Parameter;
import com.spotify.dataenum.processor.data.Spec;
import com.spotify.dataenum.processor.data.Value;
import com.spotify.dataenum.processor.generator.data.OutputSpecFactory;
import com.spotify.dataenum.processor.parser.ParserException;
import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeVariableName;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;

final class OutputValueFactory {
    private OutputValueFactory() {
    }

    static OutputValue create(Value value, ClassName specOutputClass, Spec spec) throws ParserException {
        ClassName outputClass = specOutputClass.nestedClass(value.name());
        Iterable<TypeVariableName> typeVariables = OutputValueFactory.getTypeVariables(value, spec.typeVariables());
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        for (Parameter parameter : value.parameters()) {
            TypeName rawParamType = OutputValueFactory.withoutTypeParameters(parameter.type());
            if (OutputValueFactory.isDataEnumParameter(rawParamType)) {
                TypeName paramOutputType = OutputValueFactory.withParametersFromOther(OutputSpecFactory.toOutputClass((ClassName)rawParamType), parameter.type());
                parameters.add(new Parameter(parameter.name(), paramOutputType, parameter.canBeNull(), parameter.redacted(), false));
                continue;
            }
            parameters.add(parameter);
        }
        return new OutputValue(outputClass, value.name(), parameters, typeVariables);
    }

    private static boolean isDataEnumParameter(TypeName rawParamType) {
        return rawParamType.toString().endsWith("_dataenum") && rawParamType instanceof ClassName;
    }

    private static Iterable<TypeVariableName> getTypeVariables(Value value, Iterable<TypeVariableName> typeVariables) {
        LinkedHashSet<TypeVariableName> output = new LinkedHashSet<TypeVariableName>();
        for (TypeVariableName typeVariable : typeVariables) {
            for (Parameter parameter : value.parameters()) {
                if (!OutputValueFactory.typeNeedsTypeVariable(parameter.type(), typeVariable)) continue;
                output.add(typeVariable);
            }
        }
        return output;
    }

    private static boolean typeNeedsTypeVariable(TypeName type, TypeVariableName typeVariable) {
        if (typeVariable.equals((Object)type)) {
            return true;
        }
        if (type instanceof ParameterizedTypeName) {
            ParameterizedTypeName parameterized = (ParameterizedTypeName)type;
            for (TypeName typeArgument : parameterized.typeArguments) {
                if (!typeVariable.equals((Object)typeArgument)) continue;
                return true;
            }
        }
        if (type instanceof ArrayTypeName) {
            ArrayTypeName arrayType = (ArrayTypeName)type;
            if (typeVariable.equals((Object)arrayType.componentType)) {
                return true;
            }
        }
        return false;
    }

    private static TypeName withoutTypeParameters(TypeName typeName) {
        if (typeName instanceof ParameterizedTypeName) {
            return ((ParameterizedTypeName)typeName).rawType;
        }
        return typeName;
    }

    private static TypeName withParametersFromOther(ClassName className, TypeName other) {
        if (other instanceof ParameterizedTypeName) {
            List typeArguments = ((ParameterizedTypeName)other).typeArguments;
            TypeName[] typeArgumentsArr = typeArguments.toArray(new TypeName[0]);
            return ParameterizedTypeName.get((ClassName)className, (TypeName[])typeArgumentsArr);
        }
        return className;
    }
}

