/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.dataenum.processor.parser;

import com.spotify.dataenum.processor.data.Spec;
import com.spotify.dataenum.processor.data.Value;
import com.spotify.dataenum.processor.parser.ValuesParser;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeVariableName;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.tools.Diagnostic;

public final class SpecParser {
    private SpecParser() {
    }

    public static Spec parse(Element element, ProcessingEnvironment processingEnv) {
        Messager messager = processingEnv.getMessager();
        if (element.getKind() != ElementKind.INTERFACE) {
            messager.printMessage(Diagnostic.Kind.ERROR, "@DataEnum can only be used on interfaces.", element);
            return null;
        }
        TypeElement dataEnum = (TypeElement)element;
        ArrayList<TypeVariableName> typeVariableNames = new ArrayList<TypeVariableName>();
        for (TypeParameterElement typeParameterElement : dataEnum.getTypeParameters()) {
            typeVariableNames.add(TypeVariableName.get((TypeParameterElement)typeParameterElement));
        }
        List<Value> values = ValuesParser.parse(dataEnum, processingEnv);
        if (values == null) {
            return null;
        }
        ClassName className = ClassName.get((TypeElement)dataEnum);
        return new Spec(className, typeVariableNames, values);
    }
}

