/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.dataenum.processor.generator.data;

import com.spotify.dataenum.processor.data.OutputValue;
import com.spotify.dataenum.processor.data.Parameter;
import com.spotify.dataenum.processor.data.Spec;
import com.spotify.dataenum.processor.data.Value;
import com.spotify.dataenum.processor.generator.data.OutputSpecFactory;
import com.spotify.dataenum.processor.parser.ParserException;
import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeVariableName;
import java.util.ArrayList;
import java.util.LinkedHashSet;

final class OutputValueFactory {
    private OutputValueFactory() {
    }

    static OutputValue create(Value value, ClassName specOutputClass, Spec spec) throws ParserException {
        ClassName outputClass = specOutputClass.nestedClass(value.name());
        Iterable<TypeVariableName> typeVariables = OutputValueFactory.getTypeVariables(value, spec.typeVariables());
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        for (Parameter parameter : value.parameters()) {
            parameters.add(OutputValueFactory.parameterWithoutDataEnumSuffix(parameter));
        }
        return new OutputValue(outputClass, value.name(), value.javadoc(), parameters, typeVariables);
    }

    private static Parameter parameterWithoutDataEnumSuffix(Parameter parameter) throws ParserException {
        return new Parameter(parameter.name(), OutputValueFactory.typeWithoutDataEnumSuffixes(parameter.type()), parameter.canBeNull(), parameter.redacted(), parameter.isEnum());
    }

    private static TypeName typeWithoutDataEnumSuffixes(TypeName typeName) throws ParserException {
        if (typeName instanceof ParameterizedTypeName) {
            ParameterizedTypeName paramTypeName = (ParameterizedTypeName)typeName;
            ClassName outputClassName = OutputSpecFactory.isSpecClassName(paramTypeName.rawType) ? OutputSpecFactory.toOutputClassName(paramTypeName.rawType) : paramTypeName.rawType;
            TypeName[] typeArgumentsArr = new TypeName[paramTypeName.typeArguments.size()];
            for (int i = 0; i < typeArgumentsArr.length; ++i) {
                typeArgumentsArr[i] = OutputValueFactory.typeWithoutDataEnumSuffixes((TypeName)paramTypeName.typeArguments.get(i));
            }
            return ParameterizedTypeName.get((ClassName)outputClassName, (TypeName[])typeArgumentsArr);
        }
        if (typeName instanceof ClassName) {
            ClassName className = (ClassName)typeName;
            if (OutputSpecFactory.isSpecClassName(className)) {
                return OutputSpecFactory.toOutputClassName(className);
            }
            return className;
        }
        return typeName;
    }

    private static Iterable<TypeVariableName> getTypeVariables(Value value, Iterable<TypeVariableName> typeVariables) {
        LinkedHashSet<TypeVariableName> output = new LinkedHashSet<TypeVariableName>();
        for (TypeVariableName typeVariable : typeVariables) {
            for (Parameter parameter : value.parameters()) {
                if (!OutputValueFactory.typeNeedsTypeVariable(parameter.type(), typeVariable)) continue;
                output.add(typeVariable);
            }
        }
        return output;
    }

    private static boolean typeNeedsTypeVariable(TypeName type, TypeVariableName typeVariable) {
        if (typeVariable.equals((Object)type)) {
            return true;
        }
        if (type instanceof ParameterizedTypeName) {
            ParameterizedTypeName parameterized = (ParameterizedTypeName)type;
            for (TypeName typeArgument : parameterized.typeArguments) {
                if (typeVariable.equals((Object)typeArgument)) {
                    return true;
                }
                if (!OutputValueFactory.typeNeedsTypeVariable(typeArgument, typeVariable)) continue;
                return true;
            }
        }
        if (type instanceof ArrayTypeName) {
            ArrayTypeName arrayType = (ArrayTypeName)type;
            if (typeVariable.equals((Object)arrayType.componentType)) {
                return true;
            }
        }
        return false;
    }
}

