/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.dataenum.processor;

import com.spotify.dataenum.Access;
import com.spotify.dataenum.ConstructorAccess;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;

class AccessSelector {
    private final List<PackageAndAccess> packages;

    AccessSelector(Set<? extends Element> visibilityAnnotatedPackages) {
        this.packages = this.parseAnnotatedPackages(visibilityAnnotatedPackages);
    }

    private List<PackageAndAccess> parseAnnotatedPackages(Set<? extends Element> visibilityAnnotatedPackages) {
        ArrayList<PackageAndAccess> result = new ArrayList<PackageAndAccess>(visibilityAnnotatedPackages.size());
        for (Element element : visibilityAnnotatedPackages) {
            if (!(element instanceof PackageElement)) {
                throw new IllegalArgumentException("received a access annotated element that is not a package: " + element);
            }
            PackageElement packageElement = (PackageElement)element;
            result.add(new PackageAndAccess(packageElement.getQualifiedName().toString(), element.getAnnotation(ConstructorAccess.class).value()));
        }
        result.sort((o1, o2) -> ((PackageAndAccess)o2).packageName.length() - ((PackageAndAccess)o1).packageName.length());
        return result;
    }

    public Optional<Modifier> accessModifierFor(String packageName) {
        switch (this.accessFor(packageName)) {
            case PACKAGE_PRIVATE: {
                return Optional.empty();
            }
            case PRIVATE: {
                return Optional.of(Modifier.PRIVATE);
            }
            case PROTECTED: {
                return Optional.of(Modifier.PROTECTED);
            }
            case PUBLIC: {
                return Optional.of(Modifier.PUBLIC);
            }
        }
        throw new AssertionError((Object)"cannot get here");
    }

    private Access accessFor(String packageName) {
        for (PackageAndAccess packageAndAccess : this.packages) {
            if (!this.isParentOf(packageAndAccess.packageName, packageName)) continue;
            return packageAndAccess.access;
        }
        return Access.PACKAGE_PRIVATE;
    }

    private boolean isParentOf(String maybeParentPackage, String packageName) {
        if (!packageName.startsWith(maybeParentPackage)) {
            return false;
        }
        String[] parentParts = maybeParentPackage.split("\\.");
        String[] packageParts = packageName.split("\\.");
        String lastParentPackagePart = parentParts[parentParts.length - 1];
        return packageParts[parentParts.length - 1].equals(lastParentPackagePart);
    }

    private static class PackageAndAccess {
        private final String packageName;
        private final Access access;

        private PackageAndAccess(String packageName, Access access) {
            this.packageName = packageName;
            this.access = access;
        }
    }
}

