/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.dataenum.processor.data;

import com.spotify.dataenum.processor.data.Parameter;
import com.spotify.dataenum.processor.util.Iterables;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeVariableName;
import javax.annotation.Nullable;

public class OutputValue {
    private final ClassName outputClass;
    private final Iterable<TypeVariableName> typeVariables;
    private final String name;
    @Nullable
    private final String javadoc;
    private final Iterable<Parameter> parameters;
    private final Iterable<AnnotationSpec> annotations;

    public OutputValue(ClassName outputClass, String name, String javadoc, Iterable<Parameter> parameters, Iterable<TypeVariableName> typeVariables, Iterable<AnnotationSpec> annotations) {
        this.outputClass = outputClass;
        this.name = name;
        this.javadoc = javadoc;
        this.parameters = parameters;
        this.typeVariables = typeVariables;
        this.annotations = annotations;
    }

    public ClassName outputClass() {
        return this.outputClass;
    }

    public TypeName parameterizedOutputClass() {
        if (!this.hasTypeVariables()) {
            return this.outputClass();
        }
        TypeName[] typeNames = (TypeName[])Iterables.toArray(this.typeVariables(), TypeVariableName.class);
        return ParameterizedTypeName.get((ClassName)this.outputClass(), (TypeName[])typeNames);
    }

    public Iterable<TypeVariableName> typeVariables() {
        return this.typeVariables;
    }

    public boolean hasTypeVariables() {
        return !Iterables.isEmpty(this.typeVariables());
    }

    public String name() {
        return this.name;
    }

    @Nullable
    public String javadoc() {
        return this.javadoc;
    }

    public Iterable<Parameter> parameters() {
        return this.parameters;
    }

    public boolean hasParameters() {
        return !Iterables.isEmpty(this.parameters());
    }

    public Iterable<AnnotationSpec> annotations() {
        return this.annotations;
    }
}

