/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.dataenum.processor.generator.value;

import com.spotify.dataenum.processor.data.OutputSpec;
import com.spotify.dataenum.processor.data.OutputValue;
import com.spotify.dataenum.processor.data.Parameter;
import com.spotify.dataenum.processor.generator.value.ValueTypeFactory;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.lang.model.element.Modifier;

public class ValueMethods {
    private final OutputValue value;

    public ValueMethods(OutputValue value) {
        this.value = value;
    }

    public MethodSpec createFactoryMethod(OutputSpec spec) {
        MethodSpec.Builder factory = MethodSpec.methodBuilder((String)ValueMethods.asCamelCase(this.value.name())).addTypeVariables(spec.typeVariables()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns(spec.parameterizedOutputClass());
        if (this.value.javadoc() != null) {
            factory.addJavadoc(this.value.javadoc() + "\n\n", new Object[0]);
        }
        factory.addJavadoc("@return a {@link $T} (see {@link $T#$L} for source)\n", new Object[]{this.value.outputClass(), spec.specClass(), this.value.name()});
        for (AnnotationSpec annotationSpec : this.value.annotations()) {
            factory.addAnnotation(annotationSpec);
        }
        StringBuilder newString = new StringBuilder();
        ArrayList<Object> newArgs = new ArrayList<Object>();
        newString.append("return new $T(");
        newArgs.add(this.value.parameterizedOutputClass());
        boolean first = true;
        for (Parameter parameter : this.value.parameters()) {
            ParameterSpec.Builder builder = ParameterSpec.builder((TypeName)parameter.type(), (String)parameter.name(), (Modifier[])new Modifier[0]);
            if (!parameter.type().isPrimitive()) {
                if (parameter.canBeNull()) {
                    builder.addAnnotation(Nullable.class);
                } else {
                    builder.addAnnotation(Nonnull.class);
                }
            }
            factory.addParameter(builder.build());
            if (first) {
                newString.append("$L");
                first = false;
            } else {
                newString.append(", $L");
            }
            newArgs.add(parameter.name());
        }
        newString.append(")");
        if (spec.hasTypeVariables()) {
            newString.append(".as$L()");
            newArgs.add(spec.outputClass().simpleName());
        }
        factory.addStatement(newString.toString(), newArgs.toArray());
        return factory.build();
    }

    public MethodSpec createIsMethod() {
        return MethodSpec.methodBuilder((String)("is" + this.value.name())).returns(Boolean.TYPE).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addStatement("return (this instanceof $T)", new Object[]{this.value.outputClass()}).build();
    }

    public MethodSpec createAsMethod(OutputSpec spec) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)("as" + this.value.name())).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).returns(this.value.parameterizedOutputClass()).addStatement("return ($T) this", new Object[]{this.value.parameterizedOutputClass()});
        if (!ValueTypeFactory.extractMissingTypeVariablesForValue(this.value, spec).isEmpty() && this.value.hasTypeVariables()) {
            builder.addAnnotation(ValueTypeFactory.SUPPRESS_UNCHECKED_WARNINGS);
        }
        return builder.build();
    }

    private static String asCamelCase(String text) {
        return Character.toLowerCase(text.charAt(0)) + text.substring(1);
    }
}

