/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.dataenum.processor.data;

import com.spotify.dataenum.processor.data.OutputValue;
import com.spotify.dataenum.processor.data.Spec;
import com.spotify.dataenum.processor.util.Iterables;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeVariableName;

public class OutputSpec
extends Spec {
    private final ClassName outputClass;
    private final Iterable<OutputValue> outputValues;

    public OutputSpec(Spec input, ClassName outputClass, Iterable<OutputValue> outputValues) {
        super(input.specClass(), input.typeVariables(), input.superInterfaces(), input.values(), input.methods());
        this.outputClass = outputClass;
        this.outputValues = outputValues;
    }

    public ClassName outputClass() {
        return this.outputClass;
    }

    public TypeName parameterizedOutputClass() {
        if (!this.hasTypeVariables()) {
            return this.outputClass();
        }
        TypeName[] typeNames = (TypeName[])Iterables.toArray(this.typeVariables(), TypeVariableName.class);
        return ParameterizedTypeName.get((ClassName)this.outputClass(), (TypeName[])typeNames);
    }

    public Iterable<OutputValue> outputValues() {
        return this.outputValues;
    }
}

