/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.dataenum.processor.generator.method;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeVariableName;
import com.sun.source.tree.MethodTree;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.Trees;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeMirror;

public final class MethodMethods {
    private MethodMethods() {
    }

    public static MethodSpec.Builder builderFrom(ExecutableElement el, Function<Stream<Modifier>, Stream<Modifier>> adjustModifiers, Function<Stream<? extends AnnotationMirror>, Stream<? extends AnnotationMirror>> adjustAnnotations) {
        return MethodSpec.methodBuilder((String)el.getSimpleName().toString()).addModifiers((Iterable)adjustModifiers.apply(el.getModifiers().stream()).collect(Collectors.toSet())).addAnnotations((Iterable)adjustAnnotations.apply(el.getAnnotationMirrors().stream()).map(AnnotationSpec::get).collect(Collectors.toList())).addTypeVariables((Iterable)el.getTypeParameters().stream().map(TypeVariableName::get).collect(Collectors.toList())).returns(TypeName.get((TypeMirror)el.getReturnType())).addParameters((Iterable)el.getParameters().stream().map(ParameterSpec::get).collect(Collectors.toList())).varargs(el.isVarArgs()).addExceptions((Iterable)el.getThrownTypes().stream().map(TypeName::get).collect(Collectors.toList()));
    }

    public static CodeBlock codeBlockFrom(ExecutableElement el, Trees trees) {
        MethodTree methodTree = MethodLookup.lookupTree(el, trees);
        return methodTree.getBody().getStatements().stream().map(x -> CodeBlock.of((String)x.toString(), (Object[])new Object[0])).reduce(CodeBlock.of((String)"", (Object[])new Object[0]), (a, b) -> a.toBuilder().add(b).build());
    }

    private static class MethodLookup
    extends TreePathScanner<Void, Void> {
        private final Consumer<MethodTree> onMethod;

        private MethodLookup(Consumer<MethodTree> onMethod) {
            this.onMethod = onMethod;
        }

        public static MethodTree lookupTree(ExecutableElement methodElement, Trees trees) {
            assert (methodElement.getKind() == ElementKind.METHOD);
            AtomicReference methodRef = new AtomicReference();
            new MethodLookup(methodRef::set).scan(trees.getPath(methodElement), null);
            MethodTree method = (MethodTree)methodRef.get();
            assert (method != null);
            return method;
        }

        @Override
        public Void visitMethod(MethodTree methodTree, Void v) {
            this.onMethod.accept(methodTree);
            return (Void)super.visitMethod(methodTree, v);
        }
    }
}

