/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.dataenum.processor.generator.value;

import com.spotify.dataenum.processor.data.OutputSpec;
import com.spotify.dataenum.processor.data.OutputValue;
import com.spotify.dataenum.processor.data.Parameter;
import com.spotify.dataenum.processor.generator.match.MapMethods;
import com.spotify.dataenum.processor.generator.match.MatchMethods;
import com.spotify.dataenum.processor.parser.ParserException;
import com.spotify.dataenum.processor.util.Iterables;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import com.squareup.javapoet.WildcardTypeName;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.lang.model.element.Modifier;

public class ValueTypeFactory {
    static final AnnotationSpec SUPPRESS_UNCHECKED_WARNINGS = AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "$S", new Object[]{"unchecked"}).build();

    private ValueTypeFactory() {
    }

    public static TypeSpec create(OutputValue value, OutputSpec spec, MatchMethods matchMethods, MapMethods mapMethods, Optional<Modifier> constructorAccessModifier) throws ParserException {
        TypeSpec.Builder typeBuilder = TypeSpec.classBuilder((ClassName)value.outputClass()).addTypeVariables(value.typeVariables()).superclass(ValueTypeFactory.getSuperclassForValue(value, spec)).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL});
        typeBuilder.addMethod(ValueTypeFactory.createConstructor(value, constructorAccessModifier));
        typeBuilder.addFields(ValueTypeFactory.createFields(value));
        typeBuilder.addMethods(ValueTypeFactory.createGetters(value));
        typeBuilder.addMethod(ValueTypeFactory.createEquals(value));
        typeBuilder.addMethod(ValueTypeFactory.createHashCode(value));
        typeBuilder.addMethod(ValueTypeFactory.createToString(value));
        typeBuilder.addMethod(matchMethods.createFoldVoidMethod(value));
        typeBuilder.addMethod(mapMethods.createFoldMethod(value));
        if (spec.hasTypeVariables()) {
            typeBuilder.addMethod(ValueTypeFactory.createAsSpecMethod(value, spec));
        }
        return typeBuilder.build();
    }

    private static TypeName getSuperclassForValue(OutputValue value, OutputSpec spec) throws ParserException {
        if (!spec.hasTypeVariables()) {
            return spec.outputClass();
        }
        ArrayList<Object> superParameters = new ArrayList<Object>();
        for (TypeVariableName typeVariable : spec.typeVariables()) {
            if (Iterables.contains(value.typeVariables(), typeVariable)) {
                superParameters.add(typeVariable);
                continue;
            }
            if (typeVariable.bounds.size() == 0) {
                superParameters.add(TypeName.OBJECT);
                continue;
            }
            if (typeVariable.bounds.size() == 1) {
                superParameters.add(typeVariable.bounds.get(0));
                continue;
            }
            throw new ParserException("More than one generic type bound is not supported ");
        }
        return ParameterizedTypeName.get((ClassName)spec.outputClass(), (TypeName[])superParameters.toArray(new TypeName[0]));
    }

    private static MethodSpec createConstructor(OutputValue value, Optional<Modifier> constructorAccessModifier) {
        MethodSpec.Builder constructor = MethodSpec.constructorBuilder().addModifiers(Iterables.fromOptional(constructorAccessModifier));
        for (Parameter parameter : value.parameters()) {
            constructor.addParameter(parameter.type(), parameter.name(), new Modifier[0]);
            if (parameter.type().isPrimitive() || parameter.canBeNull()) {
                constructor.addStatement("this.$1L = $1L", new Object[]{parameter.name()});
                continue;
            }
            constructor.addStatement("this.$1L = checkNotNull($1L)", new Object[]{parameter.name()});
        }
        return constructor.build();
    }

    private static Iterable<FieldSpec> createFields(OutputValue value) {
        ArrayList<FieldSpec> fields = new ArrayList<FieldSpec>();
        for (Parameter parameter : value.parameters()) {
            fields.add(ValueTypeFactory.createField(parameter));
        }
        return fields;
    }

    private static Iterable<MethodSpec> createGetters(OutputValue value) {
        ArrayList<MethodSpec> getters = new ArrayList<MethodSpec>();
        for (Parameter parameter : value.parameters()) {
            getters.add(ValueTypeFactory.createGetter(parameter));
        }
        return getters;
    }

    private static FieldSpec createField(Parameter parameter) {
        return FieldSpec.builder((TypeName)parameter.type(), (String)parameter.name(), (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build();
    }

    private static MethodSpec createGetter(Parameter parameter) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)parameter.name()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).returns(parameter.type()).addStatement("return $L", new Object[]{parameter.name()});
        if (parameter.canBeNull()) {
            builder.addAnnotation(Nullable.class);
        } else if (!parameter.type().isPrimitive()) {
            builder.addAnnotation(Nonnull.class);
        }
        return builder.build();
    }

    private static MethodSpec createEquals(OutputValue value) throws ParserException {
        String fieldName;
        MethodSpec.Builder result = MethodSpec.methodBuilder((String)"equals").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Boolean.TYPE).addParameter(Object.class, "other", new Modifier[0]);
        if (!value.parameters().iterator().hasNext()) {
            result.addStatement("return other instanceof $T", new Object[]{value.outputClass()});
            return result.build();
        }
        result.addStatement("if (other == this) return true", new Object[0]);
        result.addStatement("if (!(other instanceof $T)) return false", new Object[]{value.outputClass()});
        TypeName wildCardTypeName = ValueTypeFactory.withWildCardTypeParameters(value);
        result.addStatement("$1T o = ($1T) other", new Object[]{wildCardTypeName});
        result.addCode("$[return ", new Object[0]);
        ArrayList<Parameter> usingReferenceEquality = new ArrayList<Parameter>();
        ArrayList<Parameter> usingArraysEquality = new ArrayList<Parameter>();
        ArrayList<Parameter> usingEquals = new ArrayList<Parameter>();
        for (Parameter parameter : value.parameters()) {
            if (ValueTypeFactory.isArrayType(parameter)) {
                usingArraysEquality.add(parameter);
                continue;
            }
            if (ValueTypeFactory.useReferenceEquality(parameter)) {
                usingReferenceEquality.add(parameter);
                continue;
            }
            usingEquals.add(parameter);
        }
        boolean first = true;
        for (Parameter parameter : usingReferenceEquality) {
            if (first) {
                first = false;
            } else {
                result.addCode("\n&& ", new Object[0]);
            }
            fieldName = parameter.name();
            result.addCode("o.$1L == $1L", new Object[]{fieldName});
        }
        for (Parameter parameter : usingArraysEquality) {
            if (first) {
                first = false;
            } else {
                result.addCode("\n&& ", new Object[0]);
            }
            result.addCode("$1T.equals(o.$2L, $2L)", new Object[]{ClassName.get(Arrays.class), parameter.name()});
        }
        for (Parameter parameter : usingEquals) {
            if (first) {
                first = false;
            } else {
                result.addCode("\n&& ", new Object[0]);
            }
            fieldName = parameter.name();
            if (parameter.canBeNull()) {
                result.addCode("equal(o.$1L, this.$1L)", new Object[]{fieldName});
                continue;
            }
            result.addCode("o.$1L.equals(this.$1L)", new Object[]{fieldName});
        }
        result.addCode(";\n$]", new Object[0]);
        return result.build();
    }

    private static boolean useReferenceEquality(Parameter parameter) {
        return parameter.isEnum() || parameter.type().isPrimitive();
    }

    private static TypeName withWildCardTypeParameters(OutputValue value) {
        if (!value.hasTypeVariables()) {
            return value.outputClass();
        }
        Object[] wildCards = new TypeName[Iterables.sizeOf(value.typeVariables())];
        Arrays.fill(wildCards, WildcardTypeName.subtypeOf((TypeName)TypeName.OBJECT));
        return ParameterizedTypeName.get((ClassName)value.outputClass(), (TypeName[])wildCards);
    }

    private static MethodSpec createHashCode(OutputValue value) {
        MethodSpec.Builder result = MethodSpec.methodBuilder((String)"hashCode").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Integer.TYPE);
        if (!value.hasParameters()) {
            result.addStatement("return 0", new Object[0]);
            return result.build();
        }
        result.addStatement("int result = 0", new Object[0]);
        int parameterCount = Iterables.sizeOf(value.parameters());
        int parameterIndex = 0;
        for (Parameter parameter : value.parameters()) {
            String fieldName = parameter.name();
            if (++parameterIndex == parameterCount) {
                result.addCode("return result * 31 + ", new Object[0]);
            } else {
                result.addCode("result = result * 31 + ", new Object[0]);
            }
            if (parameter.type().isPrimitive()) {
                TypeName boxedType = parameter.type().box();
                result.addStatement("$T.valueOf(this.$L).hashCode()", new Object[]{boxedType, fieldName});
                continue;
            }
            if (ValueTypeFactory.isArrayType(parameter)) {
                result.addStatement("$T.hashCode(this.$L)", new Object[]{ClassName.get(Arrays.class), fieldName});
                continue;
            }
            if (parameter.canBeNull()) {
                result.addStatement("(this.$1L != null ? this.$1L.hashCode() : 0)", new Object[]{fieldName});
                continue;
            }
            result.addStatement("this.$L.hashCode()", new Object[]{fieldName});
        }
        return result.build();
    }

    private static boolean isArrayType(Parameter parameter) {
        return parameter.type() instanceof ArrayTypeName;
    }

    private static MethodSpec createToString(OutputValue value) {
        MethodSpec.Builder result = MethodSpec.methodBuilder((String)"toString").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(String.class);
        if (!value.parameters().iterator().hasNext()) {
            result.addStatement("return \"$L{}\"", new Object[]{value.name()});
            return result.build();
        }
        result.addStatement("$1T builder = new $1T()", new Object[]{StringBuilder.class});
        boolean first = true;
        for (Parameter parameter : value.parameters()) {
            String fieldName = parameter.name();
            String valueFormat = parameter.redacted() ? "\"***\"" : (ValueTypeFactory.isArrayType(parameter) ? "Arrays.toString(this.$1L)" : "this.$1L");
            if (first) {
                first = false;
                result.addStatement(String.format("builder.append(\"$2L{$1N=\").append(%s)", valueFormat), new Object[]{fieldName, value.name()});
                continue;
            }
            result.addStatement(String.format("builder.append(\", $1N=\").append(%s)", valueFormat), new Object[]{fieldName});
        }
        result.addStatement("return builder.append('}').toString()", new Object[]{value.name()});
        return result.build();
    }

    private static MethodSpec createAsSpecMethod(OutputValue value, OutputSpec spec) {
        List<TypeVariableName> missingTypeVariables = ValueTypeFactory.extractMissingTypeVariablesForValue(value, spec);
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)("as" + spec.outputClass().simpleName())).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).returns(spec.parameterizedOutputClass()).addTypeVariables(missingTypeVariables).addStatement("return ($T) this", new Object[]{spec.parameterizedOutputClass()});
        if (!missingTypeVariables.isEmpty()) {
            builder.addAnnotation(SUPPRESS_UNCHECKED_WARNINGS);
        }
        return builder.build();
    }

    static List<TypeVariableName> extractMissingTypeVariablesForValue(OutputValue value, OutputSpec spec) {
        ArrayList<TypeVariableName> missingTypeVariables = new ArrayList<TypeVariableName>();
        for (TypeVariableName typeVariableName : spec.typeVariables()) {
            if (Iterables.contains(value.typeVariables(), typeVariableName)) continue;
            missingTypeVariables.add(typeVariableName);
        }
        return missingTypeVariables;
    }
}

