/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.dataenum.processor.parser;

import com.spotify.dataenum.processor.ProcessingContext;
import com.spotify.dataenum.processor.data.Value;
import com.spotify.dataenum.processor.parser.MethodParser;
import com.spotify.dataenum.processor.parser.ValueParser;
import com.squareup.javapoet.MethodSpec;
import com.sun.tools.javac.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.processing.Messager;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;

final class MembersParser {
    private static final String NOT_SUPPORTED_TYPE = "not-supported-type";
    private static final String NOT_SUPPORTED_METHOD = "not-supported-method";
    private static final String VALUE = "value";
    private static final String ADT_METHOD = "adt-method";

    private MembersParser() {
    }

    static Pair<List<Value>, List<MethodSpec>> parse(TypeElement enumElement, ProcessingContext ctx) {
        Messager messager = ctx.env.getMessager();
        boolean error = false;
        ArrayList<Value> values = new ArrayList<Value>();
        HashSet<String> lowerCaseValueNames = new HashSet<String>();
        ClassifiedElements classified = new ClassifiedElementsFactory(() -> ctx).get(enumElement.getEnclosedElements());
        if (classified.containsNotSupportedTypes()) {
            error = true;
            classified.notSupportedTypes().forEach(element -> messager.printMessage(Diagnostic.Kind.ERROR, String.format("Value specs must be methods, found %s: %s", element.getKind().toString().toLowerCase(), element), (Element)element));
        }
        if (classified.containsNotSupportedMethods()) {
            error = true;
            classified.notSupportedMethods().forEach(element -> messager.printMessage(Diagnostic.Kind.ERROR, String.format("Neither Value spec, nor Method spec. Value spec must return dataenum_case, but found (%s). Method spec must be marked as `default`, but found (%s) Element: %s", element.getReturnType(), element.getModifiers().stream().map(Modifier::toString).collect(Collectors.joining(", ")), element), (Element)element));
        }
        for (Element element2 : classified.values()) {
            Value value = ValueParser.parse(element2, ctx);
            if (value == null) {
                error = true;
                continue;
            }
            if (!lowerCaseValueNames.add(value.name().toLowerCase())) {
                messager.printMessage(Diagnostic.Kind.ERROR, "Duplicate case name '" + value.name().toLowerCase() + "' - lower-case case names must be unique.", element2);
            }
            values.add(value);
        }
        return error ? null : new Pair(values, classified.adtMethods().stream().map(x -> MethodParser.parse(x, ctx.trees)).collect(Collectors.toList()));
    }

    private static final class ClassifiedElements {
        private final Map<String, ? extends List<? extends Element>> elements;

        private ClassifiedElements(Map<String, ? extends List<? extends Element>> elements) {
            this.elements = elements;
        }

        boolean containsNotSupportedTypes() {
            return this.elements.containsKey(MembersParser.NOT_SUPPORTED_TYPE);
        }

        List<? extends Element> notSupportedTypes() {
            if (this.elements.containsKey(MembersParser.NOT_SUPPORTED_TYPE)) {
                return this.elements.get(MembersParser.NOT_SUPPORTED_TYPE);
            }
            return Collections.emptyList();
        }

        boolean containsNotSupportedMethods() {
            return this.elements.containsKey(MembersParser.NOT_SUPPORTED_METHOD);
        }

        List<ExecutableElement> notSupportedMethods() {
            if (this.elements.containsKey(MembersParser.NOT_SUPPORTED_METHOD)) {
                return this.elements.get(MembersParser.NOT_SUPPORTED_METHOD).stream().map(x -> (ExecutableElement)x).collect(Collectors.toList());
            }
            return Collections.emptyList();
        }

        boolean containsValues() {
            return this.elements.containsKey(MembersParser.VALUE);
        }

        List<ExecutableElement> values() {
            if (this.elements.containsKey(MembersParser.VALUE)) {
                return this.elements.get(MembersParser.VALUE).stream().map(x -> (ExecutableElement)x).collect(Collectors.toList());
            }
            return Collections.emptyList();
        }

        boolean containsAdtMethods() {
            return this.elements.containsKey(MembersParser.ADT_METHOD);
        }

        List<ExecutableElement> adtMethods() {
            if (this.elements.containsKey(MembersParser.ADT_METHOD)) {
                return this.elements.get(MembersParser.ADT_METHOD).stream().map(x -> (ExecutableElement)x).collect(Collectors.toList());
            }
            return Collections.emptyList();
        }
    }

    private static final class ClassifiedElementsFactory {
        private final Supplier<ProcessingContext> ctx;

        private ClassifiedElementsFactory(Supplier<ProcessingContext> ctx) {
            this.ctx = ctx;
        }

        public ClassifiedElements get(List<? extends Element> elements) {
            Predicate<ExecutableElement> isValue = x -> ValueParser.isValueSpecMarker(x.getReturnType(), this.ctx.get());
            Predicate<ExecutableElement> isAdtMethod = x -> x.getModifiers().contains((Object)Modifier.DEFAULT);
            Map<String, List<Element>> xs = elements.stream().collect(Collectors.groupingBy(e -> {
                if (e instanceof ExecutableElement) {
                    ExecutableElement el = (ExecutableElement)e;
                    if (isValue.test(el)) {
                        return MembersParser.VALUE;
                    }
                    if (isAdtMethod.test(el)) {
                        return MembersParser.ADT_METHOD;
                    }
                    return MembersParser.NOT_SUPPORTED_METHOD;
                }
                return MembersParser.NOT_SUPPORTED_TYPE;
            }));
            return new ClassifiedElements(xs);
        }
    }
}

