/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.dataenum.processor.parser;

import com.spotify.dataenum.processor.ProcessingContext;
import com.spotify.dataenum.processor.data.Spec;
import com.spotify.dataenum.processor.data.Value;
import com.spotify.dataenum.processor.parser.MembersParser;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeVariableName;
import com.sun.tools.javac.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.processing.Messager;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.DeclaredType;
import javax.tools.Diagnostic;

public final class SpecParser {
    private SpecParser() {
    }

    public static Spec parse(Element element, ProcessingContext ctx) {
        Messager messager = ctx.env.getMessager();
        if (element.getKind() != ElementKind.INTERFACE) {
            messager.printMessage(Diagnostic.Kind.ERROR, "@DataEnum can only be used on interfaces.", element);
            return null;
        }
        TypeElement dataEnum = (TypeElement)element;
        ArrayList<TypeVariableName> typeVariableNames = new ArrayList<TypeVariableName>();
        for (TypeParameterElement typeParameterElement : dataEnum.getTypeParameters()) {
            typeVariableNames.add(TypeVariableName.get((TypeParameterElement)typeParameterElement));
        }
        Pair<List<Value>, List<MethodSpec>> valuesAndMethods = MembersParser.parse(dataEnum, ctx);
        if (valuesAndMethods == null) {
            return null;
        }
        List<ClassName> list = dataEnum.getInterfaces().stream().map(x -> ClassName.get((TypeElement)((TypeElement)((DeclaredType)x).asElement()))).collect(Collectors.toList());
        ClassName enumInterface = ClassName.get((TypeElement)dataEnum);
        return new Spec(enumInterface, typeVariableNames, list, (Iterable)valuesAndMethods.fst, (Iterable)valuesAndMethods.snd);
    }
}

