/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.dataenum.processor.parser;

import com.spotify.dataenum.function.Function;
import com.spotify.dataenum.processor.ProcessingContext;
import com.spotify.dataenum.processor.data.Parameter;
import com.spotify.dataenum.processor.data.Value;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.processing.Messager;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;

final class ValueParser {
    private ValueParser() {
    }

    static Value parse(Element element, ProcessingContext ctx) {
        Messager messager = ctx.env.getMessager();
        ExecutableElement methodElement = (ExecutableElement)element;
        if (methodElement.getTypeParameters().size() != 0) {
            messager.printMessage(Diagnostic.Kind.ERROR, String.format("Type parameters must be specified on the top-level interface, found: %s", element), element);
            return null;
        }
        if (methodElement.isVarArgs()) {
            messager.printMessage(Diagnostic.Kind.ERROR, String.format("Vararg parameters not permitted: %s", element), element);
            return null;
        }
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        for (VariableElement variableElement : methodElement.getParameters()) {
            String parameterName = variableElement.getSimpleName().toString();
            TypeName parameterType = TypeName.get((TypeMirror)variableElement.asType());
            boolean nullable = ValueParser.isAnnotationPresent(variableElement, (Function<AnnotationMirror, Boolean>)((Function)ValueParser::isNullableAnnotation));
            boolean redacted = ValueParser.isAnnotationPresent(variableElement, (Function<AnnotationMirror, Boolean>)((Function)ValueParser::isRedactedAnnotation));
            Element parameterTypeElement = ctx.env.getTypeUtils().asElement(variableElement.asType());
            boolean isEnum = parameterTypeElement != null && parameterTypeElement.getKind() == ElementKind.ENUM;
            parameters.add(new Parameter(parameterName, parameterType, nullable, redacted, isEnum));
        }
        String javadoc = ctx.env.getElementUtils().getDocComment(element);
        if (javadoc != null) {
            javadoc = javadoc.trim();
        }
        String string = methodElement.getSimpleName().toString();
        return new Value(string, javadoc, parameters, ValueParser.parseMethodAnnotations(methodElement, messager));
    }

    private static Iterable<AnnotationSpec> parseMethodAnnotations(ExecutableElement methodElement, Messager messager) {
        ArrayList<AnnotationSpec> annotations = new ArrayList<AnnotationSpec>();
        for (AnnotationMirror annotationMirror : methodElement.getAnnotationMirrors()) {
            TypeName annotationTypeName = ClassName.get((TypeMirror)annotationMirror.getAnnotationType().asElement().asType());
            if (!(annotationTypeName instanceof ClassName)) {
                messager.printMessage(Diagnostic.Kind.ERROR, "Annotation is not a class; this shouldn't happen", methodElement, annotationMirror);
                continue;
            }
            AnnotationSpec.Builder builder = AnnotationSpec.builder((ClassName)((ClassName)annotationTypeName));
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                builder.addMember(entry.getKey().getSimpleName().toString(), entry.getValue().toString(), new Object[0]);
            }
            annotations.add(builder.build());
        }
        return annotations;
    }

    private static boolean isAnnotationPresent(VariableElement parameterElement, Function<AnnotationMirror, Boolean> criterion) {
        for (AnnotationMirror annotationMirror : parameterElement.getAnnotationMirrors()) {
            if (!((Boolean)criterion.apply((Object)annotationMirror)).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public static boolean isValueSpecMarker(TypeMirror returnType, ProcessingContext ctx) {
        return ctx.env.getTypeUtils().isSameType(returnType, ctx.dataenum_class_element);
    }

    private static boolean isNullableAnnotation(AnnotationMirror annotation) {
        return "Nullable".contentEquals(annotation.getAnnotationType().asElement().getSimpleName());
    }

    private static boolean isRedactedAnnotation(AnnotationMirror annotationMirror) {
        return "Redacted".contentEquals(annotationMirror.getAnnotationType().asElement().getSimpleName());
    }
}

