/*-
 * -\-\-
 * github-api
 * --
 * Copyright (C) 2016 - 2020 Spotify AB
 * --
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * -/-/-
 */

package com.spotify.github;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Optional;
import org.immutables.value.Value;

/**
 * Convenience interface for tracking closing time and whatever is tracked in {@link
 * UpdateTracking}.
 */
@Value.Immutable
@GithubStyle
@JsonSerialize(as = ImmutableCloseTracking.class)
@JsonDeserialize(as = ImmutableCloseTracking.class)
public interface CloseTracking extends UpdateTracking {

  /**
   * Closed date.
   *
   * @return The date when the issue was closed
   */
  Optional<GitHubInstant> closedAt();
}
