package com.spotify.github;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link UpdateTracking}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableUpdateTracking.builder()}.
 */
@Generated(from = "UpdateTracking", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableUpdateTracking implements UpdateTracking {
  private final @Nullable GitHubInstant createdAt;
  private final @Nullable GitHubInstant updatedAt;

  private ImmutableUpdateTracking(
      @Nullable GitHubInstant createdAt,
      @Nullable GitHubInstant updatedAt) {
    this.createdAt = createdAt;
    this.updatedAt = updatedAt;
  }

  /**
   * Created date
   * @return The date when the issue was created
   */
  @JsonProperty
  @Override
  public @Nullable GitHubInstant createdAt() {
    return createdAt;
  }

  /**
   * Updated date
   * @return The date when the issue was updated
   */
  @JsonProperty
  @Override
  public @Nullable GitHubInstant updatedAt() {
    return updatedAt;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UpdateTracking#createdAt() createdAt} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for createdAt (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUpdateTracking withCreatedAt(@Nullable GitHubInstant value) {
    if (this.createdAt == value) return this;
    return new ImmutableUpdateTracking(value, this.updatedAt);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UpdateTracking#updatedAt() updatedAt} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for updatedAt (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUpdateTracking withUpdatedAt(@Nullable GitHubInstant value) {
    if (this.updatedAt == value) return this;
    return new ImmutableUpdateTracking(this.createdAt, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableUpdateTracking} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableUpdateTracking
        && equalTo((ImmutableUpdateTracking) another);
  }

  private boolean equalTo(ImmutableUpdateTracking another) {
    return Objects.equals(createdAt, another.createdAt)
        && Objects.equals(updatedAt, another.updatedAt);
  }

  /**
   * Computes a hash code from attributes: {@code createdAt}, {@code updatedAt}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(createdAt);
    h += (h << 5) + Objects.hashCode(updatedAt);
    return h;
  }

  /**
   * Prints the immutable value {@code UpdateTracking} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "UpdateTracking{"
        + "createdAt=" + createdAt
        + ", updatedAt=" + updatedAt
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "UpdateTracking", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements UpdateTracking {
    @Nullable GitHubInstant createdAt;
    @Nullable GitHubInstant updatedAt;
    @JsonProperty
    public void setCreatedAt(@Nullable GitHubInstant createdAt) {
      this.createdAt = createdAt;
    }
    @JsonProperty
    public void setUpdatedAt(@Nullable GitHubInstant updatedAt) {
      this.updatedAt = updatedAt;
    }
    @Override
    public GitHubInstant createdAt() { throw new UnsupportedOperationException(); }
    @Override
    public GitHubInstant updatedAt() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableUpdateTracking fromJson(Json json) {
    ImmutableUpdateTracking.Builder builder = ImmutableUpdateTracking.builder();
    if (json.createdAt != null) {
      builder.createdAt(json.createdAt);
    }
    if (json.updatedAt != null) {
      builder.updatedAt(json.updatedAt);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link UpdateTracking} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable UpdateTracking instance
   */
  public static ImmutableUpdateTracking copyOf(UpdateTracking instance) {
    if (instance instanceof ImmutableUpdateTracking) {
      return (ImmutableUpdateTracking) instance;
    }
    return ImmutableUpdateTracking.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableUpdateTracking ImmutableUpdateTracking}.
   * <pre>
   * ImmutableUpdateTracking.builder()
   *    .createdAt(com.spotify.github.GitHubInstant | null) // nullable {@link UpdateTracking#createdAt() createdAt}
   *    .updatedAt(com.spotify.github.GitHubInstant | null) // nullable {@link UpdateTracking#updatedAt() updatedAt}
   *    .build();
   * </pre>
   * @return A new ImmutableUpdateTracking builder
   */
  public static ImmutableUpdateTracking.Builder builder() {
    return new ImmutableUpdateTracking.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableUpdateTracking ImmutableUpdateTracking}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "UpdateTracking", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable GitHubInstant createdAt;
    private @Nullable GitHubInstant updatedAt;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code UpdateTracking} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(UpdateTracking instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable GitHubInstant createdAtValue = instance.createdAt();
      if (createdAtValue != null) {
        createdAt(createdAtValue);
      }
      @Nullable GitHubInstant updatedAtValue = instance.updatedAt();
      if (updatedAtValue != null) {
        updatedAt(updatedAtValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateTracking#createdAt() createdAt} attribute.
     * @param createdAt The value for createdAt (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder createdAt(@Nullable GitHubInstant createdAt) {
      this.createdAt = createdAt;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateTracking#updatedAt() updatedAt} attribute.
     * @param updatedAt The value for updatedAt (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder updatedAt(@Nullable GitHubInstant updatedAt) {
      this.updatedAt = updatedAt;
      return this;
    }

    /**
     * Builds a new {@link ImmutableUpdateTracking ImmutableUpdateTracking}.
     * @return An immutable instance of UpdateTracking
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableUpdateTracking build() {
      return new ImmutableUpdateTracking(createdAt, updatedAt);
    }
  }
}
