package com.spotify.github.v3.activity.events;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import com.spotify.github.v3.User;
import com.spotify.github.v3.repos.Repository;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link CreateEvent}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableCreateEvent.builder()}.
 */
@Generated(from = "CreateEvent", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableCreateEvent implements CreateEvent {
  private final @Nullable Repository repository;
  private final @Nullable User sender;
  private final @Nullable EventInstallation eventInstallation;
  private final @Nullable String ref;
  private final @Nullable String refType;
  private final @Nullable String masterBranch;
  private final @Nullable Optional<String> description;
  private final @Nullable String pusherType;

  private ImmutableCreateEvent(
      @Nullable Repository repository,
      @Nullable User sender,
      @Nullable EventInstallation eventInstallation,
      @Nullable String ref,
      @Nullable String refType,
      @Nullable String masterBranch,
      @Nullable Optional<String> description,
      @Nullable String pusherType) {
    this.repository = repository;
    this.sender = sender;
    this.eventInstallation = eventInstallation;
    this.ref = ref;
    this.refType = refType;
    this.masterBranch = masterBranch;
    this.description = description;
    this.pusherType = pusherType;
  }

  /**
   *The {@link Repository} 
   */
  @JsonProperty
  @Override
  public @Nullable Repository repository() {
    return repository;
  }

  /**
   *The {@link User} that triggered/sent the event. 
   */
  @JsonProperty
  @Override
  public @Nullable User sender() {
    return sender;
  }

  /**
   *The {@link EventInstallation}, if the event comes from a Github App. 
   */
  @JsonProperty("installation")
  @Override
  public @Nullable EventInstallation eventInstallation() {
    return eventInstallation;
  }

  /**
   *The git ref (or null if only a repository was created). 
   */
  @JsonProperty
  @Override
  public @Nullable String ref() {
    return ref;
  }

  /**
   *The object that was created. Can be one of "repository", "branch", or "tag" 
   */
  @JsonProperty
  @Override
  public @Nullable String refType() {
    return refType;
  }

  /**
   *The name of the repository's default branch (usually master). 
   */
  @JsonProperty
  @Override
  public @Nullable String masterBranch() {
    return masterBranch;
  }

  /**
   *The repository's current description. 
   */
  @JsonProperty
  @Override
  public @Nullable Optional<String> description() {
    return description;
  }

  /**
   *No doc found on github - Usually is "user". 
   */
  @JsonProperty
  @Override
  public @Nullable String pusherType() {
    return pusherType;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CreateEvent#repository() repository} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for repository (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCreateEvent withRepository(@Nullable Repository value) {
    if (this.repository == value) return this;
    return new ImmutableCreateEvent(
        value,
        this.sender,
        this.eventInstallation,
        this.ref,
        this.refType,
        this.masterBranch,
        this.description,
        this.pusherType);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CreateEvent#sender() sender} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for sender (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCreateEvent withSender(@Nullable User value) {
    if (this.sender == value) return this;
    return new ImmutableCreateEvent(
        this.repository,
        value,
        this.eventInstallation,
        this.ref,
        this.refType,
        this.masterBranch,
        this.description,
        this.pusherType);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CreateEvent#eventInstallation() eventInstallation} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for eventInstallation (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCreateEvent withEventInstallation(@Nullable EventInstallation value) {
    if (this.eventInstallation == value) return this;
    return new ImmutableCreateEvent(
        this.repository,
        this.sender,
        value,
        this.ref,
        this.refType,
        this.masterBranch,
        this.description,
        this.pusherType);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CreateEvent#ref() ref} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for ref (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCreateEvent withRef(@Nullable String value) {
    if (Objects.equals(this.ref, value)) return this;
    return new ImmutableCreateEvent(
        this.repository,
        this.sender,
        this.eventInstallation,
        value,
        this.refType,
        this.masterBranch,
        this.description,
        this.pusherType);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CreateEvent#refType() refType} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for refType (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCreateEvent withRefType(@Nullable String value) {
    if (Objects.equals(this.refType, value)) return this;
    return new ImmutableCreateEvent(
        this.repository,
        this.sender,
        this.eventInstallation,
        this.ref,
        value,
        this.masterBranch,
        this.description,
        this.pusherType);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CreateEvent#masterBranch() masterBranch} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for masterBranch (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCreateEvent withMasterBranch(@Nullable String value) {
    if (Objects.equals(this.masterBranch, value)) return this;
    return new ImmutableCreateEvent(
        this.repository,
        this.sender,
        this.eventInstallation,
        this.ref,
        this.refType,
        value,
        this.description,
        this.pusherType);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CreateEvent#description() description} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for description (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCreateEvent withDescription(@Nullable Optional<String> value) {
    if (Objects.equals(this.description, value)) return this;
    return new ImmutableCreateEvent(
        this.repository,
        this.sender,
        this.eventInstallation,
        this.ref,
        this.refType,
        this.masterBranch,
        value,
        this.pusherType);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CreateEvent#pusherType() pusherType} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for pusherType (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCreateEvent withPusherType(@Nullable String value) {
    if (Objects.equals(this.pusherType, value)) return this;
    return new ImmutableCreateEvent(
        this.repository,
        this.sender,
        this.eventInstallation,
        this.ref,
        this.refType,
        this.masterBranch,
        this.description,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableCreateEvent} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableCreateEvent
        && equalTo((ImmutableCreateEvent) another);
  }

  private boolean equalTo(ImmutableCreateEvent another) {
    return Objects.equals(repository, another.repository)
        && Objects.equals(sender, another.sender)
        && Objects.equals(eventInstallation, another.eventInstallation)
        && Objects.equals(ref, another.ref)
        && Objects.equals(refType, another.refType)
        && Objects.equals(masterBranch, another.masterBranch)
        && Objects.equals(description, another.description)
        && Objects.equals(pusherType, another.pusherType);
  }

  /**
   * Computes a hash code from attributes: {@code repository}, {@code sender}, {@code eventInstallation}, {@code ref}, {@code refType}, {@code masterBranch}, {@code description}, {@code pusherType}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(repository);
    h += (h << 5) + Objects.hashCode(sender);
    h += (h << 5) + Objects.hashCode(eventInstallation);
    h += (h << 5) + Objects.hashCode(ref);
    h += (h << 5) + Objects.hashCode(refType);
    h += (h << 5) + Objects.hashCode(masterBranch);
    h += (h << 5) + Objects.hashCode(description);
    h += (h << 5) + Objects.hashCode(pusherType);
    return h;
  }

  /**
   * Prints the immutable value {@code CreateEvent} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "CreateEvent{"
        + "repository=" + repository
        + ", sender=" + sender
        + ", eventInstallation=" + eventInstallation
        + ", ref=" + ref
        + ", refType=" + refType
        + ", masterBranch=" + masterBranch
        + ", description=" + description
        + ", pusherType=" + pusherType
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "CreateEvent", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements CreateEvent {
    @Nullable Repository repository;
    @Nullable User sender;
    @Nullable EventInstallation eventInstallation;
    @Nullable String ref;
    @Nullable String refType;
    @Nullable String masterBranch;
    @Nullable Optional<String> description;
    @Nullable String pusherType;
    @JsonProperty
    public void setRepository(@Nullable Repository repository) {
      this.repository = repository;
    }
    @JsonProperty
    public void setSender(@Nullable User sender) {
      this.sender = sender;
    }
    @JsonProperty("installation")
    public void setEventInstallation(@Nullable EventInstallation eventInstallation) {
      this.eventInstallation = eventInstallation;
    }
    @JsonProperty
    public void setRef(@Nullable String ref) {
      this.ref = ref;
    }
    @JsonProperty
    public void setRefType(@Nullable String refType) {
      this.refType = refType;
    }
    @JsonProperty
    public void setMasterBranch(@Nullable String masterBranch) {
      this.masterBranch = masterBranch;
    }
    @JsonProperty
    public void setDescription(@Nullable Optional<String> description) {
      this.description = description;
    }
    @JsonProperty
    public void setPusherType(@Nullable String pusherType) {
      this.pusherType = pusherType;
    }
    @Override
    public Repository repository() { throw new UnsupportedOperationException(); }
    @Override
    public User sender() { throw new UnsupportedOperationException(); }
    @Override
    public EventInstallation eventInstallation() { throw new UnsupportedOperationException(); }
    @Override
    public String ref() { throw new UnsupportedOperationException(); }
    @Override
    public String refType() { throw new UnsupportedOperationException(); }
    @Override
    public String masterBranch() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> description() { throw new UnsupportedOperationException(); }
    @Override
    public String pusherType() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableCreateEvent fromJson(Json json) {
    ImmutableCreateEvent.Builder builder = ImmutableCreateEvent.builder();
    if (json.repository != null) {
      builder.repository(json.repository);
    }
    if (json.sender != null) {
      builder.sender(json.sender);
    }
    if (json.eventInstallation != null) {
      builder.eventInstallation(json.eventInstallation);
    }
    if (json.ref != null) {
      builder.ref(json.ref);
    }
    if (json.refType != null) {
      builder.refType(json.refType);
    }
    if (json.masterBranch != null) {
      builder.masterBranch(json.masterBranch);
    }
    if (json.description != null) {
      builder.description(json.description);
    }
    if (json.pusherType != null) {
      builder.pusherType(json.pusherType);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link CreateEvent} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable CreateEvent instance
   */
  public static ImmutableCreateEvent copyOf(CreateEvent instance) {
    if (instance instanceof ImmutableCreateEvent) {
      return (ImmutableCreateEvent) instance;
    }
    return ImmutableCreateEvent.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableCreateEvent ImmutableCreateEvent}.
   * <pre>
   * ImmutableCreateEvent.builder()
   *    .repository(com.spotify.github.v3.repos.Repository | null) // nullable {@link CreateEvent#repository() repository}
   *    .sender(com.spotify.github.v3.User | null) // nullable {@link CreateEvent#sender() sender}
   *    .eventInstallation(com.spotify.github.v3.activity.events.EventInstallation | null) // nullable {@link CreateEvent#eventInstallation() eventInstallation}
   *    .ref(String | null) // nullable {@link CreateEvent#ref() ref}
   *    .refType(String | null) // nullable {@link CreateEvent#refType() refType}
   *    .masterBranch(String | null) // nullable {@link CreateEvent#masterBranch() masterBranch}
   *    .description(Optional&amp;lt;String&amp;gt; | null) // nullable {@link CreateEvent#description() description}
   *    .pusherType(String | null) // nullable {@link CreateEvent#pusherType() pusherType}
   *    .build();
   * </pre>
   * @return A new ImmutableCreateEvent builder
   */
  public static ImmutableCreateEvent.Builder builder() {
    return new ImmutableCreateEvent.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableCreateEvent ImmutableCreateEvent}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "CreateEvent", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable Repository repository;
    private @Nullable User sender;
    private @Nullable EventInstallation eventInstallation;
    private @Nullable String ref;
    private @Nullable String refType;
    private @Nullable String masterBranch;
    private @Nullable Optional<String> description;
    private @Nullable String pusherType;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.spotify.github.v3.activity.events.CreateEvent} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(CreateEvent instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.spotify.github.v3.activity.events.BaseEvent} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(BaseEvent instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof CreateEvent) {
        CreateEvent instance = (CreateEvent) object;
        @Nullable String refTypeValue = instance.refType();
        if (refTypeValue != null) {
          refType(refTypeValue);
        }
        @Nullable String masterBranchValue = instance.masterBranch();
        if (masterBranchValue != null) {
          masterBranch(masterBranchValue);
        }
        @Nullable Optional<String> descriptionValue = instance.description();
        if (descriptionValue != null) {
          description(descriptionValue);
        }
        @Nullable String refValue = instance.ref();
        if (refValue != null) {
          ref(refValue);
        }
        @Nullable String pusherTypeValue = instance.pusherType();
        if (pusherTypeValue != null) {
          pusherType(pusherTypeValue);
        }
      }
      if (object instanceof BaseEvent) {
        BaseEvent instance = (BaseEvent) object;
        @Nullable Repository repositoryValue = instance.repository();
        if (repositoryValue != null) {
          repository(repositoryValue);
        }
        @Nullable User senderValue = instance.sender();
        if (senderValue != null) {
          sender(senderValue);
        }
        @Nullable EventInstallation eventInstallationValue = instance.eventInstallation();
        if (eventInstallationValue != null) {
          eventInstallation(eventInstallationValue);
        }
      }
    }

    /**
     * Initializes the value for the {@link CreateEvent#repository() repository} attribute.
     * @param repository The value for repository (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder repository(@Nullable Repository repository) {
      this.repository = repository;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateEvent#sender() sender} attribute.
     * @param sender The value for sender (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder sender(@Nullable User sender) {
      this.sender = sender;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateEvent#eventInstallation() eventInstallation} attribute.
     * @param eventInstallation The value for eventInstallation (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("installation")
    public final Builder eventInstallation(@Nullable EventInstallation eventInstallation) {
      this.eventInstallation = eventInstallation;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateEvent#ref() ref} attribute.
     * @param ref The value for ref (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder ref(@Nullable String ref) {
      this.ref = ref;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateEvent#refType() refType} attribute.
     * @param refType The value for refType (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder refType(@Nullable String refType) {
      this.refType = refType;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateEvent#masterBranch() masterBranch} attribute.
     * @param masterBranch The value for masterBranch (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder masterBranch(@Nullable String masterBranch) {
      this.masterBranch = masterBranch;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateEvent#description() description} attribute.
     * @param description The value for description (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder description(@Nullable Optional<String> description) {
      this.description = description;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateEvent#pusherType() pusherType} attribute.
     * @param pusherType The value for pusherType (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder pusherType(@Nullable String pusherType) {
      this.pusherType = pusherType;
      return this;
    }

    /**
     * Builds a new {@link ImmutableCreateEvent ImmutableCreateEvent}.
     * @return An immutable instance of CreateEvent
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableCreateEvent build() {
      return new ImmutableCreateEvent(repository, sender, eventInstallation, ref, refType, masterBranch, description, pusherType);
    }
  }
}
