package com.spotify.github.v3.activity.events;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import com.spotify.github.v3.User;
import com.spotify.github.v3.repos.Repository;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ForkEvent}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableForkEvent.builder()}.
 */
@Generated(from = "ForkEvent", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableForkEvent implements ForkEvent {
  private final @Nullable Repository repository;
  private final @Nullable User sender;
  private final @Nullable EventInstallation eventInstallation;
  private final @Nullable Repository forkee;

  private ImmutableForkEvent(
      @Nullable Repository repository,
      @Nullable User sender,
      @Nullable EventInstallation eventInstallation,
      @Nullable Repository forkee) {
    this.repository = repository;
    this.sender = sender;
    this.eventInstallation = eventInstallation;
    this.forkee = forkee;
  }

  /**
   *The {@link Repository} 
   */
  @JsonProperty
  @Override
  public @Nullable Repository repository() {
    return repository;
  }

  /**
   *The {@link User} that triggered/sent the event. 
   */
  @JsonProperty
  @Override
  public @Nullable User sender() {
    return sender;
  }

  /**
   *The {@link EventInstallation}, if the event comes from a Github App. 
   */
  @JsonProperty("installation")
  @Override
  public @Nullable EventInstallation eventInstallation() {
    return eventInstallation;
  }

  /**
   *The {@link Repository} that was created. 
   */
  @JsonProperty
  @Override
  public @Nullable Repository forkee() {
    return forkee;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ForkEvent#repository() repository} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for repository (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableForkEvent withRepository(@Nullable Repository value) {
    if (this.repository == value) return this;
    return new ImmutableForkEvent(value, this.sender, this.eventInstallation, this.forkee);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ForkEvent#sender() sender} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for sender (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableForkEvent withSender(@Nullable User value) {
    if (this.sender == value) return this;
    return new ImmutableForkEvent(this.repository, value, this.eventInstallation, this.forkee);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ForkEvent#eventInstallation() eventInstallation} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for eventInstallation (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableForkEvent withEventInstallation(@Nullable EventInstallation value) {
    if (this.eventInstallation == value) return this;
    return new ImmutableForkEvent(this.repository, this.sender, value, this.forkee);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ForkEvent#forkee() forkee} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for forkee (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableForkEvent withForkee(@Nullable Repository value) {
    if (this.forkee == value) return this;
    return new ImmutableForkEvent(this.repository, this.sender, this.eventInstallation, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableForkEvent} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableForkEvent
        && equalTo((ImmutableForkEvent) another);
  }

  private boolean equalTo(ImmutableForkEvent another) {
    return Objects.equals(repository, another.repository)
        && Objects.equals(sender, another.sender)
        && Objects.equals(eventInstallation, another.eventInstallation)
        && Objects.equals(forkee, another.forkee);
  }

  /**
   * Computes a hash code from attributes: {@code repository}, {@code sender}, {@code eventInstallation}, {@code forkee}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(repository);
    h += (h << 5) + Objects.hashCode(sender);
    h += (h << 5) + Objects.hashCode(eventInstallation);
    h += (h << 5) + Objects.hashCode(forkee);
    return h;
  }

  /**
   * Prints the immutable value {@code ForkEvent} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ForkEvent{"
        + "repository=" + repository
        + ", sender=" + sender
        + ", eventInstallation=" + eventInstallation
        + ", forkee=" + forkee
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "ForkEvent", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements ForkEvent {
    @Nullable Repository repository;
    @Nullable User sender;
    @Nullable EventInstallation eventInstallation;
    @Nullable Repository forkee;
    @JsonProperty
    public void setRepository(@Nullable Repository repository) {
      this.repository = repository;
    }
    @JsonProperty
    public void setSender(@Nullable User sender) {
      this.sender = sender;
    }
    @JsonProperty("installation")
    public void setEventInstallation(@Nullable EventInstallation eventInstallation) {
      this.eventInstallation = eventInstallation;
    }
    @JsonProperty
    public void setForkee(@Nullable Repository forkee) {
      this.forkee = forkee;
    }
    @Override
    public Repository repository() { throw new UnsupportedOperationException(); }
    @Override
    public User sender() { throw new UnsupportedOperationException(); }
    @Override
    public EventInstallation eventInstallation() { throw new UnsupportedOperationException(); }
    @Override
    public Repository forkee() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableForkEvent fromJson(Json json) {
    ImmutableForkEvent.Builder builder = ImmutableForkEvent.builder();
    if (json.repository != null) {
      builder.repository(json.repository);
    }
    if (json.sender != null) {
      builder.sender(json.sender);
    }
    if (json.eventInstallation != null) {
      builder.eventInstallation(json.eventInstallation);
    }
    if (json.forkee != null) {
      builder.forkee(json.forkee);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link ForkEvent} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ForkEvent instance
   */
  public static ImmutableForkEvent copyOf(ForkEvent instance) {
    if (instance instanceof ImmutableForkEvent) {
      return (ImmutableForkEvent) instance;
    }
    return ImmutableForkEvent.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableForkEvent ImmutableForkEvent}.
   * <pre>
   * ImmutableForkEvent.builder()
   *    .repository(com.spotify.github.v3.repos.Repository | null) // nullable {@link ForkEvent#repository() repository}
   *    .sender(com.spotify.github.v3.User | null) // nullable {@link ForkEvent#sender() sender}
   *    .eventInstallation(com.spotify.github.v3.activity.events.EventInstallation | null) // nullable {@link ForkEvent#eventInstallation() eventInstallation}
   *    .forkee(com.spotify.github.v3.repos.Repository | null) // nullable {@link ForkEvent#forkee() forkee}
   *    .build();
   * </pre>
   * @return A new ImmutableForkEvent builder
   */
  public static ImmutableForkEvent.Builder builder() {
    return new ImmutableForkEvent.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableForkEvent ImmutableForkEvent}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ForkEvent", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable Repository repository;
    private @Nullable User sender;
    private @Nullable EventInstallation eventInstallation;
    private @Nullable Repository forkee;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.spotify.github.v3.activity.events.ForkEvent} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ForkEvent instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.spotify.github.v3.activity.events.BaseEvent} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(BaseEvent instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof ForkEvent) {
        ForkEvent instance = (ForkEvent) object;
        @Nullable Repository forkeeValue = instance.forkee();
        if (forkeeValue != null) {
          forkee(forkeeValue);
        }
      }
      if (object instanceof BaseEvent) {
        BaseEvent instance = (BaseEvent) object;
        @Nullable Repository repositoryValue = instance.repository();
        if (repositoryValue != null) {
          repository(repositoryValue);
        }
        @Nullable User senderValue = instance.sender();
        if (senderValue != null) {
          sender(senderValue);
        }
        @Nullable EventInstallation eventInstallationValue = instance.eventInstallation();
        if (eventInstallationValue != null) {
          eventInstallation(eventInstallationValue);
        }
      }
    }

    /**
     * Initializes the value for the {@link ForkEvent#repository() repository} attribute.
     * @param repository The value for repository (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder repository(@Nullable Repository repository) {
      this.repository = repository;
      return this;
    }

    /**
     * Initializes the value for the {@link ForkEvent#sender() sender} attribute.
     * @param sender The value for sender (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder sender(@Nullable User sender) {
      this.sender = sender;
      return this;
    }

    /**
     * Initializes the value for the {@link ForkEvent#eventInstallation() eventInstallation} attribute.
     * @param eventInstallation The value for eventInstallation (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("installation")
    public final Builder eventInstallation(@Nullable EventInstallation eventInstallation) {
      this.eventInstallation = eventInstallation;
      return this;
    }

    /**
     * Initializes the value for the {@link ForkEvent#forkee() forkee} attribute.
     * @param forkee The value for forkee (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder forkee(@Nullable Repository forkee) {
      this.forkee = forkee;
      return this;
    }

    /**
     * Builds a new {@link ImmutableForkEvent ImmutableForkEvent}.
     * @return An immutable instance of ForkEvent
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableForkEvent build() {
      return new ImmutableForkEvent(repository, sender, eventInstallation, forkee);
    }
  }
}
