package com.spotify.github.v3.activity.events;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ReviewLinks.Href}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableHref.builder()}.
 */
@Generated(from = "ReviewLinks.Href", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableHref<T> implements ReviewLinks.Href<T> {
  private final T href;

  private ImmutableHref(T href) {
    this.href = href;
  }

  /**
   * @return The value of the {@code href} attribute
   */
  @JsonProperty
  @Override
  public T href() {
    return href;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ReviewLinks.Href#href() href} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for href
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableHref<T> withHref(T value) {
    if (this.href == value) return this;
    T newValue = Objects.requireNonNull(value, "href");
    return new ImmutableHref<>(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableHref} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableHref<?>
        && equalTo((ImmutableHref<?>) another);
  }

  private boolean equalTo(ImmutableHref<?> another) {
    return href.equals(another.href);
  }

  /**
   * Computes a hash code from attributes: {@code href}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + href.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Href} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Href{"
        + "href=" + href
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "ReviewLinks.Href", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json<T> implements ReviewLinks.Href<T> {
    @Nullable T href;
    @JsonProperty
    public void setHref(T href) {
      this.href = href;
    }
    @Override
    public T href() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param <T> generic parameter T
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static <T> ImmutableHref<T> fromJson(Json<T> json) {
    ImmutableHref.Builder<T> builder = ImmutableHref.<T>builder();
    if (json.href != null) {
      builder.href(json.href);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link ReviewLinks.Href} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <T> generic parameter T
   * @param instance The instance to copy
   * @return A copied immutable Href instance
   */
  public static <T> ImmutableHref<T> copyOf(ReviewLinks.Href<T> instance) {
    if (instance instanceof ImmutableHref<?>) {
      return (ImmutableHref<T>) instance;
    }
    return ImmutableHref.<T>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableHref ImmutableHref}.
   * <pre>
   * ImmutableHref.&amp;lt;T&amp;gt;builder()
   *    .href(T) // required {@link ReviewLinks.Href#href() href}
   *    .build();
   * </pre>
   * @param <T> generic parameter T
   * @return A new ImmutableHref builder
   */
  public static <T> ImmutableHref.Builder<T> builder() {
    return new ImmutableHref.Builder<>();
  }

  /**
   * Builds instances of type {@link ImmutableHref ImmutableHref}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ReviewLinks.Href", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder<T> {
    private static final long INIT_BIT_HREF = 0x1L;
    private long initBits = 0x1L;

    private @Nullable T href;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Href} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T> from(ReviewLinks.Href<T> instance) {
      Objects.requireNonNull(instance, "instance");
      href(instance.href());
      return this;
    }

    /**
     * Initializes the value for the {@link ReviewLinks.Href#href() href} attribute.
     * @param href The value for href 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder<T> href(T href) {
      this.href = Objects.requireNonNull(href, "href");
      initBits &= ~INIT_BIT_HREF;
      return this;
    }

    /**
     * Builds a new {@link ImmutableHref ImmutableHref}.
     * @return An immutable instance of Href
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableHref<T> build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableHref<>(href);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_HREF) != 0) attributes.add("href");
      return "Cannot build Href, some of required attributes are not set " + attributes;
    }
  }
}
