package com.spotify.github.v3.activity.events;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import com.spotify.github.v3.User;
import com.spotify.github.v3.issues.Issue;
import com.spotify.github.v3.repos.Repository;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link IssuesEvent}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableIssuesEvent.builder()}.
 */
@Generated(from = "IssuesEvent", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableIssuesEvent implements IssuesEvent {
  private final @Nullable Repository repository;
  private final @Nullable User sender;
  private final @Nullable EventInstallation eventInstallation;
  private final @Nullable String action;
  private final @Nullable Issue issue;

  private ImmutableIssuesEvent(
      @Nullable Repository repository,
      @Nullable User sender,
      @Nullable EventInstallation eventInstallation,
      @Nullable String action,
      @Nullable Issue issue) {
    this.repository = repository;
    this.sender = sender;
    this.eventInstallation = eventInstallation;
    this.action = action;
    this.issue = issue;
  }

  /**
   *The {@link Repository} 
   */
  @JsonProperty
  @Override
  public @Nullable Repository repository() {
    return repository;
  }

  /**
   *The {@link User} that triggered/sent the event. 
   */
  @JsonProperty
  @Override
  public @Nullable User sender() {
    return sender;
  }

  /**
   *The {@link EventInstallation}, if the event comes from a Github App. 
   */
  @JsonProperty("installation")
  @Override
  public @Nullable EventInstallation eventInstallation() {
    return eventInstallation;
  }

  /**
   * The action that was performed. Can be one of "assigned", "unassigned", "labeled", "unlabeled",
   * "opened", "edited", "closed", or "reopened".
   */
  @JsonProperty
  @Override
  public @Nullable String action() {
    return action;
  }

  /**
   *Issue 
   */
  @JsonProperty
  @Override
  public @Nullable Issue issue() {
    return issue;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IssuesEvent#repository() repository} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for repository (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIssuesEvent withRepository(@Nullable Repository value) {
    if (this.repository == value) return this;
    return new ImmutableIssuesEvent(value, this.sender, this.eventInstallation, this.action, this.issue);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IssuesEvent#sender() sender} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for sender (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIssuesEvent withSender(@Nullable User value) {
    if (this.sender == value) return this;
    return new ImmutableIssuesEvent(this.repository, value, this.eventInstallation, this.action, this.issue);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IssuesEvent#eventInstallation() eventInstallation} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for eventInstallation (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIssuesEvent withEventInstallation(@Nullable EventInstallation value) {
    if (this.eventInstallation == value) return this;
    return new ImmutableIssuesEvent(this.repository, this.sender, value, this.action, this.issue);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IssuesEvent#action() action} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for action (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIssuesEvent withAction(@Nullable String value) {
    if (Objects.equals(this.action, value)) return this;
    return new ImmutableIssuesEvent(this.repository, this.sender, this.eventInstallation, value, this.issue);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IssuesEvent#issue() issue} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for issue (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIssuesEvent withIssue(@Nullable Issue value) {
    if (this.issue == value) return this;
    return new ImmutableIssuesEvent(this.repository, this.sender, this.eventInstallation, this.action, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableIssuesEvent} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableIssuesEvent
        && equalTo((ImmutableIssuesEvent) another);
  }

  private boolean equalTo(ImmutableIssuesEvent another) {
    return Objects.equals(repository, another.repository)
        && Objects.equals(sender, another.sender)
        && Objects.equals(eventInstallation, another.eventInstallation)
        && Objects.equals(action, another.action)
        && Objects.equals(issue, another.issue);
  }

  /**
   * Computes a hash code from attributes: {@code repository}, {@code sender}, {@code eventInstallation}, {@code action}, {@code issue}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(repository);
    h += (h << 5) + Objects.hashCode(sender);
    h += (h << 5) + Objects.hashCode(eventInstallation);
    h += (h << 5) + Objects.hashCode(action);
    h += (h << 5) + Objects.hashCode(issue);
    return h;
  }

  /**
   * Prints the immutable value {@code IssuesEvent} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "IssuesEvent{"
        + "repository=" + repository
        + ", sender=" + sender
        + ", eventInstallation=" + eventInstallation
        + ", action=" + action
        + ", issue=" + issue
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "IssuesEvent", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements IssuesEvent {
    @Nullable Repository repository;
    @Nullable User sender;
    @Nullable EventInstallation eventInstallation;
    @Nullable String action;
    @Nullable Issue issue;
    @JsonProperty
    public void setRepository(@Nullable Repository repository) {
      this.repository = repository;
    }
    @JsonProperty
    public void setSender(@Nullable User sender) {
      this.sender = sender;
    }
    @JsonProperty("installation")
    public void setEventInstallation(@Nullable EventInstallation eventInstallation) {
      this.eventInstallation = eventInstallation;
    }
    @JsonProperty
    public void setAction(@Nullable String action) {
      this.action = action;
    }
    @JsonProperty
    public void setIssue(@Nullable Issue issue) {
      this.issue = issue;
    }
    @Override
    public Repository repository() { throw new UnsupportedOperationException(); }
    @Override
    public User sender() { throw new UnsupportedOperationException(); }
    @Override
    public EventInstallation eventInstallation() { throw new UnsupportedOperationException(); }
    @Override
    public String action() { throw new UnsupportedOperationException(); }
    @Override
    public Issue issue() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableIssuesEvent fromJson(Json json) {
    ImmutableIssuesEvent.Builder builder = ImmutableIssuesEvent.builder();
    if (json.repository != null) {
      builder.repository(json.repository);
    }
    if (json.sender != null) {
      builder.sender(json.sender);
    }
    if (json.eventInstallation != null) {
      builder.eventInstallation(json.eventInstallation);
    }
    if (json.action != null) {
      builder.action(json.action);
    }
    if (json.issue != null) {
      builder.issue(json.issue);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link IssuesEvent} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable IssuesEvent instance
   */
  public static ImmutableIssuesEvent copyOf(IssuesEvent instance) {
    if (instance instanceof ImmutableIssuesEvent) {
      return (ImmutableIssuesEvent) instance;
    }
    return ImmutableIssuesEvent.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableIssuesEvent ImmutableIssuesEvent}.
   * <pre>
   * ImmutableIssuesEvent.builder()
   *    .repository(com.spotify.github.v3.repos.Repository | null) // nullable {@link IssuesEvent#repository() repository}
   *    .sender(com.spotify.github.v3.User | null) // nullable {@link IssuesEvent#sender() sender}
   *    .eventInstallation(com.spotify.github.v3.activity.events.EventInstallation | null) // nullable {@link IssuesEvent#eventInstallation() eventInstallation}
   *    .action(String | null) // nullable {@link IssuesEvent#action() action}
   *    .issue(com.spotify.github.v3.issues.Issue | null) // nullable {@link IssuesEvent#issue() issue}
   *    .build();
   * </pre>
   * @return A new ImmutableIssuesEvent builder
   */
  public static ImmutableIssuesEvent.Builder builder() {
    return new ImmutableIssuesEvent.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableIssuesEvent ImmutableIssuesEvent}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "IssuesEvent", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable Repository repository;
    private @Nullable User sender;
    private @Nullable EventInstallation eventInstallation;
    private @Nullable String action;
    private @Nullable Issue issue;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.spotify.github.v3.activity.events.IssuesEvent} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(IssuesEvent instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.spotify.github.v3.activity.events.BaseEvent} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(BaseEvent instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof IssuesEvent) {
        IssuesEvent instance = (IssuesEvent) object;
        @Nullable Issue issueValue = instance.issue();
        if (issueValue != null) {
          issue(issueValue);
        }
        @Nullable String actionValue = instance.action();
        if (actionValue != null) {
          action(actionValue);
        }
      }
      if (object instanceof BaseEvent) {
        BaseEvent instance = (BaseEvent) object;
        @Nullable Repository repositoryValue = instance.repository();
        if (repositoryValue != null) {
          repository(repositoryValue);
        }
        @Nullable User senderValue = instance.sender();
        if (senderValue != null) {
          sender(senderValue);
        }
        @Nullable EventInstallation eventInstallationValue = instance.eventInstallation();
        if (eventInstallationValue != null) {
          eventInstallation(eventInstallationValue);
        }
      }
    }

    /**
     * Initializes the value for the {@link IssuesEvent#repository() repository} attribute.
     * @param repository The value for repository (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder repository(@Nullable Repository repository) {
      this.repository = repository;
      return this;
    }

    /**
     * Initializes the value for the {@link IssuesEvent#sender() sender} attribute.
     * @param sender The value for sender (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder sender(@Nullable User sender) {
      this.sender = sender;
      return this;
    }

    /**
     * Initializes the value for the {@link IssuesEvent#eventInstallation() eventInstallation} attribute.
     * @param eventInstallation The value for eventInstallation (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("installation")
    public final Builder eventInstallation(@Nullable EventInstallation eventInstallation) {
      this.eventInstallation = eventInstallation;
      return this;
    }

    /**
     * Initializes the value for the {@link IssuesEvent#action() action} attribute.
     * @param action The value for action (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder action(@Nullable String action) {
      this.action = action;
      return this;
    }

    /**
     * Initializes the value for the {@link IssuesEvent#issue() issue} attribute.
     * @param issue The value for issue (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder issue(@Nullable Issue issue) {
      this.issue = issue;
      return this;
    }

    /**
     * Builds a new {@link ImmutableIssuesEvent ImmutableIssuesEvent}.
     * @return An immutable instance of IssuesEvent
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableIssuesEvent build() {
      return new ImmutableIssuesEvent(repository, sender, eventInstallation, action, issue);
    }
  }
}
