package com.spotify.github.v3.activity.events;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import com.spotify.github.v3.User;
import com.spotify.github.v3.prs.Comment;
import com.spotify.github.v3.prs.PullRequestItem;
import com.spotify.github.v3.repos.Repository;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link PullRequestReviewCommentEvent}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutablePullRequestReviewCommentEvent.builder()}.
 */
@Generated(from = "PullRequestReviewCommentEvent", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutablePullRequestReviewCommentEvent
    implements PullRequestReviewCommentEvent {
  private final @Nullable Repository repository;
  private final @Nullable User sender;
  private final @Nullable EventInstallation eventInstallation;
  private final @Nullable String action;
  private final @Nullable Comment comment;
  private final @Nullable PullRequestItem pullRequest;

  private ImmutablePullRequestReviewCommentEvent(
      @Nullable Repository repository,
      @Nullable User sender,
      @Nullable EventInstallation eventInstallation,
      @Nullable String action,
      @Nullable Comment comment,
      @Nullable PullRequestItem pullRequest) {
    this.repository = repository;
    this.sender = sender;
    this.eventInstallation = eventInstallation;
    this.action = action;
    this.comment = comment;
    this.pullRequest = pullRequest;
  }

  /**
   *The {@link Repository} 
   */
  @JsonProperty
  @Override
  public @Nullable Repository repository() {
    return repository;
  }

  /**
   *The {@link User} that triggered/sent the event. 
   */
  @JsonProperty
  @Override
  public @Nullable User sender() {
    return sender;
  }

  /**
   *The {@link EventInstallation}, if the event comes from a Github App. 
   */
  @JsonProperty("installation")
  @Override
  public @Nullable EventInstallation eventInstallation() {
    return eventInstallation;
  }

  /**
   * The action that was performed on the comment. Can be one of "created", "edited", or "deleted".
   */
  @JsonProperty
  @Override
  public @Nullable String action() {
    return action;
  }

  /**
   *The comment itself. 
   */
  @JsonProperty
  @Override
  public @Nullable Comment comment() {
    return comment;
  }

  /**
   *The pull request the comment belongs to. 
   */
  @JsonProperty
  @Override
  public @Nullable PullRequestItem pullRequest() {
    return pullRequest;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PullRequestReviewCommentEvent#repository() repository} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for repository (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePullRequestReviewCommentEvent withRepository(@Nullable Repository value) {
    if (this.repository == value) return this;
    return new ImmutablePullRequestReviewCommentEvent(value, this.sender, this.eventInstallation, this.action, this.comment, this.pullRequest);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PullRequestReviewCommentEvent#sender() sender} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for sender (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePullRequestReviewCommentEvent withSender(@Nullable User value) {
    if (this.sender == value) return this;
    return new ImmutablePullRequestReviewCommentEvent(this.repository, value, this.eventInstallation, this.action, this.comment, this.pullRequest);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PullRequestReviewCommentEvent#eventInstallation() eventInstallation} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for eventInstallation (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePullRequestReviewCommentEvent withEventInstallation(@Nullable EventInstallation value) {
    if (this.eventInstallation == value) return this;
    return new ImmutablePullRequestReviewCommentEvent(this.repository, this.sender, value, this.action, this.comment, this.pullRequest);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PullRequestReviewCommentEvent#action() action} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for action (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePullRequestReviewCommentEvent withAction(@Nullable String value) {
    if (Objects.equals(this.action, value)) return this;
    return new ImmutablePullRequestReviewCommentEvent(this.repository, this.sender, this.eventInstallation, value, this.comment, this.pullRequest);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PullRequestReviewCommentEvent#comment() comment} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for comment (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePullRequestReviewCommentEvent withComment(@Nullable Comment value) {
    if (this.comment == value) return this;
    return new ImmutablePullRequestReviewCommentEvent(this.repository, this.sender, this.eventInstallation, this.action, value, this.pullRequest);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PullRequestReviewCommentEvent#pullRequest() pullRequest} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for pullRequest (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePullRequestReviewCommentEvent withPullRequest(@Nullable PullRequestItem value) {
    if (this.pullRequest == value) return this;
    return new ImmutablePullRequestReviewCommentEvent(this.repository, this.sender, this.eventInstallation, this.action, this.comment, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutablePullRequestReviewCommentEvent} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutablePullRequestReviewCommentEvent
        && equalTo((ImmutablePullRequestReviewCommentEvent) another);
  }

  private boolean equalTo(ImmutablePullRequestReviewCommentEvent another) {
    return Objects.equals(repository, another.repository)
        && Objects.equals(sender, another.sender)
        && Objects.equals(eventInstallation, another.eventInstallation)
        && Objects.equals(action, another.action)
        && Objects.equals(comment, another.comment)
        && Objects.equals(pullRequest, another.pullRequest);
  }

  /**
   * Computes a hash code from attributes: {@code repository}, {@code sender}, {@code eventInstallation}, {@code action}, {@code comment}, {@code pullRequest}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(repository);
    h += (h << 5) + Objects.hashCode(sender);
    h += (h << 5) + Objects.hashCode(eventInstallation);
    h += (h << 5) + Objects.hashCode(action);
    h += (h << 5) + Objects.hashCode(comment);
    h += (h << 5) + Objects.hashCode(pullRequest);
    return h;
  }

  /**
   * Prints the immutable value {@code PullRequestReviewCommentEvent} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "PullRequestReviewCommentEvent{"
        + "repository=" + repository
        + ", sender=" + sender
        + ", eventInstallation=" + eventInstallation
        + ", action=" + action
        + ", comment=" + comment
        + ", pullRequest=" + pullRequest
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "PullRequestReviewCommentEvent", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements PullRequestReviewCommentEvent {
    @Nullable Repository repository;
    @Nullable User sender;
    @Nullable EventInstallation eventInstallation;
    @Nullable String action;
    @Nullable Comment comment;
    @Nullable PullRequestItem pullRequest;
    @JsonProperty
    public void setRepository(@Nullable Repository repository) {
      this.repository = repository;
    }
    @JsonProperty
    public void setSender(@Nullable User sender) {
      this.sender = sender;
    }
    @JsonProperty("installation")
    public void setEventInstallation(@Nullable EventInstallation eventInstallation) {
      this.eventInstallation = eventInstallation;
    }
    @JsonProperty
    public void setAction(@Nullable String action) {
      this.action = action;
    }
    @JsonProperty
    public void setComment(@Nullable Comment comment) {
      this.comment = comment;
    }
    @JsonProperty
    public void setPullRequest(@Nullable PullRequestItem pullRequest) {
      this.pullRequest = pullRequest;
    }
    @Override
    public Repository repository() { throw new UnsupportedOperationException(); }
    @Override
    public User sender() { throw new UnsupportedOperationException(); }
    @Override
    public EventInstallation eventInstallation() { throw new UnsupportedOperationException(); }
    @Override
    public String action() { throw new UnsupportedOperationException(); }
    @Override
    public Comment comment() { throw new UnsupportedOperationException(); }
    @Override
    public PullRequestItem pullRequest() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutablePullRequestReviewCommentEvent fromJson(Json json) {
    ImmutablePullRequestReviewCommentEvent.Builder builder = ImmutablePullRequestReviewCommentEvent.builder();
    if (json.repository != null) {
      builder.repository(json.repository);
    }
    if (json.sender != null) {
      builder.sender(json.sender);
    }
    if (json.eventInstallation != null) {
      builder.eventInstallation(json.eventInstallation);
    }
    if (json.action != null) {
      builder.action(json.action);
    }
    if (json.comment != null) {
      builder.comment(json.comment);
    }
    if (json.pullRequest != null) {
      builder.pullRequest(json.pullRequest);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link PullRequestReviewCommentEvent} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable PullRequestReviewCommentEvent instance
   */
  public static ImmutablePullRequestReviewCommentEvent copyOf(PullRequestReviewCommentEvent instance) {
    if (instance instanceof ImmutablePullRequestReviewCommentEvent) {
      return (ImmutablePullRequestReviewCommentEvent) instance;
    }
    return ImmutablePullRequestReviewCommentEvent.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutablePullRequestReviewCommentEvent ImmutablePullRequestReviewCommentEvent}.
   * <pre>
   * ImmutablePullRequestReviewCommentEvent.builder()
   *    .repository(com.spotify.github.v3.repos.Repository | null) // nullable {@link PullRequestReviewCommentEvent#repository() repository}
   *    .sender(com.spotify.github.v3.User | null) // nullable {@link PullRequestReviewCommentEvent#sender() sender}
   *    .eventInstallation(com.spotify.github.v3.activity.events.EventInstallation | null) // nullable {@link PullRequestReviewCommentEvent#eventInstallation() eventInstallation}
   *    .action(String | null) // nullable {@link PullRequestReviewCommentEvent#action() action}
   *    .comment(com.spotify.github.v3.prs.Comment | null) // nullable {@link PullRequestReviewCommentEvent#comment() comment}
   *    .pullRequest(com.spotify.github.v3.prs.PullRequestItem | null) // nullable {@link PullRequestReviewCommentEvent#pullRequest() pullRequest}
   *    .build();
   * </pre>
   * @return A new ImmutablePullRequestReviewCommentEvent builder
   */
  public static ImmutablePullRequestReviewCommentEvent.Builder builder() {
    return new ImmutablePullRequestReviewCommentEvent.Builder();
  }

  /**
   * Builds instances of type {@link ImmutablePullRequestReviewCommentEvent ImmutablePullRequestReviewCommentEvent}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "PullRequestReviewCommentEvent", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable Repository repository;
    private @Nullable User sender;
    private @Nullable EventInstallation eventInstallation;
    private @Nullable String action;
    private @Nullable Comment comment;
    private @Nullable PullRequestItem pullRequest;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.spotify.github.v3.activity.events.BaseEvent} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(BaseEvent instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.spotify.github.v3.activity.events.PullRequestReviewCommentEvent} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(PullRequestReviewCommentEvent instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof BaseEvent) {
        BaseEvent instance = (BaseEvent) object;
        @Nullable Repository repositoryValue = instance.repository();
        if (repositoryValue != null) {
          repository(repositoryValue);
        }
        @Nullable User senderValue = instance.sender();
        if (senderValue != null) {
          sender(senderValue);
        }
        @Nullable EventInstallation eventInstallationValue = instance.eventInstallation();
        if (eventInstallationValue != null) {
          eventInstallation(eventInstallationValue);
        }
      }
      if (object instanceof PullRequestReviewCommentEvent) {
        PullRequestReviewCommentEvent instance = (PullRequestReviewCommentEvent) object;
        @Nullable String actionValue = instance.action();
        if (actionValue != null) {
          action(actionValue);
        }
        @Nullable Comment commentValue = instance.comment();
        if (commentValue != null) {
          comment(commentValue);
        }
        @Nullable PullRequestItem pullRequestValue = instance.pullRequest();
        if (pullRequestValue != null) {
          pullRequest(pullRequestValue);
        }
      }
    }

    /**
     * Initializes the value for the {@link PullRequestReviewCommentEvent#repository() repository} attribute.
     * @param repository The value for repository (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder repository(@Nullable Repository repository) {
      this.repository = repository;
      return this;
    }

    /**
     * Initializes the value for the {@link PullRequestReviewCommentEvent#sender() sender} attribute.
     * @param sender The value for sender (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder sender(@Nullable User sender) {
      this.sender = sender;
      return this;
    }

    /**
     * Initializes the value for the {@link PullRequestReviewCommentEvent#eventInstallation() eventInstallation} attribute.
     * @param eventInstallation The value for eventInstallation (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("installation")
    public final Builder eventInstallation(@Nullable EventInstallation eventInstallation) {
      this.eventInstallation = eventInstallation;
      return this;
    }

    /**
     * Initializes the value for the {@link PullRequestReviewCommentEvent#action() action} attribute.
     * @param action The value for action (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder action(@Nullable String action) {
      this.action = action;
      return this;
    }

    /**
     * Initializes the value for the {@link PullRequestReviewCommentEvent#comment() comment} attribute.
     * @param comment The value for comment (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder comment(@Nullable Comment comment) {
      this.comment = comment;
      return this;
    }

    /**
     * Initializes the value for the {@link PullRequestReviewCommentEvent#pullRequest() pullRequest} attribute.
     * @param pullRequest The value for pullRequest (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder pullRequest(@Nullable PullRequestItem pullRequest) {
      this.pullRequest = pullRequest;
      return this;
    }

    /**
     * Builds a new {@link ImmutablePullRequestReviewCommentEvent ImmutablePullRequestReviewCommentEvent}.
     * @return An immutable instance of PullRequestReviewCommentEvent
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutablePullRequestReviewCommentEvent build() {
      return new ImmutablePullRequestReviewCommentEvent(repository, sender, eventInstallation, action, comment, pullRequest);
    }
  }
}
