package com.spotify.github.v3.checks;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link AccessToken}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableAccessToken.builder()}.
 */
@Generated(from = "AccessToken", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableAccessToken implements AccessToken {
  private final String token;
  private final ZonedDateTime expiresAt;

  private ImmutableAccessToken(String token, ZonedDateTime expiresAt) {
    this.token = token;
    this.expiresAt = expiresAt;
  }

  /**
   * Access Token.
   * @return the token content
   */
  @JsonProperty
  @Override
  public String token() {
    return token;
  }

  /**
   * Token expiration date.
   * @return the zoned date time
   */
  @JsonProperty
  @Override
  public ZonedDateTime expiresAt() {
    return expiresAt;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AccessToken#token() token} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for token
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAccessToken withToken(String value) {
    String newValue = Objects.requireNonNull(value, "token");
    if (this.token.equals(newValue)) return this;
    return new ImmutableAccessToken(newValue, this.expiresAt);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AccessToken#expiresAt() expiresAt} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for expiresAt
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAccessToken withExpiresAt(ZonedDateTime value) {
    if (this.expiresAt == value) return this;
    ZonedDateTime newValue = Objects.requireNonNull(value, "expiresAt");
    return new ImmutableAccessToken(this.token, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableAccessToken} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableAccessToken
        && equalTo((ImmutableAccessToken) another);
  }

  private boolean equalTo(ImmutableAccessToken another) {
    return token.equals(another.token)
        && expiresAt.equals(another.expiresAt);
  }

  /**
   * Computes a hash code from attributes: {@code token}, {@code expiresAt}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + token.hashCode();
    h += (h << 5) + expiresAt.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code AccessToken} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "AccessToken{"
        + "token=" + token
        + ", expiresAt=" + expiresAt
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "AccessToken", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements AccessToken {
    @Nullable String token;
    @Nullable ZonedDateTime expiresAt;
    @JsonProperty
    public void setToken(String token) {
      this.token = token;
    }
    @JsonProperty
    public void setExpiresAt(ZonedDateTime expiresAt) {
      this.expiresAt = expiresAt;
    }
    @Override
    public String token() { throw new UnsupportedOperationException(); }
    @Override
    public ZonedDateTime expiresAt() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableAccessToken fromJson(Json json) {
    ImmutableAccessToken.Builder builder = ImmutableAccessToken.builder();
    if (json.token != null) {
      builder.token(json.token);
    }
    if (json.expiresAt != null) {
      builder.expiresAt(json.expiresAt);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link AccessToken} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable AccessToken instance
   */
  public static ImmutableAccessToken copyOf(AccessToken instance) {
    if (instance instanceof ImmutableAccessToken) {
      return (ImmutableAccessToken) instance;
    }
    return ImmutableAccessToken.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableAccessToken ImmutableAccessToken}.
   * <pre>
   * ImmutableAccessToken.builder()
   *    .token(String) // required {@link AccessToken#token() token}
   *    .expiresAt(java.time.ZonedDateTime) // required {@link AccessToken#expiresAt() expiresAt}
   *    .build();
   * </pre>
   * @return A new ImmutableAccessToken builder
   */
  public static ImmutableAccessToken.Builder builder() {
    return new ImmutableAccessToken.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableAccessToken ImmutableAccessToken}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "AccessToken", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_TOKEN = 0x1L;
    private static final long INIT_BIT_EXPIRES_AT = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String token;
    private @Nullable ZonedDateTime expiresAt;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code AccessToken} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(AccessToken instance) {
      Objects.requireNonNull(instance, "instance");
      token(instance.token());
      expiresAt(instance.expiresAt());
      return this;
    }

    /**
     * Initializes the value for the {@link AccessToken#token() token} attribute.
     * @param token The value for token 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder token(String token) {
      this.token = Objects.requireNonNull(token, "token");
      initBits &= ~INIT_BIT_TOKEN;
      return this;
    }

    /**
     * Initializes the value for the {@link AccessToken#expiresAt() expiresAt} attribute.
     * @param expiresAt The value for expiresAt 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder expiresAt(ZonedDateTime expiresAt) {
      this.expiresAt = Objects.requireNonNull(expiresAt, "expiresAt");
      initBits &= ~INIT_BIT_EXPIRES_AT;
      return this;
    }

    /**
     * Builds a new {@link ImmutableAccessToken ImmutableAccessToken}.
     * @return An immutable instance of AccessToken
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableAccessToken build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableAccessToken(token, expiresAt);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_TOKEN) != 0) attributes.add("token");
      if ((initBits & INIT_BIT_EXPIRES_AT) != 0) attributes.add("expiresAt");
      return "Cannot build AccessToken, some of required attributes are not set " + attributes;
    }
  }
}
