package com.spotify.github.v3.checks;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Annotation}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableAnnotation.builder()}.
 */
@Generated(from = "Annotation", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableAnnotation implements Annotation {
  private final String path;
  private final @Nullable String blobHref;
  private final AnnotationLevel annotationLevel;
  private final String message;
  private final @Nullable String title;
  private final @Nullable String rawDetails;
  private final int startLine;
  private final int endLine;
  private final @Nullable Integer startColumn;
  private final @Nullable Integer endColumn;

  private ImmutableAnnotation(
      String path,
      @Nullable String blobHref,
      AnnotationLevel annotationLevel,
      String message,
      @Nullable String title,
      @Nullable String rawDetails,
      int startLine,
      int endLine,
      @Nullable Integer startColumn,
      @Nullable Integer endColumn) {
    this.path = path;
    this.blobHref = blobHref;
    this.annotationLevel = annotationLevel;
    this.message = message;
    this.title = title;
    this.rawDetails = rawDetails;
    this.startLine = startLine;
    this.endLine = endLine;
    this.startColumn = startColumn;
    this.endColumn = endColumn;
  }

  /**
   * The path of the file to add an annotation to. For example, assets/css/main.css.
   * @return the string
   */
  @JsonProperty
  @Override
  public String path() {
    return path;
  }

  /**
   * Blob href optional.
   * @return the optional
   */
  @JsonProperty
  @Override
  public Optional<String> blobHref() {
    return Optional.ofNullable(blobHref);
  }

  /**
   * Annotation level. Can be one of notice, warning, or failure.
   * @return the annotation level
   */
  @JsonProperty
  @Override
  public AnnotationLevel annotationLevel() {
    return annotationLevel;
  }

  /**
   * A short description of the feedback for these lines of code. The maximum size is 64 KB.
   * @return the string
   */
  @JsonProperty
  @Override
  public String message() {
    return message;
  }

  /**
   * The title that represents the annotation. The maximum size is 255 characters.
   * @return the optional
   */
  @JsonProperty
  @Override
  public Optional<String> title() {
    return Optional.ofNullable(title);
  }

  /**
   * Details about this annotation. The maximum size is 64 KB.
   * @return the optional string
   */
  @JsonProperty
  @Override
  public Optional<String> rawDetails() {
    return Optional.ofNullable(rawDetails);
  }

  /**
   * The start line of the annotation.
   * @return the int
   */
  @JsonProperty
  @Override
  public int startLine() {
    return startLine;
  }

  /**
   * The end line of the annotation.
   * @return the int
   */
  @JsonProperty
  @Override
  public int endLine() {
    return endLine;
  }

  /**
   * Start column optional.
   * @return the optional
   */
  @JsonProperty
  @Override
  public Optional<Integer> startColumn() {
    return Optional.ofNullable(startColumn);
  }

  /**
   * End column optional.
   * @return the optional
   */
  @JsonProperty
  @Override
  public Optional<Integer> endColumn() {
    return Optional.ofNullable(endColumn);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Annotation#path() path} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for path
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAnnotation withPath(String value) {
    String newValue = Objects.requireNonNull(value, "path");
    if (this.path.equals(newValue)) return this;
    return validate(new ImmutableAnnotation(
        newValue,
        this.blobHref,
        this.annotationLevel,
        this.message,
        this.title,
        this.rawDetails,
        this.startLine,
        this.endLine,
        this.startColumn,
        this.endColumn));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Annotation#blobHref() blobHref} attribute.
   * @param value The value for blobHref
   * @return A modified copy of {@code this} object
   */
  public final ImmutableAnnotation withBlobHref(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "blobHref");
    if (Objects.equals(this.blobHref, newValue)) return this;
    return validate(new ImmutableAnnotation(
        this.path,
        newValue,
        this.annotationLevel,
        this.message,
        this.title,
        this.rawDetails,
        this.startLine,
        this.endLine,
        this.startColumn,
        this.endColumn));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Annotation#blobHref() blobHref} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for blobHref
   * @return A modified copy of {@code this} object
   */
  public final ImmutableAnnotation withBlobHref(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.blobHref, value)) return this;
    return validate(new ImmutableAnnotation(
        this.path,
        value,
        this.annotationLevel,
        this.message,
        this.title,
        this.rawDetails,
        this.startLine,
        this.endLine,
        this.startColumn,
        this.endColumn));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Annotation#annotationLevel() annotationLevel} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for annotationLevel
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAnnotation withAnnotationLevel(AnnotationLevel value) {
    if (this.annotationLevel == value) return this;
    AnnotationLevel newValue = Objects.requireNonNull(value, "annotationLevel");
    if (this.annotationLevel.equals(newValue)) return this;
    return validate(new ImmutableAnnotation(
        this.path,
        this.blobHref,
        newValue,
        this.message,
        this.title,
        this.rawDetails,
        this.startLine,
        this.endLine,
        this.startColumn,
        this.endColumn));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Annotation#message() message} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for message
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAnnotation withMessage(String value) {
    String newValue = Objects.requireNonNull(value, "message");
    if (this.message.equals(newValue)) return this;
    return validate(new ImmutableAnnotation(
        this.path,
        this.blobHref,
        this.annotationLevel,
        newValue,
        this.title,
        this.rawDetails,
        this.startLine,
        this.endLine,
        this.startColumn,
        this.endColumn));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Annotation#title() title} attribute.
   * @param value The value for title
   * @return A modified copy of {@code this} object
   */
  public final ImmutableAnnotation withTitle(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "title");
    if (Objects.equals(this.title, newValue)) return this;
    return validate(new ImmutableAnnotation(
        this.path,
        this.blobHref,
        this.annotationLevel,
        this.message,
        newValue,
        this.rawDetails,
        this.startLine,
        this.endLine,
        this.startColumn,
        this.endColumn));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Annotation#title() title} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for title
   * @return A modified copy of {@code this} object
   */
  public final ImmutableAnnotation withTitle(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.title, value)) return this;
    return validate(new ImmutableAnnotation(
        this.path,
        this.blobHref,
        this.annotationLevel,
        this.message,
        value,
        this.rawDetails,
        this.startLine,
        this.endLine,
        this.startColumn,
        this.endColumn));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Annotation#rawDetails() rawDetails} attribute.
   * @param value The value for rawDetails
   * @return A modified copy of {@code this} object
   */
  public final ImmutableAnnotation withRawDetails(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "rawDetails");
    if (Objects.equals(this.rawDetails, newValue)) return this;
    return validate(new ImmutableAnnotation(
        this.path,
        this.blobHref,
        this.annotationLevel,
        this.message,
        this.title,
        newValue,
        this.startLine,
        this.endLine,
        this.startColumn,
        this.endColumn));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Annotation#rawDetails() rawDetails} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for rawDetails
   * @return A modified copy of {@code this} object
   */
  public final ImmutableAnnotation withRawDetails(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.rawDetails, value)) return this;
    return validate(new ImmutableAnnotation(
        this.path,
        this.blobHref,
        this.annotationLevel,
        this.message,
        this.title,
        value,
        this.startLine,
        this.endLine,
        this.startColumn,
        this.endColumn));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Annotation#startLine() startLine} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for startLine
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAnnotation withStartLine(int value) {
    if (this.startLine == value) return this;
    return validate(new ImmutableAnnotation(
        this.path,
        this.blobHref,
        this.annotationLevel,
        this.message,
        this.title,
        this.rawDetails,
        value,
        this.endLine,
        this.startColumn,
        this.endColumn));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Annotation#endLine() endLine} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for endLine
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAnnotation withEndLine(int value) {
    if (this.endLine == value) return this;
    return validate(new ImmutableAnnotation(
        this.path,
        this.blobHref,
        this.annotationLevel,
        this.message,
        this.title,
        this.rawDetails,
        this.startLine,
        value,
        this.startColumn,
        this.endColumn));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Annotation#startColumn() startColumn} attribute.
   * @param value The value for startColumn
   * @return A modified copy of {@code this} object
   */
  public final ImmutableAnnotation withStartColumn(int value) {
    @Nullable Integer newValue = value;
    if (Objects.equals(this.startColumn, newValue)) return this;
    return validate(new ImmutableAnnotation(
        this.path,
        this.blobHref,
        this.annotationLevel,
        this.message,
        this.title,
        this.rawDetails,
        this.startLine,
        this.endLine,
        newValue,
        this.endColumn));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Annotation#startColumn() startColumn} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for startColumn
   * @return A modified copy of {@code this} object
   */
  public final ImmutableAnnotation withStartColumn(Optional<Integer> optional) {
    @Nullable Integer value = optional.orElse(null);
    if (Objects.equals(this.startColumn, value)) return this;
    return validate(new ImmutableAnnotation(
        this.path,
        this.blobHref,
        this.annotationLevel,
        this.message,
        this.title,
        this.rawDetails,
        this.startLine,
        this.endLine,
        value,
        this.endColumn));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Annotation#endColumn() endColumn} attribute.
   * @param value The value for endColumn
   * @return A modified copy of {@code this} object
   */
  public final ImmutableAnnotation withEndColumn(int value) {
    @Nullable Integer newValue = value;
    if (Objects.equals(this.endColumn, newValue)) return this;
    return validate(new ImmutableAnnotation(
        this.path,
        this.blobHref,
        this.annotationLevel,
        this.message,
        this.title,
        this.rawDetails,
        this.startLine,
        this.endLine,
        this.startColumn,
        newValue));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Annotation#endColumn() endColumn} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for endColumn
   * @return A modified copy of {@code this} object
   */
  public final ImmutableAnnotation withEndColumn(Optional<Integer> optional) {
    @Nullable Integer value = optional.orElse(null);
    if (Objects.equals(this.endColumn, value)) return this;
    return validate(new ImmutableAnnotation(
        this.path,
        this.blobHref,
        this.annotationLevel,
        this.message,
        this.title,
        this.rawDetails,
        this.startLine,
        this.endLine,
        this.startColumn,
        value));
  }

  /**
   * This instance is equal to all instances of {@code ImmutableAnnotation} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableAnnotation
        && equalTo((ImmutableAnnotation) another);
  }

  private boolean equalTo(ImmutableAnnotation another) {
    return path.equals(another.path)
        && Objects.equals(blobHref, another.blobHref)
        && annotationLevel.equals(another.annotationLevel)
        && message.equals(another.message)
        && Objects.equals(title, another.title)
        && Objects.equals(rawDetails, another.rawDetails)
        && startLine == another.startLine
        && endLine == another.endLine
        && Objects.equals(startColumn, another.startColumn)
        && Objects.equals(endColumn, another.endColumn);
  }

  /**
   * Computes a hash code from attributes: {@code path}, {@code blobHref}, {@code annotationLevel}, {@code message}, {@code title}, {@code rawDetails}, {@code startLine}, {@code endLine}, {@code startColumn}, {@code endColumn}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + path.hashCode();
    h += (h << 5) + Objects.hashCode(blobHref);
    h += (h << 5) + annotationLevel.hashCode();
    h += (h << 5) + message.hashCode();
    h += (h << 5) + Objects.hashCode(title);
    h += (h << 5) + Objects.hashCode(rawDetails);
    h += (h << 5) + startLine;
    h += (h << 5) + endLine;
    h += (h << 5) + Objects.hashCode(startColumn);
    h += (h << 5) + Objects.hashCode(endColumn);
    return h;
  }

  /**
   * Prints the immutable value {@code Annotation} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("Annotation{");
    builder.append("path=").append(path);
    if (blobHref != null) {
      builder.append(", ");
      builder.append("blobHref=").append(blobHref);
    }
    builder.append(", ");
    builder.append("annotationLevel=").append(annotationLevel);
    builder.append(", ");
    builder.append("message=").append(message);
    if (title != null) {
      builder.append(", ");
      builder.append("title=").append(title);
    }
    if (rawDetails != null) {
      builder.append(", ");
      builder.append("rawDetails=").append(rawDetails);
    }
    builder.append(", ");
    builder.append("startLine=").append(startLine);
    builder.append(", ");
    builder.append("endLine=").append(endLine);
    if (startColumn != null) {
      builder.append(", ");
      builder.append("startColumn=").append(startColumn);
    }
    if (endColumn != null) {
      builder.append(", ");
      builder.append("endColumn=").append(endColumn);
    }
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Annotation", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements Annotation {
    @Nullable String path;
    @Nullable Optional<String> blobHref = Optional.empty();
    @Nullable AnnotationLevel annotationLevel;
    @Nullable String message;
    @Nullable Optional<String> title = Optional.empty();
    @Nullable Optional<String> rawDetails = Optional.empty();
    int startLine;
    boolean startLineIsSet;
    int endLine;
    boolean endLineIsSet;
    @Nullable Optional<Integer> startColumn = Optional.empty();
    @Nullable Optional<Integer> endColumn = Optional.empty();
    @JsonProperty
    public void setPath(String path) {
      this.path = path;
    }
    @JsonProperty
    public void setBlobHref(Optional<String> blobHref) {
      this.blobHref = blobHref;
    }
    @JsonProperty
    public void setAnnotationLevel(AnnotationLevel annotationLevel) {
      this.annotationLevel = annotationLevel;
    }
    @JsonProperty
    public void setMessage(String message) {
      this.message = message;
    }
    @JsonProperty
    public void setTitle(Optional<String> title) {
      this.title = title;
    }
    @JsonProperty
    public void setRawDetails(Optional<String> rawDetails) {
      this.rawDetails = rawDetails;
    }
    @JsonProperty
    public void setStartLine(int startLine) {
      this.startLine = startLine;
      this.startLineIsSet = true;
    }
    @JsonProperty
    public void setEndLine(int endLine) {
      this.endLine = endLine;
      this.endLineIsSet = true;
    }
    @JsonProperty
    public void setStartColumn(Optional<Integer> startColumn) {
      this.startColumn = startColumn;
    }
    @JsonProperty
    public void setEndColumn(Optional<Integer> endColumn) {
      this.endColumn = endColumn;
    }
    @Override
    public String path() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> blobHref() { throw new UnsupportedOperationException(); }
    @Override
    public AnnotationLevel annotationLevel() { throw new UnsupportedOperationException(); }
    @Override
    public String message() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> title() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> rawDetails() { throw new UnsupportedOperationException(); }
    @Override
    public int startLine() { throw new UnsupportedOperationException(); }
    @Override
    public int endLine() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Integer> startColumn() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Integer> endColumn() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableAnnotation fromJson(Json json) {
    ImmutableAnnotation.Builder builder = ImmutableAnnotation.builder();
    if (json.path != null) {
      builder.path(json.path);
    }
    if (json.blobHref != null) {
      builder.blobHref(json.blobHref);
    }
    if (json.annotationLevel != null) {
      builder.annotationLevel(json.annotationLevel);
    }
    if (json.message != null) {
      builder.message(json.message);
    }
    if (json.title != null) {
      builder.title(json.title);
    }
    if (json.rawDetails != null) {
      builder.rawDetails(json.rawDetails);
    }
    if (json.startLineIsSet) {
      builder.startLine(json.startLine);
    }
    if (json.endLineIsSet) {
      builder.endLine(json.endLine);
    }
    if (json.startColumn != null) {
      builder.startColumn(json.startColumn);
    }
    if (json.endColumn != null) {
      builder.endColumn(json.endColumn);
    }
    return builder.build();
  }

  private static ImmutableAnnotation validate(ImmutableAnnotation instance) {
    instance.check();
    return instance;
  }

  /**
   * Creates an immutable copy of a {@link Annotation} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Annotation instance
   */
  public static ImmutableAnnotation copyOf(Annotation instance) {
    if (instance instanceof ImmutableAnnotation) {
      return (ImmutableAnnotation) instance;
    }
    return ImmutableAnnotation.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableAnnotation ImmutableAnnotation}.
   * <pre>
   * ImmutableAnnotation.builder()
   *    .path(String) // required {@link Annotation#path() path}
   *    .blobHref(String) // optional {@link Annotation#blobHref() blobHref}
   *    .annotationLevel(com.spotify.github.v3.checks.AnnotationLevel) // required {@link Annotation#annotationLevel() annotationLevel}
   *    .message(String) // required {@link Annotation#message() message}
   *    .title(String) // optional {@link Annotation#title() title}
   *    .rawDetails(String) // optional {@link Annotation#rawDetails() rawDetails}
   *    .startLine(int) // required {@link Annotation#startLine() startLine}
   *    .endLine(int) // required {@link Annotation#endLine() endLine}
   *    .startColumn(Integer) // optional {@link Annotation#startColumn() startColumn}
   *    .endColumn(Integer) // optional {@link Annotation#endColumn() endColumn}
   *    .build();
   * </pre>
   * @return A new ImmutableAnnotation builder
   */
  public static ImmutableAnnotation.Builder builder() {
    return new ImmutableAnnotation.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableAnnotation ImmutableAnnotation}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Annotation", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_PATH = 0x1L;
    private static final long INIT_BIT_ANNOTATION_LEVEL = 0x2L;
    private static final long INIT_BIT_MESSAGE = 0x4L;
    private static final long INIT_BIT_START_LINE = 0x8L;
    private static final long INIT_BIT_END_LINE = 0x10L;
    private long initBits = 0x1fL;

    private @Nullable String path;
    private @Nullable String blobHref;
    private @Nullable AnnotationLevel annotationLevel;
    private @Nullable String message;
    private @Nullable String title;
    private @Nullable String rawDetails;
    private int startLine;
    private int endLine;
    private @Nullable Integer startColumn;
    private @Nullable Integer endColumn;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Annotation} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Annotation instance) {
      Objects.requireNonNull(instance, "instance");
      path(instance.path());
      Optional<String> blobHrefOptional = instance.blobHref();
      if (blobHrefOptional.isPresent()) {
        blobHref(blobHrefOptional);
      }
      annotationLevel(instance.annotationLevel());
      message(instance.message());
      Optional<String> titleOptional = instance.title();
      if (titleOptional.isPresent()) {
        title(titleOptional);
      }
      Optional<String> rawDetailsOptional = instance.rawDetails();
      if (rawDetailsOptional.isPresent()) {
        rawDetails(rawDetailsOptional);
      }
      startLine(instance.startLine());
      endLine(instance.endLine());
      Optional<Integer> startColumnOptional = instance.startColumn();
      if (startColumnOptional.isPresent()) {
        startColumn(startColumnOptional);
      }
      Optional<Integer> endColumnOptional = instance.endColumn();
      if (endColumnOptional.isPresent()) {
        endColumn(endColumnOptional);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Annotation#path() path} attribute.
     * @param path The value for path 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder path(String path) {
      this.path = Objects.requireNonNull(path, "path");
      initBits &= ~INIT_BIT_PATH;
      return this;
    }

    /**
     * Initializes the optional value {@link Annotation#blobHref() blobHref} to blobHref.
     * @param blobHref The value for blobHref
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder blobHref(String blobHref) {
      this.blobHref = Objects.requireNonNull(blobHref, "blobHref");
      return this;
    }

    /**
     * Initializes the optional value {@link Annotation#blobHref() blobHref} to blobHref.
     * @param blobHref The value for blobHref
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder blobHref(Optional<String> blobHref) {
      this.blobHref = blobHref.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link Annotation#annotationLevel() annotationLevel} attribute.
     * @param annotationLevel The value for annotationLevel 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder annotationLevel(AnnotationLevel annotationLevel) {
      this.annotationLevel = Objects.requireNonNull(annotationLevel, "annotationLevel");
      initBits &= ~INIT_BIT_ANNOTATION_LEVEL;
      return this;
    }

    /**
     * Initializes the value for the {@link Annotation#message() message} attribute.
     * @param message The value for message 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder message(String message) {
      this.message = Objects.requireNonNull(message, "message");
      initBits &= ~INIT_BIT_MESSAGE;
      return this;
    }

    /**
     * Initializes the optional value {@link Annotation#title() title} to title.
     * @param title The value for title
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder title(String title) {
      this.title = Objects.requireNonNull(title, "title");
      return this;
    }

    /**
     * Initializes the optional value {@link Annotation#title() title} to title.
     * @param title The value for title
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder title(Optional<String> title) {
      this.title = title.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link Annotation#rawDetails() rawDetails} to rawDetails.
     * @param rawDetails The value for rawDetails
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder rawDetails(String rawDetails) {
      this.rawDetails = Objects.requireNonNull(rawDetails, "rawDetails");
      return this;
    }

    /**
     * Initializes the optional value {@link Annotation#rawDetails() rawDetails} to rawDetails.
     * @param rawDetails The value for rawDetails
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder rawDetails(Optional<String> rawDetails) {
      this.rawDetails = rawDetails.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link Annotation#startLine() startLine} attribute.
     * @param startLine The value for startLine 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder startLine(int startLine) {
      this.startLine = startLine;
      initBits &= ~INIT_BIT_START_LINE;
      return this;
    }

    /**
     * Initializes the value for the {@link Annotation#endLine() endLine} attribute.
     * @param endLine The value for endLine 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder endLine(int endLine) {
      this.endLine = endLine;
      initBits &= ~INIT_BIT_END_LINE;
      return this;
    }

    /**
     * Initializes the optional value {@link Annotation#startColumn() startColumn} to startColumn.
     * @param startColumn The value for startColumn
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder startColumn(int startColumn) {
      this.startColumn = startColumn;
      return this;
    }

    /**
     * Initializes the optional value {@link Annotation#startColumn() startColumn} to startColumn.
     * @param startColumn The value for startColumn
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder startColumn(Optional<Integer> startColumn) {
      this.startColumn = startColumn.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link Annotation#endColumn() endColumn} to endColumn.
     * @param endColumn The value for endColumn
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder endColumn(int endColumn) {
      this.endColumn = endColumn;
      return this;
    }

    /**
     * Initializes the optional value {@link Annotation#endColumn() endColumn} to endColumn.
     * @param endColumn The value for endColumn
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder endColumn(Optional<Integer> endColumn) {
      this.endColumn = endColumn.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ImmutableAnnotation ImmutableAnnotation}.
     * @return An immutable instance of Annotation
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableAnnotation build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return ImmutableAnnotation.validate(new ImmutableAnnotation(
          path,
          blobHref,
          annotationLevel,
          message,
          title,
          rawDetails,
          startLine,
          endLine,
          startColumn,
          endColumn));
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_PATH) != 0) attributes.add("path");
      if ((initBits & INIT_BIT_ANNOTATION_LEVEL) != 0) attributes.add("annotationLevel");
      if ((initBits & INIT_BIT_MESSAGE) != 0) attributes.add("message");
      if ((initBits & INIT_BIT_START_LINE) != 0) attributes.add("startLine");
      if ((initBits & INIT_BIT_END_LINE) != 0) attributes.add("endLine");
      return "Cannot build Annotation, some of required attributes are not set " + attributes;
    }
  }
}
