package com.spotify.github.v3.checks;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link App}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableApp.builder()}.
 */
@Generated(from = "App", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableApp implements App {
  private final Integer id;
  private final @Nullable String slug;
  private final String name;
  private final String description;
  private final String externalUrl;
  private final String htmlUrl;
  private final ZonedDateTime createdAt;
  private final ZonedDateTime updatedAt;
  private final Map<String, String> permissions;
  private final List<String> events;
  private final @Nullable Integer installationsCount;

  private ImmutableApp(
      Integer id,
      @Nullable String slug,
      String name,
      String description,
      String externalUrl,
      String htmlUrl,
      ZonedDateTime createdAt,
      ZonedDateTime updatedAt,
      Map<String, String> permissions,
      List<String> events,
      @Nullable Integer installationsCount) {
    this.id = id;
    this.slug = slug;
    this.name = name;
    this.description = description;
    this.externalUrl = externalUrl;
    this.htmlUrl = htmlUrl;
    this.createdAt = createdAt;
    this.updatedAt = updatedAt;
    this.permissions = permissions;
    this.events = events;
    this.installationsCount = installationsCount;
  }

  /**
   * The App ID.
   * @return the ID
   */
  @JsonProperty
  @Override
  public Integer id() {
    return id;
  }

  /**
   * The URL-friendly name of the GitHub App.
   * @return the optional sting
   */
  @JsonProperty
  @Override
  public Optional<String> slug() {
    return Optional.ofNullable(slug);
  }

  /**
   * The App name
   * @return the string
   */
  @JsonProperty
  @Override
  public String name() {
    return name;
  }

  /**
   * The App Description.
   * @return the string
   */
  @JsonProperty
  @Override
  public String description() {
    return description;
  }

  /**
   * External url string.
   * @return the string
   */
  @JsonProperty
  @Override
  public String externalUrl() {
    return externalUrl;
  }

  /**
   * Html url string.
   * @return the string
   */
  @JsonProperty
  @Override
  public String htmlUrl() {
    return htmlUrl;
  }

  /**
   * The date the App was created.
   * @return the zoned date time
   */
  @JsonProperty
  @Override
  public ZonedDateTime createdAt() {
    return createdAt;
  }

  /**
   * The date the App was updated.
   * @return the zoned date time
   */
  @JsonProperty
  @Override
  public ZonedDateTime updatedAt() {
    return updatedAt;
  }

  /**
   * The permissions the installation of the app has.
   * @see "https://developer.github.com/apps/building-github-apps/creating-github-apps-using-url
   *     -parameters/#github-app-permissions"
   * @return the map with permissions
   */
  @JsonProperty
  @Override
  public Map<String, String> permissions() {
    return permissions;
  }

  /**
   * Events list this App will consume, such as push, pull_request, etc.
   * @return the list
   */
  @JsonProperty
  @Override
  public List<String> events() {
    return events;
  }

  /**
   * Installation count of the App.
   * @return the optional count
   */
  @JsonProperty
  @Override
  public Optional<Integer> installationsCount() {
    return Optional.ofNullable(installationsCount);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link App#id() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableApp withId(Integer value) {
    Integer newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutableApp(
        newValue,
        this.slug,
        this.name,
        this.description,
        this.externalUrl,
        this.htmlUrl,
        this.createdAt,
        this.updatedAt,
        this.permissions,
        this.events,
        this.installationsCount);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link App#slug() slug} attribute.
   * @param value The value for slug
   * @return A modified copy of {@code this} object
   */
  public final ImmutableApp withSlug(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "slug");
    if (Objects.equals(this.slug, newValue)) return this;
    return new ImmutableApp(
        this.id,
        newValue,
        this.name,
        this.description,
        this.externalUrl,
        this.htmlUrl,
        this.createdAt,
        this.updatedAt,
        this.permissions,
        this.events,
        this.installationsCount);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link App#slug() slug} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for slug
   * @return A modified copy of {@code this} object
   */
  public final ImmutableApp withSlug(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.slug, value)) return this;
    return new ImmutableApp(
        this.id,
        value,
        this.name,
        this.description,
        this.externalUrl,
        this.htmlUrl,
        this.createdAt,
        this.updatedAt,
        this.permissions,
        this.events,
        this.installationsCount);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link App#name() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableApp withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableApp(
        this.id,
        this.slug,
        newValue,
        this.description,
        this.externalUrl,
        this.htmlUrl,
        this.createdAt,
        this.updatedAt,
        this.permissions,
        this.events,
        this.installationsCount);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link App#description() description} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for description
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableApp withDescription(String value) {
    String newValue = Objects.requireNonNull(value, "description");
    if (this.description.equals(newValue)) return this;
    return new ImmutableApp(
        this.id,
        this.slug,
        this.name,
        newValue,
        this.externalUrl,
        this.htmlUrl,
        this.createdAt,
        this.updatedAt,
        this.permissions,
        this.events,
        this.installationsCount);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link App#externalUrl() externalUrl} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for externalUrl
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableApp withExternalUrl(String value) {
    String newValue = Objects.requireNonNull(value, "externalUrl");
    if (this.externalUrl.equals(newValue)) return this;
    return new ImmutableApp(
        this.id,
        this.slug,
        this.name,
        this.description,
        newValue,
        this.htmlUrl,
        this.createdAt,
        this.updatedAt,
        this.permissions,
        this.events,
        this.installationsCount);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link App#htmlUrl() htmlUrl} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for htmlUrl
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableApp withHtmlUrl(String value) {
    String newValue = Objects.requireNonNull(value, "htmlUrl");
    if (this.htmlUrl.equals(newValue)) return this;
    return new ImmutableApp(
        this.id,
        this.slug,
        this.name,
        this.description,
        this.externalUrl,
        newValue,
        this.createdAt,
        this.updatedAt,
        this.permissions,
        this.events,
        this.installationsCount);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link App#createdAt() createdAt} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for createdAt
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableApp withCreatedAt(ZonedDateTime value) {
    if (this.createdAt == value) return this;
    ZonedDateTime newValue = Objects.requireNonNull(value, "createdAt");
    return new ImmutableApp(
        this.id,
        this.slug,
        this.name,
        this.description,
        this.externalUrl,
        this.htmlUrl,
        newValue,
        this.updatedAt,
        this.permissions,
        this.events,
        this.installationsCount);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link App#updatedAt() updatedAt} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for updatedAt
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableApp withUpdatedAt(ZonedDateTime value) {
    if (this.updatedAt == value) return this;
    ZonedDateTime newValue = Objects.requireNonNull(value, "updatedAt");
    return new ImmutableApp(
        this.id,
        this.slug,
        this.name,
        this.description,
        this.externalUrl,
        this.htmlUrl,
        this.createdAt,
        newValue,
        this.permissions,
        this.events,
        this.installationsCount);
  }

  /**
   * Copy the current immutable object by replacing the {@link App#permissions() permissions} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the permissions map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableApp withPermissions(Map<String, ? extends String> entries) {
    if (this.permissions == entries) return this;
    Map<String, String> newValue = createUnmodifiableMap(true, false, entries);
    return new ImmutableApp(
        this.id,
        this.slug,
        this.name,
        this.description,
        this.externalUrl,
        this.htmlUrl,
        this.createdAt,
        this.updatedAt,
        newValue,
        this.events,
        this.installationsCount);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link App#events() events}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableApp withEvents(String... elements) {
    List<String> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableApp(
        this.id,
        this.slug,
        this.name,
        this.description,
        this.externalUrl,
        this.htmlUrl,
        this.createdAt,
        this.updatedAt,
        this.permissions,
        newValue,
        this.installationsCount);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link App#events() events}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of events elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableApp withEvents(Iterable<String> elements) {
    if (this.events == elements) return this;
    List<String> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableApp(
        this.id,
        this.slug,
        this.name,
        this.description,
        this.externalUrl,
        this.htmlUrl,
        this.createdAt,
        this.updatedAt,
        this.permissions,
        newValue,
        this.installationsCount);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link App#installationsCount() installationsCount} attribute.
   * @param value The value for installationsCount
   * @return A modified copy of {@code this} object
   */
  public final ImmutableApp withInstallationsCount(int value) {
    @Nullable Integer newValue = value;
    if (Objects.equals(this.installationsCount, newValue)) return this;
    return new ImmutableApp(
        this.id,
        this.slug,
        this.name,
        this.description,
        this.externalUrl,
        this.htmlUrl,
        this.createdAt,
        this.updatedAt,
        this.permissions,
        this.events,
        newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link App#installationsCount() installationsCount} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for installationsCount
   * @return A modified copy of {@code this} object
   */
  public final ImmutableApp withInstallationsCount(Optional<Integer> optional) {
    @Nullable Integer value = optional.orElse(null);
    if (Objects.equals(this.installationsCount, value)) return this;
    return new ImmutableApp(
        this.id,
        this.slug,
        this.name,
        this.description,
        this.externalUrl,
        this.htmlUrl,
        this.createdAt,
        this.updatedAt,
        this.permissions,
        this.events,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableApp} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableApp
        && equalTo((ImmutableApp) another);
  }

  private boolean equalTo(ImmutableApp another) {
    return id.equals(another.id)
        && Objects.equals(slug, another.slug)
        && name.equals(another.name)
        && description.equals(another.description)
        && externalUrl.equals(another.externalUrl)
        && htmlUrl.equals(another.htmlUrl)
        && createdAt.equals(another.createdAt)
        && updatedAt.equals(another.updatedAt)
        && permissions.equals(another.permissions)
        && events.equals(another.events)
        && Objects.equals(installationsCount, another.installationsCount);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code slug}, {@code name}, {@code description}, {@code externalUrl}, {@code htmlUrl}, {@code createdAt}, {@code updatedAt}, {@code permissions}, {@code events}, {@code installationsCount}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + Objects.hashCode(slug);
    h += (h << 5) + name.hashCode();
    h += (h << 5) + description.hashCode();
    h += (h << 5) + externalUrl.hashCode();
    h += (h << 5) + htmlUrl.hashCode();
    h += (h << 5) + createdAt.hashCode();
    h += (h << 5) + updatedAt.hashCode();
    h += (h << 5) + permissions.hashCode();
    h += (h << 5) + events.hashCode();
    h += (h << 5) + Objects.hashCode(installationsCount);
    return h;
  }

  /**
   * Prints the immutable value {@code App} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("App{");
    builder.append("id=").append(id);
    if (slug != null) {
      builder.append(", ");
      builder.append("slug=").append(slug);
    }
    builder.append(", ");
    builder.append("name=").append(name);
    builder.append(", ");
    builder.append("description=").append(description);
    builder.append(", ");
    builder.append("externalUrl=").append(externalUrl);
    builder.append(", ");
    builder.append("htmlUrl=").append(htmlUrl);
    builder.append(", ");
    builder.append("createdAt=").append(createdAt);
    builder.append(", ");
    builder.append("updatedAt=").append(updatedAt);
    builder.append(", ");
    builder.append("permissions=").append(permissions);
    builder.append(", ");
    builder.append("events=").append(events);
    if (installationsCount != null) {
      builder.append(", ");
      builder.append("installationsCount=").append(installationsCount);
    }
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "App", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements App {
    @Nullable Integer id;
    @Nullable Optional<String> slug = Optional.empty();
    @Nullable String name;
    @Nullable String description;
    @Nullable String externalUrl;
    @Nullable String htmlUrl;
    @Nullable ZonedDateTime createdAt;
    @Nullable ZonedDateTime updatedAt;
    @Nullable Map<String, String> permissions = Collections.emptyMap();
    @Nullable List<String> events = Collections.emptyList();
    @Nullable Optional<Integer> installationsCount = Optional.empty();
    @JsonProperty
    public void setId(Integer id) {
      this.id = id;
    }
    @JsonProperty
    public void setSlug(Optional<String> slug) {
      this.slug = slug;
    }
    @JsonProperty
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty
    public void setDescription(String description) {
      this.description = description;
    }
    @JsonProperty
    public void setExternalUrl(String externalUrl) {
      this.externalUrl = externalUrl;
    }
    @JsonProperty
    public void setHtmlUrl(String htmlUrl) {
      this.htmlUrl = htmlUrl;
    }
    @JsonProperty
    public void setCreatedAt(ZonedDateTime createdAt) {
      this.createdAt = createdAt;
    }
    @JsonProperty
    public void setUpdatedAt(ZonedDateTime updatedAt) {
      this.updatedAt = updatedAt;
    }
    @JsonProperty
    public void setPermissions(Map<String, String> permissions) {
      this.permissions = permissions;
    }
    @JsonProperty
    public void setEvents(List<String> events) {
      this.events = events;
    }
    @JsonProperty
    public void setInstallationsCount(Optional<Integer> installationsCount) {
      this.installationsCount = installationsCount;
    }
    @Override
    public Integer id() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> slug() { throw new UnsupportedOperationException(); }
    @Override
    public String name() { throw new UnsupportedOperationException(); }
    @Override
    public String description() { throw new UnsupportedOperationException(); }
    @Override
    public String externalUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String htmlUrl() { throw new UnsupportedOperationException(); }
    @Override
    public ZonedDateTime createdAt() { throw new UnsupportedOperationException(); }
    @Override
    public ZonedDateTime updatedAt() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, String> permissions() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> events() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Integer> installationsCount() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableApp fromJson(Json json) {
    ImmutableApp.Builder builder = ImmutableApp.builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.slug != null) {
      builder.slug(json.slug);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.description != null) {
      builder.description(json.description);
    }
    if (json.externalUrl != null) {
      builder.externalUrl(json.externalUrl);
    }
    if (json.htmlUrl != null) {
      builder.htmlUrl(json.htmlUrl);
    }
    if (json.createdAt != null) {
      builder.createdAt(json.createdAt);
    }
    if (json.updatedAt != null) {
      builder.updatedAt(json.updatedAt);
    }
    if (json.permissions != null) {
      builder.putAllPermissions(json.permissions);
    }
    if (json.events != null) {
      builder.addAllEvents(json.events);
    }
    if (json.installationsCount != null) {
      builder.installationsCount(json.installationsCount);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link App} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable App instance
   */
  public static ImmutableApp copyOf(App instance) {
    if (instance instanceof ImmutableApp) {
      return (ImmutableApp) instance;
    }
    return ImmutableApp.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableApp ImmutableApp}.
   * <pre>
   * ImmutableApp.builder()
   *    .id(Integer) // required {@link App#id() id}
   *    .slug(String) // optional {@link App#slug() slug}
   *    .name(String) // required {@link App#name() name}
   *    .description(String) // required {@link App#description() description}
   *    .externalUrl(String) // required {@link App#externalUrl() externalUrl}
   *    .htmlUrl(String) // required {@link App#htmlUrl() htmlUrl}
   *    .createdAt(java.time.ZonedDateTime) // required {@link App#createdAt() createdAt}
   *    .updatedAt(java.time.ZonedDateTime) // required {@link App#updatedAt() updatedAt}
   *    .putPermissions|putAllPermissions(String =&gt; String) // {@link App#permissions() permissions} mappings
   *    .addEvents|addAllEvents(String) // {@link App#events() events} elements
   *    .installationsCount(Integer) // optional {@link App#installationsCount() installationsCount}
   *    .build();
   * </pre>
   * @return A new ImmutableApp builder
   */
  public static ImmutableApp.Builder builder() {
    return new ImmutableApp.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableApp ImmutableApp}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "App", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_NAME = 0x2L;
    private static final long INIT_BIT_DESCRIPTION = 0x4L;
    private static final long INIT_BIT_EXTERNAL_URL = 0x8L;
    private static final long INIT_BIT_HTML_URL = 0x10L;
    private static final long INIT_BIT_CREATED_AT = 0x20L;
    private static final long INIT_BIT_UPDATED_AT = 0x40L;
    private long initBits = 0x7fL;

    private @Nullable Integer id;
    private @Nullable String slug;
    private @Nullable String name;
    private @Nullable String description;
    private @Nullable String externalUrl;
    private @Nullable String htmlUrl;
    private @Nullable ZonedDateTime createdAt;
    private @Nullable ZonedDateTime updatedAt;
    private Map<String, String> permissions = new LinkedHashMap<String, String>();
    private List<String> events = new ArrayList<String>();
    private @Nullable Integer installationsCount;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code App} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(App instance) {
      Objects.requireNonNull(instance, "instance");
      id(instance.id());
      Optional<String> slugOptional = instance.slug();
      if (slugOptional.isPresent()) {
        slug(slugOptional);
      }
      name(instance.name());
      description(instance.description());
      externalUrl(instance.externalUrl());
      htmlUrl(instance.htmlUrl());
      createdAt(instance.createdAt());
      updatedAt(instance.updatedAt());
      putAllPermissions(instance.permissions());
      addAllEvents(instance.events());
      Optional<Integer> installationsCountOptional = instance.installationsCount();
      if (installationsCountOptional.isPresent()) {
        installationsCount(installationsCountOptional);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link App#id() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder id(Integer id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the optional value {@link App#slug() slug} to slug.
     * @param slug The value for slug
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder slug(String slug) {
      this.slug = Objects.requireNonNull(slug, "slug");
      return this;
    }

    /**
     * Initializes the optional value {@link App#slug() slug} to slug.
     * @param slug The value for slug
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder slug(Optional<String> slug) {
      this.slug = slug.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link App#name() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link App#description() description} attribute.
     * @param description The value for description 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder description(String description) {
      this.description = Objects.requireNonNull(description, "description");
      initBits &= ~INIT_BIT_DESCRIPTION;
      return this;
    }

    /**
     * Initializes the value for the {@link App#externalUrl() externalUrl} attribute.
     * @param externalUrl The value for externalUrl 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder externalUrl(String externalUrl) {
      this.externalUrl = Objects.requireNonNull(externalUrl, "externalUrl");
      initBits &= ~INIT_BIT_EXTERNAL_URL;
      return this;
    }

    /**
     * Initializes the value for the {@link App#htmlUrl() htmlUrl} attribute.
     * @param htmlUrl The value for htmlUrl 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder htmlUrl(String htmlUrl) {
      this.htmlUrl = Objects.requireNonNull(htmlUrl, "htmlUrl");
      initBits &= ~INIT_BIT_HTML_URL;
      return this;
    }

    /**
     * Initializes the value for the {@link App#createdAt() createdAt} attribute.
     * @param createdAt The value for createdAt 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder createdAt(ZonedDateTime createdAt) {
      this.createdAt = Objects.requireNonNull(createdAt, "createdAt");
      initBits &= ~INIT_BIT_CREATED_AT;
      return this;
    }

    /**
     * Initializes the value for the {@link App#updatedAt() updatedAt} attribute.
     * @param updatedAt The value for updatedAt 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder updatedAt(ZonedDateTime updatedAt) {
      this.updatedAt = Objects.requireNonNull(updatedAt, "updatedAt");
      initBits &= ~INIT_BIT_UPDATED_AT;
      return this;
    }

    /**
     * Put one entry to the {@link App#permissions() permissions} map.
     * @param key The key in the permissions map
     * @param value The associated value in the permissions map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putPermissions(String key, String value) {
      this.permissions.put(
          Objects.requireNonNull(key, "permissions key"),
          Objects.requireNonNull(value, "permissions value"));
      return this;
    }

    /**
     * Put one entry to the {@link App#permissions() permissions} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putPermissions(Map.Entry<String, ? extends String> entry) {
      String k = entry.getKey();
      String v = entry.getValue();
      this.permissions.put(
          Objects.requireNonNull(k, "permissions key"),
          Objects.requireNonNull(v, "permissions value"));
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link App#permissions() permissions} map. Nulls are not permitted
     * @param entries The entries that will be added to the permissions map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder permissions(Map<String, ? extends String> entries) {
      this.permissions.clear();
      return putAllPermissions(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link App#permissions() permissions} map. Nulls are not permitted
     * @param entries The entries that will be added to the permissions map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllPermissions(Map<String, ? extends String> entries) {
      for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
        String k = e.getKey();
        String v = e.getValue();
        this.permissions.put(
            Objects.requireNonNull(k, "permissions key"),
            Objects.requireNonNull(v, "permissions value"));
      }
      return this;
    }

    /**
     * Adds one element to {@link App#events() events} list.
     * @param element A events element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addEvents(String element) {
      this.events.add(Objects.requireNonNull(element, "events element"));
      return this;
    }

    /**
     * Adds elements to {@link App#events() events} list.
     * @param elements An array of events elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addEvents(String... elements) {
      for (String element : elements) {
        this.events.add(Objects.requireNonNull(element, "events element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link App#events() events} list.
     * @param elements An iterable of events elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder events(Iterable<String> elements) {
      this.events.clear();
      return addAllEvents(elements);
    }

    /**
     * Adds elements to {@link App#events() events} list.
     * @param elements An iterable of events elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllEvents(Iterable<String> elements) {
      for (String element : elements) {
        this.events.add(Objects.requireNonNull(element, "events element"));
      }
      return this;
    }

    /**
     * Initializes the optional value {@link App#installationsCount() installationsCount} to installationsCount.
     * @param installationsCount The value for installationsCount
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder installationsCount(int installationsCount) {
      this.installationsCount = installationsCount;
      return this;
    }

    /**
     * Initializes the optional value {@link App#installationsCount() installationsCount} to installationsCount.
     * @param installationsCount The value for installationsCount
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder installationsCount(Optional<Integer> installationsCount) {
      this.installationsCount = installationsCount.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ImmutableApp ImmutableApp}.
     * @return An immutable instance of App
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableApp build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableApp(
          id,
          slug,
          name,
          description,
          externalUrl,
          htmlUrl,
          createdAt,
          updatedAt,
          createUnmodifiableMap(false, false, permissions),
          createUnmodifiableList(true, events),
          installationsCount);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_DESCRIPTION) != 0) attributes.add("description");
      if ((initBits & INIT_BIT_EXTERNAL_URL) != 0) attributes.add("externalUrl");
      if ((initBits & INIT_BIT_HTML_URL) != 0) attributes.add("htmlUrl");
      if ((initBits & INIT_BIT_CREATED_AT) != 0) attributes.add("createdAt");
      if ((initBits & INIT_BIT_UPDATED_AT) != 0) attributes.add("updatedAt");
      return "Cannot build App, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
