package com.spotify.github.v3.checks;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link CheckRunRequest}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableCheckRunRequest.builder()}.
 */
@Generated(from = "CheckRunRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableCheckRunRequest implements CheckRunRequest {
  private final String headSha;
  private final String name;
  private final CheckRunStatus status;
  private final @Nullable CheckRunConclusion conclusion;
  private final @Nullable ZonedDateTime startedAt;
  private final @Nullable ZonedDateTime completedAt;
  private final @Nullable String externalId;
  private final @Nullable String detailsUrl;
  private final @Nullable CheckRunOutput output;
  private final List<CheckRunAction> actions;

  private ImmutableCheckRunRequest(
      String headSha,
      String name,
      CheckRunStatus status,
      @Nullable CheckRunConclusion conclusion,
      @Nullable ZonedDateTime startedAt,
      @Nullable ZonedDateTime completedAt,
      @Nullable String externalId,
      @Nullable String detailsUrl,
      @Nullable CheckRunOutput output,
      List<CheckRunAction> actions) {
    this.headSha = headSha;
    this.name = name;
    this.status = status;
    this.conclusion = conclusion;
    this.startedAt = startedAt;
    this.completedAt = completedAt;
    this.externalId = externalId;
    this.detailsUrl = detailsUrl;
    this.output = output;
    this.actions = actions;
  }

  /**
   * The SHA of the commit.
   * @return the string
   */
  @JsonProperty
  @Override
  public String headSha() {
    return headSha;
  }

  /**
   * The name of the check. For example, "code-coverage".
   * @return the string
   */
  @JsonProperty
  @Override
  public String name() {
    return name;
  }

  /**
   * The current status. Can be one of queued, in_progress, or completed.
   * @return the check run status enum
   */
  @JsonProperty
  @Override
  public CheckRunStatus status() {
    return status;
  }

  /**
   * The final conclusion of the check. Can be one of success, failure, neutral, cancelled,
   * timed_out, or action_required. When the conclusion is action_required, additional details
   * should be provided on the site specified by details_url. Required if you provide completedAt or
   * a status of completed.
   * @return the conclusion
   */
  @JsonProperty
  @Override
  public Optional<CheckRunConclusion> conclusion() {
    return Optional.ofNullable(conclusion);
  }

  /**
   * The time that the check run began.
   * @return the zoned date time
   */
  @JsonProperty
  @Override
  public Optional<ZonedDateTime> startedAt() {
    return Optional.ofNullable(startedAt);
  }

  /**
   * The time that the check completed.
   * @return the zoned date time
   */
  @JsonProperty
  @Override
  public Optional<ZonedDateTime> completedAt() {
    return Optional.ofNullable(completedAt);
  }

  /**
   * A reference for the run on the integrator's system.
   * @return the optional string
   */
  @JsonProperty
  @Override
  public Optional<String> externalId() {
    return Optional.ofNullable(externalId);
  }

  /**
   * The URL of the integrator's site that has the full details of the check. If the integrator does
   * not provide this, then the homepage of the GitHub app is used.
   * @return the optional
   */
  @JsonProperty
  @Override
  public Optional<String> detailsUrl() {
    return Optional.ofNullable(detailsUrl);
  }

  /**
   * The check run output.
   * @see com.spotify.github.v3.checks.CheckRunOutput
   * @return the check run output
   */
  @JsonProperty
  @Override
  public Optional<CheckRunOutput> output() {
    return Optional.ofNullable(output);
  }

  /**
   * The actions list.
   * @see com.spotify.github.v3.checks.CheckRunAction
   * @return the actions list
   */
  @JsonProperty
  @Override
  public List<CheckRunAction> actions() {
    return actions;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CheckRunRequest#headSha() headSha} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for headSha
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCheckRunRequest withHeadSha(String value) {
    String newValue = Objects.requireNonNull(value, "headSha");
    if (this.headSha.equals(newValue)) return this;
    return new ImmutableCheckRunRequest(
        newValue,
        this.name,
        this.status,
        this.conclusion,
        this.startedAt,
        this.completedAt,
        this.externalId,
        this.detailsUrl,
        this.output,
        this.actions);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CheckRunRequest#name() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCheckRunRequest withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableCheckRunRequest(
        this.headSha,
        newValue,
        this.status,
        this.conclusion,
        this.startedAt,
        this.completedAt,
        this.externalId,
        this.detailsUrl,
        this.output,
        this.actions);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CheckRunRequest#status() status} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for status
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCheckRunRequest withStatus(CheckRunStatus value) {
    if (this.status == value) return this;
    CheckRunStatus newValue = Objects.requireNonNull(value, "status");
    if (this.status.equals(newValue)) return this;
    return new ImmutableCheckRunRequest(
        this.headSha,
        this.name,
        newValue,
        this.conclusion,
        this.startedAt,
        this.completedAt,
        this.externalId,
        this.detailsUrl,
        this.output,
        this.actions);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link CheckRunRequest#conclusion() conclusion} attribute.
   * @param value The value for conclusion
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCheckRunRequest withConclusion(CheckRunConclusion value) {
    @Nullable CheckRunConclusion newValue = Objects.requireNonNull(value, "conclusion");
    if (this.conclusion == newValue) return this;
    return new ImmutableCheckRunRequest(
        this.headSha,
        this.name,
        this.status,
        newValue,
        this.startedAt,
        this.completedAt,
        this.externalId,
        this.detailsUrl,
        this.output,
        this.actions);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link CheckRunRequest#conclusion() conclusion} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for conclusion
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableCheckRunRequest withConclusion(Optional<? extends CheckRunConclusion> optional) {
    @Nullable CheckRunConclusion value = optional.orElse(null);
    if (Objects.equals(this.conclusion, value)) return this;
    return new ImmutableCheckRunRequest(
        this.headSha,
        this.name,
        this.status,
        value,
        this.startedAt,
        this.completedAt,
        this.externalId,
        this.detailsUrl,
        this.output,
        this.actions);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link CheckRunRequest#startedAt() startedAt} attribute.
   * @param value The value for startedAt
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCheckRunRequest withStartedAt(ZonedDateTime value) {
    @Nullable ZonedDateTime newValue = Objects.requireNonNull(value, "startedAt");
    if (this.startedAt == newValue) return this;
    return new ImmutableCheckRunRequest(
        this.headSha,
        this.name,
        this.status,
        this.conclusion,
        newValue,
        this.completedAt,
        this.externalId,
        this.detailsUrl,
        this.output,
        this.actions);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link CheckRunRequest#startedAt() startedAt} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for startedAt
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableCheckRunRequest withStartedAt(Optional<? extends ZonedDateTime> optional) {
    @Nullable ZonedDateTime value = optional.orElse(null);
    if (this.startedAt == value) return this;
    return new ImmutableCheckRunRequest(
        this.headSha,
        this.name,
        this.status,
        this.conclusion,
        value,
        this.completedAt,
        this.externalId,
        this.detailsUrl,
        this.output,
        this.actions);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link CheckRunRequest#completedAt() completedAt} attribute.
   * @param value The value for completedAt
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCheckRunRequest withCompletedAt(ZonedDateTime value) {
    @Nullable ZonedDateTime newValue = Objects.requireNonNull(value, "completedAt");
    if (this.completedAt == newValue) return this;
    return new ImmutableCheckRunRequest(
        this.headSha,
        this.name,
        this.status,
        this.conclusion,
        this.startedAt,
        newValue,
        this.externalId,
        this.detailsUrl,
        this.output,
        this.actions);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link CheckRunRequest#completedAt() completedAt} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for completedAt
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableCheckRunRequest withCompletedAt(Optional<? extends ZonedDateTime> optional) {
    @Nullable ZonedDateTime value = optional.orElse(null);
    if (this.completedAt == value) return this;
    return new ImmutableCheckRunRequest(
        this.headSha,
        this.name,
        this.status,
        this.conclusion,
        this.startedAt,
        value,
        this.externalId,
        this.detailsUrl,
        this.output,
        this.actions);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link CheckRunRequest#externalId() externalId} attribute.
   * @param value The value for externalId
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCheckRunRequest withExternalId(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "externalId");
    if (Objects.equals(this.externalId, newValue)) return this;
    return new ImmutableCheckRunRequest(
        this.headSha,
        this.name,
        this.status,
        this.conclusion,
        this.startedAt,
        this.completedAt,
        newValue,
        this.detailsUrl,
        this.output,
        this.actions);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link CheckRunRequest#externalId() externalId} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for externalId
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCheckRunRequest withExternalId(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.externalId, value)) return this;
    return new ImmutableCheckRunRequest(
        this.headSha,
        this.name,
        this.status,
        this.conclusion,
        this.startedAt,
        this.completedAt,
        value,
        this.detailsUrl,
        this.output,
        this.actions);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link CheckRunRequest#detailsUrl() detailsUrl} attribute.
   * @param value The value for detailsUrl
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCheckRunRequest withDetailsUrl(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "detailsUrl");
    if (Objects.equals(this.detailsUrl, newValue)) return this;
    return new ImmutableCheckRunRequest(
        this.headSha,
        this.name,
        this.status,
        this.conclusion,
        this.startedAt,
        this.completedAt,
        this.externalId,
        newValue,
        this.output,
        this.actions);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link CheckRunRequest#detailsUrl() detailsUrl} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for detailsUrl
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCheckRunRequest withDetailsUrl(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.detailsUrl, value)) return this;
    return new ImmutableCheckRunRequest(
        this.headSha,
        this.name,
        this.status,
        this.conclusion,
        this.startedAt,
        this.completedAt,
        this.externalId,
        value,
        this.output,
        this.actions);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link CheckRunRequest#output() output} attribute.
   * @param value The value for output
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCheckRunRequest withOutput(CheckRunOutput value) {
    @Nullable CheckRunOutput newValue = Objects.requireNonNull(value, "output");
    if (this.output == newValue) return this;
    return new ImmutableCheckRunRequest(
        this.headSha,
        this.name,
        this.status,
        this.conclusion,
        this.startedAt,
        this.completedAt,
        this.externalId,
        this.detailsUrl,
        newValue,
        this.actions);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link CheckRunRequest#output() output} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for output
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableCheckRunRequest withOutput(Optional<? extends CheckRunOutput> optional) {
    @Nullable CheckRunOutput value = optional.orElse(null);
    if (this.output == value) return this;
    return new ImmutableCheckRunRequest(
        this.headSha,
        this.name,
        this.status,
        this.conclusion,
        this.startedAt,
        this.completedAt,
        this.externalId,
        this.detailsUrl,
        value,
        this.actions);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link CheckRunRequest#actions() actions}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCheckRunRequest withActions(CheckRunAction... elements) {
    List<CheckRunAction> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableCheckRunRequest(
        this.headSha,
        this.name,
        this.status,
        this.conclusion,
        this.startedAt,
        this.completedAt,
        this.externalId,
        this.detailsUrl,
        this.output,
        newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link CheckRunRequest#actions() actions}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of actions elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCheckRunRequest withActions(Iterable<? extends CheckRunAction> elements) {
    if (this.actions == elements) return this;
    List<CheckRunAction> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableCheckRunRequest(
        this.headSha,
        this.name,
        this.status,
        this.conclusion,
        this.startedAt,
        this.completedAt,
        this.externalId,
        this.detailsUrl,
        this.output,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableCheckRunRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableCheckRunRequest
        && equalTo((ImmutableCheckRunRequest) another);
  }

  private boolean equalTo(ImmutableCheckRunRequest another) {
    return headSha.equals(another.headSha)
        && name.equals(another.name)
        && status.equals(another.status)
        && Objects.equals(conclusion, another.conclusion)
        && Objects.equals(startedAt, another.startedAt)
        && Objects.equals(completedAt, another.completedAt)
        && Objects.equals(externalId, another.externalId)
        && Objects.equals(detailsUrl, another.detailsUrl)
        && Objects.equals(output, another.output)
        && actions.equals(another.actions);
  }

  /**
   * Computes a hash code from attributes: {@code headSha}, {@code name}, {@code status}, {@code conclusion}, {@code startedAt}, {@code completedAt}, {@code externalId}, {@code detailsUrl}, {@code output}, {@code actions}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + headSha.hashCode();
    h += (h << 5) + name.hashCode();
    h += (h << 5) + status.hashCode();
    h += (h << 5) + Objects.hashCode(conclusion);
    h += (h << 5) + Objects.hashCode(startedAt);
    h += (h << 5) + Objects.hashCode(completedAt);
    h += (h << 5) + Objects.hashCode(externalId);
    h += (h << 5) + Objects.hashCode(detailsUrl);
    h += (h << 5) + Objects.hashCode(output);
    h += (h << 5) + actions.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code CheckRunRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("CheckRunRequest{");
    builder.append("headSha=").append(headSha);
    builder.append(", ");
    builder.append("name=").append(name);
    builder.append(", ");
    builder.append("status=").append(status);
    if (conclusion != null) {
      builder.append(", ");
      builder.append("conclusion=").append(conclusion);
    }
    if (startedAt != null) {
      builder.append(", ");
      builder.append("startedAt=").append(startedAt);
    }
    if (completedAt != null) {
      builder.append(", ");
      builder.append("completedAt=").append(completedAt);
    }
    if (externalId != null) {
      builder.append(", ");
      builder.append("externalId=").append(externalId);
    }
    if (detailsUrl != null) {
      builder.append(", ");
      builder.append("detailsUrl=").append(detailsUrl);
    }
    if (output != null) {
      builder.append(", ");
      builder.append("output=").append(output);
    }
    builder.append(", ");
    builder.append("actions=").append(actions);
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "CheckRunRequest", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements CheckRunRequest {
    @Nullable String headSha;
    @Nullable String name;
    @Nullable CheckRunStatus status;
    @Nullable Optional<CheckRunConclusion> conclusion = Optional.empty();
    @Nullable Optional<ZonedDateTime> startedAt = Optional.empty();
    @Nullable Optional<ZonedDateTime> completedAt = Optional.empty();
    @Nullable Optional<String> externalId = Optional.empty();
    @Nullable Optional<String> detailsUrl = Optional.empty();
    @Nullable Optional<CheckRunOutput> output = Optional.empty();
    @Nullable List<CheckRunAction> actions = Collections.emptyList();
    @JsonProperty
    public void setHeadSha(String headSha) {
      this.headSha = headSha;
    }
    @JsonProperty
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty
    public void setStatus(CheckRunStatus status) {
      this.status = status;
    }
    @JsonProperty
    public void setConclusion(Optional<CheckRunConclusion> conclusion) {
      this.conclusion = conclusion;
    }
    @JsonProperty
    public void setStartedAt(Optional<ZonedDateTime> startedAt) {
      this.startedAt = startedAt;
    }
    @JsonProperty
    public void setCompletedAt(Optional<ZonedDateTime> completedAt) {
      this.completedAt = completedAt;
    }
    @JsonProperty
    public void setExternalId(Optional<String> externalId) {
      this.externalId = externalId;
    }
    @JsonProperty
    public void setDetailsUrl(Optional<String> detailsUrl) {
      this.detailsUrl = detailsUrl;
    }
    @JsonProperty
    public void setOutput(Optional<CheckRunOutput> output) {
      this.output = output;
    }
    @JsonProperty
    public void setActions(List<CheckRunAction> actions) {
      this.actions = actions;
    }
    @Override
    public String headSha() { throw new UnsupportedOperationException(); }
    @Override
    public String name() { throw new UnsupportedOperationException(); }
    @Override
    public CheckRunStatus status() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<CheckRunConclusion> conclusion() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<ZonedDateTime> startedAt() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<ZonedDateTime> completedAt() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> externalId() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> detailsUrl() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<CheckRunOutput> output() { throw new UnsupportedOperationException(); }
    @Override
    public List<CheckRunAction> actions() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableCheckRunRequest fromJson(Json json) {
    ImmutableCheckRunRequest.Builder builder = ImmutableCheckRunRequest.builder();
    if (json.headSha != null) {
      builder.headSha(json.headSha);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.status != null) {
      builder.status(json.status);
    }
    if (json.conclusion != null) {
      builder.conclusion(json.conclusion);
    }
    if (json.startedAt != null) {
      builder.startedAt(json.startedAt);
    }
    if (json.completedAt != null) {
      builder.completedAt(json.completedAt);
    }
    if (json.externalId != null) {
      builder.externalId(json.externalId);
    }
    if (json.detailsUrl != null) {
      builder.detailsUrl(json.detailsUrl);
    }
    if (json.output != null) {
      builder.output(json.output);
    }
    if (json.actions != null) {
      builder.addAllActions(json.actions);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link CheckRunRequest} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable CheckRunRequest instance
   */
  public static ImmutableCheckRunRequest copyOf(CheckRunRequest instance) {
    if (instance instanceof ImmutableCheckRunRequest) {
      return (ImmutableCheckRunRequest) instance;
    }
    return ImmutableCheckRunRequest.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableCheckRunRequest ImmutableCheckRunRequest}.
   * <pre>
   * ImmutableCheckRunRequest.builder()
   *    .headSha(String) // required {@link CheckRunRequest#headSha() headSha}
   *    .name(String) // required {@link CheckRunRequest#name() name}
   *    .status(com.spotify.github.v3.checks.CheckRunStatus) // required {@link CheckRunRequest#status() status}
   *    .conclusion(com.spotify.github.v3.checks.CheckRunConclusion) // optional {@link CheckRunRequest#conclusion() conclusion}
   *    .startedAt(java.time.ZonedDateTime) // optional {@link CheckRunRequest#startedAt() startedAt}
   *    .completedAt(java.time.ZonedDateTime) // optional {@link CheckRunRequest#completedAt() completedAt}
   *    .externalId(String) // optional {@link CheckRunRequest#externalId() externalId}
   *    .detailsUrl(String) // optional {@link CheckRunRequest#detailsUrl() detailsUrl}
   *    .output(com.spotify.github.v3.checks.CheckRunOutput) // optional {@link CheckRunRequest#output() output}
   *    .addActions|addAllActions(com.spotify.github.v3.checks.CheckRunAction) // {@link CheckRunRequest#actions() actions} elements
   *    .build();
   * </pre>
   * @return A new ImmutableCheckRunRequest builder
   */
  public static ImmutableCheckRunRequest.Builder builder() {
    return new ImmutableCheckRunRequest.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableCheckRunRequest ImmutableCheckRunRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "CheckRunRequest", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_HEAD_SHA = 0x1L;
    private static final long INIT_BIT_NAME = 0x2L;
    private static final long INIT_BIT_STATUS = 0x4L;
    private long initBits = 0x7L;

    private @Nullable String headSha;
    private @Nullable String name;
    private @Nullable CheckRunStatus status;
    private @Nullable CheckRunConclusion conclusion;
    private @Nullable ZonedDateTime startedAt;
    private @Nullable ZonedDateTime completedAt;
    private @Nullable String externalId;
    private @Nullable String detailsUrl;
    private @Nullable CheckRunOutput output;
    private List<CheckRunAction> actions = new ArrayList<CheckRunAction>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.spotify.github.v3.checks.CheckRunRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(CheckRunRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.spotify.github.v3.checks.CheckRunBase} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(CheckRunBase instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof CheckRunRequest) {
        CheckRunRequest instance = (CheckRunRequest) object;
        Optional<CheckRunOutput> outputOptional = instance.output();
        if (outputOptional.isPresent()) {
          output(outputOptional);
        }
        addAllActions(instance.actions());
      }
      if (object instanceof CheckRunBase) {
        CheckRunBase instance = (CheckRunBase) object;
        Optional<CheckRunConclusion> conclusionOptional = instance.conclusion();
        if (conclusionOptional.isPresent()) {
          conclusion(conclusionOptional);
        }
        Optional<ZonedDateTime> completedAtOptional = instance.completedAt();
        if (completedAtOptional.isPresent()) {
          completedAt(completedAtOptional);
        }
        Optional<String> detailsUrlOptional = instance.detailsUrl();
        if (detailsUrlOptional.isPresent()) {
          detailsUrl(detailsUrlOptional);
        }
        name(instance.name());
        Optional<ZonedDateTime> startedAtOptional = instance.startedAt();
        if (startedAtOptional.isPresent()) {
          startedAt(startedAtOptional);
        }
        Optional<String> externalIdOptional = instance.externalId();
        if (externalIdOptional.isPresent()) {
          externalId(externalIdOptional);
        }
        headSha(instance.headSha());
        status(instance.status());
      }
    }

    /**
     * Initializes the value for the {@link CheckRunRequest#headSha() headSha} attribute.
     * @param headSha The value for headSha 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder headSha(String headSha) {
      this.headSha = Objects.requireNonNull(headSha, "headSha");
      initBits &= ~INIT_BIT_HEAD_SHA;
      return this;
    }

    /**
     * Initializes the value for the {@link CheckRunRequest#name() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link CheckRunRequest#status() status} attribute.
     * @param status The value for status 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder status(CheckRunStatus status) {
      this.status = Objects.requireNonNull(status, "status");
      initBits &= ~INIT_BIT_STATUS;
      return this;
    }

    /**
     * Initializes the optional value {@link CheckRunRequest#conclusion() conclusion} to conclusion.
     * @param conclusion The value for conclusion
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder conclusion(CheckRunConclusion conclusion) {
      this.conclusion = Objects.requireNonNull(conclusion, "conclusion");
      return this;
    }

    /**
     * Initializes the optional value {@link CheckRunRequest#conclusion() conclusion} to conclusion.
     * @param conclusion The value for conclusion
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder conclusion(Optional<? extends CheckRunConclusion> conclusion) {
      this.conclusion = conclusion.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link CheckRunRequest#startedAt() startedAt} to startedAt.
     * @param startedAt The value for startedAt
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder startedAt(ZonedDateTime startedAt) {
      this.startedAt = Objects.requireNonNull(startedAt, "startedAt");
      return this;
    }

    /**
     * Initializes the optional value {@link CheckRunRequest#startedAt() startedAt} to startedAt.
     * @param startedAt The value for startedAt
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder startedAt(Optional<? extends ZonedDateTime> startedAt) {
      this.startedAt = startedAt.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link CheckRunRequest#completedAt() completedAt} to completedAt.
     * @param completedAt The value for completedAt
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder completedAt(ZonedDateTime completedAt) {
      this.completedAt = Objects.requireNonNull(completedAt, "completedAt");
      return this;
    }

    /**
     * Initializes the optional value {@link CheckRunRequest#completedAt() completedAt} to completedAt.
     * @param completedAt The value for completedAt
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder completedAt(Optional<? extends ZonedDateTime> completedAt) {
      this.completedAt = completedAt.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link CheckRunRequest#externalId() externalId} to externalId.
     * @param externalId The value for externalId
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder externalId(String externalId) {
      this.externalId = Objects.requireNonNull(externalId, "externalId");
      return this;
    }

    /**
     * Initializes the optional value {@link CheckRunRequest#externalId() externalId} to externalId.
     * @param externalId The value for externalId
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder externalId(Optional<String> externalId) {
      this.externalId = externalId.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link CheckRunRequest#detailsUrl() detailsUrl} to detailsUrl.
     * @param detailsUrl The value for detailsUrl
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder detailsUrl(String detailsUrl) {
      this.detailsUrl = Objects.requireNonNull(detailsUrl, "detailsUrl");
      return this;
    }

    /**
     * Initializes the optional value {@link CheckRunRequest#detailsUrl() detailsUrl} to detailsUrl.
     * @param detailsUrl The value for detailsUrl
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder detailsUrl(Optional<String> detailsUrl) {
      this.detailsUrl = detailsUrl.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link CheckRunRequest#output() output} to output.
     * @param output The value for output
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder output(CheckRunOutput output) {
      this.output = Objects.requireNonNull(output, "output");
      return this;
    }

    /**
     * Initializes the optional value {@link CheckRunRequest#output() output} to output.
     * @param output The value for output
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder output(Optional<? extends CheckRunOutput> output) {
      this.output = output.orElse(null);
      return this;
    }

    /**
     * Adds one element to {@link CheckRunRequest#actions() actions} list.
     * @param element A actions element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addActions(CheckRunAction element) {
      this.actions.add(Objects.requireNonNull(element, "actions element"));
      return this;
    }

    /**
     * Adds elements to {@link CheckRunRequest#actions() actions} list.
     * @param elements An array of actions elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addActions(CheckRunAction... elements) {
      for (CheckRunAction element : elements) {
        this.actions.add(Objects.requireNonNull(element, "actions element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link CheckRunRequest#actions() actions} list.
     * @param elements An iterable of actions elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder actions(Iterable<? extends CheckRunAction> elements) {
      this.actions.clear();
      return addAllActions(elements);
    }

    /**
     * Adds elements to {@link CheckRunRequest#actions() actions} list.
     * @param elements An iterable of actions elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllActions(Iterable<? extends CheckRunAction> elements) {
      for (CheckRunAction element : elements) {
        this.actions.add(Objects.requireNonNull(element, "actions element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableCheckRunRequest ImmutableCheckRunRequest}.
     * @return An immutable instance of CheckRunRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableCheckRunRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableCheckRunRequest(
          headSha,
          name,
          status,
          conclusion,
          startedAt,
          completedAt,
          externalId,
          detailsUrl,
          output,
          createUnmodifiableList(true, actions));
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_HEAD_SHA) != 0) attributes.add("headSha");
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_STATUS) != 0) attributes.add("status");
      return "Cannot build CheckRunRequest, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
