package com.spotify.github.v3.git;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.net.URI;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ReferenceObject}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableReferenceObject.builder()}.
 */
@Generated(from = "ReferenceObject", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableReferenceObject implements ReferenceObject {
  private final @Nullable String sha;
  private final @Nullable URI url;
  private final @Nullable String type;

  private ImmutableReferenceObject(
      @Nullable String sha,
      @Nullable URI url,
      @Nullable String type) {
    this.sha = sha;
    this.url = url;
    this.type = type;
  }

  /**
   *SHA. 
   */
  @JsonProperty
  @Override
  public @Nullable String sha() {
    return sha;
  }

  /**
   *URL. 
   */
  @JsonProperty
  @Override
  public @Nullable URI url() {
    return url;
  }

  /**
   *The type of the reference object. 
   */
  @JsonProperty
  @Override
  public @Nullable String type() {
    return type;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ReferenceObject#sha() sha} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for sha (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableReferenceObject withSha(@Nullable String value) {
    if (Objects.equals(this.sha, value)) return this;
    return new ImmutableReferenceObject(value, this.url, this.type);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ReferenceObject#url() url} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for url (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableReferenceObject withUrl(@Nullable URI value) {
    if (this.url == value) return this;
    return new ImmutableReferenceObject(this.sha, value, this.type);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ReferenceObject#type() type} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableReferenceObject withType(@Nullable String value) {
    if (Objects.equals(this.type, value)) return this;
    return new ImmutableReferenceObject(this.sha, this.url, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableReferenceObject} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableReferenceObject
        && equalTo((ImmutableReferenceObject) another);
  }

  private boolean equalTo(ImmutableReferenceObject another) {
    return Objects.equals(sha, another.sha)
        && Objects.equals(url, another.url)
        && Objects.equals(type, another.type);
  }

  /**
   * Computes a hash code from attributes: {@code sha}, {@code url}, {@code type}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(sha);
    h += (h << 5) + Objects.hashCode(url);
    h += (h << 5) + Objects.hashCode(type);
    return h;
  }

  /**
   * Prints the immutable value {@code ReferenceObject} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ReferenceObject{"
        + "sha=" + sha
        + ", url=" + url
        + ", type=" + type
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "ReferenceObject", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements ReferenceObject {
    @Nullable String sha;
    @Nullable URI url;
    @Nullable String type;
    @JsonProperty
    public void setSha(@Nullable String sha) {
      this.sha = sha;
    }
    @JsonProperty
    public void setUrl(@Nullable URI url) {
      this.url = url;
    }
    @JsonProperty
    public void setType(@Nullable String type) {
      this.type = type;
    }
    @Override
    public String sha() { throw new UnsupportedOperationException(); }
    @Override
    public URI url() { throw new UnsupportedOperationException(); }
    @Override
    public String type() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableReferenceObject fromJson(Json json) {
    ImmutableReferenceObject.Builder builder = ImmutableReferenceObject.builder();
    if (json.sha != null) {
      builder.sha(json.sha);
    }
    if (json.url != null) {
      builder.url(json.url);
    }
    if (json.type != null) {
      builder.type(json.type);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link ReferenceObject} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ReferenceObject instance
   */
  public static ImmutableReferenceObject copyOf(ReferenceObject instance) {
    if (instance instanceof ImmutableReferenceObject) {
      return (ImmutableReferenceObject) instance;
    }
    return ImmutableReferenceObject.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableReferenceObject ImmutableReferenceObject}.
   * <pre>
   * ImmutableReferenceObject.builder()
   *    .sha(String | null) // nullable {@link ReferenceObject#sha() sha}
   *    .url(java.net.URI | null) // nullable {@link ReferenceObject#url() url}
   *    .type(String | null) // nullable {@link ReferenceObject#type() type}
   *    .build();
   * </pre>
   * @return A new ImmutableReferenceObject builder
   */
  public static ImmutableReferenceObject.Builder builder() {
    return new ImmutableReferenceObject.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableReferenceObject ImmutableReferenceObject}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ReferenceObject", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable String sha;
    private @Nullable URI url;
    private @Nullable String type;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.spotify.github.v3.git.ReferenceObject} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ReferenceObject instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.spotify.github.v3.git.ShaLink} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ShaLink instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof ReferenceObject) {
        ReferenceObject instance = (ReferenceObject) object;
        @Nullable String typeValue = instance.type();
        if (typeValue != null) {
          type(typeValue);
        }
      }
      if (object instanceof ShaLink) {
        ShaLink instance = (ShaLink) object;
        @Nullable String shaValue = instance.sha();
        if (shaValue != null) {
          sha(shaValue);
        }
        @Nullable URI urlValue = instance.url();
        if (urlValue != null) {
          url(urlValue);
        }
      }
    }

    /**
     * Initializes the value for the {@link ReferenceObject#sha() sha} attribute.
     * @param sha The value for sha (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder sha(@Nullable String sha) {
      this.sha = sha;
      return this;
    }

    /**
     * Initializes the value for the {@link ReferenceObject#url() url} attribute.
     * @param url The value for url (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder url(@Nullable URI url) {
      this.url = url;
      return this;
    }

    /**
     * Initializes the value for the {@link ReferenceObject#type() type} attribute.
     * @param type The value for type (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder type(@Nullable String type) {
      this.type = type;
      return this;
    }

    /**
     * Builds a new {@link ImmutableReferenceObject ImmutableReferenceObject}.
     * @return An immutable instance of ReferenceObject
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableReferenceObject build() {
      return new ImmutableReferenceObject(sha, url, type);
    }
  }
}
