package com.spotify.github.v3.hooks;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import com.spotify.github.GitHubInstant;
import com.spotify.github.UpdateTracking;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Webhook}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableWebhook.builder()}.
 */
@Generated(from = "Webhook", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableWebhook implements Webhook {
  private final @Nullable GitHubInstant createdAt;
  private final @Nullable GitHubInstant updatedAt;
  private final @Nullable Integer id;
  private final @Nullable URI url;
  private final @Nullable URI testUrl;
  private final @Nullable URI pingUrl;
  private final @Nullable String name;
  private final @Nullable List<String> events;
  private final @Nullable Boolean active;
  private final @Nullable WebhookConfig config;

  private ImmutableWebhook(
      @Nullable GitHubInstant createdAt,
      @Nullable GitHubInstant updatedAt,
      @Nullable Integer id,
      @Nullable URI url,
      @Nullable URI testUrl,
      @Nullable URI pingUrl,
      @Nullable String name,
      @Nullable List<String> events,
      @Nullable Boolean active,
      @Nullable WebhookConfig config) {
    this.createdAt = createdAt;
    this.updatedAt = updatedAt;
    this.id = id;
    this.url = url;
    this.testUrl = testUrl;
    this.pingUrl = pingUrl;
    this.name = name;
    this.events = events;
    this.active = active;
    this.config = config;
  }

  /**
   * Created date
   * @return The date when the issue was created
   */
  @JsonProperty
  @Override
  public @Nullable GitHubInstant createdAt() {
    return createdAt;
  }

  /**
   * Updated date
   * @return The date when the issue was updated
   */
  @JsonProperty
  @Override
  public @Nullable GitHubInstant updatedAt() {
    return updatedAt;
  }

  /**
   *ID 
   */
  @JsonProperty
  @Override
  public @Nullable Integer id() {
    return id;
  }

  /**
   *URL 
   */
  @JsonProperty
  @Override
  public @Nullable URI url() {
    return url;
  }

  /**
   *Test URL 
   */
  @JsonProperty
  @Override
  public @Nullable URI testUrl() {
    return testUrl;
  }

  /**
   *Ping URL 
   */
  @JsonProperty
  @Override
  public @Nullable URI pingUrl() {
    return pingUrl;
  }

  /**
   *Name 
   */
  @JsonProperty
  @Override
  public @Nullable String name() {
    return name;
  }

  /**
   *Determines what events the hook is triggered for. Default: ["push"] 
   */
  @JsonProperty
  @Override
  public @Nullable List<String> events() {
    return events;
  }

  /**
   *Determines whether the hook is actually triggered on pushes. 
   */
  @JsonProperty
  @Override
  public @Nullable Boolean active() {
    return active;
  }

  /**
   *These settings vary between hooks and some are defined in the github-services repository. 
   */
  @JsonProperty
  @Override
  public @Nullable WebhookConfig config() {
    return config;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Webhook#createdAt() createdAt} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for createdAt (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableWebhook withCreatedAt(@Nullable GitHubInstant value) {
    if (this.createdAt == value) return this;
    return new ImmutableWebhook(
        value,
        this.updatedAt,
        this.id,
        this.url,
        this.testUrl,
        this.pingUrl,
        this.name,
        this.events,
        this.active,
        this.config);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Webhook#updatedAt() updatedAt} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for updatedAt (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableWebhook withUpdatedAt(@Nullable GitHubInstant value) {
    if (this.updatedAt == value) return this;
    return new ImmutableWebhook(
        this.createdAt,
        value,
        this.id,
        this.url,
        this.testUrl,
        this.pingUrl,
        this.name,
        this.events,
        this.active,
        this.config);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Webhook#id() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableWebhook withId(@Nullable Integer value) {
    if (Objects.equals(this.id, value)) return this;
    return new ImmutableWebhook(
        this.createdAt,
        this.updatedAt,
        value,
        this.url,
        this.testUrl,
        this.pingUrl,
        this.name,
        this.events,
        this.active,
        this.config);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Webhook#url() url} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for url (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableWebhook withUrl(@Nullable URI value) {
    if (this.url == value) return this;
    return new ImmutableWebhook(
        this.createdAt,
        this.updatedAt,
        this.id,
        value,
        this.testUrl,
        this.pingUrl,
        this.name,
        this.events,
        this.active,
        this.config);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Webhook#testUrl() testUrl} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for testUrl (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableWebhook withTestUrl(@Nullable URI value) {
    if (this.testUrl == value) return this;
    return new ImmutableWebhook(
        this.createdAt,
        this.updatedAt,
        this.id,
        this.url,
        value,
        this.pingUrl,
        this.name,
        this.events,
        this.active,
        this.config);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Webhook#pingUrl() pingUrl} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for pingUrl (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableWebhook withPingUrl(@Nullable URI value) {
    if (this.pingUrl == value) return this;
    return new ImmutableWebhook(
        this.createdAt,
        this.updatedAt,
        this.id,
        this.url,
        this.testUrl,
        value,
        this.name,
        this.events,
        this.active,
        this.config);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Webhook#name() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableWebhook withName(@Nullable String value) {
    if (Objects.equals(this.name, value)) return this;
    return new ImmutableWebhook(
        this.createdAt,
        this.updatedAt,
        this.id,
        this.url,
        this.testUrl,
        this.pingUrl,
        value,
        this.events,
        this.active,
        this.config);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Webhook#events() events}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableWebhook withEvents(@Nullable String... elements) {
    if (elements == null) {
      return new ImmutableWebhook(
          this.createdAt,
          this.updatedAt,
          this.id,
          this.url,
          this.testUrl,
          this.pingUrl,
          this.name,
          null,
          this.active,
          this.config);
    }
    @Nullable List<String> newValue = Arrays.asList(elements) == null ? null : createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableWebhook(
        this.createdAt,
        this.updatedAt,
        this.id,
        this.url,
        this.testUrl,
        this.pingUrl,
        this.name,
        newValue,
        this.active,
        this.config);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Webhook#events() events}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of events elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableWebhook withEvents(@Nullable Iterable<String> elements) {
    if (this.events == elements) return this;
    @Nullable List<String> newValue = elements == null ? null : createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableWebhook(
        this.createdAt,
        this.updatedAt,
        this.id,
        this.url,
        this.testUrl,
        this.pingUrl,
        this.name,
        newValue,
        this.active,
        this.config);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Webhook#active() active} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for active (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableWebhook withActive(@Nullable Boolean value) {
    if (Objects.equals(this.active, value)) return this;
    return new ImmutableWebhook(
        this.createdAt,
        this.updatedAt,
        this.id,
        this.url,
        this.testUrl,
        this.pingUrl,
        this.name,
        this.events,
        value,
        this.config);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Webhook#config() config} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for config (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableWebhook withConfig(@Nullable WebhookConfig value) {
    if (this.config == value) return this;
    return new ImmutableWebhook(
        this.createdAt,
        this.updatedAt,
        this.id,
        this.url,
        this.testUrl,
        this.pingUrl,
        this.name,
        this.events,
        this.active,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableWebhook} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableWebhook
        && equalTo((ImmutableWebhook) another);
  }

  private boolean equalTo(ImmutableWebhook another) {
    return Objects.equals(createdAt, another.createdAt)
        && Objects.equals(updatedAt, another.updatedAt)
        && Objects.equals(id, another.id)
        && Objects.equals(url, another.url)
        && Objects.equals(testUrl, another.testUrl)
        && Objects.equals(pingUrl, another.pingUrl)
        && Objects.equals(name, another.name)
        && Objects.equals(events, another.events)
        && Objects.equals(active, another.active)
        && Objects.equals(config, another.config);
  }

  /**
   * Computes a hash code from attributes: {@code createdAt}, {@code updatedAt}, {@code id}, {@code url}, {@code testUrl}, {@code pingUrl}, {@code name}, {@code events}, {@code active}, {@code config}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(createdAt);
    h += (h << 5) + Objects.hashCode(updatedAt);
    h += (h << 5) + Objects.hashCode(id);
    h += (h << 5) + Objects.hashCode(url);
    h += (h << 5) + Objects.hashCode(testUrl);
    h += (h << 5) + Objects.hashCode(pingUrl);
    h += (h << 5) + Objects.hashCode(name);
    h += (h << 5) + Objects.hashCode(events);
    h += (h << 5) + Objects.hashCode(active);
    h += (h << 5) + Objects.hashCode(config);
    return h;
  }

  /**
   * Prints the immutable value {@code Webhook} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Webhook{"
        + "createdAt=" + createdAt
        + ", updatedAt=" + updatedAt
        + ", id=" + id
        + ", url=" + url
        + ", testUrl=" + testUrl
        + ", pingUrl=" + pingUrl
        + ", name=" + name
        + ", events=" + events
        + ", active=" + active
        + ", config=" + config
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Webhook", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements Webhook {
    @Nullable GitHubInstant createdAt;
    @Nullable GitHubInstant updatedAt;
    @Nullable Integer id;
    @Nullable URI url;
    @Nullable URI testUrl;
    @Nullable URI pingUrl;
    @Nullable String name;
    @Nullable List<String> events = null;
    @Nullable Boolean active;
    @Nullable WebhookConfig config;
    @JsonProperty
    public void setCreatedAt(@Nullable GitHubInstant createdAt) {
      this.createdAt = createdAt;
    }
    @JsonProperty
    public void setUpdatedAt(@Nullable GitHubInstant updatedAt) {
      this.updatedAt = updatedAt;
    }
    @JsonProperty
    public void setId(@Nullable Integer id) {
      this.id = id;
    }
    @JsonProperty
    public void setUrl(@Nullable URI url) {
      this.url = url;
    }
    @JsonProperty
    public void setTestUrl(@Nullable URI testUrl) {
      this.testUrl = testUrl;
    }
    @JsonProperty
    public void setPingUrl(@Nullable URI pingUrl) {
      this.pingUrl = pingUrl;
    }
    @JsonProperty
    public void setName(@Nullable String name) {
      this.name = name;
    }
    @JsonProperty
    public void setEvents(@Nullable List<String> events) {
      this.events = events;
    }
    @JsonProperty
    public void setActive(@Nullable Boolean active) {
      this.active = active;
    }
    @JsonProperty
    public void setConfig(@Nullable WebhookConfig config) {
      this.config = config;
    }
    @Override
    public GitHubInstant createdAt() { throw new UnsupportedOperationException(); }
    @Override
    public GitHubInstant updatedAt() { throw new UnsupportedOperationException(); }
    @Override
    public Integer id() { throw new UnsupportedOperationException(); }
    @Override
    public URI url() { throw new UnsupportedOperationException(); }
    @Override
    public URI testUrl() { throw new UnsupportedOperationException(); }
    @Override
    public URI pingUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String name() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> events() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean active() { throw new UnsupportedOperationException(); }
    @Override
    public WebhookConfig config() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableWebhook fromJson(Json json) {
    ImmutableWebhook.Builder builder = ImmutableWebhook.builder();
    if (json.createdAt != null) {
      builder.createdAt(json.createdAt);
    }
    if (json.updatedAt != null) {
      builder.updatedAt(json.updatedAt);
    }
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.url != null) {
      builder.url(json.url);
    }
    if (json.testUrl != null) {
      builder.testUrl(json.testUrl);
    }
    if (json.pingUrl != null) {
      builder.pingUrl(json.pingUrl);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.events != null) {
      builder.addAllEvents(json.events);
    }
    if (json.active != null) {
      builder.active(json.active);
    }
    if (json.config != null) {
      builder.config(json.config);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Webhook} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Webhook instance
   */
  public static ImmutableWebhook copyOf(Webhook instance) {
    if (instance instanceof ImmutableWebhook) {
      return (ImmutableWebhook) instance;
    }
    return ImmutableWebhook.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableWebhook ImmutableWebhook}.
   * <pre>
   * ImmutableWebhook.builder()
   *    .createdAt(com.spotify.github.GitHubInstant | null) // nullable {@link Webhook#createdAt() createdAt}
   *    .updatedAt(com.spotify.github.GitHubInstant | null) // nullable {@link Webhook#updatedAt() updatedAt}
   *    .id(Integer | null) // nullable {@link Webhook#id() id}
   *    .url(java.net.URI | null) // nullable {@link Webhook#url() url}
   *    .testUrl(java.net.URI | null) // nullable {@link Webhook#testUrl() testUrl}
   *    .pingUrl(java.net.URI | null) // nullable {@link Webhook#pingUrl() pingUrl}
   *    .name(String | null) // nullable {@link Webhook#name() name}
   *    .events(List&amp;lt;String&amp;gt; | null) // nullable {@link Webhook#events() events}
   *    .active(Boolean | null) // nullable {@link Webhook#active() active}
   *    .config(com.spotify.github.v3.hooks.WebhookConfig | null) // nullable {@link Webhook#config() config}
   *    .build();
   * </pre>
   * @return A new ImmutableWebhook builder
   */
  public static ImmutableWebhook.Builder builder() {
    return new ImmutableWebhook.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableWebhook ImmutableWebhook}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Webhook", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable GitHubInstant createdAt;
    private @Nullable GitHubInstant updatedAt;
    private @Nullable Integer id;
    private @Nullable URI url;
    private @Nullable URI testUrl;
    private @Nullable URI pingUrl;
    private @Nullable String name;
    private List<String> events = null;
    private @Nullable Boolean active;
    private @Nullable WebhookConfig config;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.spotify.github.v3.hooks.Webhook} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Webhook instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.spotify.github.UpdateTracking} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(UpdateTracking instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof Webhook) {
        Webhook instance = (Webhook) object;
        @Nullable String nameValue = instance.name();
        if (nameValue != null) {
          name(nameValue);
        }
        @Nullable URI pingUrlValue = instance.pingUrl();
        if (pingUrlValue != null) {
          pingUrl(pingUrlValue);
        }
        @Nullable Boolean activeValue = instance.active();
        if (activeValue != null) {
          active(activeValue);
        }
        @Nullable Integer idValue = instance.id();
        if (idValue != null) {
          id(idValue);
        }
        @Nullable URI testUrlValue = instance.testUrl();
        if (testUrlValue != null) {
          testUrl(testUrlValue);
        }
        @Nullable WebhookConfig configValue = instance.config();
        if (configValue != null) {
          config(configValue);
        }
        @Nullable URI urlValue = instance.url();
        if (urlValue != null) {
          url(urlValue);
        }
        @Nullable List<String> eventsValue = instance.events();
        if (eventsValue != null) {
          addAllEvents(eventsValue);
        }
      }
      if (object instanceof UpdateTracking) {
        UpdateTracking instance = (UpdateTracking) object;
        @Nullable GitHubInstant createdAtValue = instance.createdAt();
        if (createdAtValue != null) {
          createdAt(createdAtValue);
        }
        @Nullable GitHubInstant updatedAtValue = instance.updatedAt();
        if (updatedAtValue != null) {
          updatedAt(updatedAtValue);
        }
      }
    }

    /**
     * Initializes the value for the {@link Webhook#createdAt() createdAt} attribute.
     * @param createdAt The value for createdAt (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder createdAt(@Nullable GitHubInstant createdAt) {
      this.createdAt = createdAt;
      return this;
    }

    /**
     * Initializes the value for the {@link Webhook#updatedAt() updatedAt} attribute.
     * @param updatedAt The value for updatedAt (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder updatedAt(@Nullable GitHubInstant updatedAt) {
      this.updatedAt = updatedAt;
      return this;
    }

    /**
     * Initializes the value for the {@link Webhook#id() id} attribute.
     * @param id The value for id (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder id(@Nullable Integer id) {
      this.id = id;
      return this;
    }

    /**
     * Initializes the value for the {@link Webhook#url() url} attribute.
     * @param url The value for url (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder url(@Nullable URI url) {
      this.url = url;
      return this;
    }

    /**
     * Initializes the value for the {@link Webhook#testUrl() testUrl} attribute.
     * @param testUrl The value for testUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder testUrl(@Nullable URI testUrl) {
      this.testUrl = testUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link Webhook#pingUrl() pingUrl} attribute.
     * @param pingUrl The value for pingUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder pingUrl(@Nullable URI pingUrl) {
      this.pingUrl = pingUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link Webhook#name() name} attribute.
     * @param name The value for name (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder name(@Nullable String name) {
      this.name = name;
      return this;
    }

    /**
     * Adds one element to {@link Webhook#events() events} list.
     * @param element A events element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addEvents(String element) {
      if (this.events == null) {
        this.events = new ArrayList<String>();
      }
      this.events.add(Objects.requireNonNull(element, "events element"));
      return this;
    }

    /**
     * Adds elements to {@link Webhook#events() events} list.
     * @param elements An array of events elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addEvents(String... elements) {
      if (this.events == null) {
        this.events = new ArrayList<String>();
      }
      for (String element : elements) {
        this.events.add(Objects.requireNonNull(element, "events element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Webhook#events() events} list.
     * @param elements An iterable of events elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder events(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.events = null;
        return this;
      }
      this.events = new ArrayList<String>();
      return addAllEvents(elements);
    }

    /**
     * Adds elements to {@link Webhook#events() events} list.
     * @param elements An iterable of events elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllEvents(Iterable<String> elements) {
      Objects.requireNonNull(elements, "events element");
      if (this.events == null) {
        this.events = new ArrayList<String>();
      }
      for (String element : elements) {
        this.events.add(Objects.requireNonNull(element, "events element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Webhook#active() active} attribute.
     * @param active The value for active (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder active(@Nullable Boolean active) {
      this.active = active;
      return this;
    }

    /**
     * Initializes the value for the {@link Webhook#config() config} attribute.
     * @param config The value for config (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder config(@Nullable WebhookConfig config) {
      this.config = config;
      return this;
    }

    /**
     * Builds a new {@link ImmutableWebhook ImmutableWebhook}.
     * @return An immutable instance of Webhook
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableWebhook build() {
      return new ImmutableWebhook(
          createdAt,
          updatedAt,
          id,
          url,
          testUrl,
          pingUrl,
          name,
          events == null ? null : createUnmodifiableList(true, events),
          active,
          config);
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
