package com.spotify.github.v3.issues;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.net.URI;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Label}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableLabel.builder()}.
 */
@Generated(from = "Label", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableLabel implements Label {
  private final @Nullable URI url;
  private final @Nullable String name;
  private final @Nullable String color;

  private ImmutableLabel(
      @Nullable URI url,
      @Nullable String name,
      @Nullable String color) {
    this.url = url;
    this.name = name;
    this.color = color;
  }

  /**
   *URL 
   */
  @JsonProperty
  @Override
  public @Nullable URI url() {
    return url;
  }

  /**
   *Name 
   */
  @JsonProperty
  @Override
  public @Nullable String name() {
    return name;
  }

  /**
   *Color 
   */
  @JsonProperty
  @Override
  public @Nullable String color() {
    return color;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Label#url() url} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for url (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableLabel withUrl(@Nullable URI value) {
    if (this.url == value) return this;
    return new ImmutableLabel(value, this.name, this.color);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Label#name() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableLabel withName(@Nullable String value) {
    if (Objects.equals(this.name, value)) return this;
    return new ImmutableLabel(this.url, value, this.color);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Label#color() color} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for color (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableLabel withColor(@Nullable String value) {
    if (Objects.equals(this.color, value)) return this;
    return new ImmutableLabel(this.url, this.name, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableLabel} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableLabel
        && equalTo((ImmutableLabel) another);
  }

  private boolean equalTo(ImmutableLabel another) {
    return Objects.equals(url, another.url)
        && Objects.equals(name, another.name)
        && Objects.equals(color, another.color);
  }

  /**
   * Computes a hash code from attributes: {@code url}, {@code name}, {@code color}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(url);
    h += (h << 5) + Objects.hashCode(name);
    h += (h << 5) + Objects.hashCode(color);
    return h;
  }

  /**
   * Prints the immutable value {@code Label} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Label{"
        + "url=" + url
        + ", name=" + name
        + ", color=" + color
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Label", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements Label {
    @Nullable URI url;
    @Nullable String name;
    @Nullable String color;
    @JsonProperty
    public void setUrl(@Nullable URI url) {
      this.url = url;
    }
    @JsonProperty
    public void setName(@Nullable String name) {
      this.name = name;
    }
    @JsonProperty
    public void setColor(@Nullable String color) {
      this.color = color;
    }
    @Override
    public URI url() { throw new UnsupportedOperationException(); }
    @Override
    public String name() { throw new UnsupportedOperationException(); }
    @Override
    public String color() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableLabel fromJson(Json json) {
    ImmutableLabel.Builder builder = ImmutableLabel.builder();
    if (json.url != null) {
      builder.url(json.url);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.color != null) {
      builder.color(json.color);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Label} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Label instance
   */
  public static ImmutableLabel copyOf(Label instance) {
    if (instance instanceof ImmutableLabel) {
      return (ImmutableLabel) instance;
    }
    return ImmutableLabel.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableLabel ImmutableLabel}.
   * <pre>
   * ImmutableLabel.builder()
   *    .url(java.net.URI | null) // nullable {@link Label#url() url}
   *    .name(String | null) // nullable {@link Label#name() name}
   *    .color(String | null) // nullable {@link Label#color() color}
   *    .build();
   * </pre>
   * @return A new ImmutableLabel builder
   */
  public static ImmutableLabel.Builder builder() {
    return new ImmutableLabel.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableLabel ImmutableLabel}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Label", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable URI url;
    private @Nullable String name;
    private @Nullable String color;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Label} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Label instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable URI urlValue = instance.url();
      if (urlValue != null) {
        url(urlValue);
      }
      @Nullable String nameValue = instance.name();
      if (nameValue != null) {
        name(nameValue);
      }
      @Nullable String colorValue = instance.color();
      if (colorValue != null) {
        color(colorValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Label#url() url} attribute.
     * @param url The value for url (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder url(@Nullable URI url) {
      this.url = url;
      return this;
    }

    /**
     * Initializes the value for the {@link Label#name() name} attribute.
     * @param name The value for name (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder name(@Nullable String name) {
      this.name = name;
      return this;
    }

    /**
     * Initializes the value for the {@link Label#color() color} attribute.
     * @param color The value for color (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder color(@Nullable String color) {
      this.color = color;
      return this;
    }

    /**
     * Builds a new {@link ImmutableLabel ImmutableLabel}.
     * @return An immutable instance of Label
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableLabel build() {
      return new ImmutableLabel(url, name, color);
    }
  }
}
