package com.spotify.github.v3.prs;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import com.spotify.github.Links;
import java.net.URI;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link CommentLinks}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableCommentLinks.builder()}.
 */
@Generated(from = "CommentLinks", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableCommentLinks implements CommentLinks {
  private final @Nullable Links.Href<URI> self;
  private final @Nullable Links.Href<URI> html;
  private final @Nullable Links.Href<URI> pullRequest;

  private ImmutableCommentLinks(
      @Nullable Links.Href<URI> self,
      @Nullable Links.Href<URI> html,
      @Nullable Links.Href<URI> pullRequest) {
    this.self = self;
    this.html = html;
    this.pullRequest = pullRequest;
  }

  /**
   * Link to this entity in the API.
   * @return The link to the API of this entity
   */
  @JsonProperty
  @Override
  public @Nullable Links.Href<URI> self() {
    return self;
  }

  /**
   * Link to the HTML representaion of this item.
   * @return The link to the HTML representation of this entity
   */
  @JsonProperty
  @Override
  public @Nullable Links.Href<URI> html() {
    return html;
  }

  /**
   *Link to the pull request that this comment belongs to. {@link PullRequest} 
   */
  @JsonProperty
  @Override
  public @Nullable Links.Href<URI> pullRequest() {
    return pullRequest;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CommentLinks#self() self} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for self (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCommentLinks withSelf(@Nullable Links.Href<URI> value) {
    if (this.self == value) return this;
    return new ImmutableCommentLinks(value, this.html, this.pullRequest);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CommentLinks#html() html} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for html (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCommentLinks withHtml(@Nullable Links.Href<URI> value) {
    if (this.html == value) return this;
    return new ImmutableCommentLinks(this.self, value, this.pullRequest);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CommentLinks#pullRequest() pullRequest} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for pullRequest (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCommentLinks withPullRequest(@Nullable Links.Href<URI> value) {
    if (this.pullRequest == value) return this;
    return new ImmutableCommentLinks(this.self, this.html, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableCommentLinks} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableCommentLinks
        && equalTo((ImmutableCommentLinks) another);
  }

  private boolean equalTo(ImmutableCommentLinks another) {
    return Objects.equals(self, another.self)
        && Objects.equals(html, another.html)
        && Objects.equals(pullRequest, another.pullRequest);
  }

  /**
   * Computes a hash code from attributes: {@code self}, {@code html}, {@code pullRequest}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(self);
    h += (h << 5) + Objects.hashCode(html);
    h += (h << 5) + Objects.hashCode(pullRequest);
    return h;
  }

  /**
   * Prints the immutable value {@code CommentLinks} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "CommentLinks{"
        + "self=" + self
        + ", html=" + html
        + ", pullRequest=" + pullRequest
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "CommentLinks", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements CommentLinks {
    @Nullable Links.Href<URI> self;
    @Nullable Links.Href<URI> html;
    @Nullable Links.Href<URI> pullRequest;
    @JsonProperty
    public void setSelf(@Nullable Links.Href<URI> self) {
      this.self = self;
    }
    @JsonProperty
    public void setHtml(@Nullable Links.Href<URI> html) {
      this.html = html;
    }
    @JsonProperty
    public void setPullRequest(@Nullable Links.Href<URI> pullRequest) {
      this.pullRequest = pullRequest;
    }
    @Override
    public Links.Href<URI> self() { throw new UnsupportedOperationException(); }
    @Override
    public Links.Href<URI> html() { throw new UnsupportedOperationException(); }
    @Override
    public Links.Href<URI> pullRequest() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableCommentLinks fromJson(Json json) {
    ImmutableCommentLinks.Builder builder = ImmutableCommentLinks.builder();
    if (json.self != null) {
      builder.self(json.self);
    }
    if (json.html != null) {
      builder.html(json.html);
    }
    if (json.pullRequest != null) {
      builder.pullRequest(json.pullRequest);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link CommentLinks} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable CommentLinks instance
   */
  public static ImmutableCommentLinks copyOf(CommentLinks instance) {
    if (instance instanceof ImmutableCommentLinks) {
      return (ImmutableCommentLinks) instance;
    }
    return ImmutableCommentLinks.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableCommentLinks ImmutableCommentLinks}.
   * <pre>
   * ImmutableCommentLinks.builder()
   *    .self(com.spotify.github.Links.Href&amp;lt;java.net.URI&amp;gt; | null) // nullable {@link CommentLinks#self() self}
   *    .html(com.spotify.github.Links.Href&amp;lt;java.net.URI&amp;gt; | null) // nullable {@link CommentLinks#html() html}
   *    .pullRequest(com.spotify.github.Links.Href&amp;lt;java.net.URI&amp;gt; | null) // nullable {@link CommentLinks#pullRequest() pullRequest}
   *    .build();
   * </pre>
   * @return A new ImmutableCommentLinks builder
   */
  public static ImmutableCommentLinks.Builder builder() {
    return new ImmutableCommentLinks.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableCommentLinks ImmutableCommentLinks}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "CommentLinks", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable Links.Href<URI> self;
    private @Nullable Links.Href<URI> html;
    private @Nullable Links.Href<URI> pullRequest;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.spotify.github.v3.prs.CommentLinks} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(CommentLinks instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.spotify.github.Links} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Links instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof CommentLinks) {
        CommentLinks instance = (CommentLinks) object;
        @Nullable Links.Href<URI> pullRequestValue = instance.pullRequest();
        if (pullRequestValue != null) {
          pullRequest(pullRequestValue);
        }
      }
      if (object instanceof Links) {
        Links instance = (Links) object;
        @Nullable Links.Href<URI> selfValue = instance.self();
        if (selfValue != null) {
          self(selfValue);
        }
        @Nullable Links.Href<URI> htmlValue = instance.html();
        if (htmlValue != null) {
          html(htmlValue);
        }
      }
    }

    /**
     * Initializes the value for the {@link CommentLinks#self() self} attribute.
     * @param self The value for self (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder self(@Nullable Links.Href<URI> self) {
      this.self = self;
      return this;
    }

    /**
     * Initializes the value for the {@link CommentLinks#html() html} attribute.
     * @param html The value for html (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder html(@Nullable Links.Href<URI> html) {
      this.html = html;
      return this;
    }

    /**
     * Initializes the value for the {@link CommentLinks#pullRequest() pullRequest} attribute.
     * @param pullRequest The value for pullRequest (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder pullRequest(@Nullable Links.Href<URI> pullRequest) {
      this.pullRequest = pullRequest;
      return this;
    }

    /**
     * Builds a new {@link ImmutableCommentLinks ImmutableCommentLinks}.
     * @return An immutable instance of CommentLinks
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableCommentLinks build() {
      return new ImmutableCommentLinks(self, html, pullRequest);
    }
  }
}
