package com.spotify.github.v3.prs;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import com.spotify.github.CloseTracking;
import com.spotify.github.GitHubInstant;
import com.spotify.github.UpdateTracking;
import com.spotify.github.v3.Milestone;
import com.spotify.github.v3.User;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link PullRequest}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutablePullRequest.builder()}.
 */
@Generated(from = "PullRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutablePullRequest implements PullRequest {
  private final @Nullable GitHubInstant createdAt;
  private final @Nullable GitHubInstant updatedAt;
  private final @Nullable GitHubInstant closedAt;
  private final @Nullable Integer id;
  private final @Nullable URI url;
  private final @Nullable URI htmlUrl;
  private final @Nullable URI diffUrl;
  private final @Nullable URI patchUrl;
  private final @Nullable URI issueUrl;
  private final @Nullable URI commitsUrl;
  private final @Nullable Integer number;
  private final @Nullable String state;
  private final @Nullable String title;
  private final @Nullable String body;
  private final @Nullable User assignee;
  private final @Nullable List<User> assignees;
  private final @Nullable Milestone milestone;
  private final @Nullable Boolean locked;
  private final @Nullable GitHubInstant mergedAt;
  private final @Nullable PullRequestRef head;
  private final @Nullable PullRequestRef base;
  private final @Nullable User user;
  private final @Nullable URI statusesUrl;
  private final @Nullable URI reviewCommentsUrl;
  private final @Nullable String reviewCommentUrl;
  private final @Nullable URI commentsUrl;
  private final @Nullable PullRequestLinks links;
  private final @Nullable List<User> requestedReviewers;
  private final @Nullable List<User> requestedTeams;
  private final @Nullable String mergeCommitSha;
  private final @Nullable Boolean merged;
  private final @Nullable Boolean mergeable;
  private final @Nullable User mergedBy;
  private final @Nullable Integer comments;
  private final @Nullable Integer reviewComments;
  private final @Nullable Integer commits;
  private final @Nullable Integer additions;
  private final @Nullable Integer deletions;
  private final @Nullable Integer changedFiles;
  private final @Nullable String mergeableState;
  private final @Nullable Boolean draft;

  private ImmutablePullRequest(
      @Nullable GitHubInstant createdAt,
      @Nullable GitHubInstant updatedAt,
      @Nullable GitHubInstant closedAt,
      @Nullable Integer id,
      @Nullable URI url,
      @Nullable URI htmlUrl,
      @Nullable URI diffUrl,
      @Nullable URI patchUrl,
      @Nullable URI issueUrl,
      @Nullable URI commitsUrl,
      @Nullable Integer number,
      @Nullable String state,
      @Nullable String title,
      @Nullable String body,
      @Nullable User assignee,
      @Nullable List<User> assignees,
      @Nullable Milestone milestone,
      @Nullable Boolean locked,
      @Nullable GitHubInstant mergedAt,
      @Nullable PullRequestRef head,
      @Nullable PullRequestRef base,
      @Nullable User user,
      @Nullable URI statusesUrl,
      @Nullable URI reviewCommentsUrl,
      @Nullable String reviewCommentUrl,
      @Nullable URI commentsUrl,
      @Nullable PullRequestLinks links,
      @Nullable List<User> requestedReviewers,
      @Nullable List<User> requestedTeams,
      @Nullable String mergeCommitSha,
      @Nullable Boolean merged,
      @Nullable Boolean mergeable,
      @Nullable User mergedBy,
      @Nullable Integer comments,
      @Nullable Integer reviewComments,
      @Nullable Integer commits,
      @Nullable Integer additions,
      @Nullable Integer deletions,
      @Nullable Integer changedFiles,
      @Nullable String mergeableState,
      @Nullable Boolean draft) {
    this.createdAt = createdAt;
    this.updatedAt = updatedAt;
    this.closedAt = closedAt;
    this.id = id;
    this.url = url;
    this.htmlUrl = htmlUrl;
    this.diffUrl = diffUrl;
    this.patchUrl = patchUrl;
    this.issueUrl = issueUrl;
    this.commitsUrl = commitsUrl;
    this.number = number;
    this.state = state;
    this.title = title;
    this.body = body;
    this.assignee = assignee;
    this.assignees = assignees;
    this.milestone = milestone;
    this.locked = locked;
    this.mergedAt = mergedAt;
    this.head = head;
    this.base = base;
    this.user = user;
    this.statusesUrl = statusesUrl;
    this.reviewCommentsUrl = reviewCommentsUrl;
    this.reviewCommentUrl = reviewCommentUrl;
    this.commentsUrl = commentsUrl;
    this.links = links;
    this.requestedReviewers = requestedReviewers;
    this.requestedTeams = requestedTeams;
    this.mergeCommitSha = mergeCommitSha;
    this.merged = merged;
    this.mergeable = mergeable;
    this.mergedBy = mergedBy;
    this.comments = comments;
    this.reviewComments = reviewComments;
    this.commits = commits;
    this.additions = additions;
    this.deletions = deletions;
    this.changedFiles = changedFiles;
    this.mergeableState = mergeableState;
    this.draft = draft;
  }

  /**
   * Created date
   * @return The date when the issue was created
   */
  @JsonProperty
  @Override
  public @Nullable GitHubInstant createdAt() {
    return createdAt;
  }

  /**
   * Updated date
   * @return The date when the issue was updated
   */
  @JsonProperty
  @Override
  public @Nullable GitHubInstant updatedAt() {
    return updatedAt;
  }

  /**
   * Closed date.
   * @return The date when the issue was closed
   */
  @JsonProperty
  @Override
  public Optional<GitHubInstant> closedAt() {
    return Optional.ofNullable(closedAt);
  }

  /**
   *ID. 
   */
  @JsonProperty
  @Override
  public @Nullable Integer id() {
    return id;
  }

  /**
   *URL. 
   */
  @JsonProperty
  @Override
  public @Nullable URI url() {
    return url;
  }

  /**
   *HTML URL. 
   */
  @JsonProperty
  @Override
  public @Nullable URI htmlUrl() {
    return htmlUrl;
  }

  /**
   *Diff URL. 
   */
  @JsonProperty
  @Override
  public @Nullable URI diffUrl() {
    return diffUrl;
  }

  /**
   *Patch URL. 
   */
  @JsonProperty
  @Override
  public @Nullable URI patchUrl() {
    return patchUrl;
  }

  /**
   *Issue URL. 
   */
  @JsonProperty
  @Override
  public @Nullable URI issueUrl() {
    return issueUrl;
  }

  /**
   *Commits URL. 
   */
  @JsonProperty
  @Override
  public @Nullable URI commitsUrl() {
    return commitsUrl;
  }

  /**
   *Number. 
   */
  @JsonProperty
  @Override
  public @Nullable Integer number() {
    return number;
  }

  /**
   *Either open, closed, or all to filter by state. Default: open. 
   */
  @JsonProperty
  @Override
  public @Nullable String state() {
    return state;
  }

  /**
   *The title of the pull request. 
   */
  @JsonProperty
  @Override
  public @Nullable String title() {
    return title;
  }

  /**
   *The contents of the pull request. 
   */
  @JsonProperty
  @Override
  public Optional<String> body() {
    return Optional.ofNullable(body);
  }

  /**
   *Assignee. 
   */
  @JsonProperty
  @Override
  public Optional<User> assignee() {
    return Optional.ofNullable(assignee);
  }

  /**
   *Assignees. 
   */
  @JsonProperty
  @Override
  public Optional<List<User>> assignees() {
    return Optional.ofNullable(assignees);
  }

  /**
   *Milestone. 
   */
  @JsonProperty
  @Override
  public Optional<Milestone> milestone() {
    return Optional.ofNullable(milestone);
  }

  /**
   *Is it locked. 
   */
  @JsonProperty
  @Override
  public @Nullable Boolean locked() {
    return locked;
  }

  /**
   *Merged date. 
   */
  @JsonProperty
  @Override
  public Optional<GitHubInstant> mergedAt() {
    return Optional.ofNullable(mergedAt);
  }

  /**
   *Head reference. 
   */
  @JsonProperty
  @Override
  public @Nullable PullRequestRef head() {
    return head;
  }

  /**
   *Base reference. 
   */
  @JsonProperty
  @Override
  public @Nullable PullRequestRef base() {
    return base;
  }

  /**
   *User. 
   */
  @JsonProperty
  @Override
  public @Nullable User user() {
    return user;
  }

  /**
   *Statuses API URL. 
   */
  @JsonProperty
  @Override
  public @Nullable URI statusesUrl() {
    return statusesUrl;
  }

  /**
   *Review comments API URL. 
   */
  @JsonProperty
  @Override
  public @Nullable URI reviewCommentsUrl() {
    return reviewCommentsUrl;
  }

  /**
   *Review comment API URL template. 
   */
  @JsonProperty
  @Override
  public @Nullable String reviewCommentUrl() {
    return reviewCommentUrl;
  }

  /**
   *Comments API URL. 
   */
  @JsonProperty
  @Override
  public @Nullable URI commentsUrl() {
    return commentsUrl;
  }

  /**
   *Link references. 
   */
  @JsonProperty("_links")
  @Override
  public @Nullable PullRequestLinks links() {
    return links;
  }

  /**
   *Requested reviewers (users) 
   */
  @JsonProperty("requested_reviewers")
  @Override
  public @Nullable List<User> requestedReviewers() {
    return requestedReviewers;
  }

  /**
   *Requested reviewers (teams) 
   */
  @JsonProperty("requested_teams")
  @Override
  public @Nullable List<User> requestedTeams() {
    return requestedTeams;
  }

  /**
   *@Deprecated the merge commit sha. 
   */
  @JsonProperty
  @Override
  public Optional<String> mergeCommitSha() {
    return Optional.ofNullable(mergeCommitSha);
  }

  /**
   *Is it merged. 
   */
  @JsonProperty
  @Override
  public @Nullable Boolean merged() {
    return merged;
  }

  /**
   *Is it mergeable. 
   */
  @JsonProperty
  @Override
  public Optional<Boolean> mergeable() {
    return Optional.ofNullable(mergeable);
  }

  /**
   *Merged by user. 
   */
  @JsonProperty
  @Override
  public Optional<User> mergedBy() {
    return Optional.ofNullable(mergedBy);
  }

  /**
   *Number of comments. 
   */
  @JsonProperty
  @Override
  public @Nullable Integer comments() {
    return comments;
  }

  /**
   *Number of review (commit) comments. 
   */
  @JsonProperty
  @Override
  public @Nullable Integer reviewComments() {
    return reviewComments;
  }

  /**
   *Number of commits. 
   */
  @JsonProperty
  @Override
  public @Nullable Integer commits() {
    return commits;
  }

  /**
   *Number of additions. 
   */
  @JsonProperty
  @Override
  public @Nullable Integer additions() {
    return additions;
  }

  /**
   *Number of deletions. 
   */
  @JsonProperty
  @Override
  public @Nullable Integer deletions() {
    return deletions;
  }

  /**
   *Number of changed files. 
   */
  @JsonProperty
  @Override
  public @Nullable Integer changedFiles() {
    return changedFiles;
  }

  /**
   *The mergeable state of this PR. 
   */
  @JsonProperty
  @Override
  public @Nullable String mergeableState() {
    return mergeableState;
  }

  /**
   *Is it a draft PR? 
   */
  @JsonProperty
  @Override
  public Optional<Boolean> draft() {
    return Optional.ofNullable(draft);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PullRequest#createdAt() createdAt} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for createdAt (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePullRequest withCreatedAt(@Nullable GitHubInstant value) {
    if (this.createdAt == value) return this;
    return new ImmutablePullRequest(
        value,
        this.updatedAt,
        this.closedAt,
        this.id,
        this.url,
        this.htmlUrl,
        this.diffUrl,
        this.patchUrl,
        this.issueUrl,
        this.commitsUrl,
        this.number,
        this.state,
        this.title,
        this.body,
        this.assignee,
        this.assignees,
        this.milestone,
        this.locked,
        this.mergedAt,
        this.head,
        this.base,
        this.user,
        this.statusesUrl,
        this.reviewCommentsUrl,
        this.reviewCommentUrl,
        this.commentsUrl,
        this.links,
        this.requestedReviewers,
        this.requestedTeams,
        this.mergeCommitSha,
        this.merged,
        this.mergeable,
        this.mergedBy,
        this.comments,
        this.reviewComments,
        this.commits,
        this.additions,
        this.deletions,
        this.changedFiles,
        this.mergeableState,
        this.draft);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PullRequest#updatedAt() updatedAt} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for updatedAt (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePullRequest withUpdatedAt(@Nullable GitHubInstant value) {
    if (this.updatedAt == value) return this;
    return new ImmutablePullRequest(
        this.createdAt,
        value,
        this.closedAt,
        this.id,
        this.url,
        this.htmlUrl,
        this.diffUrl,
        this.patchUrl,
        this.issueUrl,
        this.commitsUrl,
        this.number,
        this.state,
        this.title,
        this.body,
        this.assignee,
        this.assignees,
        this.milestone,
        this.locked,
        this.mergedAt,
        this.head,
        this.base,
        this.user,
        this.statusesUrl,
        this.reviewCommentsUrl,
        this.reviewCommentUrl,
        this.commentsUrl,
        this.links,
        this.requestedReviewers,
        this.requestedTeams,
        this.mergeCommitSha,
        this.merged,
        this.mergeable,
        this.mergedBy,
        this.comments,
        this.reviewComments,
        this.commits,
        this.additions,
        this.deletions,
        this.changedFiles,
        this.mergeableState,
        this.draft);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link PullRequest#closedAt() closedAt} attribute.
   * @param value The value for closedAt
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePullRequest withClosedAt(GitHubInstant value) {
    @Nullable GitHubInstant newValue = Objects.requireNonNull(value, "closedAt");
    if (this.closedAt == newValue) return this;
    return new ImmutablePullRequest(
        this.createdAt,
        this.updatedAt,
        newValue,
        this.id,
        this.url,
        this.htmlUrl,
        this.diffUrl,
        this.patchUrl,
        this.issueUrl,
        this.commitsUrl,
        this.number,
        this.state,
        this.title,
        this.body,
        this.assignee,
        this.assignees,
        this.milestone,
        this.locked,
        this.mergedAt,
        this.head,
        this.base,
        this.user,
        this.statusesUrl,
        this.reviewCommentsUrl,
        this.reviewCommentUrl,
        this.commentsUrl,
        this.links,
        this.requestedReviewers,
        this.requestedTeams,
        this.mergeCommitSha,
        this.merged,
        this.mergeable,
        this.mergedBy,
        this.comments,
        this.reviewComments,
        this.commits,
        this.additions,
        this.deletions,
        this.changedFiles,
        this.mergeableState,
        this.draft);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link PullRequest#closedAt() closedAt} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for closedAt
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutablePullRequest withClosedAt(Optional<? extends GitHubInstant> optional) {
    @Nullable GitHubInstant value = optional.orElse(null);
    if (this.closedAt == value) return this;
    return new ImmutablePullRequest(
        this.createdAt,
        this.updatedAt,
        value,
        this.id,
        this.url,
        this.htmlUrl,
        this.diffUrl,
        this.patchUrl,
        this.issueUrl,
        this.commitsUrl,
        this.number,
        this.state,
        this.title,
        this.body,
        this.assignee,
        this.assignees,
        this.milestone,
        this.locked,
        this.mergedAt,
        this.head,
        this.base,
        this.user,
        this.statusesUrl,
        this.reviewCommentsUrl,
        this.reviewCommentUrl,
        this.commentsUrl,
        this.links,
        this.requestedReviewers,
        this.requestedTeams,
        this.mergeCommitSha,
        this.merged,
        this.mergeable,
        this.mergedBy,
        this.comments,
        this.reviewComments,
        this.commits,
        this.additions,
        this.deletions,
        this.changedFiles,
        this.mergeableState,
        this.draft);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PullRequest#id() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePullRequest withId(@Nullable Integer value) {
    if (Objects.equals(this.id, value)) return this;
    return new ImmutablePullRequest(
        this.createdAt,
        this.updatedAt,
        this.closedAt,
        value,
        this.url,
        this.htmlUrl,
        this.diffUrl,
        this.patchUrl,
        this.issueUrl,
        this.commitsUrl,
        this.number,
        this.state,
        this.title,
        this.body,
        this.assignee,
        this.assignees,
        this.milestone,
        this.locked,
        this.mergedAt,
        this.head,
        this.base,
        this.user,
        this.statusesUrl,
        this.reviewCommentsUrl,
        this.reviewCommentUrl,
        this.commentsUrl,
        this.links,
        this.requestedReviewers,
        this.requestedTeams,
        this.mergeCommitSha,
        this.merged,
        this.mergeable,
        this.mergedBy,
        this.comments,
        this.reviewComments,
        this.commits,
        this.additions,
        this.deletions,
        this.changedFiles,
        this.mergeableState,
        this.draft);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PullRequest#url() url} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for url (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePullRequest withUrl(@Nullable URI value) {
    if (this.url == value) return this;
    return new ImmutablePullRequest(
        this.createdAt,
        this.updatedAt,
        this.closedAt,
        this.id,
        value,
        this.htmlUrl,
        this.diffUrl,
        this.patchUrl,
        this.issueUrl,
        this.commitsUrl,
        this.number,
        this.state,
        this.title,
        this.body,
        this.assignee,
        this.assignees,
        this.milestone,
        this.locked,
        this.mergedAt,
        this.head,
        this.base,
        this.user,
        this.statusesUrl,
        this.reviewCommentsUrl,
        this.reviewCommentUrl,
        this.commentsUrl,
        this.links,
        this.requestedReviewers,
        this.requestedTeams,
        this.mergeCommitSha,
        this.merged,
        this.mergeable,
        this.mergedBy,
        this.comments,
        this.reviewComments,
        this.commits,
        this.additions,
        this.deletions,
        this.changedFiles,
        this.mergeableState,
        this.draft);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PullRequest#htmlUrl() htmlUrl} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for htmlUrl (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePullRequest withHtmlUrl(@Nullable URI value) {
    if (this.htmlUrl == value) return this;
    return new ImmutablePullRequest(
        this.createdAt,
        this.updatedAt,
        this.closedAt,
        this.id,
        this.url,
        value,
        this.diffUrl,
        this.patchUrl,
        this.issueUrl,
        this.commitsUrl,
        this.number,
        this.state,
        this.title,
        this.body,
        this.assignee,
        this.assignees,
        this.milestone,
        this.locked,
        this.mergedAt,
        this.head,
        this.base,
        this.user,
        this.statusesUrl,
        this.reviewCommentsUrl,
        this.reviewCommentUrl,
        this.commentsUrl,
        this.links,
        this.requestedReviewers,
        this.requestedTeams,
        this.mergeCommitSha,
        this.merged,
        this.mergeable,
        this.mergedBy,
        this.comments,
        this.reviewComments,
        this.commits,
        this.additions,
        this.deletions,
        this.changedFiles,
        this.mergeableState,
        this.draft);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PullRequest#diffUrl() diffUrl} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for diffUrl (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePullRequest withDiffUrl(@Nullable URI value) {
    if (this.diffUrl == value) return this;
    return new ImmutablePullRequest(
        this.createdAt,
        this.updatedAt,
        this.closedAt,
        this.id,
        this.url,
        this.htmlUrl,
        value,
        this.patchUrl,
        this.issueUrl,
        this.commitsUrl,
        this.number,
        this.state,
        this.title,
        this.body,
        this.assignee,
        this.assignees,
        this.milestone,
        this.locked,
        this.mergedAt,
        this.head,
        this.base,
        this.user,
        this.statusesUrl,
        this.reviewCommentsUrl,
        this.reviewCommentUrl,
        this.commentsUrl,
        this.links,
        this.requestedReviewers,
        this.requestedTeams,
        this.mergeCommitSha,
        this.merged,
        this.mergeable,
        this.mergedBy,
        this.comments,
        this.reviewComments,
        this.commits,
        this.additions,
        this.deletions,
        this.changedFiles,
        this.mergeableState,
        this.draft);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PullRequest#patchUrl() patchUrl} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for patchUrl (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePullRequest withPatchUrl(@Nullable URI value) {
    if (this.patchUrl == value) return this;
    return new ImmutablePullRequest(
        this.createdAt,
        this.updatedAt,
        this.closedAt,
        this.id,
        this.url,
        this.htmlUrl,
        this.diffUrl,
        value,
        this.issueUrl,
        this.commitsUrl,
        this.number,
        this.state,
        this.title,
        this.body,
        this.assignee,
        this.assignees,
        this.milestone,
        this.locked,
        this.mergedAt,
        this.head,
        this.base,
        this.user,
        this.statusesUrl,
        this.reviewCommentsUrl,
        this.reviewCommentUrl,
        this.commentsUrl,
        this.links,
        this.requestedReviewers,
        this.requestedTeams,
        this.mergeCommitSha,
        this.merged,
        this.mergeable,
        this.mergedBy,
        this.comments,
        this.reviewComments,
        this.commits,
        this.additions,
        this.deletions,
        this.changedFiles,
        this.mergeableState,
        this.draft);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PullRequest#issueUrl() issueUrl} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for issueUrl (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePullRequest withIssueUrl(@Nullable URI value) {
    if (this.issueUrl == value) return this;
    return new ImmutablePullRequest(
        this.createdAt,
        this.updatedAt,
        this.closedAt,
        this.id,
        this.url,
        this.htmlUrl,
        this.diffUrl,
        this.patchUrl,
        value,
        this.commitsUrl,
        this.number,
        this.state,
        this.title,
        this.body,
        this.assignee,
        this.assignees,
        this.milestone,
        this.locked,
        this.mergedAt,
        this.head,
        this.base,
        this.user,
        this.statusesUrl,
        this.reviewCommentsUrl,
        this.reviewCommentUrl,
        this.commentsUrl,
        this.links,
        this.requestedReviewers,
        this.requestedTeams,
        this.mergeCommitSha,
        this.merged,
        this.mergeable,
        this.mergedBy,
        this.comments,
        this.reviewComments,
        this.commits,
        this.additions,
        this.deletions,
        this.changedFiles,
        this.mergeableState,
        this.draft);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PullRequest#commitsUrl() commitsUrl} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for commitsUrl (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePullRequest withCommitsUrl(@Nullable URI value) {
    if (this.commitsUrl == value) return this;
    return new ImmutablePullRequest(
        this.createdAt,
        this.updatedAt,
        this.closedAt,
        this.id,
        this.url,
        this.htmlUrl,
        this.diffUrl,
        this.patchUrl,
        this.issueUrl,
        value,
        this.number,
        this.state,
        this.title,
        this.body,
        this.assignee,
        this.assignees,
        this.milestone,
        this.locked,
        this.mergedAt,
        this.head,
        this.base,
        this.user,
        this.statusesUrl,
        this.reviewCommentsUrl,
        this.reviewCommentUrl,
        this.commentsUrl,
        this.links,
        this.requestedReviewers,
        this.requestedTeams,
        this.mergeCommitSha,
        this.merged,
        this.mergeable,
        this.mergedBy,
        this.comments,
        this.reviewComments,
        this.commits,
        this.additions,
        this.deletions,
        this.changedFiles,
        this.mergeableState,
        this.draft);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PullRequest#number() number} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for number (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePullRequest withNumber(@Nullable Integer value) {
    if (Objects.equals(this.number, value)) return this;
    return new ImmutablePullRequest(
        this.createdAt,
        this.updatedAt,
        this.closedAt,
        this.id,
        this.url,
        this.htmlUrl,
        this.diffUrl,
        this.patchUrl,
        this.issueUrl,
        this.commitsUrl,
        value,
        this.state,
        this.title,
        this.body,
        this.assignee,
        this.assignees,
        this.milestone,
        this.locked,
        this.mergedAt,
        this.head,
        this.base,
        this.user,
        this.statusesUrl,
        this.reviewCommentsUrl,
        this.reviewCommentUrl,
        this.commentsUrl,
        this.links,
        this.requestedReviewers,
        this.requestedTeams,
        this.mergeCommitSha,
        this.merged,
        this.mergeable,
        this.mergedBy,
        this.comments,
        this.reviewComments,
        this.commits,
        this.additions,
        this.deletions,
        this.changedFiles,
        this.mergeableState,
        this.draft);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PullRequest#state() state} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for state (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePullRequest withState(@Nullable String value) {
    if (Objects.equals(this.state, value)) return this;
    return new ImmutablePullRequest(
        this.createdAt,
        this.updatedAt,
        this.closedAt,
        this.id,
        this.url,
        this.htmlUrl,
        this.diffUrl,
        this.patchUrl,
        this.issueUrl,
        this.commitsUrl,
        this.number,
        value,
        this.title,
        this.body,
        this.assignee,
        this.assignees,
        this.milestone,
        this.locked,
        this.mergedAt,
        this.head,
        this.base,
        this.user,
        this.statusesUrl,
        this.reviewCommentsUrl,
        this.reviewCommentUrl,
        this.commentsUrl,
        this.links,
        this.requestedReviewers,
        this.requestedTeams,
        this.mergeCommitSha,
        this.merged,
        this.mergeable,
        this.mergedBy,
        this.comments,
        this.reviewComments,
        this.commits,
        this.additions,
        this.deletions,
        this.changedFiles,
        this.mergeableState,
        this.draft);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PullRequest#title() title} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for title (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePullRequest withTitle(@Nullable String value) {
    if (Objects.equals(this.title, value)) return this;
    return new ImmutablePullRequest(
        this.createdAt,
        this.updatedAt,
        this.closedAt,
        this.id,
        this.url,
        this.htmlUrl,
        this.diffUrl,
        this.patchUrl,
        this.issueUrl,
        this.commitsUrl,
        this.number,
        this.state,
        value,
        this.body,
        this.assignee,
        this.assignees,
        this.milestone,
        this.locked,
        this.mergedAt,
        this.head,
        this.base,
        this.user,
        this.statusesUrl,
        this.reviewCommentsUrl,
        this.reviewCommentUrl,
        this.commentsUrl,
        this.links,
        this.requestedReviewers,
        this.requestedTeams,
        this.mergeCommitSha,
        this.merged,
        this.mergeable,
        this.mergedBy,
        this.comments,
        this.reviewComments,
        this.commits,
        this.additions,
        this.deletions,
        this.changedFiles,
        this.mergeableState,
        this.draft);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link PullRequest#body() body} attribute.
   * @param value The value for body
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePullRequest withBody(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "body");
    if (Objects.equals(this.body, newValue)) return this;
    return new ImmutablePullRequest(
        this.createdAt,
        this.updatedAt,
        this.closedAt,
        this.id,
        this.url,
        this.htmlUrl,
        this.diffUrl,
        this.patchUrl,
        this.issueUrl,
        this.commitsUrl,
        this.number,
        this.state,
        this.title,
        newValue,
        this.assignee,
        this.assignees,
        this.milestone,
        this.locked,
        this.mergedAt,
        this.head,
        this.base,
        this.user,
        this.statusesUrl,
        this.reviewCommentsUrl,
        this.reviewCommentUrl,
        this.commentsUrl,
        this.links,
        this.requestedReviewers,
        this.requestedTeams,
        this.mergeCommitSha,
        this.merged,
        this.mergeable,
        this.mergedBy,
        this.comments,
        this.reviewComments,
        this.commits,
        this.additions,
        this.deletions,
        this.changedFiles,
        this.mergeableState,
        this.draft);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link PullRequest#body() body} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for body
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePullRequest withBody(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.body, value)) return this;
    return new ImmutablePullRequest(
        this.createdAt,
        this.updatedAt,
        this.closedAt,
        this.id,
        this.url,
        this.htmlUrl,
        this.diffUrl,
        this.patchUrl,
        this.issueUrl,
        this.commitsUrl,
        this.number,
        this.state,
        this.title,
        value,
        this.assignee,
        this.assignees,
        this.milestone,
        this.locked,
        this.mergedAt,
        this.head,
        this.base,
        this.user,
        this.statusesUrl,
        this.reviewCommentsUrl,
        this.reviewCommentUrl,
        this.commentsUrl,
        this.links,
        this.requestedReviewers,
        this.requestedTeams,
        this.mergeCommitSha,
        this.merged,
        this.mergeable,
        this.mergedBy,
        this.comments,
        this.reviewComments,
        this.commits,
        this.additions,
        this.deletions,
        this.changedFiles,
        this.mergeableState,
        this.draft);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link PullRequest#assignee() assignee} attribute.
   * @param value The value for assignee
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePullRequest withAssignee(User value) {
    @Nullable User newValue = Objects.requireNonNull(value, "assignee");
    if (this.assignee == newValue) return this;
    return new ImmutablePullRequest(
        this.createdAt,
        this.updatedAt,
        this.closedAt,
        this.id,
        this.url,
        this.htmlUrl,
        this.diffUrl,
        this.patchUrl,
        this.issueUrl,
        this.commitsUrl,
        this.number,
        this.state,
        this.title,
        this.body,
        newValue,
        this.assignees,
        this.milestone,
        this.locked,
        this.mergedAt,
        this.head,
        this.base,
        this.user,
        this.statusesUrl,
        this.reviewCommentsUrl,
        this.reviewCommentUrl,
        this.commentsUrl,
        this.links,
        this.requestedReviewers,
        this.requestedTeams,
        this.mergeCommitSha,
        this.merged,
        this.mergeable,
        this.mergedBy,
        this.comments,
        this.reviewComments,
        this.commits,
        this.additions,
        this.deletions,
        this.changedFiles,
        this.mergeableState,
        this.draft);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link PullRequest#assignee() assignee} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for assignee
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutablePullRequest withAssignee(Optional<? extends User> optional) {
    @Nullable User value = optional.orElse(null);
    if (this.assignee == value) return this;
    return new ImmutablePullRequest(
        this.createdAt,
        this.updatedAt,
        this.closedAt,
        this.id,
        this.url,
        this.htmlUrl,
        this.diffUrl,
        this.patchUrl,
        this.issueUrl,
        this.commitsUrl,
        this.number,
        this.state,
        this.title,
        this.body,
        value,
        this.assignees,
        this.milestone,
        this.locked,
        this.mergedAt,
        this.head,
        this.base,
        this.user,
        this.statusesUrl,
        this.reviewCommentsUrl,
        this.reviewCommentUrl,
        this.commentsUrl,
        this.links,
        this.requestedReviewers,
        this.requestedTeams,
        this.mergeCommitSha,
        this.merged,
        this.mergeable,
        this.mergedBy,
        this.comments,
        this.reviewComments,
        this.commits,
        this.additions,
        this.deletions,
        this.changedFiles,
        this.mergeableState,
        this.draft);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link PullRequest#assignees() assignees} attribute.
   * @param value The value for assignees
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePullRequest withAssignees(List<User> value) {
    @Nullable List<User> newValue = Objects.requireNonNull(value, "assignees");
    if (this.assignees == newValue) return this;
    return new ImmutablePullRequest(
        this.createdAt,
        this.updatedAt,
        this.closedAt,
        this.id,
        this.url,
        this.htmlUrl,
        this.diffUrl,
        this.patchUrl,
        this.issueUrl,
        this.commitsUrl,
        this.number,
        this.state,
        this.title,
        this.body,
        this.assignee,
        newValue,
        this.milestone,
        this.locked,
        this.mergedAt,
        this.head,
        this.base,
        this.user,
        this.statusesUrl,
        this.reviewCommentsUrl,
        this.reviewCommentUrl,
        this.commentsUrl,
        this.links,
        this.requestedReviewers,
        this.requestedTeams,
        this.mergeCommitSha,
        this.merged,
        this.mergeable,
        this.mergedBy,
        this.comments,
        this.reviewComments,
        this.commits,
        this.additions,
        this.deletions,
        this.changedFiles,
        this.mergeableState,
        this.draft);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link PullRequest#assignees() assignees} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for assignees
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutablePullRequest withAssignees(Optional<? extends List<User>> optional) {
    @Nullable List<User> value = optional.orElse(null);
    if (this.assignees == value) return this;
    return new ImmutablePullRequest(
        this.createdAt,
        this.updatedAt,
        this.closedAt,
        this.id,
        this.url,
        this.htmlUrl,
        this.diffUrl,
        this.patchUrl,
        this.issueUrl,
        this.commitsUrl,
        this.number,
        this.state,
        this.title,
        this.body,
        this.assignee,
        value,
        this.milestone,
        this.locked,
        this.mergedAt,
        this.head,
        this.base,
        this.user,
        this.statusesUrl,
        this.reviewCommentsUrl,
        this.reviewCommentUrl,
        this.commentsUrl,
        this.links,
        this.requestedReviewers,
        this.requestedTeams,
        this.mergeCommitSha,
        this.merged,
        this.mergeable,
        this.mergedBy,
        this.comments,
        this.reviewComments,
        this.commits,
        this.additions,
        this.deletions,
        this.changedFiles,
        this.mergeableState,
        this.draft);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link PullRequest#milestone() milestone} attribute.
   * @param value The value for milestone
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePullRequest withMilestone(Milestone value) {
    @Nullable Milestone newValue = Objects.requireNonNull(value, "milestone");
    if (this.milestone == newValue) return this;
    return new ImmutablePullRequest(
        this.createdAt,
        this.updatedAt,
        this.closedAt,
        this.id,
        this.url,
        this.htmlUrl,
        this.diffUrl,
        this.patchUrl,
        this.issueUrl,
        this.commitsUrl,
        this.number,
        this.state,
        this.title,
        this.body,
        this.assignee,
        this.assignees,
        newValue,
        this.locked,
        this.mergedAt,
        this.head,
        this.base,
        this.user,
        this.statusesUrl,
        this.reviewCommentsUrl,
        this.reviewCommentUrl,
        this.commentsUrl,
        this.links,
        this.requestedReviewers,
        this.requestedTeams,
        this.mergeCommitSha,
        this.merged,
        this.mergeable,
        this.mergedBy,
        this.comments,
        this.reviewComments,
        this.commits,
        this.additions,
        this.deletions,
        this.changedFiles,
        this.mergeableState,
        this.draft);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link PullRequest#milestone() milestone} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for milestone
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutablePullRequest withMilestone(Optional<? extends Milestone> optional) {
    @Nullable Milestone value = optional.orElse(null);
    if (this.milestone == value) return this;
    return new ImmutablePullRequest(
        this.createdAt,
        this.updatedAt,
        this.closedAt,
        this.id,
        this.url,
        this.htmlUrl,
        this.diffUrl,
        this.patchUrl,
        this.issueUrl,
        this.commitsUrl,
        this.number,
        this.state,
        this.title,
        this.body,
        this.assignee,
        this.assignees,
        value,
        this.locked,
        this.mergedAt,
        this.head,
        this.base,
        this.user,
        this.statusesUrl,
        this.reviewCommentsUrl,
        this.reviewCommentUrl,
        this.commentsUrl,
        this.links,
        this.requestedReviewers,
        this.requestedTeams,
        this.mergeCommitSha,
        this.merged,
        this.mergeable,
        this.mergedBy,
        this.comments,
        this.reviewComments,
        this.commits,
        this.additions,
        this.deletions,
        this.changedFiles,
        this.mergeableState,
        this.draft);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PullRequest#locked() locked} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for locked (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePullRequest withLocked(@Nullable Boolean value) {
    if (Objects.equals(this.locked, value)) return this;
    return new ImmutablePullRequest(
        this.createdAt,
        this.updatedAt,
        this.closedAt,
        this.id,
        this.url,
        this.htmlUrl,
        this.diffUrl,
        this.patchUrl,
        this.issueUrl,
        this.commitsUrl,
        this.number,
        this.state,
        this.title,
        this.body,
        this.assignee,
        this.assignees,
        this.milestone,
        value,
        this.mergedAt,
        this.head,
        this.base,
        this.user,
        this.statusesUrl,
        this.reviewCommentsUrl,
        this.reviewCommentUrl,
        this.commentsUrl,
        this.links,
        this.requestedReviewers,
        this.requestedTeams,
        this.mergeCommitSha,
        this.merged,
        this.mergeable,
        this.mergedBy,
        this.comments,
        this.reviewComments,
        this.commits,
        this.additions,
        this.deletions,
        this.changedFiles,
        this.mergeableState,
        this.draft);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link PullRequest#mergedAt() mergedAt} attribute.
   * @param value The value for mergedAt
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePullRequest withMergedAt(GitHubInstant value) {
    @Nullable GitHubInstant newValue = Objects.requireNonNull(value, "mergedAt");
    if (this.mergedAt == newValue) return this;
    return new ImmutablePullRequest(
        this.createdAt,
        this.updatedAt,
        this.closedAt,
        this.id,
        this.url,
        this.htmlUrl,
        this.diffUrl,
        this.patchUrl,
        this.issueUrl,
        this.commitsUrl,
        this.number,
        this.state,
        this.title,
        this.body,
        this.assignee,
        this.assignees,
        this.milestone,
        this.locked,
        newValue,
        this.head,
        this.base,
        this.user,
        this.statusesUrl,
        this.reviewCommentsUrl,
        this.reviewCommentUrl,
        this.commentsUrl,
        this.links,
        this.requestedReviewers,
        this.requestedTeams,
        this.mergeCommitSha,
        this.merged,
        this.mergeable,
        this.mergedBy,
        this.comments,
        this.reviewComments,
        this.commits,
        this.additions,
        this.deletions,
        this.changedFiles,
        this.mergeableState,
        this.draft);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link PullRequest#mergedAt() mergedAt} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for mergedAt
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutablePullRequest withMergedAt(Optional<? extends GitHubInstant> optional) {
    @Nullable GitHubInstant value = optional.orElse(null);
    if (this.mergedAt == value) return this;
    return new ImmutablePullRequest(
        this.createdAt,
        this.updatedAt,
        this.closedAt,
        this.id,
        this.url,
        this.htmlUrl,
        this.diffUrl,
        this.patchUrl,
        this.issueUrl,
        this.commitsUrl,
        this.number,
        this.state,
        this.title,
        this.body,
        this.assignee,
        this.assignees,
        this.milestone,
        this.locked,
        value,
        this.head,
        this.base,
        this.user,
        this.statusesUrl,
        this.reviewCommentsUrl,
        this.reviewCommentUrl,
        this.commentsUrl,
        this.links,
        this.requestedReviewers,
        this.requestedTeams,
        this.mergeCommitSha,
        this.merged,
        this.mergeable,
        this.mergedBy,
        this.comments,
        this.reviewComments,
        this.commits,
        this.additions,
        this.deletions,
        this.changedFiles,
        this.mergeableState,
        this.draft);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PullRequest#head() head} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for head (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePullRequest withHead(@Nullable PullRequestRef value) {
    if (this.head == value) return this;
    return new ImmutablePullRequest(
        this.createdAt,
        this.updatedAt,
        this.closedAt,
        this.id,
        this.url,
        this.htmlUrl,
        this.diffUrl,
        this.patchUrl,
        this.issueUrl,
        this.commitsUrl,
        this.number,
        this.state,
        this.title,
        this.body,
        this.assignee,
        this.assignees,
        this.milestone,
        this.locked,
        this.mergedAt,
        value,
        this.base,
        this.user,
        this.statusesUrl,
        this.reviewCommentsUrl,
        this.reviewCommentUrl,
        this.commentsUrl,
        this.links,
        this.requestedReviewers,
        this.requestedTeams,
        this.mergeCommitSha,
        this.merged,
        this.mergeable,
        this.mergedBy,
        this.comments,
        this.reviewComments,
        this.commits,
        this.additions,
        this.deletions,
        this.changedFiles,
        this.mergeableState,
        this.draft);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PullRequest#base() base} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for base (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePullRequest withBase(@Nullable PullRequestRef value) {
    if (this.base == value) return this;
    return new ImmutablePullRequest(
        this.createdAt,
        this.updatedAt,
        this.closedAt,
        this.id,
        this.url,
        this.htmlUrl,
        this.diffUrl,
        this.patchUrl,
        this.issueUrl,
        this.commitsUrl,
        this.number,
        this.state,
        this.title,
        this.body,
        this.assignee,
        this.assignees,
        this.milestone,
        this.locked,
        this.mergedAt,
        this.head,
        value,
        this.user,
        this.statusesUrl,
        this.reviewCommentsUrl,
        this.reviewCommentUrl,
        this.commentsUrl,
        this.links,
        this.requestedReviewers,
        this.requestedTeams,
        this.mergeCommitSha,
        this.merged,
        this.mergeable,
        this.mergedBy,
        this.comments,
        this.reviewComments,
        this.commits,
        this.additions,
        this.deletions,
        this.changedFiles,
        this.mergeableState,
        this.draft);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PullRequest#user() user} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for user (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePullRequest withUser(@Nullable User value) {
    if (this.user == value) return this;
    return new ImmutablePullRequest(
        this.createdAt,
        this.updatedAt,
        this.closedAt,
        this.id,
        this.url,
        this.htmlUrl,
        this.diffUrl,
        this.patchUrl,
        this.issueUrl,
        this.commitsUrl,
        this.number,
        this.state,
        this.title,
        this.body,
        this.assignee,
        this.assignees,
        this.milestone,
        this.locked,
        this.mergedAt,
        this.head,
        this.base,
        value,
        this.statusesUrl,
        this.reviewCommentsUrl,
        this.reviewCommentUrl,
        this.commentsUrl,
        this.links,
        this.requestedReviewers,
        this.requestedTeams,
        this.mergeCommitSha,
        this.merged,
        this.mergeable,
        this.mergedBy,
        this.comments,
        this.reviewComments,
        this.commits,
        this.additions,
        this.deletions,
        this.changedFiles,
        this.mergeableState,
        this.draft);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PullRequest#statusesUrl() statusesUrl} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for statusesUrl (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePullRequest withStatusesUrl(@Nullable URI value) {
    if (this.statusesUrl == value) return this;
    return new ImmutablePullRequest(
        this.createdAt,
        this.updatedAt,
        this.closedAt,
        this.id,
        this.url,
        this.htmlUrl,
        this.diffUrl,
        this.patchUrl,
        this.issueUrl,
        this.commitsUrl,
        this.number,
        this.state,
        this.title,
        this.body,
        this.assignee,
        this.assignees,
        this.milestone,
        this.locked,
        this.mergedAt,
        this.head,
        this.base,
        this.user,
        value,
        this.reviewCommentsUrl,
        this.reviewCommentUrl,
        this.commentsUrl,
        this.links,
        this.requestedReviewers,
        this.requestedTeams,
        this.mergeCommitSha,
        this.merged,
        this.mergeable,
        this.mergedBy,
        this.comments,
        this.reviewComments,
        this.commits,
        this.additions,
        this.deletions,
        this.changedFiles,
        this.mergeableState,
        this.draft);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PullRequest#reviewCommentsUrl() reviewCommentsUrl} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for reviewCommentsUrl (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePullRequest withReviewCommentsUrl(@Nullable URI value) {
    if (this.reviewCommentsUrl == value) return this;
    return new ImmutablePullRequest(
        this.createdAt,
        this.updatedAt,
        this.closedAt,
        this.id,
        this.url,
        this.htmlUrl,
        this.diffUrl,
        this.patchUrl,
        this.issueUrl,
        this.commitsUrl,
        this.number,
        this.state,
        this.title,
        this.body,
        this.assignee,
        this.assignees,
        this.milestone,
        this.locked,
        this.mergedAt,
        this.head,
        this.base,
        this.user,
        this.statusesUrl,
        value,
        this.reviewCommentUrl,
        this.commentsUrl,
        this.links,
        this.requestedReviewers,
        this.requestedTeams,
        this.mergeCommitSha,
        this.merged,
        this.mergeable,
        this.mergedBy,
        this.comments,
        this.reviewComments,
        this.commits,
        this.additions,
        this.deletions,
        this.changedFiles,
        this.mergeableState,
        this.draft);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PullRequest#reviewCommentUrl() reviewCommentUrl} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for reviewCommentUrl (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePullRequest withReviewCommentUrl(@Nullable String value) {
    if (Objects.equals(this.reviewCommentUrl, value)) return this;
    return new ImmutablePullRequest(
        this.createdAt,
        this.updatedAt,
        this.closedAt,
        this.id,
        this.url,
        this.htmlUrl,
        this.diffUrl,
        this.patchUrl,
        this.issueUrl,
        this.commitsUrl,
        this.number,
        this.state,
        this.title,
        this.body,
        this.assignee,
        this.assignees,
        this.milestone,
        this.locked,
        this.mergedAt,
        this.head,
        this.base,
        this.user,
        this.statusesUrl,
        this.reviewCommentsUrl,
        value,
        this.commentsUrl,
        this.links,
        this.requestedReviewers,
        this.requestedTeams,
        this.mergeCommitSha,
        this.merged,
        this.mergeable,
        this.mergedBy,
        this.comments,
        this.reviewComments,
        this.commits,
        this.additions,
        this.deletions,
        this.changedFiles,
        this.mergeableState,
        this.draft);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PullRequest#commentsUrl() commentsUrl} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for commentsUrl (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePullRequest withCommentsUrl(@Nullable URI value) {
    if (this.commentsUrl == value) return this;
    return new ImmutablePullRequest(
        this.createdAt,
        this.updatedAt,
        this.closedAt,
        this.id,
        this.url,
        this.htmlUrl,
        this.diffUrl,
        this.patchUrl,
        this.issueUrl,
        this.commitsUrl,
        this.number,
        this.state,
        this.title,
        this.body,
        this.assignee,
        this.assignees,
        this.milestone,
        this.locked,
        this.mergedAt,
        this.head,
        this.base,
        this.user,
        this.statusesUrl,
        this.reviewCommentsUrl,
        this.reviewCommentUrl,
        value,
        this.links,
        this.requestedReviewers,
        this.requestedTeams,
        this.mergeCommitSha,
        this.merged,
        this.mergeable,
        this.mergedBy,
        this.comments,
        this.reviewComments,
        this.commits,
        this.additions,
        this.deletions,
        this.changedFiles,
        this.mergeableState,
        this.draft);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PullRequest#links() links} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for links (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePullRequest withLinks(@Nullable PullRequestLinks value) {
    if (this.links == value) return this;
    return new ImmutablePullRequest(
        this.createdAt,
        this.updatedAt,
        this.closedAt,
        this.id,
        this.url,
        this.htmlUrl,
        this.diffUrl,
        this.patchUrl,
        this.issueUrl,
        this.commitsUrl,
        this.number,
        this.state,
        this.title,
        this.body,
        this.assignee,
        this.assignees,
        this.milestone,
        this.locked,
        this.mergedAt,
        this.head,
        this.base,
        this.user,
        this.statusesUrl,
        this.reviewCommentsUrl,
        this.reviewCommentUrl,
        this.commentsUrl,
        value,
        this.requestedReviewers,
        this.requestedTeams,
        this.mergeCommitSha,
        this.merged,
        this.mergeable,
        this.mergedBy,
        this.comments,
        this.reviewComments,
        this.commits,
        this.additions,
        this.deletions,
        this.changedFiles,
        this.mergeableState,
        this.draft);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link PullRequest#requestedReviewers() requestedReviewers}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePullRequest withRequestedReviewers(@Nullable User... elements) {
    if (elements == null) {
      return new ImmutablePullRequest(
          this.createdAt,
          this.updatedAt,
          this.closedAt,
          this.id,
          this.url,
          this.htmlUrl,
          this.diffUrl,
          this.patchUrl,
          this.issueUrl,
          this.commitsUrl,
          this.number,
          this.state,
          this.title,
          this.body,
          this.assignee,
          this.assignees,
          this.milestone,
          this.locked,
          this.mergedAt,
          this.head,
          this.base,
          this.user,
          this.statusesUrl,
          this.reviewCommentsUrl,
          this.reviewCommentUrl,
          this.commentsUrl,
          this.links,
          null,
          this.requestedTeams,
          this.mergeCommitSha,
          this.merged,
          this.mergeable,
          this.mergedBy,
          this.comments,
          this.reviewComments,
          this.commits,
          this.additions,
          this.deletions,
          this.changedFiles,
          this.mergeableState,
          this.draft);
    }
    @Nullable List<User> newValue = Arrays.asList(elements) == null ? null : createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutablePullRequest(
        this.createdAt,
        this.updatedAt,
        this.closedAt,
        this.id,
        this.url,
        this.htmlUrl,
        this.diffUrl,
        this.patchUrl,
        this.issueUrl,
        this.commitsUrl,
        this.number,
        this.state,
        this.title,
        this.body,
        this.assignee,
        this.assignees,
        this.milestone,
        this.locked,
        this.mergedAt,
        this.head,
        this.base,
        this.user,
        this.statusesUrl,
        this.reviewCommentsUrl,
        this.reviewCommentUrl,
        this.commentsUrl,
        this.links,
        newValue,
        this.requestedTeams,
        this.mergeCommitSha,
        this.merged,
        this.mergeable,
        this.mergedBy,
        this.comments,
        this.reviewComments,
        this.commits,
        this.additions,
        this.deletions,
        this.changedFiles,
        this.mergeableState,
        this.draft);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link PullRequest#requestedReviewers() requestedReviewers}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of requestedReviewers elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePullRequest withRequestedReviewers(@Nullable Iterable<? extends User> elements) {
    if (this.requestedReviewers == elements) return this;
    @Nullable List<User> newValue = elements == null ? null : createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutablePullRequest(
        this.createdAt,
        this.updatedAt,
        this.closedAt,
        this.id,
        this.url,
        this.htmlUrl,
        this.diffUrl,
        this.patchUrl,
        this.issueUrl,
        this.commitsUrl,
        this.number,
        this.state,
        this.title,
        this.body,
        this.assignee,
        this.assignees,
        this.milestone,
        this.locked,
        this.mergedAt,
        this.head,
        this.base,
        this.user,
        this.statusesUrl,
        this.reviewCommentsUrl,
        this.reviewCommentUrl,
        this.commentsUrl,
        this.links,
        newValue,
        this.requestedTeams,
        this.mergeCommitSha,
        this.merged,
        this.mergeable,
        this.mergedBy,
        this.comments,
        this.reviewComments,
        this.commits,
        this.additions,
        this.deletions,
        this.changedFiles,
        this.mergeableState,
        this.draft);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link PullRequest#requestedTeams() requestedTeams}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePullRequest withRequestedTeams(@Nullable User... elements) {
    if (elements == null) {
      return new ImmutablePullRequest(
          this.createdAt,
          this.updatedAt,
          this.closedAt,
          this.id,
          this.url,
          this.htmlUrl,
          this.diffUrl,
          this.patchUrl,
          this.issueUrl,
          this.commitsUrl,
          this.number,
          this.state,
          this.title,
          this.body,
          this.assignee,
          this.assignees,
          this.milestone,
          this.locked,
          this.mergedAt,
          this.head,
          this.base,
          this.user,
          this.statusesUrl,
          this.reviewCommentsUrl,
          this.reviewCommentUrl,
          this.commentsUrl,
          this.links,
          this.requestedReviewers,
          null,
          this.mergeCommitSha,
          this.merged,
          this.mergeable,
          this.mergedBy,
          this.comments,
          this.reviewComments,
          this.commits,
          this.additions,
          this.deletions,
          this.changedFiles,
          this.mergeableState,
          this.draft);
    }
    @Nullable List<User> newValue = Arrays.asList(elements) == null ? null : createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutablePullRequest(
        this.createdAt,
        this.updatedAt,
        this.closedAt,
        this.id,
        this.url,
        this.htmlUrl,
        this.diffUrl,
        this.patchUrl,
        this.issueUrl,
        this.commitsUrl,
        this.number,
        this.state,
        this.title,
        this.body,
        this.assignee,
        this.assignees,
        this.milestone,
        this.locked,
        this.mergedAt,
        this.head,
        this.base,
        this.user,
        this.statusesUrl,
        this.reviewCommentsUrl,
        this.reviewCommentUrl,
        this.commentsUrl,
        this.links,
        this.requestedReviewers,
        newValue,
        this.mergeCommitSha,
        this.merged,
        this.mergeable,
        this.mergedBy,
        this.comments,
        this.reviewComments,
        this.commits,
        this.additions,
        this.deletions,
        this.changedFiles,
        this.mergeableState,
        this.draft);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link PullRequest#requestedTeams() requestedTeams}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of requestedTeams elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePullRequest withRequestedTeams(@Nullable Iterable<? extends User> elements) {
    if (this.requestedTeams == elements) return this;
    @Nullable List<User> newValue = elements == null ? null : createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutablePullRequest(
        this.createdAt,
        this.updatedAt,
        this.closedAt,
        this.id,
        this.url,
        this.htmlUrl,
        this.diffUrl,
        this.patchUrl,
        this.issueUrl,
        this.commitsUrl,
        this.number,
        this.state,
        this.title,
        this.body,
        this.assignee,
        this.assignees,
        this.milestone,
        this.locked,
        this.mergedAt,
        this.head,
        this.base,
        this.user,
        this.statusesUrl,
        this.reviewCommentsUrl,
        this.reviewCommentUrl,
        this.commentsUrl,
        this.links,
        this.requestedReviewers,
        newValue,
        this.mergeCommitSha,
        this.merged,
        this.mergeable,
        this.mergedBy,
        this.comments,
        this.reviewComments,
        this.commits,
        this.additions,
        this.deletions,
        this.changedFiles,
        this.mergeableState,
        this.draft);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link PullRequest#mergeCommitSha() mergeCommitSha} attribute.
   * @param value The value for mergeCommitSha
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePullRequest withMergeCommitSha(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "mergeCommitSha");
    if (Objects.equals(this.mergeCommitSha, newValue)) return this;
    return new ImmutablePullRequest(
        this.createdAt,
        this.updatedAt,
        this.closedAt,
        this.id,
        this.url,
        this.htmlUrl,
        this.diffUrl,
        this.patchUrl,
        this.issueUrl,
        this.commitsUrl,
        this.number,
        this.state,
        this.title,
        this.body,
        this.assignee,
        this.assignees,
        this.milestone,
        this.locked,
        this.mergedAt,
        this.head,
        this.base,
        this.user,
        this.statusesUrl,
        this.reviewCommentsUrl,
        this.reviewCommentUrl,
        this.commentsUrl,
        this.links,
        this.requestedReviewers,
        this.requestedTeams,
        newValue,
        this.merged,
        this.mergeable,
        this.mergedBy,
        this.comments,
        this.reviewComments,
        this.commits,
        this.additions,
        this.deletions,
        this.changedFiles,
        this.mergeableState,
        this.draft);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link PullRequest#mergeCommitSha() mergeCommitSha} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for mergeCommitSha
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePullRequest withMergeCommitSha(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.mergeCommitSha, value)) return this;
    return new ImmutablePullRequest(
        this.createdAt,
        this.updatedAt,
        this.closedAt,
        this.id,
        this.url,
        this.htmlUrl,
        this.diffUrl,
        this.patchUrl,
        this.issueUrl,
        this.commitsUrl,
        this.number,
        this.state,
        this.title,
        this.body,
        this.assignee,
        this.assignees,
        this.milestone,
        this.locked,
        this.mergedAt,
        this.head,
        this.base,
        this.user,
        this.statusesUrl,
        this.reviewCommentsUrl,
        this.reviewCommentUrl,
        this.commentsUrl,
        this.links,
        this.requestedReviewers,
        this.requestedTeams,
        value,
        this.merged,
        this.mergeable,
        this.mergedBy,
        this.comments,
        this.reviewComments,
        this.commits,
        this.additions,
        this.deletions,
        this.changedFiles,
        this.mergeableState,
        this.draft);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PullRequest#merged() merged} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for merged (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePullRequest withMerged(@Nullable Boolean value) {
    if (Objects.equals(this.merged, value)) return this;
    return new ImmutablePullRequest(
        this.createdAt,
        this.updatedAt,
        this.closedAt,
        this.id,
        this.url,
        this.htmlUrl,
        this.diffUrl,
        this.patchUrl,
        this.issueUrl,
        this.commitsUrl,
        this.number,
        this.state,
        this.title,
        this.body,
        this.assignee,
        this.assignees,
        this.milestone,
        this.locked,
        this.mergedAt,
        this.head,
        this.base,
        this.user,
        this.statusesUrl,
        this.reviewCommentsUrl,
        this.reviewCommentUrl,
        this.commentsUrl,
        this.links,
        this.requestedReviewers,
        this.requestedTeams,
        this.mergeCommitSha,
        value,
        this.mergeable,
        this.mergedBy,
        this.comments,
        this.reviewComments,
        this.commits,
        this.additions,
        this.deletions,
        this.changedFiles,
        this.mergeableState,
        this.draft);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link PullRequest#mergeable() mergeable} attribute.
   * @param value The value for mergeable
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePullRequest withMergeable(boolean value) {
    @Nullable Boolean newValue = value;
    if (Objects.equals(this.mergeable, newValue)) return this;
    return new ImmutablePullRequest(
        this.createdAt,
        this.updatedAt,
        this.closedAt,
        this.id,
        this.url,
        this.htmlUrl,
        this.diffUrl,
        this.patchUrl,
        this.issueUrl,
        this.commitsUrl,
        this.number,
        this.state,
        this.title,
        this.body,
        this.assignee,
        this.assignees,
        this.milestone,
        this.locked,
        this.mergedAt,
        this.head,
        this.base,
        this.user,
        this.statusesUrl,
        this.reviewCommentsUrl,
        this.reviewCommentUrl,
        this.commentsUrl,
        this.links,
        this.requestedReviewers,
        this.requestedTeams,
        this.mergeCommitSha,
        this.merged,
        newValue,
        this.mergedBy,
        this.comments,
        this.reviewComments,
        this.commits,
        this.additions,
        this.deletions,
        this.changedFiles,
        this.mergeableState,
        this.draft);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link PullRequest#mergeable() mergeable} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for mergeable
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePullRequest withMergeable(Optional<Boolean> optional) {
    @Nullable Boolean value = optional.orElse(null);
    if (Objects.equals(this.mergeable, value)) return this;
    return new ImmutablePullRequest(
        this.createdAt,
        this.updatedAt,
        this.closedAt,
        this.id,
        this.url,
        this.htmlUrl,
        this.diffUrl,
        this.patchUrl,
        this.issueUrl,
        this.commitsUrl,
        this.number,
        this.state,
        this.title,
        this.body,
        this.assignee,
        this.assignees,
        this.milestone,
        this.locked,
        this.mergedAt,
        this.head,
        this.base,
        this.user,
        this.statusesUrl,
        this.reviewCommentsUrl,
        this.reviewCommentUrl,
        this.commentsUrl,
        this.links,
        this.requestedReviewers,
        this.requestedTeams,
        this.mergeCommitSha,
        this.merged,
        value,
        this.mergedBy,
        this.comments,
        this.reviewComments,
        this.commits,
        this.additions,
        this.deletions,
        this.changedFiles,
        this.mergeableState,
        this.draft);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link PullRequest#mergedBy() mergedBy} attribute.
   * @param value The value for mergedBy
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePullRequest withMergedBy(User value) {
    @Nullable User newValue = Objects.requireNonNull(value, "mergedBy");
    if (this.mergedBy == newValue) return this;
    return new ImmutablePullRequest(
        this.createdAt,
        this.updatedAt,
        this.closedAt,
        this.id,
        this.url,
        this.htmlUrl,
        this.diffUrl,
        this.patchUrl,
        this.issueUrl,
        this.commitsUrl,
        this.number,
        this.state,
        this.title,
        this.body,
        this.assignee,
        this.assignees,
        this.milestone,
        this.locked,
        this.mergedAt,
        this.head,
        this.base,
        this.user,
        this.statusesUrl,
        this.reviewCommentsUrl,
        this.reviewCommentUrl,
        this.commentsUrl,
        this.links,
        this.requestedReviewers,
        this.requestedTeams,
        this.mergeCommitSha,
        this.merged,
        this.mergeable,
        newValue,
        this.comments,
        this.reviewComments,
        this.commits,
        this.additions,
        this.deletions,
        this.changedFiles,
        this.mergeableState,
        this.draft);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link PullRequest#mergedBy() mergedBy} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for mergedBy
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutablePullRequest withMergedBy(Optional<? extends User> optional) {
    @Nullable User value = optional.orElse(null);
    if (this.mergedBy == value) return this;
    return new ImmutablePullRequest(
        this.createdAt,
        this.updatedAt,
        this.closedAt,
        this.id,
        this.url,
        this.htmlUrl,
        this.diffUrl,
        this.patchUrl,
        this.issueUrl,
        this.commitsUrl,
        this.number,
        this.state,
        this.title,
        this.body,
        this.assignee,
        this.assignees,
        this.milestone,
        this.locked,
        this.mergedAt,
        this.head,
        this.base,
        this.user,
        this.statusesUrl,
        this.reviewCommentsUrl,
        this.reviewCommentUrl,
        this.commentsUrl,
        this.links,
        this.requestedReviewers,
        this.requestedTeams,
        this.mergeCommitSha,
        this.merged,
        this.mergeable,
        value,
        this.comments,
        this.reviewComments,
        this.commits,
        this.additions,
        this.deletions,
        this.changedFiles,
        this.mergeableState,
        this.draft);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PullRequest#comments() comments} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for comments (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePullRequest withComments(@Nullable Integer value) {
    if (Objects.equals(this.comments, value)) return this;
    return new ImmutablePullRequest(
        this.createdAt,
        this.updatedAt,
        this.closedAt,
        this.id,
        this.url,
        this.htmlUrl,
        this.diffUrl,
        this.patchUrl,
        this.issueUrl,
        this.commitsUrl,
        this.number,
        this.state,
        this.title,
        this.body,
        this.assignee,
        this.assignees,
        this.milestone,
        this.locked,
        this.mergedAt,
        this.head,
        this.base,
        this.user,
        this.statusesUrl,
        this.reviewCommentsUrl,
        this.reviewCommentUrl,
        this.commentsUrl,
        this.links,
        this.requestedReviewers,
        this.requestedTeams,
        this.mergeCommitSha,
        this.merged,
        this.mergeable,
        this.mergedBy,
        value,
        this.reviewComments,
        this.commits,
        this.additions,
        this.deletions,
        this.changedFiles,
        this.mergeableState,
        this.draft);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PullRequest#reviewComments() reviewComments} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for reviewComments (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePullRequest withReviewComments(@Nullable Integer value) {
    if (Objects.equals(this.reviewComments, value)) return this;
    return new ImmutablePullRequest(
        this.createdAt,
        this.updatedAt,
        this.closedAt,
        this.id,
        this.url,
        this.htmlUrl,
        this.diffUrl,
        this.patchUrl,
        this.issueUrl,
        this.commitsUrl,
        this.number,
        this.state,
        this.title,
        this.body,
        this.assignee,
        this.assignees,
        this.milestone,
        this.locked,
        this.mergedAt,
        this.head,
        this.base,
        this.user,
        this.statusesUrl,
        this.reviewCommentsUrl,
        this.reviewCommentUrl,
        this.commentsUrl,
        this.links,
        this.requestedReviewers,
        this.requestedTeams,
        this.mergeCommitSha,
        this.merged,
        this.mergeable,
        this.mergedBy,
        this.comments,
        value,
        this.commits,
        this.additions,
        this.deletions,
        this.changedFiles,
        this.mergeableState,
        this.draft);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PullRequest#commits() commits} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for commits (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePullRequest withCommits(@Nullable Integer value) {
    if (Objects.equals(this.commits, value)) return this;
    return new ImmutablePullRequest(
        this.createdAt,
        this.updatedAt,
        this.closedAt,
        this.id,
        this.url,
        this.htmlUrl,
        this.diffUrl,
        this.patchUrl,
        this.issueUrl,
        this.commitsUrl,
        this.number,
        this.state,
        this.title,
        this.body,
        this.assignee,
        this.assignees,
        this.milestone,
        this.locked,
        this.mergedAt,
        this.head,
        this.base,
        this.user,
        this.statusesUrl,
        this.reviewCommentsUrl,
        this.reviewCommentUrl,
        this.commentsUrl,
        this.links,
        this.requestedReviewers,
        this.requestedTeams,
        this.mergeCommitSha,
        this.merged,
        this.mergeable,
        this.mergedBy,
        this.comments,
        this.reviewComments,
        value,
        this.additions,
        this.deletions,
        this.changedFiles,
        this.mergeableState,
        this.draft);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PullRequest#additions() additions} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for additions (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePullRequest withAdditions(@Nullable Integer value) {
    if (Objects.equals(this.additions, value)) return this;
    return new ImmutablePullRequest(
        this.createdAt,
        this.updatedAt,
        this.closedAt,
        this.id,
        this.url,
        this.htmlUrl,
        this.diffUrl,
        this.patchUrl,
        this.issueUrl,
        this.commitsUrl,
        this.number,
        this.state,
        this.title,
        this.body,
        this.assignee,
        this.assignees,
        this.milestone,
        this.locked,
        this.mergedAt,
        this.head,
        this.base,
        this.user,
        this.statusesUrl,
        this.reviewCommentsUrl,
        this.reviewCommentUrl,
        this.commentsUrl,
        this.links,
        this.requestedReviewers,
        this.requestedTeams,
        this.mergeCommitSha,
        this.merged,
        this.mergeable,
        this.mergedBy,
        this.comments,
        this.reviewComments,
        this.commits,
        value,
        this.deletions,
        this.changedFiles,
        this.mergeableState,
        this.draft);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PullRequest#deletions() deletions} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for deletions (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePullRequest withDeletions(@Nullable Integer value) {
    if (Objects.equals(this.deletions, value)) return this;
    return new ImmutablePullRequest(
        this.createdAt,
        this.updatedAt,
        this.closedAt,
        this.id,
        this.url,
        this.htmlUrl,
        this.diffUrl,
        this.patchUrl,
        this.issueUrl,
        this.commitsUrl,
        this.number,
        this.state,
        this.title,
        this.body,
        this.assignee,
        this.assignees,
        this.milestone,
        this.locked,
        this.mergedAt,
        this.head,
        this.base,
        this.user,
        this.statusesUrl,
        this.reviewCommentsUrl,
        this.reviewCommentUrl,
        this.commentsUrl,
        this.links,
        this.requestedReviewers,
        this.requestedTeams,
        this.mergeCommitSha,
        this.merged,
        this.mergeable,
        this.mergedBy,
        this.comments,
        this.reviewComments,
        this.commits,
        this.additions,
        value,
        this.changedFiles,
        this.mergeableState,
        this.draft);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PullRequest#changedFiles() changedFiles} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for changedFiles (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePullRequest withChangedFiles(@Nullable Integer value) {
    if (Objects.equals(this.changedFiles, value)) return this;
    return new ImmutablePullRequest(
        this.createdAt,
        this.updatedAt,
        this.closedAt,
        this.id,
        this.url,
        this.htmlUrl,
        this.diffUrl,
        this.patchUrl,
        this.issueUrl,
        this.commitsUrl,
        this.number,
        this.state,
        this.title,
        this.body,
        this.assignee,
        this.assignees,
        this.milestone,
        this.locked,
        this.mergedAt,
        this.head,
        this.base,
        this.user,
        this.statusesUrl,
        this.reviewCommentsUrl,
        this.reviewCommentUrl,
        this.commentsUrl,
        this.links,
        this.requestedReviewers,
        this.requestedTeams,
        this.mergeCommitSha,
        this.merged,
        this.mergeable,
        this.mergedBy,
        this.comments,
        this.reviewComments,
        this.commits,
        this.additions,
        this.deletions,
        value,
        this.mergeableState,
        this.draft);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PullRequest#mergeableState() mergeableState} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for mergeableState (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePullRequest withMergeableState(@Nullable String value) {
    if (Objects.equals(this.mergeableState, value)) return this;
    return new ImmutablePullRequest(
        this.createdAt,
        this.updatedAt,
        this.closedAt,
        this.id,
        this.url,
        this.htmlUrl,
        this.diffUrl,
        this.patchUrl,
        this.issueUrl,
        this.commitsUrl,
        this.number,
        this.state,
        this.title,
        this.body,
        this.assignee,
        this.assignees,
        this.milestone,
        this.locked,
        this.mergedAt,
        this.head,
        this.base,
        this.user,
        this.statusesUrl,
        this.reviewCommentsUrl,
        this.reviewCommentUrl,
        this.commentsUrl,
        this.links,
        this.requestedReviewers,
        this.requestedTeams,
        this.mergeCommitSha,
        this.merged,
        this.mergeable,
        this.mergedBy,
        this.comments,
        this.reviewComments,
        this.commits,
        this.additions,
        this.deletions,
        this.changedFiles,
        value,
        this.draft);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link PullRequest#draft() draft} attribute.
   * @param value The value for draft
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePullRequest withDraft(boolean value) {
    @Nullable Boolean newValue = value;
    if (Objects.equals(this.draft, newValue)) return this;
    return new ImmutablePullRequest(
        this.createdAt,
        this.updatedAt,
        this.closedAt,
        this.id,
        this.url,
        this.htmlUrl,
        this.diffUrl,
        this.patchUrl,
        this.issueUrl,
        this.commitsUrl,
        this.number,
        this.state,
        this.title,
        this.body,
        this.assignee,
        this.assignees,
        this.milestone,
        this.locked,
        this.mergedAt,
        this.head,
        this.base,
        this.user,
        this.statusesUrl,
        this.reviewCommentsUrl,
        this.reviewCommentUrl,
        this.commentsUrl,
        this.links,
        this.requestedReviewers,
        this.requestedTeams,
        this.mergeCommitSha,
        this.merged,
        this.mergeable,
        this.mergedBy,
        this.comments,
        this.reviewComments,
        this.commits,
        this.additions,
        this.deletions,
        this.changedFiles,
        this.mergeableState,
        newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link PullRequest#draft() draft} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for draft
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePullRequest withDraft(Optional<Boolean> optional) {
    @Nullable Boolean value = optional.orElse(null);
    if (Objects.equals(this.draft, value)) return this;
    return new ImmutablePullRequest(
        this.createdAt,
        this.updatedAt,
        this.closedAt,
        this.id,
        this.url,
        this.htmlUrl,
        this.diffUrl,
        this.patchUrl,
        this.issueUrl,
        this.commitsUrl,
        this.number,
        this.state,
        this.title,
        this.body,
        this.assignee,
        this.assignees,
        this.milestone,
        this.locked,
        this.mergedAt,
        this.head,
        this.base,
        this.user,
        this.statusesUrl,
        this.reviewCommentsUrl,
        this.reviewCommentUrl,
        this.commentsUrl,
        this.links,
        this.requestedReviewers,
        this.requestedTeams,
        this.mergeCommitSha,
        this.merged,
        this.mergeable,
        this.mergedBy,
        this.comments,
        this.reviewComments,
        this.commits,
        this.additions,
        this.deletions,
        this.changedFiles,
        this.mergeableState,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutablePullRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutablePullRequest
        && equalTo((ImmutablePullRequest) another);
  }

  private boolean equalTo(ImmutablePullRequest another) {
    return Objects.equals(createdAt, another.createdAt)
        && Objects.equals(updatedAt, another.updatedAt)
        && Objects.equals(closedAt, another.closedAt)
        && Objects.equals(id, another.id)
        && Objects.equals(url, another.url)
        && Objects.equals(htmlUrl, another.htmlUrl)
        && Objects.equals(diffUrl, another.diffUrl)
        && Objects.equals(patchUrl, another.patchUrl)
        && Objects.equals(issueUrl, another.issueUrl)
        && Objects.equals(commitsUrl, another.commitsUrl)
        && Objects.equals(number, another.number)
        && Objects.equals(state, another.state)
        && Objects.equals(title, another.title)
        && Objects.equals(body, another.body)
        && Objects.equals(assignee, another.assignee)
        && Objects.equals(assignees, another.assignees)
        && Objects.equals(milestone, another.milestone)
        && Objects.equals(locked, another.locked)
        && Objects.equals(mergedAt, another.mergedAt)
        && Objects.equals(head, another.head)
        && Objects.equals(base, another.base)
        && Objects.equals(user, another.user)
        && Objects.equals(statusesUrl, another.statusesUrl)
        && Objects.equals(reviewCommentsUrl, another.reviewCommentsUrl)
        && Objects.equals(reviewCommentUrl, another.reviewCommentUrl)
        && Objects.equals(commentsUrl, another.commentsUrl)
        && Objects.equals(links, another.links)
        && Objects.equals(requestedReviewers, another.requestedReviewers)
        && Objects.equals(requestedTeams, another.requestedTeams)
        && Objects.equals(mergeCommitSha, another.mergeCommitSha)
        && Objects.equals(merged, another.merged)
        && Objects.equals(mergeable, another.mergeable)
        && Objects.equals(mergedBy, another.mergedBy)
        && Objects.equals(comments, another.comments)
        && Objects.equals(reviewComments, another.reviewComments)
        && Objects.equals(commits, another.commits)
        && Objects.equals(additions, another.additions)
        && Objects.equals(deletions, another.deletions)
        && Objects.equals(changedFiles, another.changedFiles)
        && Objects.equals(mergeableState, another.mergeableState)
        && Objects.equals(draft, another.draft);
  }

  /**
   * Computes a hash code from attributes: {@code createdAt}, {@code updatedAt}, {@code closedAt}, {@code id}, {@code url}, {@code htmlUrl}, {@code diffUrl}, {@code patchUrl}, {@code issueUrl}, {@code commitsUrl}, {@code number}, {@code state}, {@code title}, {@code body}, {@code assignee}, {@code assignees}, {@code milestone}, {@code locked}, {@code mergedAt}, {@code head}, {@code base}, {@code user}, {@code statusesUrl}, {@code reviewCommentsUrl}, {@code reviewCommentUrl}, {@code commentsUrl}, {@code links}, {@code requestedReviewers}, {@code requestedTeams}, {@code mergeCommitSha}, {@code merged}, {@code mergeable}, {@code mergedBy}, {@code comments}, {@code reviewComments}, {@code commits}, {@code additions}, {@code deletions}, {@code changedFiles}, {@code mergeableState}, {@code draft}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(createdAt);
    h += (h << 5) + Objects.hashCode(updatedAt);
    h += (h << 5) + Objects.hashCode(closedAt);
    h += (h << 5) + Objects.hashCode(id);
    h += (h << 5) + Objects.hashCode(url);
    h += (h << 5) + Objects.hashCode(htmlUrl);
    h += (h << 5) + Objects.hashCode(diffUrl);
    h += (h << 5) + Objects.hashCode(patchUrl);
    h += (h << 5) + Objects.hashCode(issueUrl);
    h += (h << 5) + Objects.hashCode(commitsUrl);
    h += (h << 5) + Objects.hashCode(number);
    h += (h << 5) + Objects.hashCode(state);
    h += (h << 5) + Objects.hashCode(title);
    h += (h << 5) + Objects.hashCode(body);
    h += (h << 5) + Objects.hashCode(assignee);
    h += (h << 5) + Objects.hashCode(assignees);
    h += (h << 5) + Objects.hashCode(milestone);
    h += (h << 5) + Objects.hashCode(locked);
    h += (h << 5) + Objects.hashCode(mergedAt);
    h += (h << 5) + Objects.hashCode(head);
    h += (h << 5) + Objects.hashCode(base);
    h += (h << 5) + Objects.hashCode(user);
    h += (h << 5) + Objects.hashCode(statusesUrl);
    h += (h << 5) + Objects.hashCode(reviewCommentsUrl);
    h += (h << 5) + Objects.hashCode(reviewCommentUrl);
    h += (h << 5) + Objects.hashCode(commentsUrl);
    h += (h << 5) + Objects.hashCode(links);
    h += (h << 5) + Objects.hashCode(requestedReviewers);
    h += (h << 5) + Objects.hashCode(requestedTeams);
    h += (h << 5) + Objects.hashCode(mergeCommitSha);
    h += (h << 5) + Objects.hashCode(merged);
    h += (h << 5) + Objects.hashCode(mergeable);
    h += (h << 5) + Objects.hashCode(mergedBy);
    h += (h << 5) + Objects.hashCode(comments);
    h += (h << 5) + Objects.hashCode(reviewComments);
    h += (h << 5) + Objects.hashCode(commits);
    h += (h << 5) + Objects.hashCode(additions);
    h += (h << 5) + Objects.hashCode(deletions);
    h += (h << 5) + Objects.hashCode(changedFiles);
    h += (h << 5) + Objects.hashCode(mergeableState);
    h += (h << 5) + Objects.hashCode(draft);
    return h;
  }

  /**
   * Prints the immutable value {@code PullRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("PullRequest{");
    if (createdAt != null) {
      builder.append("createdAt=").append(createdAt);
    }
    if (updatedAt != null) {
      if (builder.length() > 12) builder.append(", ");
      builder.append("updatedAt=").append(updatedAt);
    }
    if (closedAt != null) {
      if (builder.length() > 12) builder.append(", ");
      builder.append("closedAt=").append(closedAt);
    }
    if (id != null) {
      if (builder.length() > 12) builder.append(", ");
      builder.append("id=").append(id);
    }
    if (url != null) {
      if (builder.length() > 12) builder.append(", ");
      builder.append("url=").append(url);
    }
    if (htmlUrl != null) {
      if (builder.length() > 12) builder.append(", ");
      builder.append("htmlUrl=").append(htmlUrl);
    }
    if (diffUrl != null) {
      if (builder.length() > 12) builder.append(", ");
      builder.append("diffUrl=").append(diffUrl);
    }
    if (patchUrl != null) {
      if (builder.length() > 12) builder.append(", ");
      builder.append("patchUrl=").append(patchUrl);
    }
    if (issueUrl != null) {
      if (builder.length() > 12) builder.append(", ");
      builder.append("issueUrl=").append(issueUrl);
    }
    if (commitsUrl != null) {
      if (builder.length() > 12) builder.append(", ");
      builder.append("commitsUrl=").append(commitsUrl);
    }
    if (number != null) {
      if (builder.length() > 12) builder.append(", ");
      builder.append("number=").append(number);
    }
    if (state != null) {
      if (builder.length() > 12) builder.append(", ");
      builder.append("state=").append(state);
    }
    if (title != null) {
      if (builder.length() > 12) builder.append(", ");
      builder.append("title=").append(title);
    }
    if (body != null) {
      if (builder.length() > 12) builder.append(", ");
      builder.append("body=").append(body);
    }
    if (assignee != null) {
      if (builder.length() > 12) builder.append(", ");
      builder.append("assignee=").append(assignee);
    }
    if (assignees != null) {
      if (builder.length() > 12) builder.append(", ");
      builder.append("assignees=").append(assignees);
    }
    if (milestone != null) {
      if (builder.length() > 12) builder.append(", ");
      builder.append("milestone=").append(milestone);
    }
    if (locked != null) {
      if (builder.length() > 12) builder.append(", ");
      builder.append("locked=").append(locked);
    }
    if (mergedAt != null) {
      if (builder.length() > 12) builder.append(", ");
      builder.append("mergedAt=").append(mergedAt);
    }
    if (head != null) {
      if (builder.length() > 12) builder.append(", ");
      builder.append("head=").append(head);
    }
    if (base != null) {
      if (builder.length() > 12) builder.append(", ");
      builder.append("base=").append(base);
    }
    if (user != null) {
      if (builder.length() > 12) builder.append(", ");
      builder.append("user=").append(user);
    }
    if (statusesUrl != null) {
      if (builder.length() > 12) builder.append(", ");
      builder.append("statusesUrl=").append(statusesUrl);
    }
    if (reviewCommentsUrl != null) {
      if (builder.length() > 12) builder.append(", ");
      builder.append("reviewCommentsUrl=").append(reviewCommentsUrl);
    }
    if (reviewCommentUrl != null) {
      if (builder.length() > 12) builder.append(", ");
      builder.append("reviewCommentUrl=").append(reviewCommentUrl);
    }
    if (commentsUrl != null) {
      if (builder.length() > 12) builder.append(", ");
      builder.append("commentsUrl=").append(commentsUrl);
    }
    if (links != null) {
      if (builder.length() > 12) builder.append(", ");
      builder.append("links=").append(links);
    }
    if (requestedReviewers != null) {
      if (builder.length() > 12) builder.append(", ");
      builder.append("requestedReviewers=").append(requestedReviewers);
    }
    if (requestedTeams != null) {
      if (builder.length() > 12) builder.append(", ");
      builder.append("requestedTeams=").append(requestedTeams);
    }
    if (mergeCommitSha != null) {
      if (builder.length() > 12) builder.append(", ");
      builder.append("mergeCommitSha=").append(mergeCommitSha);
    }
    if (merged != null) {
      if (builder.length() > 12) builder.append(", ");
      builder.append("merged=").append(merged);
    }
    if (mergeable != null) {
      if (builder.length() > 12) builder.append(", ");
      builder.append("mergeable=").append(mergeable);
    }
    if (mergedBy != null) {
      if (builder.length() > 12) builder.append(", ");
      builder.append("mergedBy=").append(mergedBy);
    }
    if (comments != null) {
      if (builder.length() > 12) builder.append(", ");
      builder.append("comments=").append(comments);
    }
    if (reviewComments != null) {
      if (builder.length() > 12) builder.append(", ");
      builder.append("reviewComments=").append(reviewComments);
    }
    if (commits != null) {
      if (builder.length() > 12) builder.append(", ");
      builder.append("commits=").append(commits);
    }
    if (additions != null) {
      if (builder.length() > 12) builder.append(", ");
      builder.append("additions=").append(additions);
    }
    if (deletions != null) {
      if (builder.length() > 12) builder.append(", ");
      builder.append("deletions=").append(deletions);
    }
    if (changedFiles != null) {
      if (builder.length() > 12) builder.append(", ");
      builder.append("changedFiles=").append(changedFiles);
    }
    if (mergeableState != null) {
      if (builder.length() > 12) builder.append(", ");
      builder.append("mergeableState=").append(mergeableState);
    }
    if (draft != null) {
      if (builder.length() > 12) builder.append(", ");
      builder.append("draft=").append(draft);
    }
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "PullRequest", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements PullRequest {
    @Nullable GitHubInstant createdAt;
    @Nullable GitHubInstant updatedAt;
    @Nullable Optional<GitHubInstant> closedAt = Optional.empty();
    @Nullable Integer id;
    @Nullable URI url;
    @Nullable URI htmlUrl;
    @Nullable URI diffUrl;
    @Nullable URI patchUrl;
    @Nullable URI issueUrl;
    @Nullable URI commitsUrl;
    @Nullable Integer number;
    @Nullable String state;
    @Nullable String title;
    @Nullable Optional<String> body = Optional.empty();
    @Nullable Optional<User> assignee = Optional.empty();
    @Nullable Optional<List<User>> assignees = Optional.empty();
    @Nullable Optional<Milestone> milestone = Optional.empty();
    @Nullable Boolean locked;
    @Nullable Optional<GitHubInstant> mergedAt = Optional.empty();
    @Nullable PullRequestRef head;
    @Nullable PullRequestRef base;
    @Nullable User user;
    @Nullable URI statusesUrl;
    @Nullable URI reviewCommentsUrl;
    @Nullable String reviewCommentUrl;
    @Nullable URI commentsUrl;
    @Nullable PullRequestLinks links;
    @Nullable List<User> requestedReviewers = null;
    @Nullable List<User> requestedTeams = null;
    @Nullable Optional<String> mergeCommitSha = Optional.empty();
    @Nullable Boolean merged;
    @Nullable Optional<Boolean> mergeable = Optional.empty();
    @Nullable Optional<User> mergedBy = Optional.empty();
    @Nullable Integer comments;
    @Nullable Integer reviewComments;
    @Nullable Integer commits;
    @Nullable Integer additions;
    @Nullable Integer deletions;
    @Nullable Integer changedFiles;
    @Nullable String mergeableState;
    @Nullable Optional<Boolean> draft = Optional.empty();
    @JsonProperty
    public void setCreatedAt(@Nullable GitHubInstant createdAt) {
      this.createdAt = createdAt;
    }
    @JsonProperty
    public void setUpdatedAt(@Nullable GitHubInstant updatedAt) {
      this.updatedAt = updatedAt;
    }
    @JsonProperty
    public void setClosedAt(Optional<GitHubInstant> closedAt) {
      this.closedAt = closedAt;
    }
    @JsonProperty
    public void setId(@Nullable Integer id) {
      this.id = id;
    }
    @JsonProperty
    public void setUrl(@Nullable URI url) {
      this.url = url;
    }
    @JsonProperty
    public void setHtmlUrl(@Nullable URI htmlUrl) {
      this.htmlUrl = htmlUrl;
    }
    @JsonProperty
    public void setDiffUrl(@Nullable URI diffUrl) {
      this.diffUrl = diffUrl;
    }
    @JsonProperty
    public void setPatchUrl(@Nullable URI patchUrl) {
      this.patchUrl = patchUrl;
    }
    @JsonProperty
    public void setIssueUrl(@Nullable URI issueUrl) {
      this.issueUrl = issueUrl;
    }
    @JsonProperty
    public void setCommitsUrl(@Nullable URI commitsUrl) {
      this.commitsUrl = commitsUrl;
    }
    @JsonProperty
    public void setNumber(@Nullable Integer number) {
      this.number = number;
    }
    @JsonProperty
    public void setState(@Nullable String state) {
      this.state = state;
    }
    @JsonProperty
    public void setTitle(@Nullable String title) {
      this.title = title;
    }
    @JsonProperty
    public void setBody(Optional<String> body) {
      this.body = body;
    }
    @JsonProperty
    public void setAssignee(Optional<User> assignee) {
      this.assignee = assignee;
    }
    @JsonProperty
    public void setAssignees(Optional<List<User>> assignees) {
      this.assignees = assignees;
    }
    @JsonProperty
    public void setMilestone(Optional<Milestone> milestone) {
      this.milestone = milestone;
    }
    @JsonProperty
    public void setLocked(@Nullable Boolean locked) {
      this.locked = locked;
    }
    @JsonProperty
    public void setMergedAt(Optional<GitHubInstant> mergedAt) {
      this.mergedAt = mergedAt;
    }
    @JsonProperty
    public void setHead(@Nullable PullRequestRef head) {
      this.head = head;
    }
    @JsonProperty
    public void setBase(@Nullable PullRequestRef base) {
      this.base = base;
    }
    @JsonProperty
    public void setUser(@Nullable User user) {
      this.user = user;
    }
    @JsonProperty
    public void setStatusesUrl(@Nullable URI statusesUrl) {
      this.statusesUrl = statusesUrl;
    }
    @JsonProperty
    public void setReviewCommentsUrl(@Nullable URI reviewCommentsUrl) {
      this.reviewCommentsUrl = reviewCommentsUrl;
    }
    @JsonProperty
    public void setReviewCommentUrl(@Nullable String reviewCommentUrl) {
      this.reviewCommentUrl = reviewCommentUrl;
    }
    @JsonProperty
    public void setCommentsUrl(@Nullable URI commentsUrl) {
      this.commentsUrl = commentsUrl;
    }
    @JsonProperty("_links")
    public void setLinks(@Nullable PullRequestLinks links) {
      this.links = links;
    }
    @JsonProperty("requested_reviewers")
    public void setRequestedReviewers(@Nullable List<User> requestedReviewers) {
      this.requestedReviewers = requestedReviewers;
    }
    @JsonProperty("requested_teams")
    public void setRequestedTeams(@Nullable List<User> requestedTeams) {
      this.requestedTeams = requestedTeams;
    }
    @JsonProperty
    public void setMergeCommitSha(Optional<String> mergeCommitSha) {
      this.mergeCommitSha = mergeCommitSha;
    }
    @JsonProperty
    public void setMerged(@Nullable Boolean merged) {
      this.merged = merged;
    }
    @JsonProperty
    public void setMergeable(Optional<Boolean> mergeable) {
      this.mergeable = mergeable;
    }
    @JsonProperty
    public void setMergedBy(Optional<User> mergedBy) {
      this.mergedBy = mergedBy;
    }
    @JsonProperty
    public void setComments(@Nullable Integer comments) {
      this.comments = comments;
    }
    @JsonProperty
    public void setReviewComments(@Nullable Integer reviewComments) {
      this.reviewComments = reviewComments;
    }
    @JsonProperty
    public void setCommits(@Nullable Integer commits) {
      this.commits = commits;
    }
    @JsonProperty
    public void setAdditions(@Nullable Integer additions) {
      this.additions = additions;
    }
    @JsonProperty
    public void setDeletions(@Nullable Integer deletions) {
      this.deletions = deletions;
    }
    @JsonProperty
    public void setChangedFiles(@Nullable Integer changedFiles) {
      this.changedFiles = changedFiles;
    }
    @JsonProperty
    public void setMergeableState(@Nullable String mergeableState) {
      this.mergeableState = mergeableState;
    }
    @JsonProperty
    public void setDraft(Optional<Boolean> draft) {
      this.draft = draft;
    }
    @Override
    public GitHubInstant createdAt() { throw new UnsupportedOperationException(); }
    @Override
    public GitHubInstant updatedAt() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<GitHubInstant> closedAt() { throw new UnsupportedOperationException(); }
    @Override
    public Integer id() { throw new UnsupportedOperationException(); }
    @Override
    public URI url() { throw new UnsupportedOperationException(); }
    @Override
    public URI htmlUrl() { throw new UnsupportedOperationException(); }
    @Override
    public URI diffUrl() { throw new UnsupportedOperationException(); }
    @Override
    public URI patchUrl() { throw new UnsupportedOperationException(); }
    @Override
    public URI issueUrl() { throw new UnsupportedOperationException(); }
    @Override
    public URI commitsUrl() { throw new UnsupportedOperationException(); }
    @Override
    public Integer number() { throw new UnsupportedOperationException(); }
    @Override
    public String state() { throw new UnsupportedOperationException(); }
    @Override
    public String title() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> body() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<User> assignee() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<List<User>> assignees() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Milestone> milestone() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean locked() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<GitHubInstant> mergedAt() { throw new UnsupportedOperationException(); }
    @Override
    public PullRequestRef head() { throw new UnsupportedOperationException(); }
    @Override
    public PullRequestRef base() { throw new UnsupportedOperationException(); }
    @Override
    public User user() { throw new UnsupportedOperationException(); }
    @Override
    public URI statusesUrl() { throw new UnsupportedOperationException(); }
    @Override
    public URI reviewCommentsUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String reviewCommentUrl() { throw new UnsupportedOperationException(); }
    @Override
    public URI commentsUrl() { throw new UnsupportedOperationException(); }
    @Override
    public PullRequestLinks links() { throw new UnsupportedOperationException(); }
    @Override
    public List<User> requestedReviewers() { throw new UnsupportedOperationException(); }
    @Override
    public List<User> requestedTeams() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> mergeCommitSha() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean merged() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Boolean> mergeable() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<User> mergedBy() { throw new UnsupportedOperationException(); }
    @Override
    public Integer comments() { throw new UnsupportedOperationException(); }
    @Override
    public Integer reviewComments() { throw new UnsupportedOperationException(); }
    @Override
    public Integer commits() { throw new UnsupportedOperationException(); }
    @Override
    public Integer additions() { throw new UnsupportedOperationException(); }
    @Override
    public Integer deletions() { throw new UnsupportedOperationException(); }
    @Override
    public Integer changedFiles() { throw new UnsupportedOperationException(); }
    @Override
    public String mergeableState() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Boolean> draft() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutablePullRequest fromJson(Json json) {
    ImmutablePullRequest.Builder builder = ImmutablePullRequest.builder();
    if (json.createdAt != null) {
      builder.createdAt(json.createdAt);
    }
    if (json.updatedAt != null) {
      builder.updatedAt(json.updatedAt);
    }
    if (json.closedAt != null) {
      builder.closedAt(json.closedAt);
    }
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.url != null) {
      builder.url(json.url);
    }
    if (json.htmlUrl != null) {
      builder.htmlUrl(json.htmlUrl);
    }
    if (json.diffUrl != null) {
      builder.diffUrl(json.diffUrl);
    }
    if (json.patchUrl != null) {
      builder.patchUrl(json.patchUrl);
    }
    if (json.issueUrl != null) {
      builder.issueUrl(json.issueUrl);
    }
    if (json.commitsUrl != null) {
      builder.commitsUrl(json.commitsUrl);
    }
    if (json.number != null) {
      builder.number(json.number);
    }
    if (json.state != null) {
      builder.state(json.state);
    }
    if (json.title != null) {
      builder.title(json.title);
    }
    if (json.body != null) {
      builder.body(json.body);
    }
    if (json.assignee != null) {
      builder.assignee(json.assignee);
    }
    if (json.assignees != null) {
      builder.assignees(json.assignees);
    }
    if (json.milestone != null) {
      builder.milestone(json.milestone);
    }
    if (json.locked != null) {
      builder.locked(json.locked);
    }
    if (json.mergedAt != null) {
      builder.mergedAt(json.mergedAt);
    }
    if (json.head != null) {
      builder.head(json.head);
    }
    if (json.base != null) {
      builder.base(json.base);
    }
    if (json.user != null) {
      builder.user(json.user);
    }
    if (json.statusesUrl != null) {
      builder.statusesUrl(json.statusesUrl);
    }
    if (json.reviewCommentsUrl != null) {
      builder.reviewCommentsUrl(json.reviewCommentsUrl);
    }
    if (json.reviewCommentUrl != null) {
      builder.reviewCommentUrl(json.reviewCommentUrl);
    }
    if (json.commentsUrl != null) {
      builder.commentsUrl(json.commentsUrl);
    }
    if (json.links != null) {
      builder.links(json.links);
    }
    if (json.requestedReviewers != null) {
      builder.addAllRequestedReviewers(json.requestedReviewers);
    }
    if (json.requestedTeams != null) {
      builder.addAllRequestedTeams(json.requestedTeams);
    }
    if (json.mergeCommitSha != null) {
      builder.mergeCommitSha(json.mergeCommitSha);
    }
    if (json.merged != null) {
      builder.merged(json.merged);
    }
    if (json.mergeable != null) {
      builder.mergeable(json.mergeable);
    }
    if (json.mergedBy != null) {
      builder.mergedBy(json.mergedBy);
    }
    if (json.comments != null) {
      builder.comments(json.comments);
    }
    if (json.reviewComments != null) {
      builder.reviewComments(json.reviewComments);
    }
    if (json.commits != null) {
      builder.commits(json.commits);
    }
    if (json.additions != null) {
      builder.additions(json.additions);
    }
    if (json.deletions != null) {
      builder.deletions(json.deletions);
    }
    if (json.changedFiles != null) {
      builder.changedFiles(json.changedFiles);
    }
    if (json.mergeableState != null) {
      builder.mergeableState(json.mergeableState);
    }
    if (json.draft != null) {
      builder.draft(json.draft);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link PullRequest} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable PullRequest instance
   */
  public static ImmutablePullRequest copyOf(PullRequest instance) {
    if (instance instanceof ImmutablePullRequest) {
      return (ImmutablePullRequest) instance;
    }
    return ImmutablePullRequest.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutablePullRequest ImmutablePullRequest}.
   * <pre>
   * ImmutablePullRequest.builder()
   *    .createdAt(com.spotify.github.GitHubInstant | null) // nullable {@link PullRequest#createdAt() createdAt}
   *    .updatedAt(com.spotify.github.GitHubInstant | null) // nullable {@link PullRequest#updatedAt() updatedAt}
   *    .closedAt(com.spotify.github.GitHubInstant) // optional {@link PullRequest#closedAt() closedAt}
   *    .id(Integer | null) // nullable {@link PullRequest#id() id}
   *    .url(java.net.URI | null) // nullable {@link PullRequest#url() url}
   *    .htmlUrl(java.net.URI | null) // nullable {@link PullRequest#htmlUrl() htmlUrl}
   *    .diffUrl(java.net.URI | null) // nullable {@link PullRequest#diffUrl() diffUrl}
   *    .patchUrl(java.net.URI | null) // nullable {@link PullRequest#patchUrl() patchUrl}
   *    .issueUrl(java.net.URI | null) // nullable {@link PullRequest#issueUrl() issueUrl}
   *    .commitsUrl(java.net.URI | null) // nullable {@link PullRequest#commitsUrl() commitsUrl}
   *    .number(Integer | null) // nullable {@link PullRequest#number() number}
   *    .state(String | null) // nullable {@link PullRequest#state() state}
   *    .title(String | null) // nullable {@link PullRequest#title() title}
   *    .body(String) // optional {@link PullRequest#body() body}
   *    .assignee(com.spotify.github.v3.User) // optional {@link PullRequest#assignee() assignee}
   *    .assignees(List&amp;lt;com.spotify.github.v3.User&amp;gt;) // optional {@link PullRequest#assignees() assignees}
   *    .milestone(com.spotify.github.v3.Milestone) // optional {@link PullRequest#milestone() milestone}
   *    .locked(Boolean | null) // nullable {@link PullRequest#locked() locked}
   *    .mergedAt(com.spotify.github.GitHubInstant) // optional {@link PullRequest#mergedAt() mergedAt}
   *    .head(com.spotify.github.v3.prs.PullRequestRef | null) // nullable {@link PullRequest#head() head}
   *    .base(com.spotify.github.v3.prs.PullRequestRef | null) // nullable {@link PullRequest#base() base}
   *    .user(com.spotify.github.v3.User | null) // nullable {@link PullRequest#user() user}
   *    .statusesUrl(java.net.URI | null) // nullable {@link PullRequest#statusesUrl() statusesUrl}
   *    .reviewCommentsUrl(java.net.URI | null) // nullable {@link PullRequest#reviewCommentsUrl() reviewCommentsUrl}
   *    .reviewCommentUrl(String | null) // nullable {@link PullRequest#reviewCommentUrl() reviewCommentUrl}
   *    .commentsUrl(java.net.URI | null) // nullable {@link PullRequest#commentsUrl() commentsUrl}
   *    .links(com.spotify.github.v3.prs.PullRequestLinks | null) // nullable {@link PullRequest#links() links}
   *    .requestedReviewers(List&amp;lt;com.spotify.github.v3.User&amp;gt; | null) // nullable {@link PullRequest#requestedReviewers() requestedReviewers}
   *    .requestedTeams(List&amp;lt;com.spotify.github.v3.User&amp;gt; | null) // nullable {@link PullRequest#requestedTeams() requestedTeams}
   *    .mergeCommitSha(String) // optional {@link PullRequest#mergeCommitSha() mergeCommitSha}
   *    .merged(Boolean | null) // nullable {@link PullRequest#merged() merged}
   *    .mergeable(Boolean) // optional {@link PullRequest#mergeable() mergeable}
   *    .mergedBy(com.spotify.github.v3.User) // optional {@link PullRequest#mergedBy() mergedBy}
   *    .comments(Integer | null) // nullable {@link PullRequest#comments() comments}
   *    .reviewComments(Integer | null) // nullable {@link PullRequest#reviewComments() reviewComments}
   *    .commits(Integer | null) // nullable {@link PullRequest#commits() commits}
   *    .additions(Integer | null) // nullable {@link PullRequest#additions() additions}
   *    .deletions(Integer | null) // nullable {@link PullRequest#deletions() deletions}
   *    .changedFiles(Integer | null) // nullable {@link PullRequest#changedFiles() changedFiles}
   *    .mergeableState(String | null) // nullable {@link PullRequest#mergeableState() mergeableState}
   *    .draft(Boolean) // optional {@link PullRequest#draft() draft}
   *    .build();
   * </pre>
   * @return A new ImmutablePullRequest builder
   */
  public static ImmutablePullRequest.Builder builder() {
    return new ImmutablePullRequest.Builder();
  }

  /**
   * Builds instances of type {@link ImmutablePullRequest ImmutablePullRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "PullRequest", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable GitHubInstant createdAt;
    private @Nullable GitHubInstant updatedAt;
    private @Nullable GitHubInstant closedAt;
    private @Nullable Integer id;
    private @Nullable URI url;
    private @Nullable URI htmlUrl;
    private @Nullable URI diffUrl;
    private @Nullable URI patchUrl;
    private @Nullable URI issueUrl;
    private @Nullable URI commitsUrl;
    private @Nullable Integer number;
    private @Nullable String state;
    private @Nullable String title;
    private @Nullable String body;
    private @Nullable User assignee;
    private @Nullable List<User> assignees;
    private @Nullable Milestone milestone;
    private @Nullable Boolean locked;
    private @Nullable GitHubInstant mergedAt;
    private @Nullable PullRequestRef head;
    private @Nullable PullRequestRef base;
    private @Nullable User user;
    private @Nullable URI statusesUrl;
    private @Nullable URI reviewCommentsUrl;
    private @Nullable String reviewCommentUrl;
    private @Nullable URI commentsUrl;
    private @Nullable PullRequestLinks links;
    private List<User> requestedReviewers = null;
    private List<User> requestedTeams = null;
    private @Nullable String mergeCommitSha;
    private @Nullable Boolean merged;
    private @Nullable Boolean mergeable;
    private @Nullable User mergedBy;
    private @Nullable Integer comments;
    private @Nullable Integer reviewComments;
    private @Nullable Integer commits;
    private @Nullable Integer additions;
    private @Nullable Integer deletions;
    private @Nullable Integer changedFiles;
    private @Nullable String mergeableState;
    private @Nullable Boolean draft;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.spotify.github.v3.prs.PullRequestItem} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(PullRequestItem instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.spotify.github.CloseTracking} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(CloseTracking instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.spotify.github.UpdateTracking} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(UpdateTracking instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.spotify.github.v3.prs.PullRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(PullRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof PullRequestItem) {
        PullRequestItem instance = (PullRequestItem) object;
        @Nullable List<User> requestedReviewersValue = instance.requestedReviewers();
        if (requestedReviewersValue != null) {
          addAllRequestedReviewers(requestedReviewersValue);
        }
        @Nullable URI diffUrlValue = instance.diffUrl();
        if (diffUrlValue != null) {
          diffUrl(diffUrlValue);
        }
        @Nullable String reviewCommentUrlValue = instance.reviewCommentUrl();
        if (reviewCommentUrlValue != null) {
          reviewCommentUrl(reviewCommentUrlValue);
        }
        @Nullable List<User> requestedTeamsValue = instance.requestedTeams();
        if (requestedTeamsValue != null) {
          addAllRequestedTeams(requestedTeamsValue);
        }
        Optional<List<User>> assigneesOptional = instance.assignees();
        if (assigneesOptional.isPresent()) {
          assignees(assigneesOptional);
        }
        @Nullable URI reviewCommentsUrlValue = instance.reviewCommentsUrl();
        if (reviewCommentsUrlValue != null) {
          reviewCommentsUrl(reviewCommentsUrlValue);
        }
        @Nullable URI commitsUrlValue = instance.commitsUrl();
        if (commitsUrlValue != null) {
          commitsUrl(commitsUrlValue);
        }
        @Nullable String titleValue = instance.title();
        if (titleValue != null) {
          title(titleValue);
        }
        Optional<String> bodyOptional = instance.body();
        if (bodyOptional.isPresent()) {
          body(bodyOptional);
        }
        @Nullable PullRequestRef headValue = instance.head();
        if (headValue != null) {
          head(headValue);
        }
        @Nullable Integer numberValue = instance.number();
        if (numberValue != null) {
          number(numberValue);
        }
        @Nullable URI patchUrlValue = instance.patchUrl();
        if (patchUrlValue != null) {
          patchUrl(patchUrlValue);
        }
        Optional<String> mergeCommitShaOptional = instance.mergeCommitSha();
        if (mergeCommitShaOptional.isPresent()) {
          mergeCommitSha(mergeCommitShaOptional);
        }
        @Nullable URI statusesUrlValue = instance.statusesUrl();
        if (statusesUrlValue != null) {
          statusesUrl(statusesUrlValue);
        }
        @Nullable PullRequestLinks linksValue = instance.links();
        if (linksValue != null) {
          links(linksValue);
        }
        @Nullable Integer idValue = instance.id();
        if (idValue != null) {
          id(idValue);
        }
        @Nullable String stateValue = instance.state();
        if (stateValue != null) {
          state(stateValue);
        }
        @Nullable Boolean lockedValue = instance.locked();
        if (lockedValue != null) {
          locked(lockedValue);
        }
        Optional<GitHubInstant> mergedAtOptional = instance.mergedAt();
        if (mergedAtOptional.isPresent()) {
          mergedAt(mergedAtOptional);
        }
        @Nullable URI htmlUrlValue = instance.htmlUrl();
        if (htmlUrlValue != null) {
          htmlUrl(htmlUrlValue);
        }
        @Nullable URI urlValue = instance.url();
        if (urlValue != null) {
          url(urlValue);
        }
        @Nullable URI issueUrlValue = instance.issueUrl();
        if (issueUrlValue != null) {
          issueUrl(issueUrlValue);
        }
        Optional<Milestone> milestoneOptional = instance.milestone();
        if (milestoneOptional.isPresent()) {
          milestone(milestoneOptional);
        }
        @Nullable URI commentsUrlValue = instance.commentsUrl();
        if (commentsUrlValue != null) {
          commentsUrl(commentsUrlValue);
        }
        Optional<User> assigneeOptional = instance.assignee();
        if (assigneeOptional.isPresent()) {
          assignee(assigneeOptional);
        }
        @Nullable User userValue = instance.user();
        if (userValue != null) {
          user(userValue);
        }
        @Nullable PullRequestRef baseValue = instance.base();
        if (baseValue != null) {
          base(baseValue);
        }
      }
      if (object instanceof CloseTracking) {
        CloseTracking instance = (CloseTracking) object;
        Optional<GitHubInstant> closedAtOptional = instance.closedAt();
        if (closedAtOptional.isPresent()) {
          closedAt(closedAtOptional);
        }
      }
      if (object instanceof UpdateTracking) {
        UpdateTracking instance = (UpdateTracking) object;
        @Nullable GitHubInstant createdAtValue = instance.createdAt();
        if (createdAtValue != null) {
          createdAt(createdAtValue);
        }
        @Nullable GitHubInstant updatedAtValue = instance.updatedAt();
        if (updatedAtValue != null) {
          updatedAt(updatedAtValue);
        }
      }
      if (object instanceof PullRequest) {
        PullRequest instance = (PullRequest) object;
        @Nullable String mergeableStateValue = instance.mergeableState();
        if (mergeableStateValue != null) {
          mergeableState(mergeableStateValue);
        }
        Optional<Boolean> mergeableOptional = instance.mergeable();
        if (mergeableOptional.isPresent()) {
          mergeable(mergeableOptional);
        }
        @Nullable Integer commentsValue = instance.comments();
        if (commentsValue != null) {
          comments(commentsValue);
        }
        @Nullable Integer additionsValue = instance.additions();
        if (additionsValue != null) {
          additions(additionsValue);
        }
        @Nullable Integer deletionsValue = instance.deletions();
        if (deletionsValue != null) {
          deletions(deletionsValue);
        }
        @Nullable Integer changedFilesValue = instance.changedFiles();
        if (changedFilesValue != null) {
          changedFiles(changedFilesValue);
        }
        Optional<Boolean> draftOptional = instance.draft();
        if (draftOptional.isPresent()) {
          draft(draftOptional);
        }
        @Nullable Boolean mergedValue = instance.merged();
        if (mergedValue != null) {
          merged(mergedValue);
        }
        @Nullable Integer commitsValue = instance.commits();
        if (commitsValue != null) {
          commits(commitsValue);
        }
        Optional<User> mergedByOptional = instance.mergedBy();
        if (mergedByOptional.isPresent()) {
          mergedBy(mergedByOptional);
        }
        @Nullable Integer reviewCommentsValue = instance.reviewComments();
        if (reviewCommentsValue != null) {
          reviewComments(reviewCommentsValue);
        }
      }
    }

    /**
     * Initializes the value for the {@link PullRequest#createdAt() createdAt} attribute.
     * @param createdAt The value for createdAt (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder createdAt(@Nullable GitHubInstant createdAt) {
      this.createdAt = createdAt;
      return this;
    }

    /**
     * Initializes the value for the {@link PullRequest#updatedAt() updatedAt} attribute.
     * @param updatedAt The value for updatedAt (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder updatedAt(@Nullable GitHubInstant updatedAt) {
      this.updatedAt = updatedAt;
      return this;
    }

    /**
     * Initializes the optional value {@link PullRequest#closedAt() closedAt} to closedAt.
     * @param closedAt The value for closedAt
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder closedAt(GitHubInstant closedAt) {
      this.closedAt = Objects.requireNonNull(closedAt, "closedAt");
      return this;
    }

    /**
     * Initializes the optional value {@link PullRequest#closedAt() closedAt} to closedAt.
     * @param closedAt The value for closedAt
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder closedAt(Optional<? extends GitHubInstant> closedAt) {
      this.closedAt = closedAt.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link PullRequest#id() id} attribute.
     * @param id The value for id (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder id(@Nullable Integer id) {
      this.id = id;
      return this;
    }

    /**
     * Initializes the value for the {@link PullRequest#url() url} attribute.
     * @param url The value for url (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder url(@Nullable URI url) {
      this.url = url;
      return this;
    }

    /**
     * Initializes the value for the {@link PullRequest#htmlUrl() htmlUrl} attribute.
     * @param htmlUrl The value for htmlUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder htmlUrl(@Nullable URI htmlUrl) {
      this.htmlUrl = htmlUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link PullRequest#diffUrl() diffUrl} attribute.
     * @param diffUrl The value for diffUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder diffUrl(@Nullable URI diffUrl) {
      this.diffUrl = diffUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link PullRequest#patchUrl() patchUrl} attribute.
     * @param patchUrl The value for patchUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder patchUrl(@Nullable URI patchUrl) {
      this.patchUrl = patchUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link PullRequest#issueUrl() issueUrl} attribute.
     * @param issueUrl The value for issueUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder issueUrl(@Nullable URI issueUrl) {
      this.issueUrl = issueUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link PullRequest#commitsUrl() commitsUrl} attribute.
     * @param commitsUrl The value for commitsUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder commitsUrl(@Nullable URI commitsUrl) {
      this.commitsUrl = commitsUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link PullRequest#number() number} attribute.
     * @param number The value for number (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder number(@Nullable Integer number) {
      this.number = number;
      return this;
    }

    /**
     * Initializes the value for the {@link PullRequest#state() state} attribute.
     * @param state The value for state (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder state(@Nullable String state) {
      this.state = state;
      return this;
    }

    /**
     * Initializes the value for the {@link PullRequest#title() title} attribute.
     * @param title The value for title (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder title(@Nullable String title) {
      this.title = title;
      return this;
    }

    /**
     * Initializes the optional value {@link PullRequest#body() body} to body.
     * @param body The value for body
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder body(String body) {
      this.body = Objects.requireNonNull(body, "body");
      return this;
    }

    /**
     * Initializes the optional value {@link PullRequest#body() body} to body.
     * @param body The value for body
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder body(Optional<String> body) {
      this.body = body.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link PullRequest#assignee() assignee} to assignee.
     * @param assignee The value for assignee
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder assignee(User assignee) {
      this.assignee = Objects.requireNonNull(assignee, "assignee");
      return this;
    }

    /**
     * Initializes the optional value {@link PullRequest#assignee() assignee} to assignee.
     * @param assignee The value for assignee
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder assignee(Optional<? extends User> assignee) {
      this.assignee = assignee.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link PullRequest#assignees() assignees} to assignees.
     * @param assignees The value for assignees
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder assignees(List<User> assignees) {
      this.assignees = Objects.requireNonNull(assignees, "assignees");
      return this;
    }

    /**
     * Initializes the optional value {@link PullRequest#assignees() assignees} to assignees.
     * @param assignees The value for assignees
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder assignees(Optional<? extends List<User>> assignees) {
      this.assignees = assignees.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link PullRequest#milestone() milestone} to milestone.
     * @param milestone The value for milestone
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder milestone(Milestone milestone) {
      this.milestone = Objects.requireNonNull(milestone, "milestone");
      return this;
    }

    /**
     * Initializes the optional value {@link PullRequest#milestone() milestone} to milestone.
     * @param milestone The value for milestone
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder milestone(Optional<? extends Milestone> milestone) {
      this.milestone = milestone.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link PullRequest#locked() locked} attribute.
     * @param locked The value for locked (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder locked(@Nullable Boolean locked) {
      this.locked = locked;
      return this;
    }

    /**
     * Initializes the optional value {@link PullRequest#mergedAt() mergedAt} to mergedAt.
     * @param mergedAt The value for mergedAt
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder mergedAt(GitHubInstant mergedAt) {
      this.mergedAt = Objects.requireNonNull(mergedAt, "mergedAt");
      return this;
    }

    /**
     * Initializes the optional value {@link PullRequest#mergedAt() mergedAt} to mergedAt.
     * @param mergedAt The value for mergedAt
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder mergedAt(Optional<? extends GitHubInstant> mergedAt) {
      this.mergedAt = mergedAt.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link PullRequest#head() head} attribute.
     * @param head The value for head (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder head(@Nullable PullRequestRef head) {
      this.head = head;
      return this;
    }

    /**
     * Initializes the value for the {@link PullRequest#base() base} attribute.
     * @param base The value for base (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder base(@Nullable PullRequestRef base) {
      this.base = base;
      return this;
    }

    /**
     * Initializes the value for the {@link PullRequest#user() user} attribute.
     * @param user The value for user (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder user(@Nullable User user) {
      this.user = user;
      return this;
    }

    /**
     * Initializes the value for the {@link PullRequest#statusesUrl() statusesUrl} attribute.
     * @param statusesUrl The value for statusesUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder statusesUrl(@Nullable URI statusesUrl) {
      this.statusesUrl = statusesUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link PullRequest#reviewCommentsUrl() reviewCommentsUrl} attribute.
     * @param reviewCommentsUrl The value for reviewCommentsUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder reviewCommentsUrl(@Nullable URI reviewCommentsUrl) {
      this.reviewCommentsUrl = reviewCommentsUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link PullRequest#reviewCommentUrl() reviewCommentUrl} attribute.
     * @param reviewCommentUrl The value for reviewCommentUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder reviewCommentUrl(@Nullable String reviewCommentUrl) {
      this.reviewCommentUrl = reviewCommentUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link PullRequest#commentsUrl() commentsUrl} attribute.
     * @param commentsUrl The value for commentsUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder commentsUrl(@Nullable URI commentsUrl) {
      this.commentsUrl = commentsUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link PullRequest#links() links} attribute.
     * @param links The value for links (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("_links")
    public final Builder links(@Nullable PullRequestLinks links) {
      this.links = links;
      return this;
    }

    /**
     * Adds one element to {@link PullRequest#requestedReviewers() requestedReviewers} list.
     * @param element A requestedReviewers element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addRequestedReviewers(User element) {
      if (this.requestedReviewers == null) {
        this.requestedReviewers = new ArrayList<User>();
      }
      this.requestedReviewers.add(Objects.requireNonNull(element, "requestedReviewers element"));
      return this;
    }

    /**
     * Adds elements to {@link PullRequest#requestedReviewers() requestedReviewers} list.
     * @param elements An array of requestedReviewers elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addRequestedReviewers(User... elements) {
      if (this.requestedReviewers == null) {
        this.requestedReviewers = new ArrayList<User>();
      }
      for (User element : elements) {
        this.requestedReviewers.add(Objects.requireNonNull(element, "requestedReviewers element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link PullRequest#requestedReviewers() requestedReviewers} list.
     * @param elements An iterable of requestedReviewers elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("requested_reviewers")
    public final Builder requestedReviewers(@Nullable Iterable<? extends User> elements) {
      if (elements == null) {
        this.requestedReviewers = null;
        return this;
      }
      this.requestedReviewers = new ArrayList<User>();
      return addAllRequestedReviewers(elements);
    }

    /**
     * Adds elements to {@link PullRequest#requestedReviewers() requestedReviewers} list.
     * @param elements An iterable of requestedReviewers elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllRequestedReviewers(Iterable<? extends User> elements) {
      Objects.requireNonNull(elements, "requestedReviewers element");
      if (this.requestedReviewers == null) {
        this.requestedReviewers = new ArrayList<User>();
      }
      for (User element : elements) {
        this.requestedReviewers.add(Objects.requireNonNull(element, "requestedReviewers element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link PullRequest#requestedTeams() requestedTeams} list.
     * @param element A requestedTeams element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addRequestedTeams(User element) {
      if (this.requestedTeams == null) {
        this.requestedTeams = new ArrayList<User>();
      }
      this.requestedTeams.add(Objects.requireNonNull(element, "requestedTeams element"));
      return this;
    }

    /**
     * Adds elements to {@link PullRequest#requestedTeams() requestedTeams} list.
     * @param elements An array of requestedTeams elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addRequestedTeams(User... elements) {
      if (this.requestedTeams == null) {
        this.requestedTeams = new ArrayList<User>();
      }
      for (User element : elements) {
        this.requestedTeams.add(Objects.requireNonNull(element, "requestedTeams element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link PullRequest#requestedTeams() requestedTeams} list.
     * @param elements An iterable of requestedTeams elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("requested_teams")
    public final Builder requestedTeams(@Nullable Iterable<? extends User> elements) {
      if (elements == null) {
        this.requestedTeams = null;
        return this;
      }
      this.requestedTeams = new ArrayList<User>();
      return addAllRequestedTeams(elements);
    }

    /**
     * Adds elements to {@link PullRequest#requestedTeams() requestedTeams} list.
     * @param elements An iterable of requestedTeams elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllRequestedTeams(Iterable<? extends User> elements) {
      Objects.requireNonNull(elements, "requestedTeams element");
      if (this.requestedTeams == null) {
        this.requestedTeams = new ArrayList<User>();
      }
      for (User element : elements) {
        this.requestedTeams.add(Objects.requireNonNull(element, "requestedTeams element"));
      }
      return this;
    }

    /**
     * Initializes the optional value {@link PullRequest#mergeCommitSha() mergeCommitSha} to mergeCommitSha.
     * @param mergeCommitSha The value for mergeCommitSha
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder mergeCommitSha(String mergeCommitSha) {
      this.mergeCommitSha = Objects.requireNonNull(mergeCommitSha, "mergeCommitSha");
      return this;
    }

    /**
     * Initializes the optional value {@link PullRequest#mergeCommitSha() mergeCommitSha} to mergeCommitSha.
     * @param mergeCommitSha The value for mergeCommitSha
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder mergeCommitSha(Optional<String> mergeCommitSha) {
      this.mergeCommitSha = mergeCommitSha.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link PullRequest#merged() merged} attribute.
     * @param merged The value for merged (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder merged(@Nullable Boolean merged) {
      this.merged = merged;
      return this;
    }

    /**
     * Initializes the optional value {@link PullRequest#mergeable() mergeable} to mergeable.
     * @param mergeable The value for mergeable
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder mergeable(boolean mergeable) {
      this.mergeable = mergeable;
      return this;
    }

    /**
     * Initializes the optional value {@link PullRequest#mergeable() mergeable} to mergeable.
     * @param mergeable The value for mergeable
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder mergeable(Optional<Boolean> mergeable) {
      this.mergeable = mergeable.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link PullRequest#mergedBy() mergedBy} to mergedBy.
     * @param mergedBy The value for mergedBy
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder mergedBy(User mergedBy) {
      this.mergedBy = Objects.requireNonNull(mergedBy, "mergedBy");
      return this;
    }

    /**
     * Initializes the optional value {@link PullRequest#mergedBy() mergedBy} to mergedBy.
     * @param mergedBy The value for mergedBy
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder mergedBy(Optional<? extends User> mergedBy) {
      this.mergedBy = mergedBy.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link PullRequest#comments() comments} attribute.
     * @param comments The value for comments (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder comments(@Nullable Integer comments) {
      this.comments = comments;
      return this;
    }

    /**
     * Initializes the value for the {@link PullRequest#reviewComments() reviewComments} attribute.
     * @param reviewComments The value for reviewComments (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder reviewComments(@Nullable Integer reviewComments) {
      this.reviewComments = reviewComments;
      return this;
    }

    /**
     * Initializes the value for the {@link PullRequest#commits() commits} attribute.
     * @param commits The value for commits (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder commits(@Nullable Integer commits) {
      this.commits = commits;
      return this;
    }

    /**
     * Initializes the value for the {@link PullRequest#additions() additions} attribute.
     * @param additions The value for additions (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder additions(@Nullable Integer additions) {
      this.additions = additions;
      return this;
    }

    /**
     * Initializes the value for the {@link PullRequest#deletions() deletions} attribute.
     * @param deletions The value for deletions (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder deletions(@Nullable Integer deletions) {
      this.deletions = deletions;
      return this;
    }

    /**
     * Initializes the value for the {@link PullRequest#changedFiles() changedFiles} attribute.
     * @param changedFiles The value for changedFiles (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder changedFiles(@Nullable Integer changedFiles) {
      this.changedFiles = changedFiles;
      return this;
    }

    /**
     * Initializes the value for the {@link PullRequest#mergeableState() mergeableState} attribute.
     * @param mergeableState The value for mergeableState (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder mergeableState(@Nullable String mergeableState) {
      this.mergeableState = mergeableState;
      return this;
    }

    /**
     * Initializes the optional value {@link PullRequest#draft() draft} to draft.
     * @param draft The value for draft
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder draft(boolean draft) {
      this.draft = draft;
      return this;
    }

    /**
     * Initializes the optional value {@link PullRequest#draft() draft} to draft.
     * @param draft The value for draft
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder draft(Optional<Boolean> draft) {
      this.draft = draft.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ImmutablePullRequest ImmutablePullRequest}.
     * @return An immutable instance of PullRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutablePullRequest build() {
      return new ImmutablePullRequest(
          createdAt,
          updatedAt,
          closedAt,
          id,
          url,
          htmlUrl,
          diffUrl,
          patchUrl,
          issueUrl,
          commitsUrl,
          number,
          state,
          title,
          body,
          assignee,
          assignees,
          milestone,
          locked,
          mergedAt,
          head,
          base,
          user,
          statusesUrl,
          reviewCommentsUrl,
          reviewCommentUrl,
          commentsUrl,
          links,
          requestedReviewers == null ? null : createUnmodifiableList(true, requestedReviewers),
          requestedTeams == null ? null : createUnmodifiableList(true, requestedTeams),
          mergeCommitSha,
          merged,
          mergeable,
          mergedBy,
          comments,
          reviewComments,
          commits,
          additions,
          deletions,
          changedFiles,
          mergeableState,
          draft);
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
