package com.spotify.github.v3.prs;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import com.spotify.github.CloseTracking;
import com.spotify.github.GitHubInstant;
import com.spotify.github.UpdateTracking;
import com.spotify.github.v3.Milestone;
import com.spotify.github.v3.User;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link PullRequestItem}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutablePullRequestItem.builder()}.
 */
@Generated(from = "PullRequestItem", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutablePullRequestItem implements PullRequestItem {
  private final @Nullable GitHubInstant createdAt;
  private final @Nullable GitHubInstant updatedAt;
  private final @Nullable GitHubInstant closedAt;
  private final @Nullable Integer id;
  private final @Nullable URI url;
  private final @Nullable URI htmlUrl;
  private final @Nullable URI diffUrl;
  private final @Nullable URI patchUrl;
  private final @Nullable URI issueUrl;
  private final @Nullable URI commitsUrl;
  private final @Nullable Integer number;
  private final @Nullable String state;
  private final @Nullable String title;
  private final @Nullable String body;
  private final @Nullable User assignee;
  private final @Nullable List<User> assignees;
  private final @Nullable Milestone milestone;
  private final @Nullable Boolean locked;
  private final @Nullable GitHubInstant mergedAt;
  private final @Nullable PullRequestRef head;
  private final @Nullable PullRequestRef base;
  private final @Nullable User user;
  private final @Nullable URI statusesUrl;
  private final @Nullable URI reviewCommentsUrl;
  private final @Nullable String reviewCommentUrl;
  private final @Nullable URI commentsUrl;
  private final @Nullable PullRequestLinks links;
  private final @Nullable List<User> requestedReviewers;
  private final @Nullable List<User> requestedTeams;
  private final @Nullable String mergeCommitSha;

  private ImmutablePullRequestItem(
      @Nullable GitHubInstant createdAt,
      @Nullable GitHubInstant updatedAt,
      @Nullable GitHubInstant closedAt,
      @Nullable Integer id,
      @Nullable URI url,
      @Nullable URI htmlUrl,
      @Nullable URI diffUrl,
      @Nullable URI patchUrl,
      @Nullable URI issueUrl,
      @Nullable URI commitsUrl,
      @Nullable Integer number,
      @Nullable String state,
      @Nullable String title,
      @Nullable String body,
      @Nullable User assignee,
      @Nullable List<User> assignees,
      @Nullable Milestone milestone,
      @Nullable Boolean locked,
      @Nullable GitHubInstant mergedAt,
      @Nullable PullRequestRef head,
      @Nullable PullRequestRef base,
      @Nullable User user,
      @Nullable URI statusesUrl,
      @Nullable URI reviewCommentsUrl,
      @Nullable String reviewCommentUrl,
      @Nullable URI commentsUrl,
      @Nullable PullRequestLinks links,
      @Nullable List<User> requestedReviewers,
      @Nullable List<User> requestedTeams,
      @Nullable String mergeCommitSha) {
    this.createdAt = createdAt;
    this.updatedAt = updatedAt;
    this.closedAt = closedAt;
    this.id = id;
    this.url = url;
    this.htmlUrl = htmlUrl;
    this.diffUrl = diffUrl;
    this.patchUrl = patchUrl;
    this.issueUrl = issueUrl;
    this.commitsUrl = commitsUrl;
    this.number = number;
    this.state = state;
    this.title = title;
    this.body = body;
    this.assignee = assignee;
    this.assignees = assignees;
    this.milestone = milestone;
    this.locked = locked;
    this.mergedAt = mergedAt;
    this.head = head;
    this.base = base;
    this.user = user;
    this.statusesUrl = statusesUrl;
    this.reviewCommentsUrl = reviewCommentsUrl;
    this.reviewCommentUrl = reviewCommentUrl;
    this.commentsUrl = commentsUrl;
    this.links = links;
    this.requestedReviewers = requestedReviewers;
    this.requestedTeams = requestedTeams;
    this.mergeCommitSha = mergeCommitSha;
  }

  /**
   * Created date
   * @return The date when the issue was created
   */
  @JsonProperty
  @Override
  public @Nullable GitHubInstant createdAt() {
    return createdAt;
  }

  /**
   * Updated date
   * @return The date when the issue was updated
   */
  @JsonProperty
  @Override
  public @Nullable GitHubInstant updatedAt() {
    return updatedAt;
  }

  /**
   * Closed date.
   * @return The date when the issue was closed
   */
  @JsonProperty
  @Override
  public Optional<GitHubInstant> closedAt() {
    return Optional.ofNullable(closedAt);
  }

  /**
   *ID. 
   */
  @JsonProperty
  @Override
  public @Nullable Integer id() {
    return id;
  }

  /**
   *URL. 
   */
  @JsonProperty
  @Override
  public @Nullable URI url() {
    return url;
  }

  /**
   *HTML URL. 
   */
  @JsonProperty
  @Override
  public @Nullable URI htmlUrl() {
    return htmlUrl;
  }

  /**
   *Diff URL. 
   */
  @JsonProperty
  @Override
  public @Nullable URI diffUrl() {
    return diffUrl;
  }

  /**
   *Patch URL. 
   */
  @JsonProperty
  @Override
  public @Nullable URI patchUrl() {
    return patchUrl;
  }

  /**
   *Issue URL. 
   */
  @JsonProperty
  @Override
  public @Nullable URI issueUrl() {
    return issueUrl;
  }

  /**
   *Commits URL. 
   */
  @JsonProperty
  @Override
  public @Nullable URI commitsUrl() {
    return commitsUrl;
  }

  /**
   *Number. 
   */
  @JsonProperty
  @Override
  public @Nullable Integer number() {
    return number;
  }

  /**
   *Either open, closed, or all to filter by state. Default: open. 
   */
  @JsonProperty
  @Override
  public @Nullable String state() {
    return state;
  }

  /**
   *The title of the pull request. 
   */
  @JsonProperty
  @Override
  public @Nullable String title() {
    return title;
  }

  /**
   *The contents of the pull request. 
   */
  @JsonProperty
  @Override
  public Optional<String> body() {
    return Optional.ofNullable(body);
  }

  /**
   *Assignee. 
   */
  @JsonProperty
  @Override
  public Optional<User> assignee() {
    return Optional.ofNullable(assignee);
  }

  /**
   *Assignees. 
   */
  @JsonProperty
  @Override
  public Optional<List<User>> assignees() {
    return Optional.ofNullable(assignees);
  }

  /**
   *Milestone. 
   */
  @JsonProperty
  @Override
  public Optional<Milestone> milestone() {
    return Optional.ofNullable(milestone);
  }

  /**
   *Is it locked. 
   */
  @JsonProperty
  @Override
  public @Nullable Boolean locked() {
    return locked;
  }

  /**
   *Merged date. 
   */
  @JsonProperty
  @Override
  public Optional<GitHubInstant> mergedAt() {
    return Optional.ofNullable(mergedAt);
  }

  /**
   *Head reference. 
   */
  @JsonProperty
  @Override
  public @Nullable PullRequestRef head() {
    return head;
  }

  /**
   *Base reference. 
   */
  @JsonProperty
  @Override
  public @Nullable PullRequestRef base() {
    return base;
  }

  /**
   *User. 
   */
  @JsonProperty
  @Override
  public @Nullable User user() {
    return user;
  }

  /**
   *Statuses API URL. 
   */
  @JsonProperty
  @Override
  public @Nullable URI statusesUrl() {
    return statusesUrl;
  }

  /**
   *Review comments API URL. 
   */
  @JsonProperty
  @Override
  public @Nullable URI reviewCommentsUrl() {
    return reviewCommentsUrl;
  }

  /**
   *Review comment API URL template. 
   */
  @JsonProperty
  @Override
  public @Nullable String reviewCommentUrl() {
    return reviewCommentUrl;
  }

  /**
   *Comments API URL. 
   */
  @JsonProperty
  @Override
  public @Nullable URI commentsUrl() {
    return commentsUrl;
  }

  /**
   *Link references. 
   */
  @JsonProperty("_links")
  @Override
  public @Nullable PullRequestLinks links() {
    return links;
  }

  /**
   *Requested reviewers (users) 
   */
  @JsonProperty("requested_reviewers")
  @Override
  public @Nullable List<User> requestedReviewers() {
    return requestedReviewers;
  }

  /**
   *Requested reviewers (teams) 
   */
  @JsonProperty("requested_teams")
  @Override
  public @Nullable List<User> requestedTeams() {
    return requestedTeams;
  }

  /**
   *@Deprecated the merge commit sha. 
   */
  @JsonProperty
  @Override
  public Optional<String> mergeCommitSha() {
    return Optional.ofNullable(mergeCommitSha);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PullRequestItem#createdAt() createdAt} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for createdAt (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePullRequestItem withCreatedAt(@Nullable GitHubInstant value) {
    if (this.createdAt == value) return this;
    return new ImmutablePullRequestItem(
        value,
        this.updatedAt,
        this.closedAt,
        this.id,
        this.url,
        this.htmlUrl,
        this.diffUrl,
        this.patchUrl,
        this.issueUrl,
        this.commitsUrl,
        this.number,
        this.state,
        this.title,
        this.body,
        this.assignee,
        this.assignees,
        this.milestone,
        this.locked,
        this.mergedAt,
        this.head,
        this.base,
        this.user,
        this.statusesUrl,
        this.reviewCommentsUrl,
        this.reviewCommentUrl,
        this.commentsUrl,
        this.links,
        this.requestedReviewers,
        this.requestedTeams,
        this.mergeCommitSha);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PullRequestItem#updatedAt() updatedAt} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for updatedAt (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePullRequestItem withUpdatedAt(@Nullable GitHubInstant value) {
    if (this.updatedAt == value) return this;
    return new ImmutablePullRequestItem(
        this.createdAt,
        value,
        this.closedAt,
        this.id,
        this.url,
        this.htmlUrl,
        this.diffUrl,
        this.patchUrl,
        this.issueUrl,
        this.commitsUrl,
        this.number,
        this.state,
        this.title,
        this.body,
        this.assignee,
        this.assignees,
        this.milestone,
        this.locked,
        this.mergedAt,
        this.head,
        this.base,
        this.user,
        this.statusesUrl,
        this.reviewCommentsUrl,
        this.reviewCommentUrl,
        this.commentsUrl,
        this.links,
        this.requestedReviewers,
        this.requestedTeams,
        this.mergeCommitSha);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link PullRequestItem#closedAt() closedAt} attribute.
   * @param value The value for closedAt
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePullRequestItem withClosedAt(GitHubInstant value) {
    @Nullable GitHubInstant newValue = Objects.requireNonNull(value, "closedAt");
    if (this.closedAt == newValue) return this;
    return new ImmutablePullRequestItem(
        this.createdAt,
        this.updatedAt,
        newValue,
        this.id,
        this.url,
        this.htmlUrl,
        this.diffUrl,
        this.patchUrl,
        this.issueUrl,
        this.commitsUrl,
        this.number,
        this.state,
        this.title,
        this.body,
        this.assignee,
        this.assignees,
        this.milestone,
        this.locked,
        this.mergedAt,
        this.head,
        this.base,
        this.user,
        this.statusesUrl,
        this.reviewCommentsUrl,
        this.reviewCommentUrl,
        this.commentsUrl,
        this.links,
        this.requestedReviewers,
        this.requestedTeams,
        this.mergeCommitSha);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link PullRequestItem#closedAt() closedAt} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for closedAt
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutablePullRequestItem withClosedAt(Optional<? extends GitHubInstant> optional) {
    @Nullable GitHubInstant value = optional.orElse(null);
    if (this.closedAt == value) return this;
    return new ImmutablePullRequestItem(
        this.createdAt,
        this.updatedAt,
        value,
        this.id,
        this.url,
        this.htmlUrl,
        this.diffUrl,
        this.patchUrl,
        this.issueUrl,
        this.commitsUrl,
        this.number,
        this.state,
        this.title,
        this.body,
        this.assignee,
        this.assignees,
        this.milestone,
        this.locked,
        this.mergedAt,
        this.head,
        this.base,
        this.user,
        this.statusesUrl,
        this.reviewCommentsUrl,
        this.reviewCommentUrl,
        this.commentsUrl,
        this.links,
        this.requestedReviewers,
        this.requestedTeams,
        this.mergeCommitSha);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PullRequestItem#id() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePullRequestItem withId(@Nullable Integer value) {
    if (Objects.equals(this.id, value)) return this;
    return new ImmutablePullRequestItem(
        this.createdAt,
        this.updatedAt,
        this.closedAt,
        value,
        this.url,
        this.htmlUrl,
        this.diffUrl,
        this.patchUrl,
        this.issueUrl,
        this.commitsUrl,
        this.number,
        this.state,
        this.title,
        this.body,
        this.assignee,
        this.assignees,
        this.milestone,
        this.locked,
        this.mergedAt,
        this.head,
        this.base,
        this.user,
        this.statusesUrl,
        this.reviewCommentsUrl,
        this.reviewCommentUrl,
        this.commentsUrl,
        this.links,
        this.requestedReviewers,
        this.requestedTeams,
        this.mergeCommitSha);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PullRequestItem#url() url} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for url (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePullRequestItem withUrl(@Nullable URI value) {
    if (this.url == value) return this;
    return new ImmutablePullRequestItem(
        this.createdAt,
        this.updatedAt,
        this.closedAt,
        this.id,
        value,
        this.htmlUrl,
        this.diffUrl,
        this.patchUrl,
        this.issueUrl,
        this.commitsUrl,
        this.number,
        this.state,
        this.title,
        this.body,
        this.assignee,
        this.assignees,
        this.milestone,
        this.locked,
        this.mergedAt,
        this.head,
        this.base,
        this.user,
        this.statusesUrl,
        this.reviewCommentsUrl,
        this.reviewCommentUrl,
        this.commentsUrl,
        this.links,
        this.requestedReviewers,
        this.requestedTeams,
        this.mergeCommitSha);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PullRequestItem#htmlUrl() htmlUrl} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for htmlUrl (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePullRequestItem withHtmlUrl(@Nullable URI value) {
    if (this.htmlUrl == value) return this;
    return new ImmutablePullRequestItem(
        this.createdAt,
        this.updatedAt,
        this.closedAt,
        this.id,
        this.url,
        value,
        this.diffUrl,
        this.patchUrl,
        this.issueUrl,
        this.commitsUrl,
        this.number,
        this.state,
        this.title,
        this.body,
        this.assignee,
        this.assignees,
        this.milestone,
        this.locked,
        this.mergedAt,
        this.head,
        this.base,
        this.user,
        this.statusesUrl,
        this.reviewCommentsUrl,
        this.reviewCommentUrl,
        this.commentsUrl,
        this.links,
        this.requestedReviewers,
        this.requestedTeams,
        this.mergeCommitSha);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PullRequestItem#diffUrl() diffUrl} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for diffUrl (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePullRequestItem withDiffUrl(@Nullable URI value) {
    if (this.diffUrl == value) return this;
    return new ImmutablePullRequestItem(
        this.createdAt,
        this.updatedAt,
        this.closedAt,
        this.id,
        this.url,
        this.htmlUrl,
        value,
        this.patchUrl,
        this.issueUrl,
        this.commitsUrl,
        this.number,
        this.state,
        this.title,
        this.body,
        this.assignee,
        this.assignees,
        this.milestone,
        this.locked,
        this.mergedAt,
        this.head,
        this.base,
        this.user,
        this.statusesUrl,
        this.reviewCommentsUrl,
        this.reviewCommentUrl,
        this.commentsUrl,
        this.links,
        this.requestedReviewers,
        this.requestedTeams,
        this.mergeCommitSha);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PullRequestItem#patchUrl() patchUrl} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for patchUrl (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePullRequestItem withPatchUrl(@Nullable URI value) {
    if (this.patchUrl == value) return this;
    return new ImmutablePullRequestItem(
        this.createdAt,
        this.updatedAt,
        this.closedAt,
        this.id,
        this.url,
        this.htmlUrl,
        this.diffUrl,
        value,
        this.issueUrl,
        this.commitsUrl,
        this.number,
        this.state,
        this.title,
        this.body,
        this.assignee,
        this.assignees,
        this.milestone,
        this.locked,
        this.mergedAt,
        this.head,
        this.base,
        this.user,
        this.statusesUrl,
        this.reviewCommentsUrl,
        this.reviewCommentUrl,
        this.commentsUrl,
        this.links,
        this.requestedReviewers,
        this.requestedTeams,
        this.mergeCommitSha);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PullRequestItem#issueUrl() issueUrl} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for issueUrl (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePullRequestItem withIssueUrl(@Nullable URI value) {
    if (this.issueUrl == value) return this;
    return new ImmutablePullRequestItem(
        this.createdAt,
        this.updatedAt,
        this.closedAt,
        this.id,
        this.url,
        this.htmlUrl,
        this.diffUrl,
        this.patchUrl,
        value,
        this.commitsUrl,
        this.number,
        this.state,
        this.title,
        this.body,
        this.assignee,
        this.assignees,
        this.milestone,
        this.locked,
        this.mergedAt,
        this.head,
        this.base,
        this.user,
        this.statusesUrl,
        this.reviewCommentsUrl,
        this.reviewCommentUrl,
        this.commentsUrl,
        this.links,
        this.requestedReviewers,
        this.requestedTeams,
        this.mergeCommitSha);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PullRequestItem#commitsUrl() commitsUrl} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for commitsUrl (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePullRequestItem withCommitsUrl(@Nullable URI value) {
    if (this.commitsUrl == value) return this;
    return new ImmutablePullRequestItem(
        this.createdAt,
        this.updatedAt,
        this.closedAt,
        this.id,
        this.url,
        this.htmlUrl,
        this.diffUrl,
        this.patchUrl,
        this.issueUrl,
        value,
        this.number,
        this.state,
        this.title,
        this.body,
        this.assignee,
        this.assignees,
        this.milestone,
        this.locked,
        this.mergedAt,
        this.head,
        this.base,
        this.user,
        this.statusesUrl,
        this.reviewCommentsUrl,
        this.reviewCommentUrl,
        this.commentsUrl,
        this.links,
        this.requestedReviewers,
        this.requestedTeams,
        this.mergeCommitSha);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PullRequestItem#number() number} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for number (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePullRequestItem withNumber(@Nullable Integer value) {
    if (Objects.equals(this.number, value)) return this;
    return new ImmutablePullRequestItem(
        this.createdAt,
        this.updatedAt,
        this.closedAt,
        this.id,
        this.url,
        this.htmlUrl,
        this.diffUrl,
        this.patchUrl,
        this.issueUrl,
        this.commitsUrl,
        value,
        this.state,
        this.title,
        this.body,
        this.assignee,
        this.assignees,
        this.milestone,
        this.locked,
        this.mergedAt,
        this.head,
        this.base,
        this.user,
        this.statusesUrl,
        this.reviewCommentsUrl,
        this.reviewCommentUrl,
        this.commentsUrl,
        this.links,
        this.requestedReviewers,
        this.requestedTeams,
        this.mergeCommitSha);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PullRequestItem#state() state} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for state (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePullRequestItem withState(@Nullable String value) {
    if (Objects.equals(this.state, value)) return this;
    return new ImmutablePullRequestItem(
        this.createdAt,
        this.updatedAt,
        this.closedAt,
        this.id,
        this.url,
        this.htmlUrl,
        this.diffUrl,
        this.patchUrl,
        this.issueUrl,
        this.commitsUrl,
        this.number,
        value,
        this.title,
        this.body,
        this.assignee,
        this.assignees,
        this.milestone,
        this.locked,
        this.mergedAt,
        this.head,
        this.base,
        this.user,
        this.statusesUrl,
        this.reviewCommentsUrl,
        this.reviewCommentUrl,
        this.commentsUrl,
        this.links,
        this.requestedReviewers,
        this.requestedTeams,
        this.mergeCommitSha);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PullRequestItem#title() title} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for title (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePullRequestItem withTitle(@Nullable String value) {
    if (Objects.equals(this.title, value)) return this;
    return new ImmutablePullRequestItem(
        this.createdAt,
        this.updatedAt,
        this.closedAt,
        this.id,
        this.url,
        this.htmlUrl,
        this.diffUrl,
        this.patchUrl,
        this.issueUrl,
        this.commitsUrl,
        this.number,
        this.state,
        value,
        this.body,
        this.assignee,
        this.assignees,
        this.milestone,
        this.locked,
        this.mergedAt,
        this.head,
        this.base,
        this.user,
        this.statusesUrl,
        this.reviewCommentsUrl,
        this.reviewCommentUrl,
        this.commentsUrl,
        this.links,
        this.requestedReviewers,
        this.requestedTeams,
        this.mergeCommitSha);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link PullRequestItem#body() body} attribute.
   * @param value The value for body
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePullRequestItem withBody(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "body");
    if (Objects.equals(this.body, newValue)) return this;
    return new ImmutablePullRequestItem(
        this.createdAt,
        this.updatedAt,
        this.closedAt,
        this.id,
        this.url,
        this.htmlUrl,
        this.diffUrl,
        this.patchUrl,
        this.issueUrl,
        this.commitsUrl,
        this.number,
        this.state,
        this.title,
        newValue,
        this.assignee,
        this.assignees,
        this.milestone,
        this.locked,
        this.mergedAt,
        this.head,
        this.base,
        this.user,
        this.statusesUrl,
        this.reviewCommentsUrl,
        this.reviewCommentUrl,
        this.commentsUrl,
        this.links,
        this.requestedReviewers,
        this.requestedTeams,
        this.mergeCommitSha);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link PullRequestItem#body() body} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for body
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePullRequestItem withBody(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.body, value)) return this;
    return new ImmutablePullRequestItem(
        this.createdAt,
        this.updatedAt,
        this.closedAt,
        this.id,
        this.url,
        this.htmlUrl,
        this.diffUrl,
        this.patchUrl,
        this.issueUrl,
        this.commitsUrl,
        this.number,
        this.state,
        this.title,
        value,
        this.assignee,
        this.assignees,
        this.milestone,
        this.locked,
        this.mergedAt,
        this.head,
        this.base,
        this.user,
        this.statusesUrl,
        this.reviewCommentsUrl,
        this.reviewCommentUrl,
        this.commentsUrl,
        this.links,
        this.requestedReviewers,
        this.requestedTeams,
        this.mergeCommitSha);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link PullRequestItem#assignee() assignee} attribute.
   * @param value The value for assignee
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePullRequestItem withAssignee(User value) {
    @Nullable User newValue = Objects.requireNonNull(value, "assignee");
    if (this.assignee == newValue) return this;
    return new ImmutablePullRequestItem(
        this.createdAt,
        this.updatedAt,
        this.closedAt,
        this.id,
        this.url,
        this.htmlUrl,
        this.diffUrl,
        this.patchUrl,
        this.issueUrl,
        this.commitsUrl,
        this.number,
        this.state,
        this.title,
        this.body,
        newValue,
        this.assignees,
        this.milestone,
        this.locked,
        this.mergedAt,
        this.head,
        this.base,
        this.user,
        this.statusesUrl,
        this.reviewCommentsUrl,
        this.reviewCommentUrl,
        this.commentsUrl,
        this.links,
        this.requestedReviewers,
        this.requestedTeams,
        this.mergeCommitSha);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link PullRequestItem#assignee() assignee} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for assignee
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutablePullRequestItem withAssignee(Optional<? extends User> optional) {
    @Nullable User value = optional.orElse(null);
    if (this.assignee == value) return this;
    return new ImmutablePullRequestItem(
        this.createdAt,
        this.updatedAt,
        this.closedAt,
        this.id,
        this.url,
        this.htmlUrl,
        this.diffUrl,
        this.patchUrl,
        this.issueUrl,
        this.commitsUrl,
        this.number,
        this.state,
        this.title,
        this.body,
        value,
        this.assignees,
        this.milestone,
        this.locked,
        this.mergedAt,
        this.head,
        this.base,
        this.user,
        this.statusesUrl,
        this.reviewCommentsUrl,
        this.reviewCommentUrl,
        this.commentsUrl,
        this.links,
        this.requestedReviewers,
        this.requestedTeams,
        this.mergeCommitSha);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link PullRequestItem#assignees() assignees} attribute.
   * @param value The value for assignees
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePullRequestItem withAssignees(List<User> value) {
    @Nullable List<User> newValue = Objects.requireNonNull(value, "assignees");
    if (this.assignees == newValue) return this;
    return new ImmutablePullRequestItem(
        this.createdAt,
        this.updatedAt,
        this.closedAt,
        this.id,
        this.url,
        this.htmlUrl,
        this.diffUrl,
        this.patchUrl,
        this.issueUrl,
        this.commitsUrl,
        this.number,
        this.state,
        this.title,
        this.body,
        this.assignee,
        newValue,
        this.milestone,
        this.locked,
        this.mergedAt,
        this.head,
        this.base,
        this.user,
        this.statusesUrl,
        this.reviewCommentsUrl,
        this.reviewCommentUrl,
        this.commentsUrl,
        this.links,
        this.requestedReviewers,
        this.requestedTeams,
        this.mergeCommitSha);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link PullRequestItem#assignees() assignees} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for assignees
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutablePullRequestItem withAssignees(Optional<? extends List<User>> optional) {
    @Nullable List<User> value = optional.orElse(null);
    if (this.assignees == value) return this;
    return new ImmutablePullRequestItem(
        this.createdAt,
        this.updatedAt,
        this.closedAt,
        this.id,
        this.url,
        this.htmlUrl,
        this.diffUrl,
        this.patchUrl,
        this.issueUrl,
        this.commitsUrl,
        this.number,
        this.state,
        this.title,
        this.body,
        this.assignee,
        value,
        this.milestone,
        this.locked,
        this.mergedAt,
        this.head,
        this.base,
        this.user,
        this.statusesUrl,
        this.reviewCommentsUrl,
        this.reviewCommentUrl,
        this.commentsUrl,
        this.links,
        this.requestedReviewers,
        this.requestedTeams,
        this.mergeCommitSha);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link PullRequestItem#milestone() milestone} attribute.
   * @param value The value for milestone
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePullRequestItem withMilestone(Milestone value) {
    @Nullable Milestone newValue = Objects.requireNonNull(value, "milestone");
    if (this.milestone == newValue) return this;
    return new ImmutablePullRequestItem(
        this.createdAt,
        this.updatedAt,
        this.closedAt,
        this.id,
        this.url,
        this.htmlUrl,
        this.diffUrl,
        this.patchUrl,
        this.issueUrl,
        this.commitsUrl,
        this.number,
        this.state,
        this.title,
        this.body,
        this.assignee,
        this.assignees,
        newValue,
        this.locked,
        this.mergedAt,
        this.head,
        this.base,
        this.user,
        this.statusesUrl,
        this.reviewCommentsUrl,
        this.reviewCommentUrl,
        this.commentsUrl,
        this.links,
        this.requestedReviewers,
        this.requestedTeams,
        this.mergeCommitSha);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link PullRequestItem#milestone() milestone} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for milestone
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutablePullRequestItem withMilestone(Optional<? extends Milestone> optional) {
    @Nullable Milestone value = optional.orElse(null);
    if (this.milestone == value) return this;
    return new ImmutablePullRequestItem(
        this.createdAt,
        this.updatedAt,
        this.closedAt,
        this.id,
        this.url,
        this.htmlUrl,
        this.diffUrl,
        this.patchUrl,
        this.issueUrl,
        this.commitsUrl,
        this.number,
        this.state,
        this.title,
        this.body,
        this.assignee,
        this.assignees,
        value,
        this.locked,
        this.mergedAt,
        this.head,
        this.base,
        this.user,
        this.statusesUrl,
        this.reviewCommentsUrl,
        this.reviewCommentUrl,
        this.commentsUrl,
        this.links,
        this.requestedReviewers,
        this.requestedTeams,
        this.mergeCommitSha);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PullRequestItem#locked() locked} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for locked (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePullRequestItem withLocked(@Nullable Boolean value) {
    if (Objects.equals(this.locked, value)) return this;
    return new ImmutablePullRequestItem(
        this.createdAt,
        this.updatedAt,
        this.closedAt,
        this.id,
        this.url,
        this.htmlUrl,
        this.diffUrl,
        this.patchUrl,
        this.issueUrl,
        this.commitsUrl,
        this.number,
        this.state,
        this.title,
        this.body,
        this.assignee,
        this.assignees,
        this.milestone,
        value,
        this.mergedAt,
        this.head,
        this.base,
        this.user,
        this.statusesUrl,
        this.reviewCommentsUrl,
        this.reviewCommentUrl,
        this.commentsUrl,
        this.links,
        this.requestedReviewers,
        this.requestedTeams,
        this.mergeCommitSha);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link PullRequestItem#mergedAt() mergedAt} attribute.
   * @param value The value for mergedAt
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePullRequestItem withMergedAt(GitHubInstant value) {
    @Nullable GitHubInstant newValue = Objects.requireNonNull(value, "mergedAt");
    if (this.mergedAt == newValue) return this;
    return new ImmutablePullRequestItem(
        this.createdAt,
        this.updatedAt,
        this.closedAt,
        this.id,
        this.url,
        this.htmlUrl,
        this.diffUrl,
        this.patchUrl,
        this.issueUrl,
        this.commitsUrl,
        this.number,
        this.state,
        this.title,
        this.body,
        this.assignee,
        this.assignees,
        this.milestone,
        this.locked,
        newValue,
        this.head,
        this.base,
        this.user,
        this.statusesUrl,
        this.reviewCommentsUrl,
        this.reviewCommentUrl,
        this.commentsUrl,
        this.links,
        this.requestedReviewers,
        this.requestedTeams,
        this.mergeCommitSha);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link PullRequestItem#mergedAt() mergedAt} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for mergedAt
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutablePullRequestItem withMergedAt(Optional<? extends GitHubInstant> optional) {
    @Nullable GitHubInstant value = optional.orElse(null);
    if (this.mergedAt == value) return this;
    return new ImmutablePullRequestItem(
        this.createdAt,
        this.updatedAt,
        this.closedAt,
        this.id,
        this.url,
        this.htmlUrl,
        this.diffUrl,
        this.patchUrl,
        this.issueUrl,
        this.commitsUrl,
        this.number,
        this.state,
        this.title,
        this.body,
        this.assignee,
        this.assignees,
        this.milestone,
        this.locked,
        value,
        this.head,
        this.base,
        this.user,
        this.statusesUrl,
        this.reviewCommentsUrl,
        this.reviewCommentUrl,
        this.commentsUrl,
        this.links,
        this.requestedReviewers,
        this.requestedTeams,
        this.mergeCommitSha);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PullRequestItem#head() head} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for head (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePullRequestItem withHead(@Nullable PullRequestRef value) {
    if (this.head == value) return this;
    return new ImmutablePullRequestItem(
        this.createdAt,
        this.updatedAt,
        this.closedAt,
        this.id,
        this.url,
        this.htmlUrl,
        this.diffUrl,
        this.patchUrl,
        this.issueUrl,
        this.commitsUrl,
        this.number,
        this.state,
        this.title,
        this.body,
        this.assignee,
        this.assignees,
        this.milestone,
        this.locked,
        this.mergedAt,
        value,
        this.base,
        this.user,
        this.statusesUrl,
        this.reviewCommentsUrl,
        this.reviewCommentUrl,
        this.commentsUrl,
        this.links,
        this.requestedReviewers,
        this.requestedTeams,
        this.mergeCommitSha);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PullRequestItem#base() base} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for base (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePullRequestItem withBase(@Nullable PullRequestRef value) {
    if (this.base == value) return this;
    return new ImmutablePullRequestItem(
        this.createdAt,
        this.updatedAt,
        this.closedAt,
        this.id,
        this.url,
        this.htmlUrl,
        this.diffUrl,
        this.patchUrl,
        this.issueUrl,
        this.commitsUrl,
        this.number,
        this.state,
        this.title,
        this.body,
        this.assignee,
        this.assignees,
        this.milestone,
        this.locked,
        this.mergedAt,
        this.head,
        value,
        this.user,
        this.statusesUrl,
        this.reviewCommentsUrl,
        this.reviewCommentUrl,
        this.commentsUrl,
        this.links,
        this.requestedReviewers,
        this.requestedTeams,
        this.mergeCommitSha);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PullRequestItem#user() user} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for user (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePullRequestItem withUser(@Nullable User value) {
    if (this.user == value) return this;
    return new ImmutablePullRequestItem(
        this.createdAt,
        this.updatedAt,
        this.closedAt,
        this.id,
        this.url,
        this.htmlUrl,
        this.diffUrl,
        this.patchUrl,
        this.issueUrl,
        this.commitsUrl,
        this.number,
        this.state,
        this.title,
        this.body,
        this.assignee,
        this.assignees,
        this.milestone,
        this.locked,
        this.mergedAt,
        this.head,
        this.base,
        value,
        this.statusesUrl,
        this.reviewCommentsUrl,
        this.reviewCommentUrl,
        this.commentsUrl,
        this.links,
        this.requestedReviewers,
        this.requestedTeams,
        this.mergeCommitSha);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PullRequestItem#statusesUrl() statusesUrl} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for statusesUrl (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePullRequestItem withStatusesUrl(@Nullable URI value) {
    if (this.statusesUrl == value) return this;
    return new ImmutablePullRequestItem(
        this.createdAt,
        this.updatedAt,
        this.closedAt,
        this.id,
        this.url,
        this.htmlUrl,
        this.diffUrl,
        this.patchUrl,
        this.issueUrl,
        this.commitsUrl,
        this.number,
        this.state,
        this.title,
        this.body,
        this.assignee,
        this.assignees,
        this.milestone,
        this.locked,
        this.mergedAt,
        this.head,
        this.base,
        this.user,
        value,
        this.reviewCommentsUrl,
        this.reviewCommentUrl,
        this.commentsUrl,
        this.links,
        this.requestedReviewers,
        this.requestedTeams,
        this.mergeCommitSha);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PullRequestItem#reviewCommentsUrl() reviewCommentsUrl} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for reviewCommentsUrl (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePullRequestItem withReviewCommentsUrl(@Nullable URI value) {
    if (this.reviewCommentsUrl == value) return this;
    return new ImmutablePullRequestItem(
        this.createdAt,
        this.updatedAt,
        this.closedAt,
        this.id,
        this.url,
        this.htmlUrl,
        this.diffUrl,
        this.patchUrl,
        this.issueUrl,
        this.commitsUrl,
        this.number,
        this.state,
        this.title,
        this.body,
        this.assignee,
        this.assignees,
        this.milestone,
        this.locked,
        this.mergedAt,
        this.head,
        this.base,
        this.user,
        this.statusesUrl,
        value,
        this.reviewCommentUrl,
        this.commentsUrl,
        this.links,
        this.requestedReviewers,
        this.requestedTeams,
        this.mergeCommitSha);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PullRequestItem#reviewCommentUrl() reviewCommentUrl} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for reviewCommentUrl (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePullRequestItem withReviewCommentUrl(@Nullable String value) {
    if (Objects.equals(this.reviewCommentUrl, value)) return this;
    return new ImmutablePullRequestItem(
        this.createdAt,
        this.updatedAt,
        this.closedAt,
        this.id,
        this.url,
        this.htmlUrl,
        this.diffUrl,
        this.patchUrl,
        this.issueUrl,
        this.commitsUrl,
        this.number,
        this.state,
        this.title,
        this.body,
        this.assignee,
        this.assignees,
        this.milestone,
        this.locked,
        this.mergedAt,
        this.head,
        this.base,
        this.user,
        this.statusesUrl,
        this.reviewCommentsUrl,
        value,
        this.commentsUrl,
        this.links,
        this.requestedReviewers,
        this.requestedTeams,
        this.mergeCommitSha);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PullRequestItem#commentsUrl() commentsUrl} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for commentsUrl (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePullRequestItem withCommentsUrl(@Nullable URI value) {
    if (this.commentsUrl == value) return this;
    return new ImmutablePullRequestItem(
        this.createdAt,
        this.updatedAt,
        this.closedAt,
        this.id,
        this.url,
        this.htmlUrl,
        this.diffUrl,
        this.patchUrl,
        this.issueUrl,
        this.commitsUrl,
        this.number,
        this.state,
        this.title,
        this.body,
        this.assignee,
        this.assignees,
        this.milestone,
        this.locked,
        this.mergedAt,
        this.head,
        this.base,
        this.user,
        this.statusesUrl,
        this.reviewCommentsUrl,
        this.reviewCommentUrl,
        value,
        this.links,
        this.requestedReviewers,
        this.requestedTeams,
        this.mergeCommitSha);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PullRequestItem#links() links} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for links (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePullRequestItem withLinks(@Nullable PullRequestLinks value) {
    if (this.links == value) return this;
    return new ImmutablePullRequestItem(
        this.createdAt,
        this.updatedAt,
        this.closedAt,
        this.id,
        this.url,
        this.htmlUrl,
        this.diffUrl,
        this.patchUrl,
        this.issueUrl,
        this.commitsUrl,
        this.number,
        this.state,
        this.title,
        this.body,
        this.assignee,
        this.assignees,
        this.milestone,
        this.locked,
        this.mergedAt,
        this.head,
        this.base,
        this.user,
        this.statusesUrl,
        this.reviewCommentsUrl,
        this.reviewCommentUrl,
        this.commentsUrl,
        value,
        this.requestedReviewers,
        this.requestedTeams,
        this.mergeCommitSha);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link PullRequestItem#requestedReviewers() requestedReviewers}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePullRequestItem withRequestedReviewers(@Nullable User... elements) {
    if (elements == null) {
      return new ImmutablePullRequestItem(
          this.createdAt,
          this.updatedAt,
          this.closedAt,
          this.id,
          this.url,
          this.htmlUrl,
          this.diffUrl,
          this.patchUrl,
          this.issueUrl,
          this.commitsUrl,
          this.number,
          this.state,
          this.title,
          this.body,
          this.assignee,
          this.assignees,
          this.milestone,
          this.locked,
          this.mergedAt,
          this.head,
          this.base,
          this.user,
          this.statusesUrl,
          this.reviewCommentsUrl,
          this.reviewCommentUrl,
          this.commentsUrl,
          this.links,
          null,
          this.requestedTeams,
          this.mergeCommitSha);
    }
    @Nullable List<User> newValue = Arrays.asList(elements) == null ? null : createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutablePullRequestItem(
        this.createdAt,
        this.updatedAt,
        this.closedAt,
        this.id,
        this.url,
        this.htmlUrl,
        this.diffUrl,
        this.patchUrl,
        this.issueUrl,
        this.commitsUrl,
        this.number,
        this.state,
        this.title,
        this.body,
        this.assignee,
        this.assignees,
        this.milestone,
        this.locked,
        this.mergedAt,
        this.head,
        this.base,
        this.user,
        this.statusesUrl,
        this.reviewCommentsUrl,
        this.reviewCommentUrl,
        this.commentsUrl,
        this.links,
        newValue,
        this.requestedTeams,
        this.mergeCommitSha);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link PullRequestItem#requestedReviewers() requestedReviewers}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of requestedReviewers elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePullRequestItem withRequestedReviewers(@Nullable Iterable<? extends User> elements) {
    if (this.requestedReviewers == elements) return this;
    @Nullable List<User> newValue = elements == null ? null : createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutablePullRequestItem(
        this.createdAt,
        this.updatedAt,
        this.closedAt,
        this.id,
        this.url,
        this.htmlUrl,
        this.diffUrl,
        this.patchUrl,
        this.issueUrl,
        this.commitsUrl,
        this.number,
        this.state,
        this.title,
        this.body,
        this.assignee,
        this.assignees,
        this.milestone,
        this.locked,
        this.mergedAt,
        this.head,
        this.base,
        this.user,
        this.statusesUrl,
        this.reviewCommentsUrl,
        this.reviewCommentUrl,
        this.commentsUrl,
        this.links,
        newValue,
        this.requestedTeams,
        this.mergeCommitSha);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link PullRequestItem#requestedTeams() requestedTeams}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePullRequestItem withRequestedTeams(@Nullable User... elements) {
    if (elements == null) {
      return new ImmutablePullRequestItem(
          this.createdAt,
          this.updatedAt,
          this.closedAt,
          this.id,
          this.url,
          this.htmlUrl,
          this.diffUrl,
          this.patchUrl,
          this.issueUrl,
          this.commitsUrl,
          this.number,
          this.state,
          this.title,
          this.body,
          this.assignee,
          this.assignees,
          this.milestone,
          this.locked,
          this.mergedAt,
          this.head,
          this.base,
          this.user,
          this.statusesUrl,
          this.reviewCommentsUrl,
          this.reviewCommentUrl,
          this.commentsUrl,
          this.links,
          this.requestedReviewers,
          null,
          this.mergeCommitSha);
    }
    @Nullable List<User> newValue = Arrays.asList(elements) == null ? null : createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutablePullRequestItem(
        this.createdAt,
        this.updatedAt,
        this.closedAt,
        this.id,
        this.url,
        this.htmlUrl,
        this.diffUrl,
        this.patchUrl,
        this.issueUrl,
        this.commitsUrl,
        this.number,
        this.state,
        this.title,
        this.body,
        this.assignee,
        this.assignees,
        this.milestone,
        this.locked,
        this.mergedAt,
        this.head,
        this.base,
        this.user,
        this.statusesUrl,
        this.reviewCommentsUrl,
        this.reviewCommentUrl,
        this.commentsUrl,
        this.links,
        this.requestedReviewers,
        newValue,
        this.mergeCommitSha);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link PullRequestItem#requestedTeams() requestedTeams}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of requestedTeams elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePullRequestItem withRequestedTeams(@Nullable Iterable<? extends User> elements) {
    if (this.requestedTeams == elements) return this;
    @Nullable List<User> newValue = elements == null ? null : createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutablePullRequestItem(
        this.createdAt,
        this.updatedAt,
        this.closedAt,
        this.id,
        this.url,
        this.htmlUrl,
        this.diffUrl,
        this.patchUrl,
        this.issueUrl,
        this.commitsUrl,
        this.number,
        this.state,
        this.title,
        this.body,
        this.assignee,
        this.assignees,
        this.milestone,
        this.locked,
        this.mergedAt,
        this.head,
        this.base,
        this.user,
        this.statusesUrl,
        this.reviewCommentsUrl,
        this.reviewCommentUrl,
        this.commentsUrl,
        this.links,
        this.requestedReviewers,
        newValue,
        this.mergeCommitSha);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link PullRequestItem#mergeCommitSha() mergeCommitSha} attribute.
   * @param value The value for mergeCommitSha
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePullRequestItem withMergeCommitSha(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "mergeCommitSha");
    if (Objects.equals(this.mergeCommitSha, newValue)) return this;
    return new ImmutablePullRequestItem(
        this.createdAt,
        this.updatedAt,
        this.closedAt,
        this.id,
        this.url,
        this.htmlUrl,
        this.diffUrl,
        this.patchUrl,
        this.issueUrl,
        this.commitsUrl,
        this.number,
        this.state,
        this.title,
        this.body,
        this.assignee,
        this.assignees,
        this.milestone,
        this.locked,
        this.mergedAt,
        this.head,
        this.base,
        this.user,
        this.statusesUrl,
        this.reviewCommentsUrl,
        this.reviewCommentUrl,
        this.commentsUrl,
        this.links,
        this.requestedReviewers,
        this.requestedTeams,
        newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link PullRequestItem#mergeCommitSha() mergeCommitSha} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for mergeCommitSha
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePullRequestItem withMergeCommitSha(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.mergeCommitSha, value)) return this;
    return new ImmutablePullRequestItem(
        this.createdAt,
        this.updatedAt,
        this.closedAt,
        this.id,
        this.url,
        this.htmlUrl,
        this.diffUrl,
        this.patchUrl,
        this.issueUrl,
        this.commitsUrl,
        this.number,
        this.state,
        this.title,
        this.body,
        this.assignee,
        this.assignees,
        this.milestone,
        this.locked,
        this.mergedAt,
        this.head,
        this.base,
        this.user,
        this.statusesUrl,
        this.reviewCommentsUrl,
        this.reviewCommentUrl,
        this.commentsUrl,
        this.links,
        this.requestedReviewers,
        this.requestedTeams,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutablePullRequestItem} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutablePullRequestItem
        && equalTo((ImmutablePullRequestItem) another);
  }

  private boolean equalTo(ImmutablePullRequestItem another) {
    return Objects.equals(createdAt, another.createdAt)
        && Objects.equals(updatedAt, another.updatedAt)
        && Objects.equals(closedAt, another.closedAt)
        && Objects.equals(id, another.id)
        && Objects.equals(url, another.url)
        && Objects.equals(htmlUrl, another.htmlUrl)
        && Objects.equals(diffUrl, another.diffUrl)
        && Objects.equals(patchUrl, another.patchUrl)
        && Objects.equals(issueUrl, another.issueUrl)
        && Objects.equals(commitsUrl, another.commitsUrl)
        && Objects.equals(number, another.number)
        && Objects.equals(state, another.state)
        && Objects.equals(title, another.title)
        && Objects.equals(body, another.body)
        && Objects.equals(assignee, another.assignee)
        && Objects.equals(assignees, another.assignees)
        && Objects.equals(milestone, another.milestone)
        && Objects.equals(locked, another.locked)
        && Objects.equals(mergedAt, another.mergedAt)
        && Objects.equals(head, another.head)
        && Objects.equals(base, another.base)
        && Objects.equals(user, another.user)
        && Objects.equals(statusesUrl, another.statusesUrl)
        && Objects.equals(reviewCommentsUrl, another.reviewCommentsUrl)
        && Objects.equals(reviewCommentUrl, another.reviewCommentUrl)
        && Objects.equals(commentsUrl, another.commentsUrl)
        && Objects.equals(links, another.links)
        && Objects.equals(requestedReviewers, another.requestedReviewers)
        && Objects.equals(requestedTeams, another.requestedTeams)
        && Objects.equals(mergeCommitSha, another.mergeCommitSha);
  }

  /**
   * Computes a hash code from attributes: {@code createdAt}, {@code updatedAt}, {@code closedAt}, {@code id}, {@code url}, {@code htmlUrl}, {@code diffUrl}, {@code patchUrl}, {@code issueUrl}, {@code commitsUrl}, {@code number}, {@code state}, {@code title}, {@code body}, {@code assignee}, {@code assignees}, {@code milestone}, {@code locked}, {@code mergedAt}, {@code head}, {@code base}, {@code user}, {@code statusesUrl}, {@code reviewCommentsUrl}, {@code reviewCommentUrl}, {@code commentsUrl}, {@code links}, {@code requestedReviewers}, {@code requestedTeams}, {@code mergeCommitSha}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(createdAt);
    h += (h << 5) + Objects.hashCode(updatedAt);
    h += (h << 5) + Objects.hashCode(closedAt);
    h += (h << 5) + Objects.hashCode(id);
    h += (h << 5) + Objects.hashCode(url);
    h += (h << 5) + Objects.hashCode(htmlUrl);
    h += (h << 5) + Objects.hashCode(diffUrl);
    h += (h << 5) + Objects.hashCode(patchUrl);
    h += (h << 5) + Objects.hashCode(issueUrl);
    h += (h << 5) + Objects.hashCode(commitsUrl);
    h += (h << 5) + Objects.hashCode(number);
    h += (h << 5) + Objects.hashCode(state);
    h += (h << 5) + Objects.hashCode(title);
    h += (h << 5) + Objects.hashCode(body);
    h += (h << 5) + Objects.hashCode(assignee);
    h += (h << 5) + Objects.hashCode(assignees);
    h += (h << 5) + Objects.hashCode(milestone);
    h += (h << 5) + Objects.hashCode(locked);
    h += (h << 5) + Objects.hashCode(mergedAt);
    h += (h << 5) + Objects.hashCode(head);
    h += (h << 5) + Objects.hashCode(base);
    h += (h << 5) + Objects.hashCode(user);
    h += (h << 5) + Objects.hashCode(statusesUrl);
    h += (h << 5) + Objects.hashCode(reviewCommentsUrl);
    h += (h << 5) + Objects.hashCode(reviewCommentUrl);
    h += (h << 5) + Objects.hashCode(commentsUrl);
    h += (h << 5) + Objects.hashCode(links);
    h += (h << 5) + Objects.hashCode(requestedReviewers);
    h += (h << 5) + Objects.hashCode(requestedTeams);
    h += (h << 5) + Objects.hashCode(mergeCommitSha);
    return h;
  }

  /**
   * Prints the immutable value {@code PullRequestItem} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("PullRequestItem{");
    if (createdAt != null) {
      builder.append("createdAt=").append(createdAt);
    }
    if (updatedAt != null) {
      if (builder.length() > 16) builder.append(", ");
      builder.append("updatedAt=").append(updatedAt);
    }
    if (closedAt != null) {
      if (builder.length() > 16) builder.append(", ");
      builder.append("closedAt=").append(closedAt);
    }
    if (id != null) {
      if (builder.length() > 16) builder.append(", ");
      builder.append("id=").append(id);
    }
    if (url != null) {
      if (builder.length() > 16) builder.append(", ");
      builder.append("url=").append(url);
    }
    if (htmlUrl != null) {
      if (builder.length() > 16) builder.append(", ");
      builder.append("htmlUrl=").append(htmlUrl);
    }
    if (diffUrl != null) {
      if (builder.length() > 16) builder.append(", ");
      builder.append("diffUrl=").append(diffUrl);
    }
    if (patchUrl != null) {
      if (builder.length() > 16) builder.append(", ");
      builder.append("patchUrl=").append(patchUrl);
    }
    if (issueUrl != null) {
      if (builder.length() > 16) builder.append(", ");
      builder.append("issueUrl=").append(issueUrl);
    }
    if (commitsUrl != null) {
      if (builder.length() > 16) builder.append(", ");
      builder.append("commitsUrl=").append(commitsUrl);
    }
    if (number != null) {
      if (builder.length() > 16) builder.append(", ");
      builder.append("number=").append(number);
    }
    if (state != null) {
      if (builder.length() > 16) builder.append(", ");
      builder.append("state=").append(state);
    }
    if (title != null) {
      if (builder.length() > 16) builder.append(", ");
      builder.append("title=").append(title);
    }
    if (body != null) {
      if (builder.length() > 16) builder.append(", ");
      builder.append("body=").append(body);
    }
    if (assignee != null) {
      if (builder.length() > 16) builder.append(", ");
      builder.append("assignee=").append(assignee);
    }
    if (assignees != null) {
      if (builder.length() > 16) builder.append(", ");
      builder.append("assignees=").append(assignees);
    }
    if (milestone != null) {
      if (builder.length() > 16) builder.append(", ");
      builder.append("milestone=").append(milestone);
    }
    if (locked != null) {
      if (builder.length() > 16) builder.append(", ");
      builder.append("locked=").append(locked);
    }
    if (mergedAt != null) {
      if (builder.length() > 16) builder.append(", ");
      builder.append("mergedAt=").append(mergedAt);
    }
    if (head != null) {
      if (builder.length() > 16) builder.append(", ");
      builder.append("head=").append(head);
    }
    if (base != null) {
      if (builder.length() > 16) builder.append(", ");
      builder.append("base=").append(base);
    }
    if (user != null) {
      if (builder.length() > 16) builder.append(", ");
      builder.append("user=").append(user);
    }
    if (statusesUrl != null) {
      if (builder.length() > 16) builder.append(", ");
      builder.append("statusesUrl=").append(statusesUrl);
    }
    if (reviewCommentsUrl != null) {
      if (builder.length() > 16) builder.append(", ");
      builder.append("reviewCommentsUrl=").append(reviewCommentsUrl);
    }
    if (reviewCommentUrl != null) {
      if (builder.length() > 16) builder.append(", ");
      builder.append("reviewCommentUrl=").append(reviewCommentUrl);
    }
    if (commentsUrl != null) {
      if (builder.length() > 16) builder.append(", ");
      builder.append("commentsUrl=").append(commentsUrl);
    }
    if (links != null) {
      if (builder.length() > 16) builder.append(", ");
      builder.append("links=").append(links);
    }
    if (requestedReviewers != null) {
      if (builder.length() > 16) builder.append(", ");
      builder.append("requestedReviewers=").append(requestedReviewers);
    }
    if (requestedTeams != null) {
      if (builder.length() > 16) builder.append(", ");
      builder.append("requestedTeams=").append(requestedTeams);
    }
    if (mergeCommitSha != null) {
      if (builder.length() > 16) builder.append(", ");
      builder.append("mergeCommitSha=").append(mergeCommitSha);
    }
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "PullRequestItem", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements PullRequestItem {
    @Nullable GitHubInstant createdAt;
    @Nullable GitHubInstant updatedAt;
    @Nullable Optional<GitHubInstant> closedAt = Optional.empty();
    @Nullable Integer id;
    @Nullable URI url;
    @Nullable URI htmlUrl;
    @Nullable URI diffUrl;
    @Nullable URI patchUrl;
    @Nullable URI issueUrl;
    @Nullable URI commitsUrl;
    @Nullable Integer number;
    @Nullable String state;
    @Nullable String title;
    @Nullable Optional<String> body = Optional.empty();
    @Nullable Optional<User> assignee = Optional.empty();
    @Nullable Optional<List<User>> assignees = Optional.empty();
    @Nullable Optional<Milestone> milestone = Optional.empty();
    @Nullable Boolean locked;
    @Nullable Optional<GitHubInstant> mergedAt = Optional.empty();
    @Nullable PullRequestRef head;
    @Nullable PullRequestRef base;
    @Nullable User user;
    @Nullable URI statusesUrl;
    @Nullable URI reviewCommentsUrl;
    @Nullable String reviewCommentUrl;
    @Nullable URI commentsUrl;
    @Nullable PullRequestLinks links;
    @Nullable List<User> requestedReviewers = null;
    @Nullable List<User> requestedTeams = null;
    @Nullable Optional<String> mergeCommitSha = Optional.empty();
    @JsonProperty
    public void setCreatedAt(@Nullable GitHubInstant createdAt) {
      this.createdAt = createdAt;
    }
    @JsonProperty
    public void setUpdatedAt(@Nullable GitHubInstant updatedAt) {
      this.updatedAt = updatedAt;
    }
    @JsonProperty
    public void setClosedAt(Optional<GitHubInstant> closedAt) {
      this.closedAt = closedAt;
    }
    @JsonProperty
    public void setId(@Nullable Integer id) {
      this.id = id;
    }
    @JsonProperty
    public void setUrl(@Nullable URI url) {
      this.url = url;
    }
    @JsonProperty
    public void setHtmlUrl(@Nullable URI htmlUrl) {
      this.htmlUrl = htmlUrl;
    }
    @JsonProperty
    public void setDiffUrl(@Nullable URI diffUrl) {
      this.diffUrl = diffUrl;
    }
    @JsonProperty
    public void setPatchUrl(@Nullable URI patchUrl) {
      this.patchUrl = patchUrl;
    }
    @JsonProperty
    public void setIssueUrl(@Nullable URI issueUrl) {
      this.issueUrl = issueUrl;
    }
    @JsonProperty
    public void setCommitsUrl(@Nullable URI commitsUrl) {
      this.commitsUrl = commitsUrl;
    }
    @JsonProperty
    public void setNumber(@Nullable Integer number) {
      this.number = number;
    }
    @JsonProperty
    public void setState(@Nullable String state) {
      this.state = state;
    }
    @JsonProperty
    public void setTitle(@Nullable String title) {
      this.title = title;
    }
    @JsonProperty
    public void setBody(Optional<String> body) {
      this.body = body;
    }
    @JsonProperty
    public void setAssignee(Optional<User> assignee) {
      this.assignee = assignee;
    }
    @JsonProperty
    public void setAssignees(Optional<List<User>> assignees) {
      this.assignees = assignees;
    }
    @JsonProperty
    public void setMilestone(Optional<Milestone> milestone) {
      this.milestone = milestone;
    }
    @JsonProperty
    public void setLocked(@Nullable Boolean locked) {
      this.locked = locked;
    }
    @JsonProperty
    public void setMergedAt(Optional<GitHubInstant> mergedAt) {
      this.mergedAt = mergedAt;
    }
    @JsonProperty
    public void setHead(@Nullable PullRequestRef head) {
      this.head = head;
    }
    @JsonProperty
    public void setBase(@Nullable PullRequestRef base) {
      this.base = base;
    }
    @JsonProperty
    public void setUser(@Nullable User user) {
      this.user = user;
    }
    @JsonProperty
    public void setStatusesUrl(@Nullable URI statusesUrl) {
      this.statusesUrl = statusesUrl;
    }
    @JsonProperty
    public void setReviewCommentsUrl(@Nullable URI reviewCommentsUrl) {
      this.reviewCommentsUrl = reviewCommentsUrl;
    }
    @JsonProperty
    public void setReviewCommentUrl(@Nullable String reviewCommentUrl) {
      this.reviewCommentUrl = reviewCommentUrl;
    }
    @JsonProperty
    public void setCommentsUrl(@Nullable URI commentsUrl) {
      this.commentsUrl = commentsUrl;
    }
    @JsonProperty("_links")
    public void setLinks(@Nullable PullRequestLinks links) {
      this.links = links;
    }
    @JsonProperty("requested_reviewers")
    public void setRequestedReviewers(@Nullable List<User> requestedReviewers) {
      this.requestedReviewers = requestedReviewers;
    }
    @JsonProperty("requested_teams")
    public void setRequestedTeams(@Nullable List<User> requestedTeams) {
      this.requestedTeams = requestedTeams;
    }
    @JsonProperty
    public void setMergeCommitSha(Optional<String> mergeCommitSha) {
      this.mergeCommitSha = mergeCommitSha;
    }
    @Override
    public GitHubInstant createdAt() { throw new UnsupportedOperationException(); }
    @Override
    public GitHubInstant updatedAt() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<GitHubInstant> closedAt() { throw new UnsupportedOperationException(); }
    @Override
    public Integer id() { throw new UnsupportedOperationException(); }
    @Override
    public URI url() { throw new UnsupportedOperationException(); }
    @Override
    public URI htmlUrl() { throw new UnsupportedOperationException(); }
    @Override
    public URI diffUrl() { throw new UnsupportedOperationException(); }
    @Override
    public URI patchUrl() { throw new UnsupportedOperationException(); }
    @Override
    public URI issueUrl() { throw new UnsupportedOperationException(); }
    @Override
    public URI commitsUrl() { throw new UnsupportedOperationException(); }
    @Override
    public Integer number() { throw new UnsupportedOperationException(); }
    @Override
    public String state() { throw new UnsupportedOperationException(); }
    @Override
    public String title() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> body() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<User> assignee() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<List<User>> assignees() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Milestone> milestone() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean locked() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<GitHubInstant> mergedAt() { throw new UnsupportedOperationException(); }
    @Override
    public PullRequestRef head() { throw new UnsupportedOperationException(); }
    @Override
    public PullRequestRef base() { throw new UnsupportedOperationException(); }
    @Override
    public User user() { throw new UnsupportedOperationException(); }
    @Override
    public URI statusesUrl() { throw new UnsupportedOperationException(); }
    @Override
    public URI reviewCommentsUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String reviewCommentUrl() { throw new UnsupportedOperationException(); }
    @Override
    public URI commentsUrl() { throw new UnsupportedOperationException(); }
    @Override
    public PullRequestLinks links() { throw new UnsupportedOperationException(); }
    @Override
    public List<User> requestedReviewers() { throw new UnsupportedOperationException(); }
    @Override
    public List<User> requestedTeams() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> mergeCommitSha() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutablePullRequestItem fromJson(Json json) {
    ImmutablePullRequestItem.Builder builder = ImmutablePullRequestItem.builder();
    if (json.createdAt != null) {
      builder.createdAt(json.createdAt);
    }
    if (json.updatedAt != null) {
      builder.updatedAt(json.updatedAt);
    }
    if (json.closedAt != null) {
      builder.closedAt(json.closedAt);
    }
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.url != null) {
      builder.url(json.url);
    }
    if (json.htmlUrl != null) {
      builder.htmlUrl(json.htmlUrl);
    }
    if (json.diffUrl != null) {
      builder.diffUrl(json.diffUrl);
    }
    if (json.patchUrl != null) {
      builder.patchUrl(json.patchUrl);
    }
    if (json.issueUrl != null) {
      builder.issueUrl(json.issueUrl);
    }
    if (json.commitsUrl != null) {
      builder.commitsUrl(json.commitsUrl);
    }
    if (json.number != null) {
      builder.number(json.number);
    }
    if (json.state != null) {
      builder.state(json.state);
    }
    if (json.title != null) {
      builder.title(json.title);
    }
    if (json.body != null) {
      builder.body(json.body);
    }
    if (json.assignee != null) {
      builder.assignee(json.assignee);
    }
    if (json.assignees != null) {
      builder.assignees(json.assignees);
    }
    if (json.milestone != null) {
      builder.milestone(json.milestone);
    }
    if (json.locked != null) {
      builder.locked(json.locked);
    }
    if (json.mergedAt != null) {
      builder.mergedAt(json.mergedAt);
    }
    if (json.head != null) {
      builder.head(json.head);
    }
    if (json.base != null) {
      builder.base(json.base);
    }
    if (json.user != null) {
      builder.user(json.user);
    }
    if (json.statusesUrl != null) {
      builder.statusesUrl(json.statusesUrl);
    }
    if (json.reviewCommentsUrl != null) {
      builder.reviewCommentsUrl(json.reviewCommentsUrl);
    }
    if (json.reviewCommentUrl != null) {
      builder.reviewCommentUrl(json.reviewCommentUrl);
    }
    if (json.commentsUrl != null) {
      builder.commentsUrl(json.commentsUrl);
    }
    if (json.links != null) {
      builder.links(json.links);
    }
    if (json.requestedReviewers != null) {
      builder.addAllRequestedReviewers(json.requestedReviewers);
    }
    if (json.requestedTeams != null) {
      builder.addAllRequestedTeams(json.requestedTeams);
    }
    if (json.mergeCommitSha != null) {
      builder.mergeCommitSha(json.mergeCommitSha);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link PullRequestItem} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable PullRequestItem instance
   */
  public static ImmutablePullRequestItem copyOf(PullRequestItem instance) {
    if (instance instanceof ImmutablePullRequestItem) {
      return (ImmutablePullRequestItem) instance;
    }
    return ImmutablePullRequestItem.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutablePullRequestItem ImmutablePullRequestItem}.
   * <pre>
   * ImmutablePullRequestItem.builder()
   *    .createdAt(com.spotify.github.GitHubInstant | null) // nullable {@link PullRequestItem#createdAt() createdAt}
   *    .updatedAt(com.spotify.github.GitHubInstant | null) // nullable {@link PullRequestItem#updatedAt() updatedAt}
   *    .closedAt(com.spotify.github.GitHubInstant) // optional {@link PullRequestItem#closedAt() closedAt}
   *    .id(Integer | null) // nullable {@link PullRequestItem#id() id}
   *    .url(java.net.URI | null) // nullable {@link PullRequestItem#url() url}
   *    .htmlUrl(java.net.URI | null) // nullable {@link PullRequestItem#htmlUrl() htmlUrl}
   *    .diffUrl(java.net.URI | null) // nullable {@link PullRequestItem#diffUrl() diffUrl}
   *    .patchUrl(java.net.URI | null) // nullable {@link PullRequestItem#patchUrl() patchUrl}
   *    .issueUrl(java.net.URI | null) // nullable {@link PullRequestItem#issueUrl() issueUrl}
   *    .commitsUrl(java.net.URI | null) // nullable {@link PullRequestItem#commitsUrl() commitsUrl}
   *    .number(Integer | null) // nullable {@link PullRequestItem#number() number}
   *    .state(String | null) // nullable {@link PullRequestItem#state() state}
   *    .title(String | null) // nullable {@link PullRequestItem#title() title}
   *    .body(String) // optional {@link PullRequestItem#body() body}
   *    .assignee(com.spotify.github.v3.User) // optional {@link PullRequestItem#assignee() assignee}
   *    .assignees(List&amp;lt;com.spotify.github.v3.User&amp;gt;) // optional {@link PullRequestItem#assignees() assignees}
   *    .milestone(com.spotify.github.v3.Milestone) // optional {@link PullRequestItem#milestone() milestone}
   *    .locked(Boolean | null) // nullable {@link PullRequestItem#locked() locked}
   *    .mergedAt(com.spotify.github.GitHubInstant) // optional {@link PullRequestItem#mergedAt() mergedAt}
   *    .head(com.spotify.github.v3.prs.PullRequestRef | null) // nullable {@link PullRequestItem#head() head}
   *    .base(com.spotify.github.v3.prs.PullRequestRef | null) // nullable {@link PullRequestItem#base() base}
   *    .user(com.spotify.github.v3.User | null) // nullable {@link PullRequestItem#user() user}
   *    .statusesUrl(java.net.URI | null) // nullable {@link PullRequestItem#statusesUrl() statusesUrl}
   *    .reviewCommentsUrl(java.net.URI | null) // nullable {@link PullRequestItem#reviewCommentsUrl() reviewCommentsUrl}
   *    .reviewCommentUrl(String | null) // nullable {@link PullRequestItem#reviewCommentUrl() reviewCommentUrl}
   *    .commentsUrl(java.net.URI | null) // nullable {@link PullRequestItem#commentsUrl() commentsUrl}
   *    .links(com.spotify.github.v3.prs.PullRequestLinks | null) // nullable {@link PullRequestItem#links() links}
   *    .requestedReviewers(List&amp;lt;com.spotify.github.v3.User&amp;gt; | null) // nullable {@link PullRequestItem#requestedReviewers() requestedReviewers}
   *    .requestedTeams(List&amp;lt;com.spotify.github.v3.User&amp;gt; | null) // nullable {@link PullRequestItem#requestedTeams() requestedTeams}
   *    .mergeCommitSha(String) // optional {@link PullRequestItem#mergeCommitSha() mergeCommitSha}
   *    .build();
   * </pre>
   * @return A new ImmutablePullRequestItem builder
   */
  public static ImmutablePullRequestItem.Builder builder() {
    return new ImmutablePullRequestItem.Builder();
  }

  /**
   * Builds instances of type {@link ImmutablePullRequestItem ImmutablePullRequestItem}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "PullRequestItem", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable GitHubInstant createdAt;
    private @Nullable GitHubInstant updatedAt;
    private @Nullable GitHubInstant closedAt;
    private @Nullable Integer id;
    private @Nullable URI url;
    private @Nullable URI htmlUrl;
    private @Nullable URI diffUrl;
    private @Nullable URI patchUrl;
    private @Nullable URI issueUrl;
    private @Nullable URI commitsUrl;
    private @Nullable Integer number;
    private @Nullable String state;
    private @Nullable String title;
    private @Nullable String body;
    private @Nullable User assignee;
    private @Nullable List<User> assignees;
    private @Nullable Milestone milestone;
    private @Nullable Boolean locked;
    private @Nullable GitHubInstant mergedAt;
    private @Nullable PullRequestRef head;
    private @Nullable PullRequestRef base;
    private @Nullable User user;
    private @Nullable URI statusesUrl;
    private @Nullable URI reviewCommentsUrl;
    private @Nullable String reviewCommentUrl;
    private @Nullable URI commentsUrl;
    private @Nullable PullRequestLinks links;
    private List<User> requestedReviewers = null;
    private List<User> requestedTeams = null;
    private @Nullable String mergeCommitSha;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.spotify.github.v3.prs.PullRequestItem} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(PullRequestItem instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.spotify.github.CloseTracking} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(CloseTracking instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.spotify.github.UpdateTracking} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(UpdateTracking instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof PullRequestItem) {
        PullRequestItem instance = (PullRequestItem) object;
        @Nullable List<User> requestedReviewersValue = instance.requestedReviewers();
        if (requestedReviewersValue != null) {
          addAllRequestedReviewers(requestedReviewersValue);
        }
        @Nullable URI diffUrlValue = instance.diffUrl();
        if (diffUrlValue != null) {
          diffUrl(diffUrlValue);
        }
        @Nullable String reviewCommentUrlValue = instance.reviewCommentUrl();
        if (reviewCommentUrlValue != null) {
          reviewCommentUrl(reviewCommentUrlValue);
        }
        @Nullable List<User> requestedTeamsValue = instance.requestedTeams();
        if (requestedTeamsValue != null) {
          addAllRequestedTeams(requestedTeamsValue);
        }
        Optional<List<User>> assigneesOptional = instance.assignees();
        if (assigneesOptional.isPresent()) {
          assignees(assigneesOptional);
        }
        @Nullable URI reviewCommentsUrlValue = instance.reviewCommentsUrl();
        if (reviewCommentsUrlValue != null) {
          reviewCommentsUrl(reviewCommentsUrlValue);
        }
        @Nullable URI commitsUrlValue = instance.commitsUrl();
        if (commitsUrlValue != null) {
          commitsUrl(commitsUrlValue);
        }
        @Nullable String titleValue = instance.title();
        if (titleValue != null) {
          title(titleValue);
        }
        Optional<String> bodyOptional = instance.body();
        if (bodyOptional.isPresent()) {
          body(bodyOptional);
        }
        @Nullable PullRequestRef headValue = instance.head();
        if (headValue != null) {
          head(headValue);
        }
        @Nullable Integer numberValue = instance.number();
        if (numberValue != null) {
          number(numberValue);
        }
        @Nullable URI patchUrlValue = instance.patchUrl();
        if (patchUrlValue != null) {
          patchUrl(patchUrlValue);
        }
        Optional<String> mergeCommitShaOptional = instance.mergeCommitSha();
        if (mergeCommitShaOptional.isPresent()) {
          mergeCommitSha(mergeCommitShaOptional);
        }
        @Nullable URI statusesUrlValue = instance.statusesUrl();
        if (statusesUrlValue != null) {
          statusesUrl(statusesUrlValue);
        }
        @Nullable PullRequestLinks linksValue = instance.links();
        if (linksValue != null) {
          links(linksValue);
        }
        @Nullable Integer idValue = instance.id();
        if (idValue != null) {
          id(idValue);
        }
        @Nullable String stateValue = instance.state();
        if (stateValue != null) {
          state(stateValue);
        }
        @Nullable Boolean lockedValue = instance.locked();
        if (lockedValue != null) {
          locked(lockedValue);
        }
        Optional<GitHubInstant> mergedAtOptional = instance.mergedAt();
        if (mergedAtOptional.isPresent()) {
          mergedAt(mergedAtOptional);
        }
        @Nullable URI htmlUrlValue = instance.htmlUrl();
        if (htmlUrlValue != null) {
          htmlUrl(htmlUrlValue);
        }
        @Nullable URI urlValue = instance.url();
        if (urlValue != null) {
          url(urlValue);
        }
        @Nullable URI issueUrlValue = instance.issueUrl();
        if (issueUrlValue != null) {
          issueUrl(issueUrlValue);
        }
        Optional<Milestone> milestoneOptional = instance.milestone();
        if (milestoneOptional.isPresent()) {
          milestone(milestoneOptional);
        }
        @Nullable URI commentsUrlValue = instance.commentsUrl();
        if (commentsUrlValue != null) {
          commentsUrl(commentsUrlValue);
        }
        Optional<User> assigneeOptional = instance.assignee();
        if (assigneeOptional.isPresent()) {
          assignee(assigneeOptional);
        }
        @Nullable User userValue = instance.user();
        if (userValue != null) {
          user(userValue);
        }
        @Nullable PullRequestRef baseValue = instance.base();
        if (baseValue != null) {
          base(baseValue);
        }
      }
      if (object instanceof CloseTracking) {
        CloseTracking instance = (CloseTracking) object;
        Optional<GitHubInstant> closedAtOptional = instance.closedAt();
        if (closedAtOptional.isPresent()) {
          closedAt(closedAtOptional);
        }
      }
      if (object instanceof UpdateTracking) {
        UpdateTracking instance = (UpdateTracking) object;
        @Nullable GitHubInstant createdAtValue = instance.createdAt();
        if (createdAtValue != null) {
          createdAt(createdAtValue);
        }
        @Nullable GitHubInstant updatedAtValue = instance.updatedAt();
        if (updatedAtValue != null) {
          updatedAt(updatedAtValue);
        }
      }
    }

    /**
     * Initializes the value for the {@link PullRequestItem#createdAt() createdAt} attribute.
     * @param createdAt The value for createdAt (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder createdAt(@Nullable GitHubInstant createdAt) {
      this.createdAt = createdAt;
      return this;
    }

    /**
     * Initializes the value for the {@link PullRequestItem#updatedAt() updatedAt} attribute.
     * @param updatedAt The value for updatedAt (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder updatedAt(@Nullable GitHubInstant updatedAt) {
      this.updatedAt = updatedAt;
      return this;
    }

    /**
     * Initializes the optional value {@link PullRequestItem#closedAt() closedAt} to closedAt.
     * @param closedAt The value for closedAt
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder closedAt(GitHubInstant closedAt) {
      this.closedAt = Objects.requireNonNull(closedAt, "closedAt");
      return this;
    }

    /**
     * Initializes the optional value {@link PullRequestItem#closedAt() closedAt} to closedAt.
     * @param closedAt The value for closedAt
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder closedAt(Optional<? extends GitHubInstant> closedAt) {
      this.closedAt = closedAt.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link PullRequestItem#id() id} attribute.
     * @param id The value for id (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder id(@Nullable Integer id) {
      this.id = id;
      return this;
    }

    /**
     * Initializes the value for the {@link PullRequestItem#url() url} attribute.
     * @param url The value for url (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder url(@Nullable URI url) {
      this.url = url;
      return this;
    }

    /**
     * Initializes the value for the {@link PullRequestItem#htmlUrl() htmlUrl} attribute.
     * @param htmlUrl The value for htmlUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder htmlUrl(@Nullable URI htmlUrl) {
      this.htmlUrl = htmlUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link PullRequestItem#diffUrl() diffUrl} attribute.
     * @param diffUrl The value for diffUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder diffUrl(@Nullable URI diffUrl) {
      this.diffUrl = diffUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link PullRequestItem#patchUrl() patchUrl} attribute.
     * @param patchUrl The value for patchUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder patchUrl(@Nullable URI patchUrl) {
      this.patchUrl = patchUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link PullRequestItem#issueUrl() issueUrl} attribute.
     * @param issueUrl The value for issueUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder issueUrl(@Nullable URI issueUrl) {
      this.issueUrl = issueUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link PullRequestItem#commitsUrl() commitsUrl} attribute.
     * @param commitsUrl The value for commitsUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder commitsUrl(@Nullable URI commitsUrl) {
      this.commitsUrl = commitsUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link PullRequestItem#number() number} attribute.
     * @param number The value for number (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder number(@Nullable Integer number) {
      this.number = number;
      return this;
    }

    /**
     * Initializes the value for the {@link PullRequestItem#state() state} attribute.
     * @param state The value for state (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder state(@Nullable String state) {
      this.state = state;
      return this;
    }

    /**
     * Initializes the value for the {@link PullRequestItem#title() title} attribute.
     * @param title The value for title (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder title(@Nullable String title) {
      this.title = title;
      return this;
    }

    /**
     * Initializes the optional value {@link PullRequestItem#body() body} to body.
     * @param body The value for body
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder body(String body) {
      this.body = Objects.requireNonNull(body, "body");
      return this;
    }

    /**
     * Initializes the optional value {@link PullRequestItem#body() body} to body.
     * @param body The value for body
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder body(Optional<String> body) {
      this.body = body.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link PullRequestItem#assignee() assignee} to assignee.
     * @param assignee The value for assignee
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder assignee(User assignee) {
      this.assignee = Objects.requireNonNull(assignee, "assignee");
      return this;
    }

    /**
     * Initializes the optional value {@link PullRequestItem#assignee() assignee} to assignee.
     * @param assignee The value for assignee
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder assignee(Optional<? extends User> assignee) {
      this.assignee = assignee.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link PullRequestItem#assignees() assignees} to assignees.
     * @param assignees The value for assignees
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder assignees(List<User> assignees) {
      this.assignees = Objects.requireNonNull(assignees, "assignees");
      return this;
    }

    /**
     * Initializes the optional value {@link PullRequestItem#assignees() assignees} to assignees.
     * @param assignees The value for assignees
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder assignees(Optional<? extends List<User>> assignees) {
      this.assignees = assignees.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link PullRequestItem#milestone() milestone} to milestone.
     * @param milestone The value for milestone
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder milestone(Milestone milestone) {
      this.milestone = Objects.requireNonNull(milestone, "milestone");
      return this;
    }

    /**
     * Initializes the optional value {@link PullRequestItem#milestone() milestone} to milestone.
     * @param milestone The value for milestone
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder milestone(Optional<? extends Milestone> milestone) {
      this.milestone = milestone.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link PullRequestItem#locked() locked} attribute.
     * @param locked The value for locked (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder locked(@Nullable Boolean locked) {
      this.locked = locked;
      return this;
    }

    /**
     * Initializes the optional value {@link PullRequestItem#mergedAt() mergedAt} to mergedAt.
     * @param mergedAt The value for mergedAt
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder mergedAt(GitHubInstant mergedAt) {
      this.mergedAt = Objects.requireNonNull(mergedAt, "mergedAt");
      return this;
    }

    /**
     * Initializes the optional value {@link PullRequestItem#mergedAt() mergedAt} to mergedAt.
     * @param mergedAt The value for mergedAt
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder mergedAt(Optional<? extends GitHubInstant> mergedAt) {
      this.mergedAt = mergedAt.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link PullRequestItem#head() head} attribute.
     * @param head The value for head (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder head(@Nullable PullRequestRef head) {
      this.head = head;
      return this;
    }

    /**
     * Initializes the value for the {@link PullRequestItem#base() base} attribute.
     * @param base The value for base (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder base(@Nullable PullRequestRef base) {
      this.base = base;
      return this;
    }

    /**
     * Initializes the value for the {@link PullRequestItem#user() user} attribute.
     * @param user The value for user (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder user(@Nullable User user) {
      this.user = user;
      return this;
    }

    /**
     * Initializes the value for the {@link PullRequestItem#statusesUrl() statusesUrl} attribute.
     * @param statusesUrl The value for statusesUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder statusesUrl(@Nullable URI statusesUrl) {
      this.statusesUrl = statusesUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link PullRequestItem#reviewCommentsUrl() reviewCommentsUrl} attribute.
     * @param reviewCommentsUrl The value for reviewCommentsUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder reviewCommentsUrl(@Nullable URI reviewCommentsUrl) {
      this.reviewCommentsUrl = reviewCommentsUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link PullRequestItem#reviewCommentUrl() reviewCommentUrl} attribute.
     * @param reviewCommentUrl The value for reviewCommentUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder reviewCommentUrl(@Nullable String reviewCommentUrl) {
      this.reviewCommentUrl = reviewCommentUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link PullRequestItem#commentsUrl() commentsUrl} attribute.
     * @param commentsUrl The value for commentsUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder commentsUrl(@Nullable URI commentsUrl) {
      this.commentsUrl = commentsUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link PullRequestItem#links() links} attribute.
     * @param links The value for links (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("_links")
    public final Builder links(@Nullable PullRequestLinks links) {
      this.links = links;
      return this;
    }

    /**
     * Adds one element to {@link PullRequestItem#requestedReviewers() requestedReviewers} list.
     * @param element A requestedReviewers element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addRequestedReviewers(User element) {
      if (this.requestedReviewers == null) {
        this.requestedReviewers = new ArrayList<User>();
      }
      this.requestedReviewers.add(Objects.requireNonNull(element, "requestedReviewers element"));
      return this;
    }

    /**
     * Adds elements to {@link PullRequestItem#requestedReviewers() requestedReviewers} list.
     * @param elements An array of requestedReviewers elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addRequestedReviewers(User... elements) {
      if (this.requestedReviewers == null) {
        this.requestedReviewers = new ArrayList<User>();
      }
      for (User element : elements) {
        this.requestedReviewers.add(Objects.requireNonNull(element, "requestedReviewers element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link PullRequestItem#requestedReviewers() requestedReviewers} list.
     * @param elements An iterable of requestedReviewers elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("requested_reviewers")
    public final Builder requestedReviewers(@Nullable Iterable<? extends User> elements) {
      if (elements == null) {
        this.requestedReviewers = null;
        return this;
      }
      this.requestedReviewers = new ArrayList<User>();
      return addAllRequestedReviewers(elements);
    }

    /**
     * Adds elements to {@link PullRequestItem#requestedReviewers() requestedReviewers} list.
     * @param elements An iterable of requestedReviewers elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllRequestedReviewers(Iterable<? extends User> elements) {
      Objects.requireNonNull(elements, "requestedReviewers element");
      if (this.requestedReviewers == null) {
        this.requestedReviewers = new ArrayList<User>();
      }
      for (User element : elements) {
        this.requestedReviewers.add(Objects.requireNonNull(element, "requestedReviewers element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link PullRequestItem#requestedTeams() requestedTeams} list.
     * @param element A requestedTeams element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addRequestedTeams(User element) {
      if (this.requestedTeams == null) {
        this.requestedTeams = new ArrayList<User>();
      }
      this.requestedTeams.add(Objects.requireNonNull(element, "requestedTeams element"));
      return this;
    }

    /**
     * Adds elements to {@link PullRequestItem#requestedTeams() requestedTeams} list.
     * @param elements An array of requestedTeams elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addRequestedTeams(User... elements) {
      if (this.requestedTeams == null) {
        this.requestedTeams = new ArrayList<User>();
      }
      for (User element : elements) {
        this.requestedTeams.add(Objects.requireNonNull(element, "requestedTeams element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link PullRequestItem#requestedTeams() requestedTeams} list.
     * @param elements An iterable of requestedTeams elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("requested_teams")
    public final Builder requestedTeams(@Nullable Iterable<? extends User> elements) {
      if (elements == null) {
        this.requestedTeams = null;
        return this;
      }
      this.requestedTeams = new ArrayList<User>();
      return addAllRequestedTeams(elements);
    }

    /**
     * Adds elements to {@link PullRequestItem#requestedTeams() requestedTeams} list.
     * @param elements An iterable of requestedTeams elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllRequestedTeams(Iterable<? extends User> elements) {
      Objects.requireNonNull(elements, "requestedTeams element");
      if (this.requestedTeams == null) {
        this.requestedTeams = new ArrayList<User>();
      }
      for (User element : elements) {
        this.requestedTeams.add(Objects.requireNonNull(element, "requestedTeams element"));
      }
      return this;
    }

    /**
     * Initializes the optional value {@link PullRequestItem#mergeCommitSha() mergeCommitSha} to mergeCommitSha.
     * @param mergeCommitSha The value for mergeCommitSha
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder mergeCommitSha(String mergeCommitSha) {
      this.mergeCommitSha = Objects.requireNonNull(mergeCommitSha, "mergeCommitSha");
      return this;
    }

    /**
     * Initializes the optional value {@link PullRequestItem#mergeCommitSha() mergeCommitSha} to mergeCommitSha.
     * @param mergeCommitSha The value for mergeCommitSha
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty
    public final Builder mergeCommitSha(Optional<String> mergeCommitSha) {
      this.mergeCommitSha = mergeCommitSha.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ImmutablePullRequestItem ImmutablePullRequestItem}.
     * @return An immutable instance of PullRequestItem
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutablePullRequestItem build() {
      return new ImmutablePullRequestItem(
          createdAt,
          updatedAt,
          closedAt,
          id,
          url,
          htmlUrl,
          diffUrl,
          patchUrl,
          issueUrl,
          commitsUrl,
          number,
          state,
          title,
          body,
          assignee,
          assignees,
          milestone,
          locked,
          mergedAt,
          head,
          base,
          user,
          statusesUrl,
          reviewCommentsUrl,
          reviewCommentUrl,
          commentsUrl,
          links,
          requestedReviewers == null ? null : createUnmodifiableList(true, requestedReviewers),
          requestedTeams == null ? null : createUnmodifiableList(true, requestedTeams),
          mergeCommitSha);
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
